/*
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Karl Park <karl.park@sun.com>
 */

#ifndef COMPOSER_H
#define COMPOSER_H
#include <IMProtocolStruct.h>
#include <SunIM.h>
#include <koinput.h>
#if 0
#define logf(...) /**/
#endif
typedef enum _JAMO_T { JM_NONE, JAEUM, MOEUM } JAMO_T;

typedef enum _CHOJUNGJONG_T {
  CJJ_NONE = -1,
  CJJ_CHOSUNG, CJJ_JUNGSUNG, CJJ_JONGSUNG
} CHOJUNGJONG_T;

typedef struct _HANGUL HANGUL, *HANGULList;

typedef struct _Jamo Jamo;
struct _Jamo {
  UTFCHAR first;
  UTFCHAR second;
  UTFCHAR coupled;
};

struct _HANGUL {
  Jamo L;			/* leading consonant */
  Jamo V;			/* vowel */
  Jamo T;			/* trailing consonan	*/
  Bool completed;  
};


typedef struct _HANGULBuffer HANGULBuffer;
struct _HANGULBuffer {
  int	  		count;
  HANGULList 	*buffer;
};

typedef struct _MapInfo MapInfo;
struct _MapInfo{
  unsigned short val;
  CHOJUNGJONG_T type;
};


typedef struct _KeymapData KeymapData;
struct _KeymapData{
  MapInfo layout[LAYOUT_NUM];
};

typedef enum _ComposerRetVal {
  ComposerRetErr = -1, ComposerRetKeep, ComposerRetBreak,
} AutomataRetVal;

void
composer_hangul_initialize (HANGUL *a_hangul);

void
composer_hangul_free (HANGUL *a_hangul);

void
composer_hangul_copy (HANGUL *dst, HANGUL *src);

HANGULBuffer *
composer_hangul_buffer_new (void);

void
composer_hangul_buffer_initialize (HANGULBuffer *hangul_buffer);


HANGUL *
composer_hangul_buffer_get_next_hangul (HANGULBuffer *hangul_buffer, HANGUL *current_hangul);

int
composer_hangul_buffer_get_hangul_length (HANGULBuffer *hangul_buffer);

void
composer_hangul_buffer_print (HANGULBuffer *hangul_buffer);

Boolean
composer_hangul_buffer_delete_hangul_character (HANGULBuffer *hangul_buffer, 
						Boolean delete_whole_character,
						HANGUL *deleted_hangul_return);
/* create a copy of HANGUL a_hangul and append it to the array */
HANGUL *
composer_hangul_buffer_add_hangul (HANGULBuffer *hangul_buffer, HANGUL *a_hangul);


/* NULL return indicates either
   hangul_buffer was not valid
   or
   there was not HANGUL element in the buffer
*/
HANGUL *composer_hangul_buffer_get_last_hangul (HANGULBuffer *hangul_buffer);

HANGUL *composer_hangul_buffer_pop_hangul (HANGULBuffer *hangul_buffer);

UTFCHAR
composer_hangul_combine_cho_jung_jong (HANGUL *a_hangul);

int
composer_hangul_automata_2pair (int keyCode, int keyChar, int state, HANGULBuffer *hangul_buffer, Config *pconfig);


Boolean
composer_hangul_hanja_lookup_start (HANGULBuffer *hangul_buffer,
                                    int *number_of_candidates,
                                    UTFCHAR ***hanja_list_return);
Bool composer_hangul_buffer_get_content_in_u16 (HANGULBuffer *hbuf, UTFCHAR **u16hangul_return);



Bool _jamo_is_clean (Jamo *jamo);
UTFCHAR _jamo_get_value (Jamo *jamo);

/* language engine configuartion methods */
void composer_config_switch_codeset (Config *pconfig, int *newcodeset);
void composer_config_switch_keyboard (Config *pconfig);
void composer_config_switch_commit_method (Config *pconfig);

UTFCHAR get_utf_input_by_keyboard (IMEKeyEventStruct *, KEYBOARD_LAYOUT_T);

#endif /* COMPOSER_H */
