#ifndef _IME_MODULE_H_
#define _IME_MODULE_H_

#include "ime.h"

enum {
    IME_NOT_INITIALIZED = 0,
    IME_INITIALIZED_SUCCESS,
    IME_INITIALIZED_FAIL,
};

typedef struct TImePCAuxOption {
    int    type;
    int    showSystemBar;
    int    followCursor;
    int    composite;
    int    showPageControl;
    int    ignorCandidateTitle;

    int    candidateVertical;
    int    candidatePosition;
    int    candidateTitlePosition;
} TImePCAuxOption;

typedef struct _ImeModuleRec {
    int initialized;
    char *object_file_path;
    char *args;
    void *module_handler;

    ImeInfoRec *info;
    ImeMethodsRec *methods;

    /* FIXME, this should on (ime, desktop) co-context */
    int                 pc_cursor_x, pc_cursor_y, pc_cursor_w, pc_cursor_h;
    /* FIXME, these should on (ime, user) co-context */
    char                pc_aux_name[256];       //preedit_candidates aux name
    TImePCAuxOption     pc_aux_options;         //preedit_candidates aux options
} ImeModuleRec;

typedef struct _ImeModuleContextRec {
    ImeModuleRec *ime_module;

    int enabled;

    int user_data_len;
    void *user_data_ptr;

    ImePropertyListRec *pl;

} ImeModuleContextRec;

#endif	/* _IME_MODULE_H_ */
