#ifndef _LE_INFO_H_
#define _LE_INFO_H_

#include "SunIM.h"
#include "m17n.h"
#include "m17n-misc.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

typedef enum {
    LE_FAIL = 0,
    LE_OK,
} LeResult;

typedef enum {
    LE_FALSE = 0,
    LE_TRUE,
} LeBoolean;

/* define the status for conversion/qjbj/punctuation */
typedef enum {
    CONVERSION_OFF = 0,
    CONVERSION_ON,
} ConversionStatus;

#define MAX_SUPPORT_LOCALES    100

typedef struct {
    int enabled;

    MSymbol language;
    MSymbol name;
    MInputMethod *im;
} M17nImInfoRec;

typedef struct {
    int num_input_methods;
    M17nImInfoRec **input_methods;

    MSymbol    Miiim_ic;
    MSymbol    Mkey_english_native;
    MSymbol    Mkey_switch_next_im;

    MConverter *converter;
} LeInfoRec;

#endif	/* _LE_INFO_H_ */
