/*
  IIIMF keycode definition.
 */

#ifndef IIIMP_KEYCODE_H_
#define IIIMP_KEYCODE_H_

enum IIIMF_KEYCODES {
	IIIMF_KEYCODE_UNDEFINED = 0,
	IIIMF_KEYCODE_LBUTTON = 1,
	IIIMF_KEYCODE_RBUTTON = 2,
	IIIMF_KEYCODE_CANCEL = 3,
	IIIMF_KEYCODE_MBUTTON = 4,
	IIIMF_KEYCODE_XBUTTON1 = 5,
	IIIMF_KEYCODE_XBUTTON2 = 6,
	IIIMF_KEYCODE_BACK_SPACE = 8,
	IIIMF_KEYCODE_TAB = 9,
	IIIMF_KEYCODE_ENTER = 10,
	IIIMF_KEYCODE_CLEAR = 12,
	IIIMF_KEYCODE_SHIFT = 16,
	IIIMF_KEYCODE_CONTROL = 17,
	IIIMF_KEYCODE_ALT = 18,
	IIIMF_KEYCODE_PAUSE = 19,
	IIIMF_KEYCODE_CAPS_LOCK = 20,
	IIIMF_KEYCODE_KANA = 21,
	IIIMF_KEYCODE_HANGUL = 21,
	IIIMF_KEYCODE_JUNJA = 23,
	IIIMF_KEYCODE_FINAL = 24,
	IIIMF_KEYCODE_KANJI = 25,
	IIIMF_KEYCODE_HANJA = 25,
	IIIMF_KEYCODE_ESCAPE = 27,
	IIIMF_KEYCODE_CONVERT = 28,
	IIIMF_KEYCODE_NONCONVERT = 29,
	IIIMF_KEYCODE_ACCEPT = 30,
	IIIMF_KEYCODE_MODECHANGE = 31,
	IIIMF_KEYCODE_SPACE = 32,
	IIIMF_KEYCODE_PAGE_UP = 33,
	IIIMF_KEYCODE_PAGE_DOWN = 34,
	IIIMF_KEYCODE_END = 35,
	IIIMF_KEYCODE_HOME = 36,
	IIIMF_KEYCODE_LEFT = 37,
	IIIMF_KEYCODE_UP = 38,
	IIIMF_KEYCODE_RIGHT = 39,
	IIIMF_KEYCODE_DOWN = 40,
	IIIMF_KEYCODE_COMMA = 44,
	IIIMF_KEYCODE_MINUS = 45,
	IIIMF_KEYCODE_PERIOD = 46,
	IIIMF_KEYCODE_SLASH = 47,

	IIIMF_KEYCODE_0 = 48,
	IIIMF_KEYCODE_1 = 49,
	IIIMF_KEYCODE_2 = 50,
	IIIMF_KEYCODE_3 = 51,
	IIIMF_KEYCODE_4 = 52,
	IIIMF_KEYCODE_5 = 53,
	IIIMF_KEYCODE_6 = 54,
	IIIMF_KEYCODE_7 = 55,
	IIIMF_KEYCODE_8 = 56,
	IIIMF_KEYCODE_9 = 57,

	IIIMF_KEYCODE_SEMICOLON = 59,
	IIIMF_KEYCODE_EQUALS = 61,

	IIIMF_KEYCODE_A = 65,
	IIIMF_KEYCODE_B = 66,
	IIIMF_KEYCODE_C = 67,
	IIIMF_KEYCODE_D = 68,
	IIIMF_KEYCODE_E = 69,
	IIIMF_KEYCODE_F = 70,
	IIIMF_KEYCODE_G = 71,
	IIIMF_KEYCODE_H = 72,
	IIIMF_KEYCODE_I = 73,
	IIIMF_KEYCODE_J = 74,
	IIIMF_KEYCODE_K = 75,
	IIIMF_KEYCODE_L = 76,
	IIIMF_KEYCODE_M = 77,
	IIIMF_KEYCODE_N = 78,
	IIIMF_KEYCODE_O = 79,
	IIIMF_KEYCODE_P = 80,
	IIIMF_KEYCODE_Q = 81,
	IIIMF_KEYCODE_R = 82,
	IIIMF_KEYCODE_S = 83,
	IIIMF_KEYCODE_T = 84,
	IIIMF_KEYCODE_U = 85,
	IIIMF_KEYCODE_V = 86,
	IIIMF_KEYCODE_W = 87,
	IIIMF_KEYCODE_X = 88,
	IIIMF_KEYCODE_Y = 89,
	IIIMF_KEYCODE_Z = 90,

	IIIMF_KEYCODE_OPEN_BRACKET = 91,
	IIIMF_KEYCODE_BACK_SLASH = 92,
	IIIMF_KEYCODE_CLOSE_BRACKET = 93,

	IIIMF_KEYCODE_NUMPAD0 = 96,
	IIIMF_KEYCODE_NUMPAD1 = 97,
	IIIMF_KEYCODE_NUMPAD2 = 98,
	IIIMF_KEYCODE_NUMPAD3 = 99,
	IIIMF_KEYCODE_NUMPAD4 = 100,
	IIIMF_KEYCODE_NUMPAD5 = 101,
	IIIMF_KEYCODE_NUMPAD6 = 102,
	IIIMF_KEYCODE_NUMPAD7 = 103,
	IIIMF_KEYCODE_NUMPAD8 = 104,
	IIIMF_KEYCODE_NUMPAD9 = 105,
	IIIMF_KEYCODE_MULTIPLY = 106,
	IIIMF_KEYCODE_ADD = 107,
	IIIMF_KEYCODE_SEPARATOR = 108,
	IIIMF_KEYCODE_SEPARATER = 108,
	IIIMF_KEYCODE_SUBTRACT = 109,
	IIIMF_KEYCODE_DECIMAL = 110,
	IIIMF_KEYCODE_DIVIDE = 111,

	IIIMF_KEYCODE_F1 = 112,
	IIIMF_KEYCODE_F2 = 113,
	IIIMF_KEYCODE_F3 = 114,
	IIIMF_KEYCODE_F4 = 115,
	IIIMF_KEYCODE_F5 = 116,
	IIIMF_KEYCODE_F6 = 117,
	IIIMF_KEYCODE_F7 = 118,
	IIIMF_KEYCODE_F8 = 119,
	IIIMF_KEYCODE_F9 = 120,
	IIIMF_KEYCODE_F10 = 121,
	IIIMF_KEYCODE_F11 = 122,
	IIIMF_KEYCODE_F12 = 123,

	IIIMF_KEYCODE_DELETE = 127,
	IIIMF_KEYCODE_DEAD_GRAVE = 128,
	IIIMF_KEYCODE_DEAD_ACUTE = 129,
	IIIMF_KEYCODE_DEAD_CIRCUMFLEX = 130,
	IIIMF_KEYCODE_DEAD_TILDE = 131,
	IIIMF_KEYCODE_DEAD_MACRON = 132,
	IIIMF_KEYCODE_DEAD_BREVE = 133,
	IIIMF_KEYCODE_DEAD_ABOVEDOT = 134,
	IIIMF_KEYCODE_DEAD_DIAERESIS = 135,
	IIIMF_KEYCODE_DEAD_ABOVERING = 136,
	IIIMF_KEYCODE_DEAD_DOUBLEACUTE = 137,
	IIIMF_KEYCODE_DEAD_CARON = 138,
	IIIMF_KEYCODE_DEAD_CEDILLA = 139,
	IIIMF_KEYCODE_DEAD_OGONEK = 140,
	IIIMF_KEYCODE_DEAD_IOTA = 141,
	IIIMF_KEYCODE_DEAD_VOICED_SOUND = 142,
	IIIMF_KEYCODE_DEAD_SEMIVOICED_SOUND = 143,

	IIIMF_KEYCODE_NUM_LOCK = 144,
	IIIMF_KEYCODE_SCROLL_LOCK = 145,
	IIIMF_KEYCODE_AMPERSAND = 150,
	IIIMF_KEYCODE_ASTERISK = 151,
	IIIMF_KEYCODE_QUOTEDBL = 152,
	IIIMF_KEYCODE_LESS = 153,
	IIIMF_KEYCODE_PRINTSCREEN = 154,
	IIIMF_KEYCODE_INSERT = 155,
	IIIMF_KEYCODE_HELP = 156,
	IIIMF_KEYCODE_META = 157,
	IIIMF_KEYCODE_GREATER = 160,
	IIIMF_KEYCODE_BRACELEFT = 161,
	IIIMF_KEYCODE_BRACERIGHT = 162,
	IIIMF_KEYCODE_BACK_QUOTE = 192,
	IIIMF_KEYCODE_QUOTE = 222,
	IIIMF_KEYCODE_KP_UP = 224,
	IIIMF_KEYCODE_KP_DOWN = 225,
	IIIMF_KEYCODE_KP_LEFT = 226,
	IIIMF_KEYCODE_KP_RIGHT = 227,
	IIIMF_KEYCODE_ALPHANUMERIC = 240,
	IIIMF_KEYCODE_KATAKANA = 241,
	IIIMF_KEYCODE_HIRAGANA = 242,
	IIIMF_KEYCODE_FULL_WIDTH = 243,
	IIIMF_KEYCODE_HALF_WIDTH = 244,
	IIIMF_KEYCODE_ROMAN_CHARACTERS = 245,
	IIIMF_KEYCODE_ALL_CANDIDATES = 256,
	IIIMF_KEYCODE_PREVIOUS_CANDIDATE = 257,
	IIIMF_KEYCODE_CODE_INPUT = 258,
	IIIMF_KEYCODE_JAPANESE_KATAKANA = 259,
	IIIMF_KEYCODE_JAPANESE_HIRAGANA = 260,
	IIIMF_KEYCODE_JAPANESE_ROMAN = 261,
	IIIMF_KEYCODE_KANA_LOCK = 262,
	IIIMF_KEYCODE_INPUT_METHOD_ON_OFF = 263,
	IIIMF_KEYCODE_AT = 512,
	IIIMF_KEYCODE_COLON = 513,
	IIIMF_KEYCODE_CIRCUMFLEX = 514,
	IIIMF_KEYCODE_DOLLAR = 515,
	IIIMF_KEYCODE_EURO_SIGN = 516,
	IIIMF_KEYCODE_EXCLAMATION_MARK = 517,
	IIIMF_KEYCODE_INVERTED_EXCLAMATION_MARK = 518,
	IIIMF_KEYCODE_LEFT_PARENTHESIS = 519,
	IIIMF_KEYCODE_NUMBER_SIGN = 520,
	IIIMF_KEYCODE_PLUS = 521,
	IIIMF_KEYCODE_RIGHT_PARENTHESIS = 522,
	IIIMF_KEYCODE_UNDERSCORE = 523,

	IIIMF_KEYCODE_F13 = 61440,
	IIIMF_KEYCODE_F14 = 61441,
	IIIMF_KEYCODE_F15 = 61442,
	IIIMF_KEYCODE_F16 = 61443,
	IIIMF_KEYCODE_F17 = 61444,
	IIIMF_KEYCODE_F18 = 61445,
	IIIMF_KEYCODE_F19 = 61446,
	IIIMF_KEYCODE_F20 = 61447,
	IIIMF_KEYCODE_F21 = 61448,
	IIIMF_KEYCODE_F22 = 61449,
	IIIMF_KEYCODE_F23 = 61450,
	IIIMF_KEYCODE_F24 = 61451,

	IIIMF_KEYCODE_COMPOSE = 65312,
	IIIMF_KEYCODE_ALT_GRAPH = 65406,
	IIIMF_KEYCODE_STOP = 65480,
	IIIMF_KEYCODE_AGAIN = 65481,
	IIIMF_KEYCODE_PROPS = 65482,
	IIIMF_KEYCODE_UNDO = 65483,
	IIIMF_KEYCODE_COPY = 65485,
	IIIMF_KEYCODE_PASTE = 65487,
	IIIMF_KEYCODE_FIND = 65488,
	IIIMF_KEYCODE_CUT = 65489
};

#endif /* not IIIMP_KEYCODE_H_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */

