/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef iiimpIM_H
#define iiimpIM_H

#include <iiimcf.h>
#include "commonIM.h"
#include "xiiimp.h"

extern XIM _IIIMP_OpenIM(XLCd lcd, Display *dpy, XrmDatabase rdb,
			 char *res_name, char *res_class);

typedef struct _im_locale_pair {
  char *canonical;
  char *alias;
} im_locale_pair;

typedef struct _XIMIIimpIMRec {
  IIIMCF_handle handle;
  Window	cb_window;
  Bool          inited;

  int on_keys_num;
  IIIMCF_keyevent *pkev_on;
  int off_keys_num;
  IIIMCF_keyevent *pkev_off;

  char		*engine_name;
  char		*default_font_name;
  char		*primary_locale;
  char		*client_type;
  XIC		current_ic;

  im_locale_pair *lang_alias;

  XIMText	*supported_languages;
  int		count_languages;

  XIMMethods	switch_methods;

  int counter;

} XIMIIimpIMRec;

extern void ChangePreeditState(XicCommon);
extern void SetConversionMode(XicCommon, int);
extern void PutBackXKeyEvent(XicCommon);
extern void HoldXKeyEvent(XicCommon, XEvent *);

#define IsConversionMode(ic)  (XIM_IS_IIIMP(ic->core.im) && XIC_IIIMP(ic, filtered))

/* private XIC data for IIIMP */
typedef struct _XICKeyEventList {
  XKeyEvent			key_event;
  struct _XICKeyEventList *	next;
} XICKeyEventListRec;

typedef struct _XICIIimpIMRec {
  IIIMCF_context context;
  int           preedit_prev_len;
  Bool		filtered;
  KeySym	keysym_return;	/* For IM_FORWARD_EVENT(Server->Client)
				   (Now only for dummy) */

  /* flag for X*LookupString (Why this API involves dirty state???)
     Once committed text is looked up by X*LookupString.
     This flag must be set until the next commited text comes. */
  Bool          committed_text_consumed;

  /*  The following member is used for AUX object and external programs.
      For backward compatibility, such entities require an integer id to
      distinguish context so that this member holds a unique number.  */
  int id;

  XICKeyEventListRec	*key_event_list;
  int		key_event_num;

  XKeyEvent	keyevent_return;
  Bool		has_keyevent_return;

  int		key_event_forwarded;

  struct _aux   *aux;

  XICMethods	switch_methods;
} XICIIimpIMRec;

typedef enum {
  CONV_OFF = 0,
  CONV_ON = 1
} XICConversionMode;

typedef enum {
  CREATE_IC = 0,
  SET_IC = 1
} XICSetMode;

typedef enum {
  INPUT_LANGUAGE = 1,
  CHARACTER_SUBSETS = 2,
  INPUT_METHOD = 3
} ICAttributeID;

#define IIIMP_CLIENT_TYPE "XIM IIIMP ADAPTOR"

typedef enum {
  IM_GUI_OBJECT = 0,
  IM_LWE_OBJECT = 1,
  IM_SYNTAX_RULE_OBJECT = 2,
  IM_MANAGER_RULE_OBJECT = 3,
  IM_PRELOADING_LWE_OBJECT = 4
} IMObjectCategory;

typedef enum {
  INPUTMETHOD_LIST = 0x1001,
  OBJECT_DESCRIPTER_LIST = 0x1010,
  CLIENT_DESCRIPTER = 0x1011,
  CCDEF = 0x1030,
  GUI_OBJECT = 0x1033,
  LWE_OBJECT = 0x1034,
  OS_VERSION	= 0x2001,
  OS_NAME	= 0x2002,
  OS_ARCH	= 0x2003
} IMAttributeID;

typedef struct {
  ICAttributeID attribute_id;
  int		value_length;
  XPointer	value;
} XICAttribute;

typedef struct _IIIMObject {
  IMObjectCategory	obj_cat;	/* object category */
  unsigned int		obj_size;	/* object size */
  IMAttributeID		id;		/* CCDEF, GUI_OBJECT, LWE_OBJECT */
  unsigned int		id_dyn;		/* dynamic assigned id */
  char *		domain;		/* reversed domain */
  CARD16 *		name;		/* HRN */
  int			name_length;	/* HRN len in UTF16-char unit */
  char *		signature;	/* Object signature */
  char *		scope;		/* usability id or `generic' */

  char *		path;		/* path for object */
  char *		basepath;	/* base path for include tag */
  char *		encoding;	/* encoding of CCDEF */

  struct _IIIMObject *	next;
} IIIMObjectRec;

extern char *	IIIMP_GetIMValues(XIM xim, XIMArg *arg);
extern char*	IIIMP_SetIMValues(XIM xim, XIMArg *arg);

extern Status IIIMP_OpenIM_SWITCH(XIM xim, XLCd lcd, Display *dpy);
extern Status IIIMP_CreateIC_SWITCH(XIC xic, XIMArg *arg);

extern IIIMCF_language get_IM_language(
    XimCommon im
);

/* iiimcfFun.c */
extern Bool	IMGetICValues(XicCommon ic, XICAttribute *ic_attr,
			      int attr_count);
extern Bool	IMSetICValues(XicCommon ic, XICAttribute *ic_attr,
			      int attr_count);
extern Bool	IMCheckIMWindow(XicCommon ic, Window window);
extern Bool	IMForwardEvent(XicCommon xic, XEvent *ev);
extern Bool	IMTriggerNotify(XicCommon ic, XICConversionMode conv_mode);
extern Bool	IMSetIMValues(XimCommon im);
extern Bool	IMGetIMValue(XimCommon im, int attr_id);

extern Bool	IMAuxSetValues(XicCommon ic, IIIMCF_event ev);
extern Bool	IMAuxGetValues(XicCommon ic, IIIMCF_event ev);

extern IIIMF_status IMCreateIC(
    XimCommon im,
    IIIMCF_context *pc
);
extern Bool IMSetPrimaryLocale(
    XicCommon ic,
    char *input_locale
);
extern IIIMF_status IMChangeFocus(
    XicCommon ic,
    int flag
);
extern Bool IMChangeClientType(
    XimCommon im,
    char *client_type
);
extern void IM_free_langlist(
    XimCommon im
);


/* iiimpConv.c */
extern int	IMConvertFromUTF8ToUTF16(char *from_buf, size_t from_left,
					 char **to_buf, size_t *to_left);
extern int	IMConvertFromUTF8(char *from_buf, size_t from_left,
				  char **to_buf, size_t *to_left);
extern int	IIimpConvertToUTF16(char *from_buf, size_t from_left,
				    char **to_buf, size_t *to_left);
extern int	IIimpConvertFromUTF16(const char *from_buf, size_t from_left,
				      char **to_buf, size_t * to_left);
extern int	IMConvertToUTF8(char *from_buf, size_t from_left,
				char **to_buf, size_t *to_left);
extern int	IIimpWcstoMbs(XimCommon im, wchar_t *from, int from_len,
			      char *to, int to_len, Status *state);
extern int	IIimpMbstoWcs(XimCommon im, char *from, int from_len,
			      wchar_t *to, int to_len, Status *state);

extern int	IMConvertFromUTF8ToUTF16(char *from_buf, size_t from_left,
					 char **to_buf, size_t *to_left);

extern void	SwitchKeyEventFilter(XicCommon ic, Window old_focus);
extern void	IIIMPKeyEventFilter(XicCommon ic, Window old_focus);

/* iiimpClientDescriptor.c */
extern void	makeClientDescripter(Display *dpy, char *client_name,
				     XICAttribute *ic_attr,
				     int icid);

extern void ic_change_conversion_mode (XicCommon ic, char *conv_mode);
extern void ic_initialize_with_input_language (XicCommon ic, char *new_lang);

#endif

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
