/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "xiiimp.h"
#include "guiIMPre.h"
#include "XimpIm.h"

/* ChangePreedit Methods */
static void
create(XicCommon ic, XPointer call_data) {
  PreeditWin preedit = (PreeditWin)ic->gui_icpart->preedit;

  if (!preedit) {
    SetupPreeditExt(ic);
    preedit = (PreeditWin)ic->gui_icpart->preedit;
  }

  if (preedit->parent != 0 && preedit->preedit_areas) {
    /* preedit window is already created  */
    return;
  }

  if (!(ic->ximp_icpart->value_mask & XIMP_CLIENT_WIN)) return;

  SetupPreeditWindow(ic, ic->core.client_window);
  return;
}

static void
set_window(XicCommon ic, XPointer call_data) {
  PreeditWin preedit = (PreeditWin)(ic->gui_icpart->preedit);
  PreeditArea preedit_area;
  CacheRec *preedit_cache;
  PreeditChars preedit_chars;
  XRectangle *ic_preedit_area;
  unsigned int width, height, max_width, max_height;
  XFontSetExtents *fse;

  if (!preedit) {
    create(ic, NULL);
    preedit = (PreeditWin)(ic->gui_icpart->preedit);
    if (!preedit) return;
  }
  if (!preedit->fontset) {
    SetPreeditFont(ic, NULL);
    if (!preedit->fontset) return;
  }

  preedit_chars = (PreeditChars)&(preedit->preedit_chars);
  if (preedit_chars->wchar_len == 0) return;

  preedit_area = (PreeditArea)(preedit->preedit_areas);
  if (preedit->active_areas != 1 || !preedit_area ||
      !preedit_area[0].window) {
    return;
  }

  fse = XExtentsOfFontSet(preedit->fontset);
  width = XwcTextEscapement(preedit->fontset,
			    preedit_chars->wchar,
			    preedit_chars->wchar_len);
  if (width == 0) width = 1;
  height = fse->max_ink_extent.height;
  if (height == 0) height = 1;

  ic_preedit_area = &ic->core.preedit_attr.area;
  max_width = (fse->max_ink_extent.width > ic_preedit_area->width) ?
    fse->max_ink_extent.width : ic_preedit_area->width;
  max_height = ic_preedit_area->height;

  preedit_area[0].configured = False;
  preedit_area[0].x = 0;
  preedit_area[0].char_offset = 0;
  preedit_area[0].char_len = preedit_chars->wchar_len;
  if (max_height < fse->max_ink_extent.height) {
    int height_diff;
    height_diff =
      (max_height - fse->max_ink_extent.height);
    height_diff += (height_diff & 1);
    preedit_area[0].y = (-fse->max_ink_extent.y) + (height_diff / 2);
  }
  else {
    preedit_area[0].y = (-fse->max_ink_extent.y);
  }

  if (width <= max_width) {
    preedit_area[0].active_lines = 0;
  }
  else if (max_height < fse->max_ink_extent.height) {
    /* draw latest characters only */
    preedit_area[0].active_lines = 0;
    preedit_area[0].x = max_width - width;
  }
  else {
    /* draw more than two lines */
    int left;
    wchar_t *wcstr;
    int n, prev_y, line_spacing;
    PreeditLine preedit_line;
    
    preedit_line = preedit_area[0].lines;
    left = preedit_chars->wchar_len;
    wcstr = preedit_chars->wchar;
    n = 0;
    line_spacing = (ic->core.preedit_attr.line_spacing > 0) ?
      ic->core.preedit_attr.line_spacing : height;
    prev_y = preedit_area[0].y - line_spacing;;
    while (left) {
      wchar_t *p = wcstr;
      int cur_width = 0;
      int i;
      if (n == preedit_area[0].alloc_lines) {
	preedit_area[0].alloc_lines += 10;
	if (!preedit_area[0].lines) {
	  preedit_area[0].lines =
	    (PreeditLine)Xmalloc(sizeof(PreeditLineRec) *
				 preedit_area[0].alloc_lines);
	}
	else {
	  preedit_area[0].lines =
	    (PreeditLine)Xrealloc(preedit_area[0].lines,
				  sizeof(PreeditLineRec) *
				  preedit_area[0].alloc_lines);
	}
	if (!preedit_area[0].lines) return;
	preedit_line = preedit_area[0].lines;
      }
      for (i = 1; i <= left; i++) {
	cur_width += XwcTextEscapement(preedit->fontset, p++, 1);
	if (cur_width > max_width) break;
      }
      preedit_line[n].x = 0;
      preedit_line[n].y = prev_y + line_spacing;
      preedit_line[n].char_offset = wcstr - preedit_chars->wchar;
      preedit_line[n].char_len = i - 1;
      prev_y = preedit_line[n].y;
      n++;
      left -= (i - 1);
      wcstr += i - 1;
    }
    preedit_area[0].active_lines = n;
    height = line_spacing * n;
    if (max_height < height) {
      int i;
      int height_diff = height - max_height;
      for (i = 0; i < n; ++i) {
	preedit_line[i].y -= height_diff;
      }
    }
  }
  if (max_width < width) width = max_width;
  // Is window size changed?
  if (preedit_area[0].win_config.x != ic_preedit_area->x ||
      preedit_area[0].win_config.y != ic_preedit_area->y ||
      preedit_area[0].win_config.width != ic_preedit_area->width ||
      preedit_area[0].win_config.height != ic_preedit_area->height) {
    XMoveResizeWindow(ic->core.im->core.display,
		      preedit_area[0].window,
		      ic_preedit_area->x, ic_preedit_area->y,
		      ic_preedit_area->width, ic_preedit_area->height);
    preedit_area[0].win_config.x = ic_preedit_area->x;
    preedit_area[0].win_config.y = ic_preedit_area->y;
    preedit_area[0].win_config.width = ic_preedit_area->width;
    preedit_area[0].win_config.height = ic_preedit_area->height;
    preedit_area[0].configured = True;
  }
  // Is preedit area not changed ?
  preedit_cache = (CacheRec*)&(preedit->preedit_cache);
  if (preedit_cache->win_x == preedit_area[0].x &&
      preedit_cache->win_y == preedit_area[0].y &&
      preedit_cache->win_width == width &&
      preedit_cache->win_height == height) {
    return;
  }
  preedit_area[0].configured = True;
  /* data cache */
  preedit_cache->win_x = preedit_area[0].x;
  preedit_cache->win_y = preedit_area[0].y;
  preedit_cache->win_width = width;
  preedit_cache->win_height = height;
  preedit_cache->font_set = preedit->fontset;

  return;
}

static void
move(XicCommon ic, XPointer call_data) {
  /* nothing to do */
  return;
}

static PreeditCB preedit_area_methods[] = {
  create,			/* PREEDIT_CREATE */
  set_window,			/* PREEDIT_WIN */
  SetPreeditForeground,		/* PREEDIT_FG */
  SetPreeditBackground,		/* PREEDIT_BG */
  SetPreeditFont,		/* PREEDIT_FONT */
  move,				/* PREEDIT_MOVE */
  PreeditStart,			/* PREEDIT_START */
  PreeditDrawText,		/* PREEDIT_DRAW */
  PreeditCaret,			/* PREEDIT_CARET */
  PreeditDone,			/* PREEDIT_DONE */
  DestroyPreedit		/* PREEDIT_DESTROY */
};

void
ChangePreeditArea(XIC xic, PreeditAttr reason, XPointer call_data) {
  XicCommon ic = (XicCommon)xic;
  if (reason > PREEDIT_DESTROY) return;
  preedit_area_methods[reason](ic, call_data);
  return;
}
