/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

/*
 * $Id: guiIM.h,v 1.3 2004/01/28 21:42:43 tajima Exp $
 */

#ifndef _guiIM_H
#define _guiIM_H

#include "commonIM.h"
#include "xiiimp.h"
#include <X11/X.h>
#include <X11/Xlib.h>

typedef struct _CacheRec {
  int		win_x;
  int		win_y;
  int		win_width;
  int		win_height;
  XFontSet	font_set;
  unsigned long   foreground;
  unsigned long   background;
} CacheRec;

typedef enum {
  STATUS_CREATE = 0,		/* allocate IMstatus data */
  STATUS_WIN = 1,		/* create IMstatus window */
  STATUS_FG = 2,		/* set IMstatus foreground color */
  STATUS_BG = 3,		/* set IMstatus background color */
  STATUS_FONT = 4,		/* set IMstatus fontset */
  STATUS_START = 5,		/* start IMstatus */
  STATUS_DRAW = 6,		/* draw IMstatus */
  STATUS_DONE = 7,		/* done IMstatus */
  STATUS_DESTROY = 8,		/* destroy IMstatus data */
  STATUS_HIDE = 9		/* hide status window */
} StatusAttr;

typedef enum {
  PREEDIT_CREATE = 0,		/* allocate IMpreedit data */
  PREEDIT_WIN = 1,		/* create IMPreedit window */
  PREEDIT_FG = 2,		/* set IMpreedit foreground color */
  PREEDIT_BG = 3,		/* set IMpreedit background color */
  PREEDIT_FONT = 4,		/* set IMpreedit fontset */
  PREEDIT_MOVE = 5,		/* move IMpreedit window */
  PREEDIT_START = 6,		/* start IMpreedit */
  PREEDIT_DRAW = 7,		/* draw IMpreedit */
  PREEDIT_CARET = 8,		/* set caret of IMpreedit */
  PREEDIT_DONE= 9,		/* done IMpreedit */
  PREEDIT_DESTROY = 10		/* destroy IMpreedit data */
} PreeditAttr;

typedef enum {
  LOOKUP_CREATE = 0,		/* allocate IMlookup data */
  LOOKUP_START = 1,		/* start IMlookup */
  LOOKUP_DRAW = 2,		/* draw IMlookup*/
  LOOKUP_PROCESS = 3,		/* process IMlookup */
  LOOKUP_DONE = 4,		/* done IMlookup */
  LOOKUP_MOVE = 5,		/* move IMlookup window */
  LOOKUP_DESTROY = 6,		/* destroy IMlookup data */
  LOOKUP_SETFOCUS = 7		/* setfocus for lookup window */
} LookupAttr;

typedef void (*ChangeStatusProc)(XIC, StatusAttr, XPointer);
typedef void (*ChangePreeditProc)(XIC, PreeditAttr, XPointer);
typedef void (*ChangeLookupProc)(XIC, LookupAttr, XPointer);
typedef void (*RegisterForwardEventProc)(XIC, Bool(*)(XIC, XEvent*));

typedef struct _PreeditWinRec *PreeditWin;
typedef struct _StatusWinRec  *StatusWin;
typedef struct _LookupWinRec  *LookupWin;

typedef struct _XICGUIRec {
  ChangeStatusProc	change_status;
  ChangePreeditProc	change_preedit;
  ChangeLookupProc	change_lookup;
  PreeditWin preedit;
  StatusWin  status;
  LookupWin  lookup;
  int		screen_number;	/* screen number of IC */
  void 		*dl_icpart;	/* for dl gui object */
} XICGUIRec;

#define DEFAULT_FONT_NAME	"-*-*-medium-r-normal--*-*-*-*-c-*-*-*"
#define DEFAULT_FONT_NAME_CDE	"-dt-interface user-*-*-14-*-*"
#define MAX_STATUS_CHARNUM 20
#define MAX_PREEDIT_CHARNUM 20

typedef struct {
  int type;
  Bool (*filter)(Display*, Window, XEvent*, XPointer);
  XPointer client_data;
} XIMFilterRec, *XIMFilter;

/* Public functions for rendering preedit/status/lookup */

extern XICGUI CreateGUI(XicCommon ic, XIMArg *arg);
extern void DestroyGUI(XicCommon);
extern void SetScreenNumber(XicCommon ic);

extern void ChangeStatusArea(XIC, StatusAttr, XPointer);
extern void ChangeStatusNothing(XIC, StatusAttr, XPointer);

extern void ChangePreeditArea(XIC, PreeditAttr, XPointer);
extern void ChangePreeditPosition(XIC, PreeditAttr, XPointer);
extern void ChangePreeditNothing(XIC, PreeditAttr, XPointer);

extern void ChangeLookup(XIC, LookupAttr, XPointer);

/* this might be called from dl object, so need to take XIC as an 
   argument type, instead of Xic  */
extern Bool IMForwardEvent(XicCommon, XEvent*);

/* guiIMClbk.c */
extern int	CallPreeditStartCallback(XicCommon ic, XPointer p);
extern Bool	CallPreeditDrawCallback(XicCommon ic,
					XIMPreeditDrawCallbackStruct *p,
					IMFeedbackList *feedback_list);
extern Bool	CallPreeditCaretCallback(XicCommon ic, XPointer p);
extern Bool	CallPreeditDoneCallback(XicCommon ic, XPointer p);
extern Bool	CallStatusStartCallback(XicCommon ic, XPointer p);
extern Bool	CallStatusDrawCallback(XicCommon ic,
				       XIMStatusDrawCallbackStruct *call_data,
				       IMFeedbackList *feedback_list);
extern Bool	CallStatusDoneCallback(XicCommon ic, XPointer p);

/* IMSettings */
extern Bool IsIMEnabled ();
extern Bool IsIMStatusEnabled ();
extern Bool IsIMStatusAttached ();
extern Bool IsIMLookupEnabled ();
#endif
