#ifndef LEMGR_HH_
#define LEMGR_HH_
#include <string>
#include <map>
#include <vector>
#include "basictype.hh"
#include "IMBasicObject.hh"
#include "lexmlconf.h"
#include "LE.hh"
#include "SunIM.h"

#include "IMHotkey.hh"

class IMInputContext;

class LEMgr
{
    string lepath;

    typedef map<string, LEBase*> LEBaseMap;
    typedef vector<string> LENameVec;
    LEBaseMap lemap;
    LEBase *psunim_default_lebase;
    LENameVec reload_les;
    IIIMLEXMLConf *pxmllecfg;

    bool ledata_inited;
    bool loading_preferred_les;
    IMLangList langlist;
    IMImeInfoList imeinfolist;
    IMDescriptorList imdesclist;
    IMObjectWithDescList imobjectdesclist;
    typedef map<iml_desktop_t *, IMLangList> LEMgrDesktopLangMap;
    LEMgrDesktopLangMap lemgr_dlmap;
    typedef map<iml_desktop_t *, IMDescriptorList> LEMgrDesktopDescMap;
    LEMgrDesktopDescMap lemgr_ddmap;

    typedef map<IMHotkeyProfileStruct*, string> LEHotkeyProfileMap;
    LEHotkeyProfileMap le_hotkey_profile_map;

    bool initialize_ledata();

    void check_new_LEs();
    void check_reloaded_LEs();
    void listup_LEs();

  public:
    const IMLangList* get_all_langlist(iml_desktop_t *curr_desktop);
    const IMDescriptorList* get_all_imdesclist(iml_desktop_t *curr_desktop);
    const bool update_imdesclist(IMLEName *LEname, IMLocale *Locales, int nLocales);
    const IMObjectWithDescList* get_all_imobjectdesclist();

    IMHotkeyProfileStruct *get_hotkey_profiles(int *count_profiles);

    LEContext *choose_LE(
	IMInputContext *pic
    );
    void reload();
    void set_nsmap_config(IMNsMapStruct *nsm, int count);
    LEMgr(const char* lepath);
    LEMgr(const char* lepath, IIIMLEXMLConf &xml);
    LEMgr(const char* lepath, IIIMLEXMLConf &xml, bool preferred_loading);
    virtual ~LEMgr();
};

#endif /* not IMSVRARG_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
