/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "IMLog.hh"
#include "IMKeyUtils.hh"

/*******************************************************************************
                                 IMKeySpec
*******************************************************************************/

IMKeySpec::IMKeySpec(int x_keycode,
		     int x_keychar,
		     int x_modifier,
		     int x_timestamp)
{
	keycode = x_keycode;
	keychar = x_keychar;
	modifier = x_modifier;
	timestamp = x_timestamp;
}

/*******************************************************************************
                 IMKeyParser (helper object to parse key symbols
*******************************************************************************/
IMKeyParser::IMKeyParser(const char *strings)
{
	char *ptop, *pend;
	IMKeySpec *key;
	std::string s;

	ptop = (char *) strings;
	while (ptop) {
		if ((pend = strchr(ptop, ',')) != NULL) {
			s.assign(ptop, pend - ptop);
			ptop = pend + 1;
		} else {
			s.assign(ptop);
			ptop = NULL;
		}
                parse_key(s);
	}
}

void
IMKeyParser::parse_key(std::string& s)
{
	std::string token, mtoken;
	int j, pos, size, mod = 0;
	static struct {
		const char *symbol;
		int modifier;
	} modifiers[] = {
		{"shift", 1}, {"sh", 1}, {"s", 1},
		{"control", 2}, {"ctrl", 2}, {"c", 2},
		{"alt", 4},
		{NULL, 0},
	};
#include "keysyms.h"

	size = s.size();
	for (j = 0; j < size; j++) {
		if (s[j] == '<') {
			pos = s.find('>', j + 1);
			if (pos > j) {
				mtoken = s.substr(j + 1, pos - j - 1);
				for (int i = 0; modifiers[i].symbol != NULL; i++) {
					if (!strcasecmp(modifiers[i].symbol, mtoken.c_str())) {
						mod |= modifiers[i].modifier;
						j = pos;
					}
				}
				if (pos > j) {
					LOG_DEBUG("unknown modifier symbol: %s\n", mtoken.c_str());
				}
			}
		} else {
			if (token.size() > 0) {
				LOG_DEBUG("duplicated key definition. ignoring a previous key(%s)\n", token.c_str());
			}
			pos = s.find('<', j + 1);
			if (pos > j) {
				token = s.substr(j, pos - j);
				j = pos - 1;
			} else {
				token = s.substr(j);
				break;
			}
		}
	}
	if (token.size() > 0) {
		for (j = 0; keysymtable[j].keyname != NULL; j++) {
			if (!strcasecmp (keysymtable[j].keyname, token.c_str())) {
				/* FIXME: xkb's keycode and IIIMF's keycode seems different. */
                                keys.push_back(IMKeySpec(keysymtable[j].keysym,
                                               keysymtable[j].keysym,
                                               mod,
                                               0));
                                return;
			}
		}
		LOG_DEBUG("cannot parse the unknown key(%s)\n", token.c_str());
	}

        return;
}

std::string
IMKeyParser::generate_key(IMKeySpec &spec)
{
	int keycode = spec.get_keycode();
	int modifier = spec.get_modifier();
	std::string key;
	static struct {
		const char *symbol;
		int modifier;
	} modifiers[] = {
		{"Shift", 1}, {"Control", 2}, {"Alt", 4}, {NULL, 0}
	};
#include "keysyms.h"

	for (int i = 0; modifiers[i].symbol != NULL; i++) {
		if (modifier & modifiers[i].modifier) {
			key += std::string("<") + std::string(modifiers[i].symbol) + std::string(">");
		}
	}
	for (int j = 0; keysymtable[j].keyname != NULL; j++) {
		if (keysymtable[j].keysym == keycode) {
			key += std::string(keysymtable[j].keyname);
			return key;
		}
	}
	key = "";

	return key;
}
