#ifndef IMDESKTOP_HH_
#define IMDESKTOP_HH_
#include <SunIM.h>
#include <string>
#include <vector>
#include <map>
#include "basictype.hh"

class IMUser;
class LEBase;
class LEContext;
class IMDesktop
{
  public:
    enum IMDESKTOP_ATTRS {
	    CLIENT_HOST,
	    CLIENT_NAME,
	    OS_NAME,
	    OS_ARCH,
	    OS_VERSION,
	    X_DISPLAY_NAME,
	    X_SERVER_VENDOR
    };
    typedef map<int, u16string> IMDesktopAttr;

    enum CLIENT_TYPE {
	    IIIMXCF,
	    IIIMJCF,
	    IIIMECF,
	    IIIMGCF,
	    UNKNOWN_CLIENT
    };

  private:
    IMUser *puser;
    IMDesktopAttr attrs;
    bool iiim_xbe;
    string desktop_display_name;

    enum CLIENT_TYPE client_type;

    void initialize();

    typedef map<LEBase*, iml_desktop_t*> IMLDesktopMap;
    IMLDesktopMap iml_desktop_map;

    iml_desktop_t* create_iml_desktop(
	LEContext &lec
    );

  public:
    iml_desktop_t* request_iml_desktop(
	LEContext &lec
    );
    void release_iml_desktop(
	LEContext &lec,
	iml_desktop_t *iml_desktop
    );
    bool match(
	IMDesktopAttr &attrs
    );
    const u16string* get_attr(
	enum IMDESKTOP_ATTRS attr
    );
    const string& get_desktop_display_name() const
    { return desktop_display_name; }
    enum CLIENT_TYPE get_client_type() const
    { return client_type; }
    bool iiim_xbe_p() const
    { return iiim_xbe; }
    void get_iml_desktop_args(
	vector<IMArg> &args
    );
    void get_lecontext_args(
	vector<IMArg> &args
    );
    IMDesktop(
	IMUser *pu
    );
    IMDesktop(
	IMUser *pu,
	IMDesktopAttr& attrs
    );
    virtual ~IMDesktop();
};

#endif /* not IMDESKTOP_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
