/*
  lookup.cpp
  Copyright (C) 2003 Free Standards Group

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL OPENI18N WG OR FREE STANDARDS GROUP. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

  Except as contained in this notice, the names of OpenI18N WG and/or
  Free Standards Group shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from OpenI18N WG and/or Free Standards Group
  as applicable.

  Author: ILGYOUNG PARK <Karl.Park@Sun.COM>
	  TuBo	<Gavin.Tu@Sun.COM>

*/
#include <qapplication.h>

#include "lookup.h"
#include "debug.h"

static const int MIN_CAND_WIDTH = 80;

const Qt::WFlags candidateFlag = ( Qt::WType_TopLevel
                                   | Qt::WStyle_Customize
                                   | Qt::WStyle_StaysOnTop
                                   | Qt::WStyle_NoBorder
                                   | Qt::WStyle_Tool
				   | Qt::WPaintClever	
#if defined(Q_WS_X11)
                                   | Qt::WX11BypassWM
#endif

                                   );

IIIMQCFLookup::IIIMQCFLookup(QWidget *w, IIIMInputContext *ic)
	
{
  iiimqc = ic;
  vbox = new QVBox(w, 0, candidateFlag); 

  numLabel = new QLabel(vbox, "candidateLabel");
  lw = new QListBox (vbox, "candidateListBox");
  lw->setVScrollBarMode(QScrollView::AlwaysOff);
  lw->setHScrollBarMode(QScrollView::AlwaysOff);
  lw->setFocusPolicy (QWidget::NoFocus);
  
}



IIIMQCFLookup::~IIIMQCFLookup()
{
  if(vbox)
	 delete vbox;
}



void
IIIMQCFLookup::showLookupWindow (QWidget *w)
{
  if (lw->count() > 0)
  {
     vbox->raise();
     vbox->show();
   }
  DEBUG_DO(qDebug("**IIIMQCF: showLookupWindow() after setFocus\n"));
}



void
IIIMQCFLookup::hideLookupWindow (void)
{
 vbox->hide();
}



void
IIIMQCFLookup::setLookupChoices (QStringList &lc,
				 int size,
				 int first_index,
				 int last_index,
				 int current_index)

{
  clearLookupChoices ();
  lw->insertStringList (lc);
  lw->setCurrentItem (current_index);
  adjustLookupWindowSize();
}


void 
IIIMQCFLookup::setLookupTitle(QString title)
{
  updateLabel(title);
}


void
IIIMQCFLookup::clearLookupChoices (void)
{
  lw->clear ();
}


bool
IIIMQCFLookup::isVisible () const
{
  return lw->isVisible ();
}


void 
IIIMQCFLookup::layoutWindow(int x, int y, int w, int h)
{
    DEBUG_DO(qDebug("**IIIMQCF: layoutWindow: x is %d, y is %d, w is %d, h is %d\n", x, y, w, h));
    QRect focusRect  = QRect(QPoint(x, y + h), vbox->frameSize());

    QRect screenRect = QRect(0, 0,
                             QApplication::desktop()->screenGeometry().width(),
                             QApplication::desktop()->screenGeometry().height());

    QPoint p = forceInside(screenRect, focusRect);
    vbox->move(p);

}


QPoint IIIMQCFLookup::forceInside(const QRect &enclosure, const QRect &prisoner)
{
    int new_x, new_y;

    new_x = QMIN(enclosure.right(), prisoner.right()) - prisoner.width() + 1;
    new_x = QMAX(enclosure.left(), new_x);
    new_y = QMIN(enclosure.bottom(), prisoner.bottom()) - prisoner.height() + 1;
    new_y = QMAX(enclosure.top(), new_y);

    return QPoint(new_x, new_y);
}


void IIIMQCFLookup::updateLabel(QString title)
{
    numLabel->setText(title);
}



void IIIMQCFLookup::adjustLookupWindowSize()
{
    DEBUG_DO(qDebug("**IIIMQCF: adjustCandidateWindowSize()"));

    int width  = 0;
    int height = 0;
    QListBoxItem *item =lw->item(0);
    if (item)
        height = item->height(lw) * (lw->count() + 1);

    unsigned int maxCharIndex = 0, maxCharCount = 0;
    for (int i = 0; i < lw->count(); i++) {
        if (maxCharCount < lw->item(i)->text().length()) {
            maxCharIndex = i;
 	    maxCharCount = lw->item(i)->text().length();
        }
    }

    QFontMetrics fm(lw->font());
    if(lw->item(maxCharIndex))
	    width  = fm.width(lw->item(maxCharIndex)->text() + "   " + lw->item(maxCharIndex)->text());

    if (width < MIN_CAND_WIDTH)
        width = MIN_CAND_WIDTH;

    vbox->resize(width, height);
}

