/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ICOLORBARS_H
#define ICOLORBARS_H


#include "iobject.h"


#include "iarray.h"
#include "iparameter.h"

class iColorBarActor;
class iColorBarLabel;
struct iColorBarItem;
class iDataType;
class iPalette;

class vtkActor2D;


struct iColorBarItem
{
	int Var;
	int Palette;
	int DataTypeId;
	int Priority;
	int Count;
	bool operator<(const iColorBarItem &item) const;
	bool operator==(const iColorBarItem &item) const;
};


class iColorBars: public iObject
{
	
	IPOINTER_AS_PART(ViewModule);

public:
	
	vtkTypeMacro(iColorBars,iObject);
	static iColorBars* New(iViewModule *vm = 0);
	static const iObjectType& Type();
	
	IOBJECT_DECLARE_GETSET1(Color,iColor);
	//virtual void SetColor(iColor c);
	//inline iColor GetColor() const { return mColor; }

	IOBJECT_DECLARE_GETSET2(SideOffset,float);
	//virtual void SetSideOffset(float v);
	//float GetSideOffset() const;

	IOBJECT_DECLARE_GETSET2(Size,float);
	//virtual void SetSize(float v);
	//float GetSize() const;

	IOBJECT_DECLARE_GETSET1(Automatic,bool);
	//virtual void SetAutomatic(bool);
	//inline bool GetAutomatic() const { return mAutomatic; }

	void SetBar(int bar, int v, int id, int p); 
	void GetBar(int bar, int &v, int &id, int &p) const; 
	static const iObjectKey& KeyBarLeft();
	static const iObjectKey& KeyBarRight();

	void ShowBar(int priority, int v, const iDataType &dt, int p, bool s);

	const iColorBarItem* GetItem(bool left);
	vtkActor2D* GetActor(bool left) const;

protected:
	
	virtual ~iColorBars();
	
	virtual void PackStateBody(iString &s) const;
	virtual void UnPackStateBody(const iString &s);

private:

	iColorBars(iViewModule *vm);

	iOrderedArray<iColorBarItem>& Queue();

	bool mAutomatic;
	iColor mColor;

	iOrderedArray<iColorBarItem> mAutomaticBars;
	iOrderedArray<iColorBarItem> mManualBars;

	static const iColorBarItem NullItem;

	iColorBarActor *mActors[2];
};


inline iOrderedArray<iColorBarItem>& iColorBars::Queue()
{
	return mAutomatic ? mAutomaticBars : mManualBars;
}

#endif // ICOLORBARS_H
