/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef NOATUNPlaylistLoader_H
#define NOATUNPlaylistLoader_H

#include <qmap.h>
#include <qfile.h>


/**
 * Most of this code was taken from the noatun playlist source code.
 * Holds a playlist entry.
 **/
class PlayListEntry
   {
public:
   PlayListEntry(): fl("") {}
   PlayListEntry( const QString& filename, const QString& title, const QString& length )
         : fl(filename), tl(title), ln(length)
      {}

   QString filename() const { return fl; }
   QString title() const { return tl; }
   QString length() const { return ln; }

private:
   QString fl;
   QString tl;
   QString ln;
   };

typedef QValueList<PlayListEntry> PlayList;

/**
 * Most of this code was taken from the noatun playlist source code.
 * Reads playlist files.
 **/
class PlaylistLoader
   {
public:
   enum Options
   {
      XMLPlaylist=1,
      M3U=2,
      PLS=4,
      EXTM3U=8,
      ASX=16
   };

   PlayList list;

   PlaylistLoader();
   virtual ~PlaylistLoader();

   /**
    * Read a file parsing through the file while calling readItem.
    * The items looked for are "url", "file", "title", "author"
    * and "length".
    * Currently there is no support for remote files or nonlocal URLs.
    * @param playlistfile the file to be opened and read
    * @param options the type of playlist
    * @return returns true on success.
    * \brief Loads a playlist file.
    */
   bool load(QFile &playlistfile, int options=0);
   /**
    * This function gets the total size of all files in the playlist.
    * @return returns size on success
    * \brief Returns the size of the playlist.
    */
   int  sizeOfPlaylist();
   /**
    * This function returns the total number of files in the playlist.
    * @return returns numbers of files on success
    * \brief Returns total number of files in the playlist.
    */
   int  numFilesInPlaylist();

protected:
   /**
    * Populates a playlist entry based on the input QString Map
    * which coincide with the standard noatun ones.
    * Both url and file are treated the same.
    * @param properties a QString Map that holds the info.
    * \brief Populates a playlist entry based on the input QString Map.
    */
   void readItem(const QMap<QString,QString> &properties);


   /**
    * This is called when you should either clear your list,
    * or start writing from the start of the list.
    *
    * You usually don't need to implement this, since it'l always
    * be called immediately after load() or save()
    * \brief Clears the playlist entries.
    **/
   virtual void reset() {}

private:
   /**
    * Read a M3U file parsing through the file while calling readItem.
    * The items looked for are url/file, title, author and length.
    * Currently there is no support for remote files or nonlocal URLs.
    * @param playlistfile the file to be opened and read
    * @param opt the type of playlist (not used for M3U)
    * @return bool (true/false) did it load or not.
    * \brief Loads M3U format playlist
    */
   bool loadM3U(QFile &playlistfile, int x=0);
   };

#endif
