/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>


/**
 * Dialog box that allows the user to enter a new directory name.
 */
class CreateDirWindow: public QDialog
{
   Q_OBJECT

   public:
      CreateDirWindow(const char *caption=0);
      ~CreateDirWindow();

      /**
       * Use this to enter a default string for the dialog box.
       * @param fileName
       */
      void setNewDirName(const QString &dirName);
      QString getNewDirName() const { return baseDir + dirTextBox->text(); }
      /**
       * Use this to set the base directory.
       * @param fileName
       */
      void setBaseDir(const QString &value)
         {
         baseDir = value;
         if (baseDir.right(baseDir.length()) != "/")
            baseDir.append("/");
         }
      QString getBaseDir() const { return baseDir; }

   public slots:
      virtual void btnOk_clicked();
      virtual void btnCancel_clicked();

   signals:
      /**
       * This signal is emitted when the user presses the OK button
       * @param QString the returned string entered by the user
       */
      void btnOkClicked(const QString &);
      /**
       * This signal is emitted when the user presses the Cancel button.
       */
      void btnCancelClicked(void);


   private:
      QGridLayout *layout;
      QLabel *lblInstructions;
      QLineEdit *dirTextBox;
      QPushButton *btnCancel;
      QPushButton *btnOk;
      QString baseDir;
};

