dnl  
dnl  keymap.m4inc - Macros for keymap definitions.
dnl  
dnl  Author: Lorentey Karoly <lorentey@elte.hu>.
dnl  
dnl  Time-stamp: <2001-09-19 01:15:58 lorentey>
dnl
divert(-1)

dnl Undefine the `shift' builtin.
define(`m4_shift',defn(`shift'))
undefine(`shift')

dnl Check that we were included from a generator file.
ifdef(`keymap_generator', , `errprint(`Please run m4 on a generator file.
')m4exit')

define(`new_key',    `                               keycode $1 = ')
define(`add_none', `$1')
define(`add_plain',  `plain                          substr($1,31)')
define(`add_shiftl', `shiftl substr($1,7)')
define(`add_hun', defn(`add_shiftl'))
define(`add_shift',  `substr($1,0,6) shift substr($1,13)')
define(`add_altgr',  `substr($1,0,12) altgr substr($1,19)')
define(`add_control',`substr($1,0,18) control substr($1,27)')
define(`add_alt',    `substr($1,0,26) alt substr($1,31)')

define(`rem_shiftl', `       substr($1,7)')
define(`rem_shift',  `substr($1,0,6)       substr($1,13)')
define(`rem_altgr',  `substr($1,0,12)       substr($1,19)')
define(`rem_control',`substr($1,0,18)         substr($1,27)')
define(`rem_alt',    `substr($1,0,26)     substr($1,31)')

define(`add_mod', `indir(`add_$1', ``$2'')')

define(`apply_mod', 
       `ifelse($#, 1, `$1', $#, 2, `add_mod(`$2', `$1')',
	       `apply_mod(add_mod(`$2', `$1'), m4_shift(m4_shift($@)))')')

define(`defkey', `ifelse($#, 2, `new_key($1)$2',
                         `apply_mod(new_key($1)$2, m4_shift(m4_shift($@)))')')

define(`bothdefkey', `defkey($@)
defkey($@,shiftl)')

define(`ctrlalt', 
`defkey($@)
pushdef(`temp', ifelse($#, 2, `none', ``m4_shift(m4_shift($@))''))dnl
defkey($1, Control_$2, temp, control)
defkey($1, Meta_$2, temp, alt)
defkey($1, Meta_Control_$2, temp, control, alt)')popdef(`temp')')

define(`newsection',
`######################################################################
`#' $1
`######################################################################'')

dnl A key that has a single keysym, no matter what modifiers are in
dnl effect.  (Example: Insert)
define(`uniform_key', `
# Uniform Key: $2.
defkey($1, $2)')

dnl Mode dependent keys have two keysyms, one for both languages.
define(`mode_dependent_key', `
# Mode dependent key: $2/$3.
defkey($1, $2)
defkey($1, $3, hun)
defkey($1, $3, hun, shift)
defkey($1, $3, hun, altgr)
defkey($1, $3, hun, altgr, shift)
defkey($1, $3, hun, control)
defkey($1, $3, hun, control, shift)
defkey($1, $3, hun, altgr, control)
defkey($1, $3, hun, altgr, control, shift)
defkey($1, $3, hun, alt)
defkey($1, $3, hun, alt, shift)
defkey($1, $3, hun, altgr, alt)
defkey($1, $3, hun, altgr, alt, shift)
defkey($1, $3, hun, control, alt)
defkey($1, $3, hun, control, alt, shift)
defkey($1, $3, hun, altgr, control, alt)
defkey($1, $3, hun, altgr, control, alt, shift)')

dnl A system key behaves differently when an Alt-like modifier is in
dnl effect.  (Example: Up, Down.)
define(`system_key', `
# System Key: $2/$3.
defkey($1, $2)
bothdefkey($1, $3, alt)
bothdefkey($1, $3, alt, shift)
bothdefkey($1, $3, alt, control)
bothdefkey($1, $3, alt, control, shift)
bothdefkey($1, $3, altgr)
bothdefkey($1, $3, altgr, shift)
bothdefkey($1, $3, altgr, control)
bothdefkey($1, $3, altgr, control, shift)
bothdefkey($1, $3, altgr, alt)
bothdefkey($1, $3, altgr, alt, shift)
bothdefkey($1, $3, altgr, alt, control)
bothdefkey($1, $3, altgr, alt, control, shift)')

dnl Simple keys have two keysyms, a main keysym and its Meta_
dnl counterpart. (Example: Escape, Tab.)
define(`simple_key',`
# Simple Key: $2.
bothdefkey($1, $2)
bothdefkey($1, $2, shift)
bothdefkey($1, $2, control)
bothdefkey($1, $2, control, shift)
bothdefkey($1, Meta_$2, alt)
bothdefkey($1, Meta_$2, alt, shift)
bothdefkey($1, Meta_$2, alt, control)
bothdefkey($1, Meta_$2, alt, control, shift)
defkey($1, Meta_$2, altgr)
defkey($1, Meta_$2, altgr, shift)
defkey($1, Meta_$2, altgr, control)
defkey($1, Meta_$2, altgr, control, shift)
defkey($1, $2, hun, altgr)
defkey($1, $2, hun, altgr, shift)
defkey($1, $2, hun, altgr, control)
defkey($1, $2, hun, altgr, control, shift)
defkey($1, Meta_$2, hun, altgr, alt)
defkey($1, Meta_$2, hun, altgr, alt, shift)
defkey($1, Meta_$2, hun, altgr, alt, control)
defkey($1, Meta_$2, hun, altgr, alt, control, shift)')

dnl We provide support for 48 function keys and 48 console
dnl instances.
define(`function_key',`
# Function key F$2.
bothdefkey($1, F$2)
bothdefkey($1, F$3, shift)
bothdefkey($1, F$4, control)
bothdefkey($1, F$5, control, shift)
bothdefkey($1, Console_$2, alt)
bothdefkey($1, Console_$3, alt, shift)
bothdefkey($1, Console_$4, alt, control)
bothdefkey($1, Console_$5, alt, control, shift)
bothdefkey($1, Console_$2, altgr)
bothdefkey($1, Console_$3, altgr, shift)
bothdefkey($1, Console_$4, altgr, control)
bothdefkey($1, Console_$5, altgr, control, shift)
bothdefkey($1, Console_$2, altgr, alt)
bothdefkey($1, Console_$3, altgr, alt, shift)
bothdefkey($1, Console_$4, altgr, alt, control)
bothdefkey($1, Console_$5, altgr, alt, control, shift)')

dnl Complex keys are those that have individual non-alphabetic keysyms
dnl for both languages, with Meta_ versions.
define(`complex_key',`
# Complex key $2.
defkey($1, $2, plain)
defkey($1, Meta_$2, alt)
defkey($1, Meta_$2, altgr)
defkey($1, Meta_$2, altgr, alt)
defkey($1, $3, shift)
defkey($1, Meta_$3, alt, shift)
defkey($1, Meta_$3, altgr, shift)
defkey($1, Meta_$3, altgr, alt, shift)
defkey($1, $4, hun)
defkey($1, Meta_$4, hun, alt)
defkey($1, $5, hun, shift)
defkey($1, Meta_$5, hun, alt, shift)
defkey($1, $6, hun, altgr)
defkey($1, $6, hun, altgr, shift)')

dnl Accented letters are symbolic/numeric in the first language, but
dnl alphabetic in the other.  (Example: 0/odiaeresis)
define(`accented_letter',`
# Accented letter $2/$4.
defkey($1, nul)
defkey($1, $2, plain)
defkey($1, Meta_$2, alt)
defkey($1, Meta_$2, altgr)
defkey($1, Meta_$2, altgr, alt)
defkey($1, $3, shift)
defkey($1, Meta_$3, alt, shift)
defkey($1, Meta_$3, altgr, shift)
defkey($1, Meta_$3, altgr, alt, shift)
defkey($1, +$4, hun)
defkey($1, +$5, hun, shift)
defkey($1, $6, hun, altgr)')

dnl Alphabetic keys may have different definitions in the two
dnl languages.  (Example: QWERTY/QWERTZ.)
define(`letter', `
# Letter $3.
defkey($1, nul)
defkey($1, +$2, plain)
defkey($1, +$3, shift)
defkey($1, Control_$2, control)
defkey($1, Control_$2, control, shift)
defkey($1, Meta_$2, alt)
defkey($1, Meta_$2, altgr)
defkey($1, Meta_$2, altgr, alt)
defkey($1, Meta_$3, alt, shift)
defkey($1, Meta_$3, altgr, shift)
defkey($1, Meta_$3, altgr, alt, shift)
defkey($1, Meta_Control_$2, alt, control)
defkey($1, Meta_Control_$2, altgr, control)
defkey($1, Meta_Control_$2, altgr, alt, control)
defkey($1, Meta_Control_$2, alt, control, shift)
defkey($1, Meta_Control_$2, altgr, control, shift)
defkey($1, Meta_Control_$2, altgr, alt, control, shift)
defkey($1, +$4, hun)
defkey($1, +$5, hun, shift)
defkey($1, Control_$4, hun, control)
defkey($1, Control_$4, hun, control, shift)
defkey($1, Meta_$4, hun, alt)
defkey($1, Meta_$5, hun, alt, shift)
defkey($1, Meta_Control_$4, hun, alt, control)
defkey($1, Meta_Control_$4, hun, alt, control, shift)
ifelse($6, , , 
       $6, nometa, `defkey($1, $7, hun, altgr)
', `defkey($1, $6, hun, altgr)
defkey($1, Meta_$6, hun, altgr, alt)')')


divert`'dnl
dnl Insert a standard warning comment.
#
#    THIS IS AN AUTOGENERATED FILE. PLEASE DO NOT EDIT.
#
dnl Local Variables:
dnl mode: m4
dnl End:
