#!/bin/bash

msg()
{
    echo -en "$1"
}
	
die(){
    msg "$1\n"
    exit 1
}


[ -z "$1" -o -z "$2" ] && die "Missing argument"

SUBDIRS="12x12 16x16 26x26 34x34 40x40 50x50 250x250 scalable"
CATEGORIES="apps devices filesystems mimetypes hildon"

for d in $SUBDIRS; do 
    for s in $CATEGORIES; do 
	mkdir -p $2/$d/$s
    done
done

pushd $2

for i in $1/*/*.png; do 
	INFO="`file $i | sed -e 's/,//g'`"
	IX="`echo $INFO | awk -- '{ print $5}'`"
	IY="`echo $INFO | awk -- '{ print $7}'`"

	[ -n "$DH_VERBOSE" ] && echo "$i $IX $IY"
	if [ "$IX" = "$IY" ]; then
		[ -d "${IX}x${IY}/hildon" ] || die "Something wrong ? Directory ${IX}x${IY}/hildon missing"
		cp -a $i ${IX}x${IY}/hildon/
	else
		cp -a $i scalable/hildon/
	fi
done

# Workarounds for animations
cp -a $1/34x34/qgn_indi_tap_hold_a.ani 34x34/hildon/
cp -a $1/40x40/qgn_indi_batterycharging_a.ani 40x40/hildon/
#cp -a $1/50x50/qgn_indi_offmode_batterycharging_a.ani 50x50/hildon/

for i in 110x60/qgn_indi_copy_a.ani 22x24/qgn_indi_pball_a.ani 54x60/qgn_indi_process_a.ani 63x60/qgn_indi_send_a.ani 64x54/qgn_indi_send_recieve_a.ani 91x54/qgn_indi_delete_a.ani; do 
 cp -a $1/$i scalable/hildon/
done

popd

