{- This module was generated from data in the Kate syntax
   highlighting file makefile.xml, version 1.12, by Per Wigren (wigren@home.se) -}

module Text.Highlighting.Kate.Syntax.Makefile
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Makefile"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "GNUmakefile;Makefile;makefile;GNUmakefile.*;Makefile.*;makefile.*"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Makefile" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Makefile",["Normal"])], synStLanguage = "Makefile", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "String" -> (popContext) >> pEndLine
    "Value" -> (popContext) >> pEndLine
    "VarFromValue(" -> return ()
    "VarFromValue{" -> return ()
    "VarFromNormal(" -> return ()
    "VarFromNormal{" -> return ()
    "FunctionCall(" -> return ()
    "FunctionCall{" -> return ()
    "Commands" -> (popContext) >> pEndLine
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "include define else endef endif ifdef ifeq ifndef ifneq"
list_functions = Set.fromList $ words $ "call subst patsubst strip findstring filter filter-out sort word wordlist words firstword lastword dir notdir suffix basename addsuffix addprefix join wildcard realpath abspath if or and foreach value eval origin flavor shell error warning info"

regex_'5b'5f'5cw'5cd'5d'2a'5cs'2a'28'3f'3d'3a'3d'7c'3d'7c'5c'2b'3d'7c'5c'3f'3d'29 = compileRegex "[_\\w\\d]*\\s*(?=:=|=|\\+=|\\?=)"
regex_'5b'5f'5cw'5cd'2d'5d'2a'5cs'2a'3a = compileRegex "[_\\w\\d-]*\\s*:"
regex_'5b'2e'5d'2e'2a'3a = compileRegex "[.].*:"
regex_'23'2e'2a'24 = compileRegex "#.*$"
regex_'40'5b'2d'5f'5cd'5cw'5d'2a'40 = compileRegex "@[-_\\d\\w]*@"
regex_'5b'5f'5cw'2d'5d'2a'5cb = compileRegex "[_\\w-]*\\b"

defaultAttributes = [("Normal",NormalTok),("String",StringTok),("Value",StringTok),("VarFromValue(",DataTypeTok),("VarFromValue{",DataTypeTok),("VarFromNormal(",DataTypeTok),("VarFromNormal{",DataTypeTok),("FunctionCall(",StringTok),("FunctionCall{",StringTok),("Commands",NormalTok)]

parseRules "Normal" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5b'5f'5cw'5cd'5d'2a'5cs'2a'28'3f'3d'3a'3d'7c'3d'7c'5c'2b'3d'7c'5c'3f'3d'29 >>= withAttribute DataTypeTok) >>~ pushContext "Value")
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'5b'5f'5cw'5cd'2d'5d'2a'5cs'2a'3a >>= withAttribute DecValTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5b'2e'5d'2e'2a'3a >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((pDetect2Chars False '$' '{' >>= withAttribute CharTok) >>~ pushContext "VarFromNormal{")
   <|>
   ((pDetect2Chars False '$' '(' >>= withAttribute CharTok) >>~ pushContext "VarFromNormal(")
   <|>
   ((pDetect2Chars False '\\' '#' >>= withAttribute FloatTok))
   <|>
   ((pDetect2Chars False '\\' '\\' >>= withAttribute FloatTok))
   <|>
   ((pAnyChar "+*=%$():\\;" >>= withAttribute CharTok))
   <|>
   ((pFirstNonSpace >> pAnyChar "@-" >>= withAttribute CharTok) >>~ pushContext "Commands")
   <|>
   ((pRegExpr regex_'23'2e'2a'24 >>= withAttribute CommentTok)))

parseRules "String" =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Value" =
  (((pLineContinue >>= withAttribute CharTok))
   <|>
   ((pDetect2Chars False '$' '{' >>= withAttribute CharTok) >>~ pushContext "VarFromValue{")
   <|>
   ((pDetect2Chars False '$' '(' >>= withAttribute CharTok) >>~ pushContext "VarFromValue(")
   <|>
   ((pRegExpr regex_'40'5b'2d'5f'5cd'5cw'5d'2a'40 >>= withAttribute FloatTok) >>~ (popContext))
   <|>
   ((pDetectChar False ';' >>= withAttribute CharTok) >>~ (popContext)))

parseRules "VarFromValue(" =
  ((pDetectChar False ')' >>= withAttribute CharTok) >>~ (popContext))

parseRules "VarFromValue{" =
  ((pDetectChar False '}' >>= withAttribute CharTok) >>~ (popContext))

parseRules "VarFromNormal(" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_functions >>= withAttribute KeywordTok) >>~ pushContext "FunctionCall(")
   <|>
   ((pDetectChar False ')' >>= withAttribute CharTok) >>~ (popContext)))

parseRules "VarFromNormal{" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_functions >>= withAttribute KeywordTok) >>~ pushContext "FunctionCall{")
   <|>
   ((pDetectChar False '}' >>= withAttribute CommentTok) >>~ (popContext)))

parseRules "FunctionCall(" =
  (((pDetect2Chars False '$' '{' >>= withAttribute CharTok) >>~ pushContext "VarFromNormal{")
   <|>
   ((pDetect2Chars False '$' '(' >>= withAttribute CharTok) >>~ pushContext "VarFromNormal(")
   <|>
   ((pDetectChar False ')' >>= withAttribute CharTok) >>~ (popContext >> popContext)))

parseRules "FunctionCall{" =
  (((pDetect2Chars False '$' '{' >>= withAttribute CharTok) >>~ pushContext "VarFromNormal{")
   <|>
   ((pDetect2Chars False '$' '(' >>= withAttribute CharTok) >>~ pushContext "VarFromNormal(")
   <|>
   ((pDetectChar False '}' >>= withAttribute CharTok) >>~ (popContext >> popContext)))

parseRules "Commands" =
  (((pDetect2Chars False '$' '{' >>= withAttribute CharTok) >>~ pushContext "VarFromNormal{")
   <|>
   ((pDetect2Chars False '$' '(' >>= withAttribute CharTok) >>~ pushContext "VarFromNormal(")
   <|>
   ((pRegExpr regex_'5b'5f'5cw'2d'5d'2a'5cb >>= withAttribute BaseNTok) >>~ (popContext)))

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
