{- This module was generated from data in the Kate syntax highlighting file monobasic.xml, version 1.01,
   by  Davide Bettio (davide.bettio@kdemail.net) -}

module Text.Highlighting.Kate.Syntax.Monobasic ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "MonoBasic"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.vb"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "MonoBasic" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("MonoBasic",["Normal"])], synStLanguage = "MonoBasic", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return () >> pHandleEndLine
    "String" -> (popContext) >> pEndLine
    "Comment" -> (popContext) >> pEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Type","dt"),("String","st"),("Preprocessor","ot"),("Comment","co")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "option explicit strict imports inherits as new dim redim private friend public const readonly writeonly default shared shadows protected overloads overrides notoverridable notinheritable mustinherit mustoverride mybase myclass me delegate catch finaly when throw to step then else true false nothing call byval byref optional paramarray return declare withevents event raiseevent addhandler and or not xor andalso orelse goto on error resume"
list_types = Set.fromList $ words $ "boolean char string integer long double object exception date datetime int16 int32 int64 paramarray timespan byte decimal intptr single guid"

regex_'5cb'28Namespace'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Namespace)([\\s]|$)"
regex_End'2eNamespace'2e'2a'24 = compileRegex "End.Namespace.*$"
regex_'5cb'28Module'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Module)([\\s]|$)"
regex_End'2eModule'2e'2a'24 = compileRegex "End.Module.*$"
regex_'5cb'28Class'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Class)([\\s]|$)"
regex_End'2eClass'2e'2a'24 = compileRegex "End.Class.*$"
regex_'5cb'28Interface'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Interface)([\\s]|$)"
regex_End'2eInterface'2e'2a'24 = compileRegex "End.Interface.*$"
regex_'5cb'28Structure'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Structure)([\\s]|$)"
regex_End'2eStructure'2e'2a'24 = compileRegex "End.Structure.*$"
regex_'5cb'28Enum'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Enum)([\\s]|$)"
regex_End'2eEnum'2e'2a'24 = compileRegex "End.Enum.*$"
regex_'5cb'28Property'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Property)([\\s]|$)"
regex_End'2eProperty'2e'2a'24 = compileRegex "End.Property.*$"
regex_'5cb'28Get'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Get)([\\s]|$)"
regex_End'2eGet'2e'2a'24 = compileRegex "End.Get.*$"
regex_'5cb'28Set'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Set)([\\s]|$)"
regex_End'2eSet'2e'2a'24 = compileRegex "End.Set.*$"
regex_'5cb'28Sub'29'28'5b'2e'5cs'5d'7c'24'29 = compileRegex "\\b(Sub)([.\\s]|$)"
regex_End'2eSub'2e'2a'24 = compileRegex "End.Sub.*$"
regex_Exit'2eSub'2e'2a'24 = compileRegex "Exit.Sub.*$"
regex_'5cb'28Function'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Function)([\\s]|$)"
regex_End'2eFunction'2e'2a'24 = compileRegex "End.Function.*$"
regex_Exit'2eFunction'2e'2a'24 = compileRegex "Exit.Function.*$"
regex_'5cb'28Try'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Try)([\\s]|$)"
regex_End'2eTry'2e'2a'24 = compileRegex "End.Try.*$"
regex_'5cb'28If'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(If)([\\s]|$)"
regex_End'2eIf'2e'2a'24 = compileRegex "End.If.*$"
regex_Select'2eCase'2e'2a'24 = compileRegex "Select.Case.*$"
regex_End'2eSelect'2e'2a'24 = compileRegex "End.Select.*$"
regex_'5cb'28For'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(For)([\\s]|$)"
regex_'5cb'28Next'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Next)([\\s]|$)"
regex_'5cb'28Do'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Do)([\\s]|$)"
regex_'5cb'28Loop'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(Loop)([\\s]|$)"
regex_'5cb'28While'29'28'5b'5cs'5d'7c'24'29 = compileRegex "\\b(While)([\\s]|$)"
regex_End'2eWhile'2e'2a'24 = compileRegex "End.While.*$"
regex_Exit'2eWhile'2e'2a'24 = compileRegex "Exit.While.*$"
regex_'23Region'2e'2a'24 = compileRegex "#Region.*$"
regex_'23End'2eRegion'2e'2a'24 = compileRegex "#End.Region.*$"
regex_'23If'2e'2a'24 = compileRegex "#If.*$"
regex_'23End'2eIf'2e'2a'24 = compileRegex "#End.If.*$"

defaultAttributes = [("Normal","Normal Text"),("String","String"),("Comment","Comment")]

parseRules "Normal" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute "Type"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Comment") >>~ pushContext "Comment")
                        <|>
                        ((pRegExpr regex_'5cb'28Namespace'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eNamespace'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Module'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eModule'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Class'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eClass'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Interface'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eInterface'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Structure'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eStructure'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Enum'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eEnum'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Property'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eProperty'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Get'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eGet'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Set'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eSet'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Sub'29'28'5b'2e'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eSub'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_Exit'2eSub'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Function'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eFunction'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_Exit'2eFunction'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Try'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eTry'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28If'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eIf'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_Select'2eCase'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eSelect'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28For'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Next'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Do'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28Loop'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28While'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_End'2eWhile'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_Exit'2eWhile'2e'2a'24 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'23Region'2e'2a'24 >>= withAttribute "Preprocessor"))
                        <|>
                        ((pRegExpr regex_'23End'2eRegion'2e'2a'24 >>= withAttribute "Preprocessor"))
                        <|>
                        ((pRegExpr regex_'23If'2e'2a'24 >>= withAttribute "Preprocessor"))
                        <|>
                        ((pRegExpr regex_'23End'2eIf'2e'2a'24 >>= withAttribute "Preprocessor")))
     return (attr, result)

parseRules "String" = 
  do (attr, result) <- (((pLineContinue >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pHlCStringChar >>= withAttribute "String Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext)))
     return (attr, result)

parseRules "Comment" = 
  pzero

parseRules x = fail $ "Unknown context" ++ x
