{- This module was generated from data in the Kate syntax highlighting file email.xml, version 1.00,
   by  Carl A Joslin (carl.joslin@joslin.dyndns.org) -}

module Text.Highlighting.Kate.Syntax.Email ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

-- | Full name of language.
syntaxName :: String
syntaxName = "Email"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.eml"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Email" }
  context <- currentContext <|> (pushContext "headder" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Email",["headder"])], synStLanguage = "Email", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = False, synStKeywordCaseSensitive = False, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "headder" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("rfc-main","al"),("string","st"),("base64","re"),("marker","al"),("sign","co")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))


regex_'5bTt'5do'3a'2e'2a'24 = compileRegex "[Tt]o:.*$"
regex_'5bFf'5drom'3a'2e'2a'24 = compileRegex "[Ff]rom:.*$"
regex_'5bCc'5d'5bCc'5d'3a'2e'2a'24 = compileRegex "[Cc][Cc]:.*$"
regex_'5bBb'5d'5bCc'5d'5bCc'5d'3a'2e'2a'24 = compileRegex "[Bb][Cc][Cc]:.*$"
regex_'5bSs'5dubject'3a'2e'2a'24 = compileRegex "[Ss]ubject:.*$"
regex_'5bDd'5date'3a'2e'2a'24 = compileRegex "[Dd]ate:.*$"
regex_'5bSs'5dender'3a = compileRegex "[Ss]ender:"
regex_'5bRr'5deply'2d'5bTt'5do'3a = compileRegex "[Rr]eply-[Tt]o:"
regex_'5bMm'5dessage'2d'5bIi'5d'5bDd'5d'3a = compileRegex "[Mm]essage-[Ii][Dd]:"
regex_'5bIi'5dn'2d'5bRr'5deply'2d'5bTt'5do'3a = compileRegex "[Ii]n-[Rr]eply-[Tt]o:"
regex_'5bRr'5deferences'3a = compileRegex "[Rr]eferences:"
regex_'5bCc'5domments'3a = compileRegex "[Cc]omments:"
regex_'5bKk'5deywors'3a = compileRegex "[Kk]eywors:"
regex_'5bRr'5desent'2d'5bDd'5date'3a = compileRegex "[Rr]esent-[Dd]ate:"
regex_'5bRr'5desent'2d'5bFf'5drom'3a = compileRegex "[Rr]esent-[Ff]rom:"
regex_'5bRr'5desent'2d'5bSs'5dender'3a = compileRegex "[Rr]esent-[Ss]ender:"
regex_'5bRr'5desent'2d'5bTt'5do'3a = compileRegex "[Rr]esent-[Tt]o:"
regex_'5bRr'5desent'2d'5bCc'5d'5bCc'5d'3a = compileRegex "[Rr]esent-[Cc][Cc]:"
regex_'5bRr'5desent'2d'5bBb'5d'5bCc'5d'5bCc'5d'3a = compileRegex "[Rr]esent-[Bb][Cc][Cc]:"
regex_'5bRr'5desent'2d'5bMm'5dessage'2d'5bIi'5d'5bDd'5d'3a = compileRegex "[Rr]esent-[Mm]essage-[Ii][Dd]:"
regex_'5bRr'5desent'2d'5bRr'5deply'2d'5bTt'5do'3a = compileRegex "[Rr]esent-[Rr]eply-[Tt]o:"
regex_'5bRr'5deturn'2d'5bPp'5dath'3a = compileRegex "[Rr]eturn-[Pp]ath:"
regex_'5bRr'5deceived'3a = compileRegex "[Rr]eceived:"
regex_'5bXx'5d'2d'5bMm'5dozilla'2d'5bSs'5dtatus'3a = compileRegex "[Xx]-[Mm]ozilla-[Ss]tatus:"
regex_'5bXx'5d'2d'5bMm'5dozilla'2d'5bSs'5dtatus2'3a = compileRegex "[Xx]-[Mm]ozilla-[Ss]tatus2:"
regex_'5bEe'5dnverlope'2d'5bTt'5do'3a = compileRegex "[Ee]nverlope-[Tt]o:"
regex_'5bDd'5delivery'2d'5bDd'5date'3a = compileRegex "[Dd]elivery-[Dd]ate:"
regex_'5bXx'5d'2d'5bOo'5driginating'2d'5bIi'5d'5bPp'5d'3a = compileRegex "[Xx]-[Oo]riginating-[Ii][Pp]:"
regex_'5bXx'5d'2d'5bOo'5driginating'2d'5bEe'5dmail'3a = compileRegex "[Xx]-[Oo]riginating-[Ee]mail:"
regex_'5bXx'5d'2d'5bSs'5dender'3a = compileRegex "[Xx]-[Ss]ender:"
regex_'5bMm'5dime'2d'5bVv'5dersion'3a = compileRegex "[Mm]ime-[Vv]ersion:"
regex_'5bCc'5dontent'2d'5bTt'5dype'3a = compileRegex "[Cc]ontent-[Tt]ype:"
regex_'5bXx'5d'2d'5bMm'5dailing'2d'5bLl'5dist'3a = compileRegex "[Xx]-[Mm]ailing-[Ll]ist:"
regex_'5bXx'5d'2d'5bLl'5doop'3a = compileRegex "[Xx]-[Ll]oop:"
regex_'5bLl'5dist'2d'5bPp'5dost'3a = compileRegex "[Ll]ist-[Pp]ost:"
regex_'5bLl'5dist'2d'5bHh'5delp'3a = compileRegex "[Ll]ist-[Hh]elp:"
regex_'5bLl'5dist'2d'5bUu'5dnsubscribe'3a = compileRegex "[Ll]ist-[Uu]nsubscribe:"
regex_'5bPp'5drecedence'3a = compileRegex "[Pp]recedence:"
regex_'5bCc'5dontent'2d'5bTt'5dransfer'2d'5bEe'5dncoding'3a = compileRegex "[Cc]ontent-[Tt]ransfer-[Ee]ncoding:"
regex_'5bXx'5d'2d'5bBb'5dulkmail'3a = compileRegex "[Xx]-[Bb]ulkmail:"
regex_'5bCc'5dontent'2d'5bDd'5disposition'3a = compileRegex "[Cc]ontent-[Dd]isposition:"
regex_'5b0'2d9a'2dzA'2dZ'2d'2e'5d'2b'3a = compileRegex "[0-9a-zA-Z-.]+:"
regex_'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'5c'40'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b = compileRegex "[a-zA-Z0-9.\\-]+\\@[a-zA-Z0-9.\\-]+"
regex_'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2a'5cs'2a'3c'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'5c'40'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'3e = compileRegex "[a-zA-Z0-9.\\-]*\\s*<[a-zA-Z0-9.\\-]+\\@[a-zA-Z0-9.\\-]+>"
regex_'22'5ba'2dzA'2dZ0'2d9'2e_'5c'2d'5d'2b'22'5cs'2a'3c'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'5c'40'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'3e = compileRegex "\"[a-zA-Z0-9. \\-]+\"\\s*<[a-zA-Z0-9.\\-]+\\@[a-zA-Z0-9.\\-]+>"
regex_'22'2e'2a'22 = compileRegex "\".*\""
regex_'27'2e'2a'27 = compileRegex "'.*'"
regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a = compileRegex "[|>]\\s*[|>]\\s*[|>]\\s*[|>]\\s*[|>]\\s*[|>].*"
regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a = compileRegex "[|>]\\s*[|>]\\s*[|>]\\s*[|>]\\s*[|>].*"
regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a = compileRegex "[|>]\\s*[|>]\\s*[|>]\\s*[|>].*"
regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a = compileRegex "[|>]\\s*[|>]\\s*[|>].*"
regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a = compileRegex "[|>]\\s*[|>].*"
regex_'5b'7c'3e'5d'2e'2a = compileRegex "[|>].*"
regex_'28'5bA'2dZa'2dz0'2d9'2b'2f'5d'5bA'2dZa'2dz0'2d9'2b'2f'5d'5bA'2dZa'2dz0'2d9'2b'2f'5d'5bA'2dZa'2dz0'2d9'2b'2f'5d'29'7b10'2c20'7d'24 = compileRegex "([A-Za-z0-9+/][A-Za-z0-9+/][A-Za-z0-9+/][A-Za-z0-9+/]){10,20}$"
regex_'5bA'2dZa'2dz0'2d9'2b'3d'2f'5d'2b'3d'24 = compileRegex "[A-Za-z0-9+=/]+=$"
regex_'28'2d_'29'3f'2d'2d'28'2d'2d'2e'2a'29'3f = compileRegex "(- )?--(--.*)?"

defaultAttributes = [("headder","Normal Text")]

parseRules "headder" = 
  do (attr, result) <- (((pColumn 0 >> pRegExpr regex_'5bTt'5do'3a'2e'2a'24 >>= withAttribute "rfc-main"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bFf'5drom'3a'2e'2a'24 >>= withAttribute "rfc-main"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bCc'5d'5bCc'5d'3a'2e'2a'24 >>= withAttribute "rfc-main"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bBb'5d'5bCc'5d'5bCc'5d'3a'2e'2a'24 >>= withAttribute "rfc-main"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bSs'5dubject'3a'2e'2a'24 >>= withAttribute "rfc-main"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bDd'5date'3a'2e'2a'24 >>= withAttribute "rfc-main"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bSs'5dender'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bRr'5deply'2d'5bTt'5do'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bMm'5dessage'2d'5bIi'5d'5bDd'5d'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bIi'5dn'2d'5bRr'5deply'2d'5bTt'5do'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bRr'5deferences'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bCc'5domments'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bKk'5deywors'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bDd'5date'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bFf'5drom'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bSs'5dender'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bTt'5do'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bCc'5d'5bCc'5d'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bBb'5d'5bCc'5d'5bCc'5d'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bMm'5dessage'2d'5bIi'5d'5bDd'5d'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bRr'5desent'2d'5bRr'5deply'2d'5bTt'5do'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bRr'5deturn'2d'5bPp'5dath'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bRr'5deceived'3a >>= withAttribute "rfc"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bMm'5dozilla'2d'5bSs'5dtatus'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bMm'5dozilla'2d'5bSs'5dtatus2'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bEe'5dnverlope'2d'5bTt'5do'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bDd'5delivery'2d'5bDd'5date'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bOo'5driginating'2d'5bIi'5d'5bPp'5d'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bOo'5driginating'2d'5bEe'5dmail'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bSs'5dender'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bMm'5dime'2d'5bVv'5dersion'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bCc'5dontent'2d'5bTt'5dype'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bMm'5dailing'2d'5bLl'5dist'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bLl'5doop'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bLl'5dist'2d'5bPp'5dost'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bLl'5dist'2d'5bHh'5delp'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bLl'5dist'2d'5bUu'5dnsubscribe'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bPp'5drecedence'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bCc'5dontent'2d'5bTt'5dransfer'2d'5bEe'5dncoding'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bCc'5dontent'2d'5bTt'5dype'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bXx'5d'2d'5bBb'5dulkmail'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bPp'5drecedence'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bCc'5dontent'2d'5bDd'5disposition'3a >>= withAttribute "common"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5b0'2d9a'2dzA'2dZ'2d'2e'5d'2b'3a >>= withAttribute "other"))
                        <|>
                        ((pRegExpr regex_'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'5c'40'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b >>= withAttribute "email"))
                        <|>
                        ((pRegExpr regex_'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2a'5cs'2a'3c'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'5c'40'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'3e >>= withAttribute "email"))
                        <|>
                        ((pRegExpr regex_'22'5ba'2dzA'2dZ0'2d9'2e_'5c'2d'5d'2b'22'5cs'2a'3c'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'5c'40'5ba'2dzA'2dZ0'2d9'2e'5c'2d'5d'2b'3e >>= withAttribute "email"))
                        <|>
                        ((pRegExpr regex_'22'2e'2a'22 >>= withAttribute "string"))
                        <|>
                        ((pRegExpr regex_'27'2e'2a'27 >>= withAttribute "string"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a >>= withAttribute "indent6"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a >>= withAttribute "indent5"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a >>= withAttribute "indent4"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a >>= withAttribute "indent3"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5b'7c'3e'5d'5cs'2a'5b'7c'3e'5d'2e'2a >>= withAttribute "indent2"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5b'7c'3e'5d'2e'2a >>= withAttribute "indent1"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'28'5bA'2dZa'2dz0'2d9'2b'2f'5d'5bA'2dZa'2dz0'2d9'2b'2f'5d'5bA'2dZa'2dz0'2d9'2b'2f'5d'5bA'2dZa'2dz0'2d9'2b'2f'5d'29'7b10'2c20'7d'24 >>= withAttribute "base64"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5bA'2dZa'2dz0'2d9'2b'3d'2f'5d'2b'3d'24 >>= withAttribute "base64"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'28'2d_'29'3f'2d'2d'28'2d'2d'2e'2a'29'3f >>= withAttribute "marker")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
