{- This module was generated from data in the Kate syntax highlighting file cisco.xml, version 1.10,
   by  Raphaël GRAPINET -}

module Text.Highlighting.Kate.Syntax.Cisco ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Cisco"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.cis"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Cisco" }
  context <- currentContext <|> (pushContext "Base" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Cisco",["Base"])], synStLanguage = "Cisco", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Base" -> return () >> pHandleEndLine
    "String" -> return () >> pHandleEndLine
    "Single Quote" -> return () >> pHandleEndLine
    "Substitution" -> return () >> pHandleEndLine
    "Parameter" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Decimal","dv"),("Float","fl"),("Char","ch"),("String","st"),("Comment","co"),("Substitution","ot"),("Parameter","ot"),("Operator","ot")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_commands = Set.fromList $ words $ "aaa access-list address alias arp async-bootp banner boot bridge buffers busy-message call-history-mib cdp chat-script class-map clock cns config-register controller crypto default default-value dialer dialer-list dnsix-dmdp dnsix-nat downward-compatible-config enable end exception exit file frame-relay help hostname interface ip isdn isdn-mib kerberos key line logging login-string map-class map-list memory-size menu modemcap multilink netbios no ntp partition policy-map priority-list privilege process-max-time prompt queue-list resume-string rlogin rmon route-map router rtr scheduler service snmp-server sntp stackmaker state-machine subscriber-policy tacacs-server template terminal-queue tftp-server time-range username virtual-profile virtual-template vpdn vpdn-group x25 x29"
list_parameters = Set.fromList $ words $ "accounting accounting-list accounting-threshold accounting-transits address-pool as-path audit auth-proxy authentication authorization bgp-community bootp cef classless community-list default-gateway default-network dhcp dhcp-server domain-list domain-lookup domain-name dvmrp exec-callback extcommunity-list finger flow-aggregation flow-cache flow-export forward-protocol ftp gratuitous-arps host host-routing hp-host http icmp inspect local mrm mroute msdp multicast multicast-routing name-server nat new-model ospf password password-encryption pgm pim port-map prefix-list radius rcmd reflexive-list route routing rsvp rtcp sap sdr security source-route subnet-zero tacacs tcp tcp-small-servers telnet tftp timestamps udp-small-servers vrf wccp"
list_options = Set.fromList $ words $ "accounting accounting-list accounting-threshold accounting-transits address-pool as-path audit auth-proxy authentication authorization bgp-community bootp cef classless community-list default-gateway default-network dhcp dhcp-server domain-list domain-lookup domain-name dvmrp exec-callback extcommunity-list finger flow-aggregation flow-cache flow-export forward-protocol ftp gratuitous-arps host host-routing hp-host http icmp inspect local mrm mroute msdp multicast multicast-routing name-server nat new-model ospf password password-encryption pgm pim port-map prefix-list radius rcmd reflexive-list route routing rsvp rtcp sap sdr security source-route subnet-zero tacacs tcp tcp-small-servers telnet tftp timestamps udp-small-servers vrf wccp"

regex_'5cbdone'5cb = compileRegex "\\bdone\\b"
regex_'5cbdo'5cb = compileRegex "\\bdo\\b"
regex_'5cbelif'5cb = compileRegex "\\belif\\b"
regex_'5cbif'5cb = compileRegex "\\bif\\b"
regex_'5cbfi'5cb = compileRegex "\\bfi\\b"
regex_'5cbcase'5cb = compileRegex "\\bcase\\b"
regex_'5cbesac'5cb = compileRegex "\\besac\\b"
regex_'5b'5e'28'29'5d'2b'5c'29 = compileRegex "[^()]+\\)"
regex_'5c'24'5bA'2dZa'2dz0'2d9'5f'3f'7b'7d'21'5d'2b = compileRegex "\\$[A-Za-z0-9_?{}!]+"
regex_'23'2e'2a'24 = compileRegex "#.*$"
regex_'5c'24'5bA'2dZa'2dz0'2d9'5f'3f'5d'2b = compileRegex "\\$[A-Za-z0-9_?]+"

defaultAttributes = [("Base","Normal Text"),("String","String"),("Single Quote","String"),("Substitution","Substitution"),("Parameter","Parameter")]

parseRules "Base" = 
  do (attr, result) <- (((pRegExpr regex_'5cbdone'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbdo'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbelif'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbif'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbfi'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbcase'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbesac'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5b'5e'28'29'5d'2b'5c'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pDetect2Chars False ';' ';' >>= withAttribute "Keyword"))
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Keyword"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_commands >>= withAttribute "Command"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_parameters >>= withAttribute "Parameter"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_options >>= withAttribute "Keyword"))
                        <|>
                        ((pInt >>= withAttribute "Decimal"))
                        <|>
                        ((pRegExpr regex_'5c'24'5bA'2dZa'2dz0'2d9'5f'3f'7b'7d'21'5d'2b >>= withAttribute "Parameter"))
                        <|>
                        ((pRangeDetect '"' '"' >>= withAttribute "String"))
                        <|>
                        ((pAnyChar "|<>=;" >>= withAttribute "Operator"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ pushContext "Single Quote")
                        <|>
                        ((pDetectChar False '`' >>= withAttribute "Substitution") >>~ pushContext "Substitution")
                        <|>
                        ((pDetect2Chars False '\\' '#' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'23'2e'2a'24 >>= withAttribute "Comment")))
     return (attr, result)

parseRules "String" = 
  do (attr, result) <- (((pDetect2Chars False '\\' '\\' >>= withAttribute "String"))
                        <|>
                        ((pDetect2Chars False '\\' '"' >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext)))
     return (attr, result)

parseRules "Single Quote" = 
  do (attr, result) <- (((pDetect2Chars False '\\' '\\' >>= withAttribute "String"))
                        <|>
                        ((pDetect2Chars False '\\' '\'' >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ (popContext)))
     return (attr, result)

parseRules "Substitution" = 
  do (attr, result) <- (((pDetect2Chars False '\\' '\\' >>= withAttribute "String"))
                        <|>
                        ((pDetect2Chars False '\\' '`' >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '`' >>= withAttribute "Substitution") >>~ (popContext)))
     return (attr, result)

parseRules "Parameter" = 
  do (attr, result) <- ((pRegExpr regex_'5c'24'5bA'2dZa'2dz0'2d9'5f'3f'5d'2b >>= withAttribute "Parameter") >>~ (popContext))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
