{- This module was generated from data in the Kate syntax highlighting file changelog.xml, version 1.04,
   by  Dominik Haumann (dhdev@gmx.de) -}

module Text.Highlighting.Kate.Syntax.Changelog ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

-- | Full name of language.
syntaxName :: String
syntaxName = "ChangeLog"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "ChangeLog"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "ChangeLog" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("ChangeLog",["Normal"])], synStLanguage = "ChangeLog", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return () >> pHandleEndLine
    "line" -> (popContext) >> pEndLine
    "entry" -> (popContext) >> pEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Name","kw"),("E-Mail","ot"),("Date","dt"),("Entry","dv")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))


regex_'5cd'5cd'5cd'5cd'5cs'2a'2d'5cs'2a'5cd'5cd'5cs'2a'2d'5cs'2a'5cd'5cd'5cs'2a = compileRegex "\\d\\d\\d\\d\\s*-\\s*\\d\\d\\s*-\\s*\\d\\d\\s*"
regex_'28'5cw'5cs'2a'29'2b = compileRegex "(\\w\\s*)+"
regex_'3c'2e'2a'3e'5cs'2a'24 = compileRegex "<.*>\\s*$"
regex_'2e'2a'3a = compileRegex ".*:"

defaultAttributes = [("Normal","Normal Text"),("line","Normal Text"),("entry","Normal Text")]

parseRules "Normal" = 
  do (attr, result) <- (((pFirstNonSpace >> pDetectChar False '*' >>= withAttribute "Entry") >>~ pushContext "entry")
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5cd'5cd'5cd'5cd'5cs'2a'2d'5cs'2a'5cd'5cd'5cs'2a'2d'5cs'2a'5cd'5cd'5cs'2a >>= withAttribute "Date") >>~ pushContext "line"))
     return (attr, result)

parseRules "line" = 
  do (attr, result) <- (((pRegExpr regex_'28'5cw'5cs'2a'29'2b >>= withAttribute "Name"))
                        <|>
                        ((pRegExpr regex_'3c'2e'2a'3e'5cs'2a'24 >>= withAttribute "E-Mail") >>~ (popContext)))
     return (attr, result)

parseRules "entry" = 
  do (attr, result) <- ((pRegExpr regex_'2e'2a'3a >>= withAttribute "Entry") >>~ (popContext))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
