{- This module was generated from data in the Kate syntax highlighting file bibtex.xml, version 1.17,
   by  Jeroen Wijnhout (Jeroen.Wijnhout@kdemail.net)+Thomas Braun (thomas.braun@virtuell-zuhause.de) -}

module Text.Highlighting.Kate.Syntax.Bibtex ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "BibTeX"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.bib"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "BibTeX" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("BibTeX",["Normal"])], synStLanguage = "BibTeX", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return () >> pHandleEndLine
    "PreambleCommand" -> return () >> pHandleEndLine
    "StringCommand" -> return () >> pHandleEndLine
    "Entry" -> return () >> pHandleEndLine
    "Field" -> return () >> pHandleEndLine
    "CurlyBracket" -> return () >> pHandleEndLine
    "QuotedText" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Entry","kw"),("Command","fu"),("Field","dt"),("Ref Key","ot"),("LatexCommand","ch"),("Comment","co"),("Error","al"),("String","st")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_kw'5fentry = Set.fromList $ words $ "@article @book @booklet @conference @collection @electronic @inbook @incollection @inproceedings @manual @mastersthesis @misc @online @patent @periodical @proceedings @report @phdthesis @set @thesis @techreport @unpublished @www @person @company @place"

regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5d'2b = compileRegex "[a-zA-Z0-9\\-]+"
regex_'5ba'2dzA'2dZ0'2d9'5f'40'5c'5c'2d'5c'5c'3a'5d'2b = compileRegex "[a-zA-Z0-9_@\\\\-\\\\:]+"
regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5f'5c'2e'5d'2b = compileRegex "[a-zA-Z0-9\\-_\\.]+"
regex_'5b0'2d9'5d'2b = compileRegex "[0-9]+"
regex_'2e = compileRegex "."
regex_'5c'5c'28'5ba'2dzA'2dZ'40'5d'2b'7c'5b'5e_'5d'29 = compileRegex "\\\\([a-zA-Z@]+|[^ ])"
regex_'7d'24 = compileRegex "}$"

defaultAttributes = [("Normal","Comment"),("PreambleCommand","Normal Text"),("StringCommand","Normal Text"),("Entry","Normal Text"),("Field","Normal Text"),("CurlyBracket","Normal Text"),("QuotedText","String")]

parseRules "Normal" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~" list_kw'5fentry >>= withAttribute "Entry") >>~ pushContext "Entry")
                        <|>
                        ((pString False "@string" >>= withAttribute "Command") >>~ pushContext "StringCommand")
                        <|>
                        ((pString False "@preamble" >>= withAttribute "Command") >>~ pushContext "PreambleCommand")
                        <|>
                        ((pString False "@comment" >>= withAttribute "Comment")))
     return (attr, result)

parseRules "PreambleCommand" = 
  do (attr, result) <- (((pDetectChar False '{' >>= withAttribute "Normal Text") >>~ pushContext "CurlyBracket")
                        <|>
                        ((popContext) >> return ([], "")))
     return (attr, result)

parseRules "StringCommand" = 
  do (attr, result) <- (((pDetectChar False '{' >>= withAttribute "Normal Text") >>~ pushContext "CurlyBracket")
                        <|>
                        ((pRegExpr regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5d'2b >>= withAttribute "String") >>~ pushContext "CurlyBracket")
                        <|>
                        ((popContext) >> return ([], "")))
     return (attr, result)

parseRules "Entry" = 
  do (attr, result) <- (((pDetectChar False '{' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'5ba'2dzA'2dZ0'2d9'5f'40'5c'5c'2d'5c'5c'3a'5d'2b >>= withAttribute "Ref Key"))
                        <|>
                        ((pDetectChar False ',' >>= withAttribute "Normal Text") >>~ pushContext "Field")
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Normal Text") >>~ (popContext)))
     return (attr, result)

parseRules "Field" = 
  do (attr, result) <- (((pFirstNonSpace >> pRegExpr regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5f'5c'2e'5d'2b >>= withAttribute "Field"))
                        <|>
                        ((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '=' >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Normal Text") >>~ pushContext "CurlyBracket")
                        <|>
                        ((lookAhead (pDetectChar False '}') >> return ([],"") ) >>~ (popContext))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "Normal Text") >>~ pushContext "QuotedText")
                        <|>
                        ((pDetectChar False ',' >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'5b0'2d9'5d'2b >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'5ba'2dzA'2dZ0'2d9'5c'2d'5d'2b >>= withAttribute "String"))
                        <|>
                        ((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'2e >>= withAttribute "Error")))
     return (attr, result)

parseRules "CurlyBracket" = 
  do (attr, result) <- (((pDetectChar False '{' >>= withAttribute "Normal Text") >>~ pushContext "CurlyBracket")
                        <|>
                        ((pRegExpr regex_'5c'5c'28'5ba'2dzA'2dZ'40'5d'2b'7c'5b'5e_'5d'29 >>= withAttribute "LatexCommand"))
                        <|>
                        ((pRegExpr regex_'7d'24 >>= withAttribute "Normal Text") >>~ (popContext >> popContext))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Normal Text") >>~ (popContext)))
     return (attr, result)

parseRules "QuotedText" = 
  do (attr, result) <- (((pDetectChar False '"' >>= withAttribute "Normal Text") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5c'5c'28'5ba'2dzA'2dZ'40'5d'2b'7c'5b'5e_'5d'29 >>= withAttribute "LatexCommand")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
