{- This module was generated from data in the Kate syntax highlighting file php.xml, version 1.32,
   by   -}

module Text.Highlighting.Kate.Syntax.Php ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import Text.ParserCombinators.Parsec
import Data.List (nub)
import qualified Data.Set as Set
import Data.Map (fromList)
import Data.Maybe (fromMaybe)

-- | Full name of language.
syntaxName :: String
syntaxName = "PHP/PHP"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = ""

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "PHP/PHP" }
  context <- currentContext <|> (pushContext "start" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("PHP/PHP",["start"])], synStLanguage = "PHP/PHP", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "start" -> return ()
    "braceregion" -> return ()
    "phpsource" -> return ()
    "onelinecomment" -> (popContext >> return ())
    "twolinecomment" -> return ()
    "doublebackquotestringcommon" -> return ()
    "backquotestring" -> return ()
    "doblequotestring" -> return ()
    "singlequotestring" -> return ()
    "heredoc" -> return ()
    _ -> return ()
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents, synStCharsParsedInLine = 0, synStPrevChar = '\n' }

withAttribute attr txt = do
  if null txt
     then fail "Parser matched no text"
     else return ()
  let style = fromMaybe "" $ lookup attr styles
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (nub [style, attr], txt)

styles = [("Normal Text","Normal"),("PHP Text","Normal"),("Keyword","Keyword"),("Function","Function"),("Special method","Function"),("Decimal","DecVal"),("Octal","BaseN"),("Hex","BaseN"),("Float","Float"),("String","String"),("Comment","Comment"),("Variable","Keyword"),("Control Structures","Keyword"),("Backslash Code","Keyword"),("Other","Others"),("HTML Tag","Keyword"),("HTML Comment","Comment"),("Identifier","Others"),("Types","DataType")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_control_structures = Set.fromList $ words $ "as case default if else elseif while do for foreach break continue switch declare return require include require_once include_once endif endwhile endfor endforeach endswitch"
list_keywords = Set.fromList $ words $ "abstract catch class clone const extends final function implements instanceof interface new self static parent private protected public throw try and or xor var __file__ __line__ e_error e_warning e_parse e_notice e_strict e_core_error e_core_warning e_compile_error e_compile_warning e_user_error e_user_warning e_user_notice e_all true false zend_thread_safe null php_version php_os php_sapi default_include_path pear_install_dir pear_extension_dir php_extension_dir php_prefix php_bindir php_libdir php_datadir php_sysconfdir php_localstatedir php_config_file_path php_config_file_scan_dir php_shlib_suffix php_eol php_output_handler_start php_output_handler_cont php_output_handler_end upload_err_ok upload_err_ini_size upload_err_form_size upload_err_partial upload_err_no_file upload_err_no_tmp_dir p_static p_public p_protected p_private m_static m_public m_protected m_private m_abstract m_final c_implicit_abstract c_explicit_abstract c_final xml_error_none xml_error_no_memory xml_error_syntax xml_error_no_elements xml_error_invalid_token xml_error_unclosed_token xml_error_partial_char xml_error_tag_mismatch xml_error_duplicate_attribute xml_error_junk_after_doc_element xml_error_param_entity_ref xml_error_undefined_entity xml_error_recursive_entity_ref xml_error_async_entity xml_error_bad_char_ref xml_error_binary_entity_ref xml_error_attribute_external_entity_ref xml_error_misplaced_xml_pi xml_error_unknown_encoding xml_error_incorrect_encoding xml_error_unclosed_cdata_section xml_error_external_entity_handling xml_option_case_folding xml_option_target_encoding xml_option_skip_tagstart xml_option_skip_white xml_sax_impl connection_aborted connection_normal connection_timeout ini_user ini_perdir ini_system ini_all sunfuncs_ret_timestamp sunfuncs_ret_string sunfuncs_ret_double m_e m_log2e m_log10e m_ln2 m_ln10 m_pi m_pi_2 m_pi_4 m_1_pi m_2_pi m_2_sqrtpi m_sqrt2 m_sqrt1_2 inf nan info_general info_credits info_configuration info_modules info_environment info_variables info_license info_all credits_group credits_general credits_sapi credits_modules credits_docs credits_fullpage credits_qa credits_all html_specialchars html_entities ent_compat ent_quotes ent_noquotes str_pad_left str_pad_right str_pad_both pathinfo_dirname pathinfo_basename pathinfo_extension char_max lc_ctype lc_numeric lc_time lc_collate lc_monetary lc_all lc_messages seek_set seek_cur seek_end lock_sh lock_ex lock_un lock_nb stream_notify_connect stream_notify_auth_required stream_notify_auth_result stream_notify_mime_type_is stream_notify_file_size_is stream_notify_redirected stream_notify_progress stream_notify_failure stream_notify_completed stream_notify_resolve stream_notify_severity_info stream_notify_severity_warn stream_notify_severity_err stream_filter_read stream_filter_write stream_filter_all stream_client_persistent stream_client_async_connect stream_client_connect stream_peek stream_oob stream_server_bind stream_server_listen file_use_include_path file_ignore_new_lines file_skip_empty_lines file_append file_no_default_context fnm_noescape fnm_pathname fnm_period fnm_casefold psfs_pass_on psfs_feed_me psfs_err_fatal psfs_flag_normal psfs_flag_flush_inc psfs_flag_flush_close abday_1 abday_2 abday_3 abday_4 abday_5 abday_6 abday_7 day_1 day_2 day_3 day_4 day_5 day_6 day_7 abmon_1 abmon_2 abmon_3 abmon_4 abmon_5 abmon_6 abmon_7 abmon_8 abmon_9 abmon_10 abmon_11 abmon_12 mon_1 mon_2 mon_3 mon_4 mon_5 mon_6 mon_7 mon_8 mon_9 mon_10 mon_11 mon_12 am_str pm_str d_t_fmt d_fmt t_fmt t_fmt_ampm era era_d_t_fmt era_d_fmt era_t_fmt alt_digits crncystr radixchar thousep yesexpr noexpr codeset crypt_salt_length crypt_std_des crypt_ext_des crypt_md5 crypt_blowfish directory_separator path_separator glob_brace glob_mark glob_nosort glob_nocheck glob_noescape glob_onlydir log_emerg log_alert log_crit log_err log_warning log_notice log_info log_debug log_kern log_user log_mail log_daemon log_auth log_syslog log_lpr log_news log_uucp log_cron log_authpriv log_local0 log_local1 log_local2 log_local3 log_local4 log_local5 log_local6 log_local7 log_pid log_cons log_odelay log_ndelay log_nowait log_perror extr_overwrite extr_skip extr_prefix_same extr_prefix_all extr_prefix_invalid extr_prefix_if_exists extr_if_exists extr_refs sort_asc sort_desc sort_regular sort_numeric sort_string sort_locale_string case_lower case_upper count_normal count_recursive assert_active assert_callback assert_bail assert_warning assert_quiet_eval stream_use_path stream_ignore_url stream_enforce_safe_mode stream_report_errors stream_must_seek stream_url_stat_link stream_url_stat_quiet stream_mkdir_recursive imagetype_gif imagetype_jpeg imagetype_png imagetype_swf imagetype_psd imagetype_bmp imagetype_tiff_ii imagetype_tiff_mm imagetype_jpc imagetype_jp2 imagetype_jpx imagetype_jb2 imagetype_iff imagetype_wbmp imagetype_jpeg2000 imagetype_xbm dns_a dns_ns dns_cname dns_soa dns_ptr dns_hinfo dns_mx dns_txt dns_srv dns_naptr dns_aaaa dns_any dns_all rit_leaves_only rit_self_first rit_child_first cit_call_tostring cit_catch_get_child preg_pattern_order preg_set_order preg_offset_capture preg_split_no_empty preg_split_delim_capture preg_split_offset_capture preg_grep_invert cal_gregorian cal_julian cal_jewish cal_french cal_num_cals cal_dow_dayno cal_dow_short cal_dow_long cal_month_gregorian_short cal_month_gregorian_long cal_month_julian_short cal_month_julian_long cal_month_jewish cal_month_french cal_easter_default cal_easter_roman cal_easter_always_gregorian cal_easter_always_julian cal_jewish_add_alafim_geresh cal_jewish_add_alafim cal_jewish_add_gereshayim curlopt_dns_use_global_cache curlopt_dns_cache_timeout curlopt_port curlopt_file curlopt_readdata curlopt_infile curlopt_infilesize curlopt_url curlopt_proxy curlopt_verbose curlopt_header curlopt_httpheader curlopt_noprogress curlopt_nobody curlopt_failonerror curlopt_upload curlopt_post curlopt_ftplistonly curlopt_ftpappend curlopt_netrc curlopt_followlocation curlopt_ftpascii curlopt_put curlopt_mute curlopt_userpwd curlopt_proxyuserpwd curlopt_range curlopt_timeout curlopt_postfields curlopt_referer curlopt_useragent curlopt_ftpport curlopt_ftp_use_epsv curlopt_low_speed_limit curlopt_low_speed_time curlopt_resume_from curlopt_cookie curlopt_sslcert curlopt_sslcertpasswd curlopt_writeheader curlopt_ssl_verifyhost curlopt_cookiefile curlopt_sslversion curlopt_timecondition curlopt_timevalue curlopt_customrequest curlopt_stderr curlopt_transfertext curlopt_returntransfer curlopt_quote curlopt_postquote curlopt_interface curlopt_krb4level curlopt_httpproxytunnel curlopt_filetime curlopt_writefunction curlopt_readfunction curlopt_passwdfunction curlopt_headerfunction curlopt_maxredirs curlopt_maxconnects curlopt_closepolicy curlopt_fresh_connect curlopt_forbid_reuse curlopt_random_file curlopt_egdsocket curlopt_connecttimeout curlopt_ssl_verifypeer curlopt_cainfo curlopt_capath curlopt_cookiejar curlopt_ssl_cipher_list curlopt_binarytransfer curlopt_nosignal curlopt_proxytype curlopt_buffersize curlopt_httpget curlopt_http_version curlopt_sslkey curlopt_sslkeytype curlopt_sslkeypasswd curlopt_sslengine curlopt_sslengine_default curlopt_sslcerttype curlopt_crlf curlopt_encoding curlopt_proxyport curlopt_unrestricted_auth curlopt_ftp_use_eprt curlopt_http200aliases curl_timecond_ifmodsince curl_timecond_ifunmodsince curl_timecond_lastmod curlopt_httpauth curlauth_basic curlauth_digest curlauth_gssnegotiate curlauth_ntlm curlauth_any curlauth_anysafe curlopt_proxyauth curlclosepolicy_least_recently_used curlclosepolicy_least_traffic curlclosepolicy_slowest curlclosepolicy_callback curlclosepolicy_oldest curlinfo_effective_url curlinfo_http_code curlinfo_header_size curlinfo_request_size curlinfo_total_time curlinfo_namelookup_time curlinfo_connect_time curlinfo_pretransfer_time curlinfo_size_upload curlinfo_size_download curlinfo_speed_download curlinfo_speed_upload curlinfo_filetime curlinfo_ssl_verifyresult curlinfo_content_length_download curlinfo_content_length_upload curlinfo_starttransfer_time curlinfo_content_type curlinfo_redirect_time curlinfo_redirect_count curl_version_ipv6 curl_version_kerberos4 curl_version_ssl curl_version_libz curlversion_now curle_ok curle_unsupported_protocol curle_failed_init curle_url_malformat curle_url_malformat_user curle_couldnt_resolve_proxy curle_couldnt_resolve_host curle_couldnt_connect curle_ftp_weird_server_reply curle_ftp_access_denied curle_ftp_user_password_incorrect curle_ftp_weird_pass_reply curle_ftp_weird_user_reply curle_ftp_weird_pasv_reply curle_ftp_weird_227_format curle_ftp_cant_get_host curle_ftp_cant_reconnect curle_ftp_couldnt_set_binary curle_partial_file curle_ftp_couldnt_retr_file curle_ftp_write_error curle_ftp_quote_error curle_http_not_found curle_write_error curle_malformat_user curle_ftp_couldnt_stor_file curle_read_error curle_out_of_memory curle_operation_timeouted curle_ftp_couldnt_set_ascii curle_ftp_port_failed curle_ftp_couldnt_use_rest curle_ftp_couldnt_get_size curle_http_range_error curle_http_post_error curle_ssl_connect_error curle_ftp_bad_download_resume curle_file_couldnt_read_file curle_ldap_cannot_bind curle_ldap_search_failed curle_library_not_found curle_function_not_found curle_aborted_by_callback curle_bad_function_argument curle_bad_calling_order curle_http_port_failed curle_bad_password_entered curle_too_many_redirects curle_unknown_telnet_option curle_telnet_option_syntax curle_obsolete curle_ssl_peer_certificate curle_got_nothing curle_ssl_engine_notfound curle_ssl_engine_setfailed curle_send_error curle_recv_error curle_share_in_use curle_ssl_certproblem curle_ssl_cipher curle_ssl_cacert curle_bad_content_encoding curlproxy_http curlproxy_socks5 curl_netrc_optional curl_netrc_ignored curl_netrc_required curl_http_version_none curl_http_version_1_0 curl_http_version_1_1 curlm_call_multi_perform curlm_ok curlm_bad_handle curlm_bad_easy_handle curlm_out_of_memory curlm_internal_error curlmsg_done dbx_mysql dbx_odbc dbx_pgsql dbx_mssql dbx_fbsql dbx_oci8 dbx_sybasect dbx_sqlite dbx_persistent dbx_result_info dbx_result_index dbx_result_assoc dbx_result_unbuffered dbx_colnames_unchanged dbx_colnames_uppercase dbx_colnames_lowercase dbx_cmp_native dbx_cmp_text dbx_cmp_number dbx_cmp_asc dbx_cmp_desc o_rdonly o_wronly o_rdwr o_creat o_excl o_trunc o_append o_nonblock o_ndelay o_sync o_async o_noctty s_irwxu s_irusr s_iwusr s_ixusr s_irwxg s_irgrp s_iwgrp s_ixgrp s_irwxo s_iroth s_iwoth s_ixoth f_dupfd f_getfd f_getfl f_setfl f_getlk f_setlk f_setlkw f_setown f_getown f_unlck f_rdlck f_wrlck xml_element_node xml_attribute_node xml_text_node xml_cdata_section_node xml_entity_ref_node xml_entity_node xml_pi_node xml_comment_node xml_document_node xml_document_type_node xml_document_frag_node xml_notation_node xml_html_document_node xml_dtd_node xml_element_decl_node xml_attribute_decl_node xml_entity_decl_node xml_namespace_decl_node xml_local_namespace xml_attribute_cdata xml_attribute_id xml_attribute_idref xml_attribute_idrefs xml_attribute_entity xml_attribute_nmtoken xml_attribute_nmtokens xml_attribute_enumeration xml_attribute_notation dom_php_err dom_index_size_err domstring_size_err dom_hierarchy_request_err dom_wrong_document_err dom_invalid_character_err dom_no_data_allowed_err dom_no_modification_allowed_err dom_not_found_err dom_not_supported_err dom_inuse_attribute_err dom_invalid_state_err dom_syntax_err dom_invalid_modification_err dom_namespace_err dom_invalid_access_err dom_validation_err exif_use_mbstring famchanged famdeleted famstartexecuting famstopexecuting famcreated fammoved famacknowledge famexists famendexist ftp_ascii ftp_text ftp_binary ftp_image ftp_autoresume ftp_timeout_sec ftp_autoseek ftp_failed ftp_finished ftp_moredata img_gif img_jpg img_jpeg img_png img_wbmp img_xpm img_color_tiled img_color_styled img_color_brushed img_color_styledbrushed img_color_transparent img_arc_rounded img_arc_pie img_arc_chord img_arc_nofill img_arc_edged img_gd2_raw img_gd2_compressed img_effect_replace img_effect_alphablend img_effect_normal img_effect_overlay gd_bundled img_filter_negate img_filter_grayscale img_filter_brightness img_filter_contrast img_filter_colorize img_filter_edgedetect img_filter_gaussian_blur img_filter_selective_blur img_filter_emboss img_filter_mean_removal img_filter_smooth gmp_round_zero gmp_round_plusinf gmp_round_minusinf iconv_impl iconv_version iconv_mime_decode_strict iconv_mime_decode_continue_on_error nil imap_opentimeout imap_readtimeout imap_writetimeout imap_closetimeout op_debug op_readonly op_anonymous op_shortcache op_silent op_prototype op_halfopen op_expunge op_secure cl_expunge ft_uid ft_peek ft_not ft_internal ft_prefetchtext st_uid st_silent st_set cp_uid cp_move se_uid se_free se_noprefetch so_free so_noserver sa_messages sa_recent sa_unseen sa_uidnext sa_uidvalidity sa_all latt_noinferiors latt_noselect latt_marked latt_unmarked latt_referral latt_haschildren latt_hasnochildren sortdate sortarrival sortfrom sortsubject sortto sortcc sortsize typetext typemultipart typemessage typeapplication typeaudio typeimage typevideo typemodel typeother enc7bit enc8bit encbinary encbase64 encquotedprintable encother ldap_deref_never ldap_deref_searching ldap_deref_finding ldap_deref_always ldap_opt_deref ldap_opt_sizelimit ldap_opt_timelimit ldap_opt_protocol_version ldap_opt_error_number ldap_opt_referrals ldap_opt_restart ldap_opt_host_name ldap_opt_error_string ldap_opt_matched_dn ldap_opt_server_controls ldap_opt_client_controls ldap_opt_debug_level mb_overload_mail mb_overload_string mb_overload_regex mb_case_upper mb_case_lower mb_case_title mcrypt_encrypt mcrypt_decrypt mcrypt_dev_random mcrypt_dev_urandom mcrypt_rand mcrypt_3des mcrypt_arcfour_iv mcrypt_arcfour mcrypt_blowfish mcrypt_blowfish_compat mcrypt_cast_128 mcrypt_cast_256 mcrypt_crypt mcrypt_des mcrypt_enigna mcrypt_gost mcrypt_loki97 mcrypt_panama mcrypt_rc2 mcrypt_rijndael_128 mcrypt_rijndael_192 mcrypt_rijndael_256 mcrypt_safer64 mcrypt_safer128 mcrypt_saferplus mcrypt_serpent mcrypt_threeway mcrypt_tripledes mcrypt_twofish mcrypt_wake mcrypt_xtea mcrypt_idea mcrypt_mars mcrypt_rc6 mcrypt_skipjack mcrypt_mode_cbc mcrypt_mode_cfb mcrypt_mode_ecb mcrypt_mode_nofb mcrypt_mode_ofb mcrypt_mode_stream mhash_crc32 mhash_md5 mhash_sha1 mhash_haval256 mhash_ripemd160 mhash_tiger mhash_gost mhash_crc32b mhash_haval224 mhash_haval192 mhash_haval160 mhash_haval128 mhash_tiger128 mhash_tiger160 mhash_md4 mhash_sha256 mhash_adler32 mhash_sha224 mhash_sha512 mhash_sha384 mhash_whirlpool mhash_ripemd128 mhash_ripemd256 mhash_ripemd320 mhash_snefru128 mhash_snefru256 mhash_md2 mysql_assoc mysql_num mysql_both mysql_client_compress mysql_client_ssl mysql_client_interactive mysql_client_ignore_space mysqli_read_default_group mysqli_read_default_file mysqli_opt_connect_timeout mysqli_opt_local_infile mysqli_init_command mysqli_client_ssl mysqli_client_compress mysqli_client_interactive mysqli_client_ignore_space mysqli_client_no_schema mysqli_client_found_rows mysqli_store_result mysqli_use_result mysqli_assoc mysqli_num mysqli_both mysqli_stmt_attr_update_max_length mysqli_not_null_flag mysqli_pri_key_flag mysqli_unique_key_flag mysqli_multiple_key_flag mysqli_blob_flag mysqli_unsigned_flag mysqli_zerofill_flag mysqli_auto_increment_flag mysqli_timestamp_flag mysqli_set_flag mysqli_num_flag mysqli_part_key_flag mysqli_group_flag mysqli_type_decimal mysqli_type_tiny mysqli_type_short mysqli_type_long mysqli_type_float mysqli_type_double mysqli_type_null mysqli_type_timestamp mysqli_type_longlong mysqli_type_int24 mysqli_type_date mysqli_type_time mysqli_type_datetime mysqli_type_year mysqli_type_newdate mysqli_type_enum mysqli_type_set mysqli_type_tiny_blob mysqli_type_medium_blob mysqli_type_long_blob mysqli_type_blob mysqli_type_var_string mysqli_type_string mysqli_type_char mysqli_type_interval mysqli_type_geometry mysqli_rpl_master mysqli_rpl_slave mysqli_rpl_admin mysqli_no_data mysqli_report_index mysqli_report_error mysqli_report_all mysqli_report_off ncurses_color_black ncurses_color_red ncurses_color_green ncurses_color_yellow ncurses_color_blue ncurses_color_magenta ncurses_color_cyan ncurses_color_white ncurses_key_down ncurses_key_up ncurses_key_left ncurses_key_right ncurses_key_backspace ncurses_key_mouse ncurses_key_f0 ncurses_key_f1 ncurses_key_f2 ncurses_key_f3 ncurses_key_f4 ncurses_key_f5 ncurses_key_f6 ncurses_key_f7 ncurses_key_f8 ncurses_key_f9 ncurses_key_f10 ncurses_key_f11 ncurses_key_f12 ncurses_key_dl ncurses_key_il ncurses_key_dc ncurses_key_ic ncurses_key_eic ncurses_key_clear ncurses_key_eos ncurses_key_eol ncurses_key_sf ncurses_key_sr ncurses_key_npage ncurses_key_ppage ncurses_key_stab ncurses_key_ctab ncurses_key_catab ncurses_key_enter ncurses_key_sreset ncurses_key_reset ncurses_key_print ncurses_key_ll ncurses_key_a1 ncurses_key_a3 ncurses_key_b2 ncurses_key_c1 ncurses_key_c3 ncurses_key_btab ncurses_key_beg ncurses_key_cancel ncurses_key_close ncurses_key_command ncurses_key_copy ncurses_key_create ncurses_key_end ncurses_key_exit ncurses_key_find ncurses_key_help ncurses_key_mark ncurses_key_message ncurses_key_move ncurses_key_next ncurses_key_open ncurses_key_options ncurses_key_previous ncurses_key_redo ncurses_key_reference ncurses_key_refresh ncurses_key_replace ncurses_key_restart ncurses_key_resume ncurses_key_save ncurses_key_sbeg ncurses_key_scancel ncurses_key_scommand ncurses_key_scopy ncurses_key_screate ncurses_key_sdc ncurses_key_sdl ncurses_key_select ncurses_key_send ncurses_key_seol ncurses_key_sexit ncurses_key_sfind ncurses_key_shelp ncurses_key_shome ncurses_key_sic ncurses_key_sleft ncurses_key_smessage ncurses_key_smove ncurses_key_snext ncurses_key_soptions ncurses_key_sprevious ncurses_key_sprint ncurses_key_sredo ncurses_key_sreplace ncurses_key_sright ncurses_key_srsume ncurses_key_ssave ncurses_key_ssuspend ncurses_key_sundo ncurses_key_suspend ncurses_key_undo ncurses_key_resize ncurses_a_normal ncurses_a_standout ncurses_a_underline ncurses_a_reverse ncurses_a_blink ncurses_a_dim ncurses_a_bold ncurses_a_protect ncurses_a_invis ncurses_a_altcharset ncurses_a_chartext ncurses_button1_pressed ncurses_button1_released ncurses_button1_clicked ncurses_button1_double_clicked ncurses_button1_triple_clicked ncurses_button2_pressed ncurses_button2_released ncurses_button2_clicked ncurses_button2_double_clicked ncurses_button2_triple_clicked ncurses_button3_pressed ncurses_button3_released ncurses_button3_clicked ncurses_button3_double_clicked ncurses_button3_triple_clicked ncurses_button4_pressed ncurses_button4_released ncurses_button4_clicked ncurses_button4_double_clicked ncurses_button4_triple_clicked ncurses_button_shift ncurses_button_ctrl ncurses_button_alt ncurses_all_mouse_events ncurses_report_mouse_position odbc_type odbc_binmode_passthru odbc_binmode_return odbc_binmode_convert sql_odbc_cursors sql_cur_use_driver sql_cur_use_if_needed sql_cur_use_odbc sql_concurrency sql_concur_read_only sql_concur_lock sql_concur_rowver sql_concur_values sql_cursor_type sql_cursor_forward_only sql_cursor_keyset_driven sql_cursor_dynamic sql_cursor_static sql_keyset_size sql_fetch_first sql_fetch_next sql_char sql_varchar sql_longvarchar sql_decimal sql_numeric sql_bit sql_tinyint sql_smallint sql_integer sql_bigint sql_real sql_float sql_double sql_binary sql_varbinary sql_longvarbinary sql_date sql_time sql_timestamp x509_purpose_ssl_client x509_purpose_ssl_server x509_purpose_ns_ssl_server x509_purpose_smime_sign x509_purpose_smime_encrypt x509_purpose_crl_sign x509_purpose_any openssl_algo_sha1 openssl_algo_md5 openssl_algo_md4 openssl_algo_md2 pkcs7_detached pkcs7_text pkcs7_nointern pkcs7_noverify pkcs7_nochain pkcs7_nocerts pkcs7_noattr pkcs7_binary pkcs7_nosigs openssl_pkcs1_padding openssl_sslv23_padding openssl_no_padding openssl_pkcs1_oaep_padding openssl_cipher_rc2_40 openssl_cipher_rc2_128 openssl_cipher_rc2_64 openssl_cipher_des openssl_cipher_3des openssl_keytype_rsa openssl_keytype_dsa openssl_keytype_dh wnohang wuntraced sig_ign sig_dfl sig_err sighup sigint sigquit sigill sigtrap sigabrt sigiot sigbus sigfpe sigkill sigusr1 sigsegv sigusr2 sigpipe sigalrm sigterm sigstkflt sigcld sigchld sigcont sigstop sigtstp sigttin sigttou sigurg sigxcpu sigxfsz sigvtalrm sigprof sigwinch sigpoll sigio sigpwr sigsys sigbaby prio_pgrp prio_user prio_process pgsql_connect_force_new pgsql_assoc pgsql_num pgsql_both pgsql_connection_bad pgsql_connection_ok pgsql_seek_set pgsql_seek_cur pgsql_seek_end pgsql_status_long pgsql_status_string pgsql_empty_query pgsql_command_ok pgsql_tuples_ok pgsql_copy_out pgsql_copy_in pgsql_bad_response pgsql_nonfatal_error pgsql_fatal_error pgsql_conv_ignore_default pgsql_conv_force_null pgsql_conv_ignore_not_null pgsql_dml_no_conv pgsql_dml_exec pgsql_dml_async pgsql_dml_string snmp_value_library snmp_value_plain snmp_value_object snmp_bit_str snmp_octet_str snmp_opaque snmp_null snmp_object_id snmp_ipaddress snmp_counter snmp_unsigned snmp_timeticks snmp_uinteger snmp_integer snmp_counter64 soap_1_1 soap_1_2 soap_persistence_session soap_persistence_request soap_functions_all soap_encoded soap_literal soap_rpc soap_document soap_actor_next soap_actor_none soap_actor_unlimatereceiver soap_compression_accept soap_compression_gzip soap_compression_deflate unknown_type xsd_string xsd_boolean xsd_decimal xsd_float xsd_double xsd_duration xsd_datetime xsd_time xsd_date xsd_gyearmonth xsd_gyear xsd_gmonthday xsd_gday xsd_gmonth xsd_hexbinary xsd_base64binary xsd_anyuri xsd_qname xsd_notation xsd_normalizedstring xsd_token xsd_language xsd_nmtoken xsd_name xsd_ncname xsd_id xsd_idref xsd_idrefs xsd_entity xsd_entities xsd_integer xsd_nonpositiveinteger xsd_negativeinteger xsd_long xsd_int xsd_short xsd_byte xsd_nonnegativeinteger xsd_unsignedlong xsd_unsignedint xsd_unsignedshort xsd_unsignedbyte xsd_positiveinteger xsd_nmtokens xsd_anytype soap_enc_object soap_enc_array xsd_1999_timeinstant xsd_namespace xsd_1999_namespace af_unix af_inet af_inet6 sock_stream sock_dgram sock_raw sock_seqpacket sock_rdm msg_oob msg_waitall msg_peek msg_dontroute so_debug so_reuseaddr so_keepalive so_dontroute so_linger so_broadcast so_oobinline so_sndbuf so_rcvbuf so_sndlowat so_rcvlowat so_sndtimeo so_rcvtimeo so_type so_error sol_socket somaxconn php_normal_read php_binary_read socket_eperm socket_enoent socket_eintr socket_eio socket_enxio socket_e2big socket_ebadf socket_eagain socket_enomem socket_eacces socket_efault socket_enotblk socket_ebusy socket_eexist socket_exdev socket_enodev socket_enotdir socket_eisdir socket_einval socket_enfile socket_emfile socket_enotty socket_enospc socket_espipe socket_erofs socket_emlink socket_epipe socket_enametoolong socket_enolck socket_enosys socket_enotempty socket_eloop socket_ewouldblock socket_enomsg socket_eidrm socket_echrng socket_el2nsync socket_el3hlt socket_el3rst socket_elnrng socket_eunatch socket_enocsi socket_el2hlt socket_ebade socket_ebadr socket_exfull socket_enoano socket_ebadrqc socket_ebadslt socket_enostr socket_enodata socket_etime socket_enosr socket_enonet socket_eremote socket_enolink socket_eadv socket_esrmnt socket_ecomm socket_eproto socket_emultihop socket_ebadmsg socket_enotuniq socket_ebadfd socket_eremchg socket_erestart socket_estrpipe socket_eusers socket_enotsock socket_edestaddrreq socket_emsgsize socket_eprototype socket_enoprotoopt socket_eprotonosupport socket_esocktnosupport socket_eopnotsupp socket_epfnosupport socket_eafnosupport socket_eaddrinuse socket_eaddrnotavail socket_enetdown socket_enetunreach socket_enetreset socket_econnaborted socket_econnreset socket_enobufs socket_eisconn socket_enotconn socket_eshutdown socket_etoomanyrefs socket_etimedout socket_econnrefused socket_ehostdown socket_ehostunreach socket_ealready socket_einprogress socket_eisnam socket_eremoteio socket_edquot socket_enomedium socket_emediumtype sol_tcp sol_udp sqlite_both sqlite_num sqlite_assoc sqlite_ok sqlite_error sqlite_internal sqlite_perm sqlite_abort sqlite_busy sqlite_locked sqlite_nomem sqlite_readonly sqlite_interrupt sqlite_ioerr sqlite_corrupt sqlite_notfound sqlite_full sqlite_cantopen sqlite_protocol sqlite_empty sqlite_schema sqlite_toobig sqlite_constraint sqlite_mismatch sqlite_misuse sqlite_nolfs sqlite_auth sqlite_format sqlite_row sqlite_done msg_ipc_nowait msg_noerror msg_except t_include t_include_once t_eval t_require t_require_once t_logical_or t_logical_xor t_logical_and t_print t_plus_equal t_minus_equal t_mul_equal t_div_equal t_concat_equal t_mod_equal t_and_equal t_or_equal t_xor_equal t_sl_equal t_sr_equal t_boolean_or t_boolean_and t_is_equal t_is_not_equal t_is_identical t_is_not_identical t_is_smaller_or_equal t_is_greater_or_equal t_sl t_sr t_inc t_dec t_int_cast t_double_cast t_string_cast t_array_cast t_object_cast t_bool_cast t_unset_cast t_new t_exit t_if t_elseif t_else t_endif t_lnumber t_dnumber t_string t_string_varname t_variable t_num_string t_inline_html t_character t_bad_character t_encapsed_and_whitespace t_constant_encapsed_string t_echo t_do t_while t_endwhile t_for t_endfor t_foreach t_endforeach t_declare t_enddeclare t_as t_switch t_endswitch t_case t_default t_break t_continue t_function t_const t_return t_use t_global t_static t_var t_unset t_isset t_empty t_class t_extends t_interface t_implements t_object_operator t_double_arrow t_list t_array t_class_c t_func_c t_method_c t_line t_file t_comment t_doc_comment t_open_tag t_open_tag_with_echo t_close_tag t_whitespace t_start_heredoc t_end_heredoc t_dollar_open_curly_braces t_curly_open t_paamayim_nekudotayim t_double_colon t_abstract t_catch t_final t_instanceof t_private t_protected t_public t_throw t_try t_clone xsl_clone_auto xsl_clone_never xsl_clone_always yperr_badargs yperr_baddb yperr_busy yperr_domain yperr_key yperr_map yperr_nodom yperr_nomore yperr_pmap yperr_resrc yperr_rpc yperr_ypbind yperr_yperr yperr_ypserv yperr_vers force_gzip force_deflate e_error e_warning e_parse e_notice e_strict e_core_error e_core_warning e_compile_error e_compile_warning e_user_error e_user_warning e_user_notice e_all true false zend_thread_safe null php_version php_os php_sapi default_include_path pear_install_dir pear_extension_dir php_extension_dir php_prefix php_bindir php_libdir php_datadir php_sysconfdir php_localstatedir php_config_file_path php_config_file_scan_dir php_shlib_suffix php_eol php_output_handler_start php_output_handler_cont php_output_handler_end upload_err_ok upload_err_ini_size upload_err_form_size upload_err_partial upload_err_no_file upload_err_no_tmp_dir p_static p_public p_protected p_private m_static m_public m_protected m_private m_abstract m_final c_implicit_abstract c_explicit_abstract c_final xml_error_none xml_error_no_memory xml_error_syntax xml_error_no_elements xml_error_invalid_token xml_error_unclosed_token xml_error_partial_char xml_error_tag_mismatch xml_error_duplicate_attribute xml_error_junk_after_doc_element xml_error_param_entity_ref xml_error_undefined_entity xml_error_recursive_entity_ref xml_error_async_entity xml_error_bad_char_ref xml_error_binary_entity_ref xml_error_attribute_external_entity_ref xml_error_misplaced_xml_pi xml_error_unknown_encoding xml_error_incorrect_encoding xml_error_unclosed_cdata_section xml_error_external_entity_handling xml_option_case_folding xml_option_target_encoding xml_option_skip_tagstart xml_option_skip_white xml_sax_impl connection_aborted connection_normal connection_timeout ini_user ini_perdir ini_system ini_all sunfuncs_ret_timestamp sunfuncs_ret_string sunfuncs_ret_double m_e m_log2e m_log10e m_ln2 m_ln10 m_pi m_pi_2 m_pi_4 m_1_pi m_2_pi m_2_sqrtpi m_sqrt2 m_sqrt1_2 inf nan info_general info_credits info_configuration info_modules info_environment info_variables info_license info_all credits_group credits_general credits_sapi credits_modules credits_docs credits_fullpage credits_qa credits_all html_specialchars html_entities ent_compat ent_quotes ent_noquotes str_pad_left str_pad_right str_pad_both pathinfo_dirname pathinfo_basename pathinfo_extension char_max lc_ctype lc_numeric lc_time lc_collate lc_monetary lc_all lc_messages seek_set seek_cur seek_end lock_sh lock_ex lock_un lock_nb stream_notify_connect stream_notify_auth_required stream_notify_auth_result stream_notify_mime_type_is stream_notify_file_size_is stream_notify_redirected stream_notify_progress stream_notify_failure stream_notify_completed stream_notify_resolve stream_notify_severity_info stream_notify_severity_warn stream_notify_severity_err stream_filter_read stream_filter_write stream_filter_all stream_client_persistent stream_client_async_connect stream_client_connect stream_peek stream_oob stream_server_bind stream_server_listen file_use_include_path file_ignore_new_lines file_skip_empty_lines file_append file_no_default_context fnm_noescape fnm_pathname fnm_period fnm_casefold psfs_pass_on psfs_feed_me psfs_err_fatal psfs_flag_normal psfs_flag_flush_inc psfs_flag_flush_close abday_1 abday_2 abday_3 abday_4 abday_5 abday_6 abday_7 day_1 day_2 day_3 day_4 day_5 day_6 day_7 abmon_1 abmon_2 abmon_3 abmon_4 abmon_5 abmon_6 abmon_7 abmon_8 abmon_9 abmon_10 abmon_11 abmon_12 mon_1 mon_2 mon_3 mon_4 mon_5 mon_6 mon_7 mon_8 mon_9 mon_10 mon_11 mon_12 am_str pm_str d_t_fmt d_fmt t_fmt t_fmt_ampm era era_d_t_fmt era_d_fmt era_t_fmt alt_digits crncystr radixchar thousep yesexpr noexpr codeset crypt_salt_length crypt_std_des crypt_ext_des crypt_md5 crypt_blowfish directory_separator path_separator glob_brace glob_mark glob_nosort glob_nocheck glob_noescape glob_onlydir log_emerg log_alert log_crit log_err log_warning log_notice log_info log_debug log_kern log_user log_mail log_daemon log_auth log_syslog log_lpr log_news log_uucp log_cron log_authpriv log_local0 log_local1 log_local2 log_local3 log_local4 log_local5 log_local6 log_local7 log_pid log_cons log_odelay log_ndelay log_nowait log_perror extr_overwrite extr_skip extr_prefix_same extr_prefix_all extr_prefix_invalid extr_prefix_if_exists extr_if_exists extr_refs sort_asc sort_desc sort_regular sort_numeric sort_string sort_locale_string case_lower case_upper count_normal count_recursive assert_active assert_callback assert_bail assert_warning assert_quiet_eval stream_use_path stream_ignore_url stream_enforce_safe_mode stream_report_errors stream_must_seek stream_url_stat_link stream_url_stat_quiet stream_mkdir_recursive imagetype_gif imagetype_jpeg imagetype_png imagetype_swf imagetype_psd imagetype_bmp imagetype_tiff_ii imagetype_tiff_mm imagetype_jpc imagetype_jp2 imagetype_jpx imagetype_jb2 imagetype_iff imagetype_wbmp imagetype_jpeg2000 imagetype_xbm dns_a dns_ns dns_cname dns_soa dns_ptr dns_hinfo dns_mx dns_txt dns_srv dns_naptr dns_aaaa dns_any dns_all rit_leaves_only rit_self_first rit_child_first cit_call_tostring cit_catch_get_child preg_pattern_order preg_set_order preg_offset_capture preg_split_no_empty preg_split_delim_capture preg_split_offset_capture preg_grep_invert cal_gregorian cal_julian cal_jewish cal_french cal_num_cals cal_dow_dayno cal_dow_short cal_dow_long cal_month_gregorian_short cal_month_gregorian_long cal_month_julian_short cal_month_julian_long cal_month_jewish cal_month_french cal_easter_default cal_easter_roman cal_easter_always_gregorian cal_easter_always_julian cal_jewish_add_alafim_geresh cal_jewish_add_alafim cal_jewish_add_gereshayim curlopt_dns_use_global_cache curlopt_dns_cache_timeout curlopt_port curlopt_file curlopt_readdata curlopt_infile curlopt_infilesize curlopt_url curlopt_proxy curlopt_verbose curlopt_header curlopt_httpheader curlopt_noprogress curlopt_nobody curlopt_failonerror curlopt_upload curlopt_post curlopt_ftplistonly curlopt_ftpappend curlopt_netrc curlopt_followlocation curlopt_ftpascii curlopt_put curlopt_mute curlopt_userpwd curlopt_proxyuserpwd curlopt_range curlopt_timeout curlopt_postfields curlopt_referer curlopt_useragent curlopt_ftpport curlopt_ftp_use_epsv curlopt_low_speed_limit curlopt_low_speed_time curlopt_resume_from curlopt_cookie curlopt_sslcert curlopt_sslcertpasswd curlopt_writeheader curlopt_ssl_verifyhost curlopt_cookiefile curlopt_sslversion curlopt_timecondition curlopt_timevalue curlopt_customrequest curlopt_stderr curlopt_transfertext curlopt_returntransfer curlopt_quote curlopt_postquote curlopt_interface curlopt_krb4level curlopt_httpproxytunnel curlopt_filetime curlopt_writefunction curlopt_readfunction curlopt_passwdfunction curlopt_headerfunction curlopt_maxredirs curlopt_maxconnects curlopt_closepolicy curlopt_fresh_connect curlopt_forbid_reuse curlopt_random_file curlopt_egdsocket curlopt_connecttimeout curlopt_ssl_verifypeer curlopt_cainfo curlopt_capath curlopt_cookiejar curlopt_ssl_cipher_list curlopt_binarytransfer curlopt_nosignal curlopt_proxytype curlopt_buffersize curlopt_httpget curlopt_http_version curlopt_sslkey curlopt_sslkeytype curlopt_sslkeypasswd curlopt_sslengine curlopt_sslengine_default curlopt_sslcerttype curlopt_crlf curlopt_encoding curlopt_proxyport curlopt_unrestricted_auth curlopt_ftp_use_eprt curlopt_http200aliases curl_timecond_ifmodsince curl_timecond_ifunmodsince curl_timecond_lastmod curlopt_httpauth curlauth_basic curlauth_digest curlauth_gssnegotiate curlauth_ntlm curlauth_any curlauth_anysafe curlopt_proxyauth curlclosepolicy_least_recently_used curlclosepolicy_least_traffic curlclosepolicy_slowest curlclosepolicy_callback curlclosepolicy_oldest curlinfo_effective_url curlinfo_http_code curlinfo_header_size curlinfo_request_size curlinfo_total_time curlinfo_namelookup_time curlinfo_connect_time curlinfo_pretransfer_time curlinfo_size_upload curlinfo_size_download curlinfo_speed_download curlinfo_speed_upload curlinfo_filetime curlinfo_ssl_verifyresult curlinfo_content_length_download curlinfo_content_length_upload curlinfo_starttransfer_time curlinfo_content_type curlinfo_redirect_time curlinfo_redirect_count curl_version_ipv6 curl_version_kerberos4 curl_version_ssl curl_version_libz curlversion_now curle_ok curle_unsupported_protocol curle_failed_init curle_url_malformat curle_url_malformat_user curle_couldnt_resolve_proxy curle_couldnt_resolve_host curle_couldnt_connect curle_ftp_weird_server_reply curle_ftp_access_denied curle_ftp_user_password_incorrect curle_ftp_weird_pass_reply curle_ftp_weird_user_reply curle_ftp_weird_pasv_reply curle_ftp_weird_227_format curle_ftp_cant_get_host curle_ftp_cant_reconnect curle_ftp_couldnt_set_binary curle_partial_file curle_ftp_couldnt_retr_file curle_ftp_write_error curle_ftp_quote_error curle_http_not_found curle_write_error curle_malformat_user curle_ftp_couldnt_stor_file curle_read_error curle_out_of_memory curle_operation_timeouted curle_ftp_couldnt_set_ascii curle_ftp_port_failed curle_ftp_couldnt_use_rest curle_ftp_couldnt_get_size curle_http_range_error curle_http_post_error curle_ssl_connect_error curle_ftp_bad_download_resume curle_file_couldnt_read_file curle_ldap_cannot_bind curle_ldap_search_failed curle_library_not_found curle_function_not_found curle_aborted_by_callback curle_bad_function_argument curle_bad_calling_order curle_http_port_failed curle_bad_password_entered curle_too_many_redirects curle_unknown_telnet_option curle_telnet_option_syntax curle_obsolete curle_ssl_peer_certificate curle_got_nothing curle_ssl_engine_notfound curle_ssl_engine_setfailed curle_send_error curle_recv_error curle_share_in_use curle_ssl_certproblem curle_ssl_cipher curle_ssl_cacert curle_bad_content_encoding curlproxy_http curlproxy_socks5 curl_netrc_optional curl_netrc_ignored curl_netrc_required curl_http_version_none curl_http_version_1_0 curl_http_version_1_1 curlm_call_multi_perform curlm_ok curlm_bad_handle curlm_bad_easy_handle curlm_out_of_memory curlm_internal_error curlmsg_done dbx_mysql dbx_odbc dbx_pgsql dbx_mssql dbx_fbsql dbx_oci8 dbx_sybasect dbx_sqlite dbx_persistent dbx_result_info dbx_result_index dbx_result_assoc dbx_result_unbuffered dbx_colnames_unchanged dbx_colnames_uppercase dbx_colnames_lowercase dbx_cmp_native dbx_cmp_text dbx_cmp_number dbx_cmp_asc dbx_cmp_desc o_rdonly o_wronly o_rdwr o_creat o_excl o_trunc o_append o_nonblock o_ndelay o_sync o_async o_noctty s_irwxu s_irusr s_iwusr s_ixusr s_irwxg s_irgrp s_iwgrp s_ixgrp s_irwxo s_iroth s_iwoth s_ixoth f_dupfd f_getfd f_getfl f_setfl f_getlk f_setlk f_setlkw f_setown f_getown f_unlck f_rdlck f_wrlck xml_element_node xml_attribute_node xml_text_node xml_cdata_section_node xml_entity_ref_node xml_entity_node xml_pi_node xml_comment_node xml_document_node xml_document_type_node xml_document_frag_node xml_notation_node xml_html_document_node xml_dtd_node xml_element_decl_node xml_attribute_decl_node xml_entity_decl_node xml_namespace_decl_node xml_local_namespace xml_attribute_cdata xml_attribute_id xml_attribute_idref xml_attribute_idrefs xml_attribute_entity xml_attribute_nmtoken xml_attribute_nmtokens xml_attribute_enumeration xml_attribute_notation dom_php_err dom_index_size_err domstring_size_err dom_hierarchy_request_err dom_wrong_document_err dom_invalid_character_err dom_no_data_allowed_err dom_no_modification_allowed_err dom_not_found_err dom_not_supported_err dom_inuse_attribute_err dom_invalid_state_err dom_syntax_err dom_invalid_modification_err dom_namespace_err dom_invalid_access_err dom_validation_err exif_use_mbstring famchanged famdeleted famstartexecuting famstopexecuting famcreated fammoved famacknowledge famexists famendexist ftp_ascii ftp_text ftp_binary ftp_image ftp_autoresume ftp_timeout_sec ftp_autoseek ftp_failed ftp_finished ftp_moredata img_gif img_jpg img_jpeg img_png img_wbmp img_xpm img_color_tiled img_color_styled img_color_brushed img_color_styledbrushed img_color_transparent img_arc_rounded img_arc_pie img_arc_chord img_arc_nofill img_arc_edged img_gd2_raw img_gd2_compressed img_effect_replace img_effect_alphablend img_effect_normal img_effect_overlay gd_bundled img_filter_negate img_filter_grayscale img_filter_brightness img_filter_contrast img_filter_colorize img_filter_edgedetect img_filter_gaussian_blur img_filter_selective_blur img_filter_emboss img_filter_mean_removal img_filter_smooth gmp_round_zero gmp_round_plusinf gmp_round_minusinf iconv_impl iconv_version iconv_mime_decode_strict iconv_mime_decode_continue_on_error nil imap_opentimeout imap_readtimeout imap_writetimeout imap_closetimeout op_debug op_readonly op_anonymous op_shortcache op_silent op_prototype op_halfopen op_expunge op_secure cl_expunge ft_uid ft_peek ft_not ft_internal ft_prefetchtext st_uid st_silent st_set cp_uid cp_move se_uid se_free se_noprefetch so_free so_noserver sa_messages sa_recent sa_unseen sa_uidnext sa_uidvalidity sa_all latt_noinferiors latt_noselect latt_marked latt_unmarked latt_referral latt_haschildren latt_hasnochildren sortdate sortarrival sortfrom sortsubject sortto sortcc sortsize typetext typemultipart typemessage typeapplication typeaudio typeimage typevideo typemodel typeother enc7bit enc8bit encbinary encbase64 encquotedprintable encother ldap_deref_never ldap_deref_searching ldap_deref_finding ldap_deref_always ldap_opt_deref ldap_opt_sizelimit ldap_opt_timelimit ldap_opt_protocol_version ldap_opt_error_number ldap_opt_referrals ldap_opt_restart ldap_opt_host_name ldap_opt_error_string ldap_opt_matched_dn ldap_opt_server_controls ldap_opt_client_controls ldap_opt_debug_level mb_overload_mail mb_overload_string mb_overload_regex mb_case_upper mb_case_lower mb_case_title mcrypt_encrypt mcrypt_decrypt mcrypt_dev_random mcrypt_dev_urandom mcrypt_rand mcrypt_3des mcrypt_arcfour_iv mcrypt_arcfour mcrypt_blowfish mcrypt_blowfish_compat mcrypt_cast_128 mcrypt_cast_256 mcrypt_crypt mcrypt_des mcrypt_enigna mcrypt_gost mcrypt_loki97 mcrypt_panama mcrypt_rc2 mcrypt_rijndael_128 mcrypt_rijndael_192 mcrypt_rijndael_256 mcrypt_safer64 mcrypt_safer128 mcrypt_saferplus mcrypt_serpent mcrypt_threeway mcrypt_tripledes mcrypt_twofish mcrypt_wake mcrypt_xtea mcrypt_idea mcrypt_mars mcrypt_rc6 mcrypt_skipjack mcrypt_mode_cbc mcrypt_mode_cfb mcrypt_mode_ecb mcrypt_mode_nofb mcrypt_mode_ofb mcrypt_mode_stream mhash_crc32 mhash_md5 mhash_sha1 mhash_haval256 mhash_ripemd160 mhash_tiger mhash_gost mhash_crc32b mhash_haval224 mhash_haval192 mhash_haval160 mhash_haval128 mhash_tiger128 mhash_tiger160 mhash_md4 mhash_sha256 mhash_adler32 mhash_sha224 mhash_sha512 mhash_sha384 mhash_whirlpool mhash_ripemd128 mhash_ripemd256 mhash_ripemd320 mhash_snefru128 mhash_snefru256 mhash_md2 mysql_assoc mysql_num mysql_both mysql_client_compress mysql_client_ssl mysql_client_interactive mysql_client_ignore_space mysqli_read_default_group mysqli_read_default_file mysqli_opt_connect_timeout mysqli_opt_local_infile mysqli_init_command mysqli_client_ssl mysqli_client_compress mysqli_client_interactive mysqli_client_ignore_space mysqli_client_no_schema mysqli_client_found_rows mysqli_store_result mysqli_use_result mysqli_assoc mysqli_num mysqli_both mysqli_stmt_attr_update_max_length mysqli_not_null_flag mysqli_pri_key_flag mysqli_unique_key_flag mysqli_multiple_key_flag mysqli_blob_flag mysqli_unsigned_flag mysqli_zerofill_flag mysqli_auto_increment_flag mysqli_timestamp_flag mysqli_set_flag mysqli_num_flag mysqli_part_key_flag mysqli_group_flag mysqli_type_decimal mysqli_type_tiny mysqli_type_short mysqli_type_long mysqli_type_float mysqli_type_double mysqli_type_null mysqli_type_timestamp mysqli_type_longlong mysqli_type_int24 mysqli_type_date mysqli_type_time mysqli_type_datetime mysqli_type_year mysqli_type_newdate mysqli_type_enum mysqli_type_set mysqli_type_tiny_blob mysqli_type_medium_blob mysqli_type_long_blob mysqli_type_blob mysqli_type_var_string mysqli_type_string mysqli_type_char mysqli_type_interval mysqli_type_geometry mysqli_rpl_master mysqli_rpl_slave mysqli_rpl_admin mysqli_no_data mysqli_report_index mysqli_report_error mysqli_report_all mysqli_report_off ncurses_color_black ncurses_color_red ncurses_color_green ncurses_color_yellow ncurses_color_blue ncurses_color_magenta ncurses_color_cyan ncurses_color_white ncurses_key_down ncurses_key_up ncurses_key_left ncurses_key_right ncurses_key_backspace ncurses_key_mouse ncurses_key_f0 ncurses_key_f1 ncurses_key_f2 ncurses_key_f3 ncurses_key_f4 ncurses_key_f5 ncurses_key_f6 ncurses_key_f7 ncurses_key_f8 ncurses_key_f9 ncurses_key_f10 ncurses_key_f11 ncurses_key_f12 ncurses_key_dl ncurses_key_il ncurses_key_dc ncurses_key_ic ncurses_key_eic ncurses_key_clear ncurses_key_eos ncurses_key_eol ncurses_key_sf ncurses_key_sr ncurses_key_npage ncurses_key_ppage ncurses_key_stab ncurses_key_ctab ncurses_key_catab ncurses_key_enter ncurses_key_sreset ncurses_key_reset ncurses_key_print ncurses_key_ll ncurses_key_a1 ncurses_key_a3 ncurses_key_b2 ncurses_key_c1 ncurses_key_c3 ncurses_key_btab ncurses_key_beg ncurses_key_cancel ncurses_key_close ncurses_key_command ncurses_key_copy ncurses_key_create ncurses_key_end ncurses_key_exit ncurses_key_find ncurses_key_help ncurses_key_mark ncurses_key_message ncurses_key_move ncurses_key_next ncurses_key_open ncurses_key_options ncurses_key_previous ncurses_key_redo ncurses_key_reference ncurses_key_refresh ncurses_key_replace ncurses_key_restart ncurses_key_resume ncurses_key_save ncurses_key_sbeg ncurses_key_scancel ncurses_key_scommand ncurses_key_scopy ncurses_key_screate ncurses_key_sdc ncurses_key_sdl ncurses_key_select ncurses_key_send ncurses_key_seol ncurses_key_sexit ncurses_key_sfind ncurses_key_shelp ncurses_key_shome ncurses_key_sic ncurses_key_sleft ncurses_key_smessage ncurses_key_smove ncurses_key_snext ncurses_key_soptions ncurses_key_sprevious ncurses_key_sprint ncurses_key_sredo ncurses_key_sreplace ncurses_key_sright ncurses_key_srsume ncurses_key_ssave ncurses_key_ssuspend ncurses_key_sundo ncurses_key_suspend ncurses_key_undo ncurses_key_resize ncurses_a_normal ncurses_a_standout ncurses_a_underline ncurses_a_reverse ncurses_a_blink ncurses_a_dim ncurses_a_bold ncurses_a_protect ncurses_a_invis ncurses_a_altcharset ncurses_a_chartext ncurses_button1_pressed ncurses_button1_released ncurses_button1_clicked ncurses_button1_double_clicked ncurses_button1_triple_clicked ncurses_button2_pressed ncurses_button2_released ncurses_button2_clicked ncurses_button2_double_clicked ncurses_button2_triple_clicked ncurses_button3_pressed ncurses_button3_released ncurses_button3_clicked ncurses_button3_double_clicked ncurses_button3_triple_clicked ncurses_button4_pressed ncurses_button4_released ncurses_button4_clicked ncurses_button4_double_clicked ncurses_button4_triple_clicked ncurses_button_shift ncurses_button_ctrl ncurses_button_alt ncurses_all_mouse_events ncurses_report_mouse_position odbc_type odbc_binmode_passthru odbc_binmode_return odbc_binmode_convert sql_odbc_cursors sql_cur_use_driver sql_cur_use_if_needed sql_cur_use_odbc sql_concurrency sql_concur_read_only sql_concur_lock sql_concur_rowver sql_concur_values sql_cursor_type sql_cursor_forward_only sql_cursor_keyset_driven sql_cursor_dynamic sql_cursor_static sql_keyset_size sql_fetch_first sql_fetch_next sql_char sql_varchar sql_longvarchar sql_decimal sql_numeric sql_bit sql_tinyint sql_smallint sql_integer sql_bigint sql_real sql_float sql_double sql_binary sql_varbinary sql_longvarbinary sql_date sql_time sql_timestamp x509_purpose_ssl_client x509_purpose_ssl_server x509_purpose_ns_ssl_server x509_purpose_smime_sign x509_purpose_smime_encrypt x509_purpose_crl_sign x509_purpose_any openssl_algo_sha1 openssl_algo_md5 openssl_algo_md4 openssl_algo_md2 pkcs7_detached pkcs7_text pkcs7_nointern pkcs7_noverify pkcs7_nochain pkcs7_nocerts pkcs7_noattr pkcs7_binary pkcs7_nosigs openssl_pkcs1_padding openssl_sslv23_padding openssl_no_padding openssl_pkcs1_oaep_padding openssl_cipher_rc2_40 openssl_cipher_rc2_128 openssl_cipher_rc2_64 openssl_cipher_des openssl_cipher_3des openssl_keytype_rsa openssl_keytype_dsa openssl_keytype_dh wnohang wuntraced sig_ign sig_dfl sig_err sighup sigint sigquit sigill sigtrap sigabrt sigiot sigbus sigfpe sigkill sigusr1 sigsegv sigusr2 sigpipe sigalrm sigterm sigstkflt sigcld sigchld sigcont sigstop sigtstp sigttin sigttou sigurg sigxcpu sigxfsz sigvtalrm sigprof sigwinch sigpoll sigio sigpwr sigsys sigbaby prio_pgrp prio_user prio_process pgsql_connect_force_new pgsql_assoc pgsql_num pgsql_both pgsql_connection_bad pgsql_connection_ok pgsql_seek_set pgsql_seek_cur pgsql_seek_end pgsql_status_long pgsql_status_string pgsql_empty_query pgsql_command_ok pgsql_tuples_ok pgsql_copy_out pgsql_copy_in pgsql_bad_response pgsql_nonfatal_error pgsql_fatal_error pgsql_conv_ignore_default pgsql_conv_force_null pgsql_conv_ignore_not_null pgsql_dml_no_conv pgsql_dml_exec pgsql_dml_async pgsql_dml_string snmp_value_library snmp_value_plain snmp_value_object snmp_bit_str snmp_octet_str snmp_opaque snmp_null snmp_object_id snmp_ipaddress snmp_counter snmp_unsigned snmp_timeticks snmp_uinteger snmp_integer snmp_counter64 soap_1_1 soap_1_2 soap_persistence_session soap_persistence_request soap_functions_all soap_encoded soap_literal soap_rpc soap_document soap_actor_next soap_actor_none soap_actor_unlimatereceiver soap_compression_accept soap_compression_gzip soap_compression_deflate unknown_type xsd_string xsd_boolean xsd_decimal xsd_float xsd_double xsd_duration xsd_datetime xsd_time xsd_date xsd_gyearmonth xsd_gyear xsd_gmonthday xsd_gday xsd_gmonth xsd_hexbinary xsd_base64binary xsd_anyuri xsd_qname xsd_notation xsd_normalizedstring xsd_token xsd_language xsd_nmtoken xsd_name xsd_ncname xsd_id xsd_idref xsd_idrefs xsd_entity xsd_entities xsd_integer xsd_nonpositiveinteger xsd_negativeinteger xsd_long xsd_int xsd_short xsd_byte xsd_nonnegativeinteger xsd_unsignedlong xsd_unsignedint xsd_unsignedshort xsd_unsignedbyte xsd_positiveinteger xsd_nmtokens xsd_anytype soap_enc_object soap_enc_array xsd_1999_timeinstant xsd_namespace xsd_1999_namespace af_unix af_inet af_inet6 sock_stream sock_dgram sock_raw sock_seqpacket sock_rdm msg_oob msg_waitall msg_peek msg_dontroute so_debug so_reuseaddr so_keepalive so_dontroute so_linger so_broadcast so_oobinline so_sndbuf so_rcvbuf so_sndlowat so_rcvlowat so_sndtimeo so_rcvtimeo so_type so_error sol_socket somaxconn php_normal_read php_binary_read socket_eperm socket_enoent socket_eintr socket_eio socket_enxio socket_e2big socket_ebadf socket_eagain socket_enomem socket_eacces socket_efault socket_enotblk socket_ebusy socket_eexist socket_exdev socket_enodev socket_enotdir socket_eisdir socket_einval socket_enfile socket_emfile socket_enotty socket_enospc socket_espipe socket_erofs socket_emlink socket_epipe socket_enametoolong socket_enolck socket_enosys socket_enotempty socket_eloop socket_ewouldblock socket_enomsg socket_eidrm socket_echrng socket_el2nsync socket_el3hlt socket_el3rst socket_elnrng socket_eunatch socket_enocsi socket_el2hlt socket_ebade socket_ebadr socket_exfull socket_enoano socket_ebadrqc socket_ebadslt socket_enostr socket_enodata socket_etime socket_enosr socket_enonet socket_eremote socket_enolink socket_eadv socket_esrmnt socket_ecomm socket_eproto socket_emultihop socket_ebadmsg socket_enotuniq socket_ebadfd socket_eremchg socket_erestart socket_estrpipe socket_eusers socket_enotsock socket_edestaddrreq socket_emsgsize socket_eprototype socket_enoprotoopt socket_eprotonosupport socket_esocktnosupport socket_eopnotsupp socket_epfnosupport socket_eafnosupport socket_eaddrinuse socket_eaddrnotavail socket_enetdown socket_enetunreach socket_enetreset socket_econnaborted socket_econnreset socket_enobufs socket_eisconn socket_enotconn socket_eshutdown socket_etoomanyrefs socket_etimedout socket_econnrefused socket_ehostdown socket_ehostunreach socket_ealready socket_einprogress socket_eisnam socket_eremoteio socket_edquot socket_enomedium socket_emediumtype sol_tcp sol_udp sqlite_both sqlite_num sqlite_assoc sqlite_ok sqlite_error sqlite_internal sqlite_perm sqlite_abort sqlite_busy sqlite_locked sqlite_nomem sqlite_readonly sqlite_interrupt sqlite_ioerr sqlite_corrupt sqlite_notfound sqlite_full sqlite_cantopen sqlite_protocol sqlite_empty sqlite_schema sqlite_toobig sqlite_constraint sqlite_mismatch sqlite_misuse sqlite_nolfs sqlite_auth sqlite_format sqlite_row sqlite_done msg_ipc_nowait msg_noerror msg_except t_include t_include_once t_eval t_require t_require_once t_logical_or t_logical_xor t_logical_and t_print t_plus_equal t_minus_equal t_mul_equal t_div_equal t_concat_equal t_mod_equal t_and_equal t_or_equal t_xor_equal t_sl_equal t_sr_equal t_boolean_or t_boolean_and t_is_equal t_is_not_equal t_is_identical t_is_not_identical t_is_smaller_or_equal t_is_greater_or_equal t_sl t_sr t_inc t_dec t_int_cast t_double_cast t_string_cast t_array_cast t_object_cast t_bool_cast t_unset_cast t_new t_exit t_if t_elseif t_else t_endif t_lnumber t_dnumber t_string t_string_varname t_variable t_num_string t_inline_html t_character t_bad_character t_encapsed_and_whitespace t_constant_encapsed_string t_echo t_do t_while t_endwhile t_for t_endfor t_foreach t_endforeach t_declare t_enddeclare t_as t_switch t_endswitch t_case t_default t_break t_continue t_function t_const t_return t_use t_global t_static t_var t_unset t_isset t_empty t_class t_extends t_interface t_implements t_object_operator t_double_arrow t_list t_array t_class_c t_func_c t_method_c t_line t_file t_comment t_doc_comment t_open_tag t_open_tag_with_echo t_close_tag t_whitespace t_start_heredoc t_end_heredoc t_dollar_open_curly_braces t_curly_open t_paamayim_nekudotayim t_double_colon t_abstract t_catch t_final t_instanceof t_private t_protected t_public t_throw t_try t_clone xsl_clone_auto xsl_clone_never xsl_clone_always yperr_badargs yperr_baddb yperr_busy yperr_domain yperr_key yperr_map yperr_nodom yperr_nomore yperr_pmap yperr_resrc yperr_rpc yperr_ypbind yperr_yperr yperr_ypserv yperr_vers force_gzip force_deflate"
list_special'5fmethods = Set.fromList $ words $ "__autoload __call __clone __construct __destruct __get __isset __set __set_state __sleep __tostring __unset __wakeup"
list_functions = Set.fromList $ words $ "abs acos acosh addcslashes addslashes apache_get_modules apache_get_version apache_getenv apache_lookup_uri apache_note apache_request_headers apache_response_headers apache_setenv array array_change_key_case array_chunk array_combine array_count_values array_diff array_diff_assoc array_diff_key array_diff_uassoc array_diff_ukey array_diff array_fill array_filter array_flip array_intersect array_intersect_assoc array_intersect_key array_intersect_uassoc array_intersect_ukey array_intersect array_key_exists array_keys array_map array_merge array_merge_recursive array_multisort array_pad array_pop array_product array_push array_rand array_reduce array_reverse array_search array_shift array_slice array_splice array_sum array_udiff array_udiff_assoc array_udiff_uassoc array_uintersect array_uintersect_assoc array_uintersect_uassoc array_uintersect array_unique array_unshift array_values array_walk array_walk_recursive arsort ascii2ebcdic asin asinh asort aspell_check aspell_check_raw aspell_new aspell_suggest assert assert_options atan atan2 atanh base64_decode base64_encode base_convert basename bcadd bccomp bcdiv bcmod bcmul bcpow bcpowmod bcscale bcsqrt bcsub bin2hex bind_textdomain_codeset bindec bindtextdomain bzclose bzcompress bzdecompress bzerrno bzerror bzerrstr bzflush bzopen bzread bzwrite cal_days_in_month cal_from_jd cal_info cal_to_jd call_user_func call_user_func_array call_user_method call_user_method_array ccvs_add ccvs_auth ccvs_command ccvs_count ccvs_delete ccvs_done ccvs_init ccvs_lookup ccvs_new ccvs_report ccvs_return ccvs_reverse ccvs_sale ccvs_status ccvs_textvalue ccvs_void ceil chdir checkdate checkdnsrr chgrp chmod chop chown chr chroot chunk_split class_exists class_implements class_parents clearstatcache closedir closelog com com_addref com_get com_invoke com_isenum com_load com_load_typelib com_propget com_propput com_propset com_release com_set compact connection_aborted connection_status connection_timeout constant convert_cyr_string convert_uudecode convert_uuencode copy cos cosh count count_chars cpdf_add_annotation cpdf_add_outline cpdf_arc cpdf_begin_text cpdf_circle cpdf_clip cpdf_close cpdf_closepath cpdf_closepath_fill_stroke cpdf_closepath_stroke cpdf_continue_text cpdf_curveto cpdf_end_text cpdf_fill cpdf_fill_stroke cpdf_finalize cpdf_finalize_page cpdf_global_set_document_limits cpdf_import_jpeg cpdf_lineto cpdf_moveto cpdf_newpath cpdf_open cpdf_output_buffer cpdf_page_init cpdf_place_inline_image cpdf_rect cpdf_restore cpdf_rlineto cpdf_rmoveto cpdf_rotate cpdf_rotate_text cpdf_save cpdf_save_to_file cpdf_scale cpdf_set_action_url cpdf_set_char_spacing cpdf_set_creator cpdf_set_current_page cpdf_set_font cpdf_set_font_directories cpdf_set_font_map_file cpdf_set_horiz_scaling cpdf_set_keywords cpdf_set_leading cpdf_set_page_animation cpdf_set_subject cpdf_set_text_matrix cpdf_set_text_pos cpdf_set_text_rendering cpdf_set_text_rise cpdf_set_title cpdf_set_viewer_preferences cpdf_set_word_spacing cpdf_setdash cpdf_setflat cpdf_setgray cpdf_setgray_fill cpdf_setgray_stroke cpdf_setlinecap cpdf_setlinejoin cpdf_setlinewidth cpdf_setmiterlimit cpdf_setrgbcolor cpdf_setrgbcolor_fill cpdf_setrgbcolor_stroke cpdf_show cpdf_show_xy cpdf_stringwidth cpdf_stroke cpdf_text cpdf_translate crack_check crack_closedict crack_getlastmessage crack_opendict crc32 create_function crypt ctype_alnum ctype_alpha ctype_cntrl ctype_digit ctype_graph ctype_lower ctype_print ctype_punct ctype_space ctype_upper ctype_xdigit curl_close curl_copy_handle curl_errno curl_error curl_exec curl_getinfo curl_init curl_multi_add_handle curl_multi_close curl_multi_exec curl_multi_getcontent curl_multi_info_read curl_multi_init curl_multi_remove_handle curl_multi_select curl_setopt curl_version current cybercash_base64_decode cybercash_base64_encode cybercash_decr cybercash_encr cybermut_creerformulairecm cybermut_creerreponsecm cybermut_testmac cyrus_authenticate cyrus_bind cyrus_close cyrus_connect cyrus_query cyrus_unbind date date_sunrise date_sunset dba_close dba_delete dba_exists dba_fetch dba_firstkey dba_handlers dba_insert dba_key_split dba_list dba_nextkey dba_open dba_optimize dba_popen dba_replace dba_sync dbase_add_record dbase_close dbase_create dbase_delete_record dbase_get_header_info dbase_get_record dbase_get_record_with_names dbase_numfields dbase_numrecords dbase_open dbase_pack dbase_replace_record dblist dbmclose dbmdelete dbmexists dbmfetch dbmfirstkey dbminsert dbmnextkey dbmopen dbmreplace dbplus_add dbplus_aql dbplus_chdir dbplus_close dbplus_curr dbplus_errcode dbplus_errno dbplus_find dbplus_first dbplus_flush dbplus_freealllocks dbplus_freelock dbplus_freerlocks dbplus_getlock dbplus_getunique dbplus_info dbplus_last dbplus_lockrel dbplus_next dbplus_open dbplus_prev dbplus_rchperm dbplus_rcreate dbplus_rcrtexact dbplus_rcrtlike dbplus_resolve dbplus_restorepos dbplus_rkeys dbplus_ropen dbplus_rquery dbplus_rrename dbplus_rsecindex dbplus_runlink dbplus_rzap dbplus_savepos dbplus_setindex dbplus_setindexbynumber dbplus_sql dbplus_tcl dbplus_tremove dbplus_undo dbplus_undoprepare dbplus_unlockrel dbplus_unselect dbplus_update dbplus_xlockrel dbplus_xunlockrel dbx_close dbx_compare dbx_connect dbx_error dbx_escape_string dbx_fetch_row dbx_query dbx_sort dcgettext dcngettext debug_backtrace debug_print_backtrace debug_zval_dump dcgettext dcngettext debugger_off debugger_on decbin dechex decoct define define_syslog_variables defined deg2rad delete dgettext die dio_close dio_fcntl dio_open dio_read dio_seek dio_stat dio_tcsetattr dio_truncate dio_write dir dirname disk_free_space disk_total_space diskfreespace dl dngettext dns_check_record dns_get_mx dns_get_record dom_import_simplexml dngettext domxml_add_root domxml_attributes domxml_children domxml_dumpmem domxml_get_attribute domxml_new_child domxml_new_xmldoc domxml_node domxml_node_set_content domxml_node_unlink_node domxml_root domxml_set_attribute domxml_version dotnet_load doubleval each easter_date easter_days ebcdic2ascii echo empty end ereg ereg_replace eregi eregi_replace error_log error_reporting escapeshellarg escapeshellcmd eval exec exif_imagetype exif_read_data exif_tagname exif_thumbnail exit exp explode expm1 extension_loaded extract ezmlm_hash fam_cancel_monitor fam_close fam_monitor_collection fam_monitor_directory fam_monitor_file fam_next_event fam_open fam_pending fam_resume_monitor fam_suspend_monitor fbsql_affected_rows fbsql_autocommit fbsql_change_user fbsql_close fbsql_commit fbsql_connect fbsql_create_blob fbsql_create_clob fbsql_create_db fbsql_data_seek fbsql_database fbsql_database_password fbsql_db_query fbsql_db_status fbsql_drop_db fbsql_errno fbsql_error fbsql_fetch_array fbsql_fetch_assoc fbsql_fetch_field fbsql_fetch_lengths fbsql_fetch_object fbsql_fetch_row fbsql_field_flags fbsql_field_len fbsql_field_name fbsql_field_seek fbsql_field_table fbsql_field_type fbsql_free_result fbsql_get_autostart_info fbsql_hostname fbsql_insert_id fbsql_list_dbs fbsql_list_fields fbsql_list_tables fbsql_next_result fbsql_num_fields fbsql_num_rows fbsql_password fbsql_pconnect fbsql_query fbsql_read_blob fbsql_read_clob fbsql_result fbsql_rollback fbsql_select_db fbsql_set_lob_mode fbsql_set_transaction fbsql_start_db fbsql_stop_db fbsql_tablename fbsql_username fbsql_warnings fclose fdf_add_template fdf_close fdf_create fdf_get_file fdf_get_status fdf_get_value fdf_next_field_name fdf_open fdf_save fdf_set_ap fdf_set_encoding fdf_set_file fdf_set_flags fdf_set_javascript_action fdf_set_opt fdf_set_status fdf_set_submit_form_action fdf_set_value feof fflush fgetc fgetcsv fgets fgetss fgetwrapperdata file file_exists file_get_contents file_put_contents fileatime filectime filegroup fileinode filemtime fileowner fileperms filepro filepro_fieldcount filepro_fieldname filepro_fieldtype filepro_fieldwidth filepro_retrieve filepro_rowcount filesize filetype floatval flock floor flush fmod fnmatch fopen fpassthru fprintf fputs fread frenchtojd fribidi_log2vis fscanf fseek fsockopen fstat ftell ftok ftp_alloc ftp_cdup ftp_chdir ftp_chmod ftp_close ftp_connect ftp_delete ftp_exec ftp_fget ftp_fput ftp_get ftp_get_option ftp_login ftp_mdtm ftp_mkdir ftp_nb_continue ftp_nb_fget ftp_nb_fput ftp_nb_get ftp_nb_put ftp_nlist ftp_pasv ftp_put ftp_pwd ftp_quit ftp_raw ftp_rawlist ftp_rename ftp_rmdir ftp_set_option ftp_site ftp_size ftp_ssl_connect ftp_systype ftruncate func_get_arg func_get_args func_num_args function_exists fwrite gd_info get_browser get_cfg_var get_class get_class_methods get_class_vars get_current_user get_declared_classes get_declared_interfaces get_defined_constants get_defined_functions get_defined_vars get_extension_funcs get_headers get_html_translation_table get_include_path get_included_files get_loaded_extensions get_magic_quotes_gpc get_magic_quotes_runtime get_meta_tags get_object_vars get_parent_class get_required_files get_resource_type getallheaders getcwd getdate getenv gethostbyaddr gethostbyname gethostbynamel getimagesize getlastmod getmxrr getmygid getmyinode getmypid getmyuid getopt getprotobyname getprotobynumber getrandmax getrusage getservbyname getservbyport gettext gettimeofday gettype glob global gmdate gmmktime gmp_abs gmp_add gmp_and gmp_clrbit gmp_cmp gmp_com gmp_div gmp_div_q gmp_div_qr gmp_div_r gmp_divexact gmp_fact gmp_gcd gmp_gcdext gmp_hamdist gmp_init gmp_intval gmp_invert gmp_jacobi gmp_legendre gmp_mod gmp_mul gmp_neg gmp_or gmp_perfect_square gmp_popcount gmp_pow gmp_powm gmp_prob_prime gmp_random gmp_scan0 gmp_scan1 gmp_setbit gmp_sign gmp_sqrt gmp_sqrtrem gmp_strval gmp_sub gmp_xor gmstrftime gregoriantojd gzclose gzcompress gzdeflate gzencode gzeof gzfile gzgetc gzgets gzgetss gzinflate gzopen gzpassthru gzputs gzread gzrewind gzseek gztell gzuncompress gzwrite header headers_list headers_sent hebrev hebrevc hexdec highlight_file highlight_string html_entity_decode htmlentities htmlspecialchars http_build_query hw_array2objrec hw_changeobject hw_children hw_childrenobj hw_close hw_connect hw_connection_info hw_cp hw_deleteobject hw_docbyanchor hw_docbyanchorobj hw_document_attributes hw_document_bodytag hw_document_content hw_document_setcontent hw_document_size hw_dummy hw_edittext hw_error hw_errormsg hw_free_document hw_getanchors hw_getanchorsobj hw_getandlock hw_getchildcoll hw_getchildcollobj hw_getchilddoccoll hw_getchilddoccollobj hw_getobject hw_getobjectbyquery hw_getobjectbyquerycoll hw_getobjectbyquerycollobj hw_getobjectbyqueryobj hw_getparents hw_getparentsobj hw_getrellink hw_getremote hw_getremotechildren hw_getsrcbydestobj hw_gettext hw_getusername hw_identify hw_incollections hw_info hw_inscoll hw_insdoc hw_insertanchors hw_insertdocument hw_insertobject hw_mapid hw_modifyobject hw_mv hw_new_document hw_objrec2array hw_output_document hw_pconnect hw_pipedocument hw_root hw_setlinkroot hw_stat hw_unlock hw_who hypot idate ibase_blob_add ibase_blob_cancel ibase_blob_close ibase_blob_create ibase_blob_echo ibase_blob_get ibase_blob_import ibase_blob_info ibase_blob_open ibase_close ibase_commit ibase_connect ibase_errmsg ibase_execute ibase_fetch_object ibase_fetch_row ibase_field_info ibase_free_query ibase_free_result ibase_num_fields ibase_pconnect ibase_prepare ibase_query ibase_rollback ibase_timefmt ibase_trans icap_close icap_create_calendar icap_delete_calendar icap_delete_event icap_fetch_event icap_list_alarms icap_list_events icap_open icap_rename_calendar icap_reopen icap_snooze icap_store_event iconv iconv_get_encoding iconv_mime_decode iconv_mime_decode_headers iconv_mime_encode iconv_set_encoding ifx_affected_rows ifx_blobinfile_mode ifx_byteasvarchar ifx_close ifx_connect ifx_copy_blob ifx_create_blob ifx_create_char ifx_do ifx_error ifx_errormsg ifx_fetch_row ifx_fieldproperties ifx_fieldtypes ifx_free_blob ifx_free_char ifx_free_result ifx_get_blob ifx_get_char ifx_getsqlca ifx_htmltbl_result ifx_nullformat ifx_num_fields ifx_num_rows ifx_pconnect ifx_prepare ifx_query ifx_textasvarchar ifx_update_blob ifx_update_char ifxus_close_slob ifxus_create_slob ifxus_free_slob ifxus_open_slob ifxus_read_slob ifxus_seek_slob ifxus_tell_slob ifxus_write_slob ignore_user_abort image2wbmp image_type_to_mime_type imagealphablending imageantialias imagearc imagechar imagecharup imagecolorallocate imagecolorallocatealpha imagecolorat imagecolorclosest imagecolorclosestalpha imagecolorclosesthwb imagecolordeallocate imagecolorexact imagecolorexactalpha imagecolormatch imagecolorresolve imagecolorresolvealpha imagecolorset imagecolorsforindex imagecolorstotal imagecolortransparent imagecopy imagecopymerge imagecopymergegray imagecopyresampled imagecopyresized imagecreate imagecreatefromgd imagecreatefromgd2 imagecreatefromgd2part imagecreatefromgif imagecreatefromjpeg imagecreatefrompng imagecreatefromstring imagecreatefromwbmp imagecreatefromxbm imagecreatefromxpm imagecreatetruecolor imagedashedline imagedestroy imageellipse imagefill imagefilledarc imagefilledellipse imagefilledpolygon imagefilledrectangle imagefilltoborder imagefilter imagefontheight imagefontwidth imageftbbox imagefttext imagegammacorrect imagegd imagegd2 imagegif imageinterlace imageistruecolor imagejpeg imagelayereffect imageline imageloadfont imagepalettecopy imagepng imagepolygon imagepsbbox imagepsencodefont imagepsextendfont imagepsfreefont imagepsloadfont imagepsslantfont imagepstext imagerectangle imagerotate imagesavealpha imagesetbrush imagesetpixel imagesetstyle imagesetthickness imagesettile imagestring imagestringup imagesx imagesy imagetruecolortopalette imagettfbbox imagettftext imagetypes imagewbmp imagexbm imap_8bit imap_alerts imap_append imap_base64 imap_binary imap_body imap_bodystruct imap_check imap_clearflag_full imap_close imap_create imap_createmailbox imap_delete imap_deletemailbox imap_errors imap_expunge imap_fetch_overview imap_fetchbody imap_fetchheader imap_fetchstructure imap_fetchtext imap_get_quota imap_get_quotaroot imap_getacl imap_getmailboxes imap_getsubscribed imap_header imap_headerinfo imap_headers imap_last_error imap_list imap_listmailbox imap_listsubscribed imap_lsub imap_mail imap_mail_compose imap_mail_copy imap_mail_move imap_mailboxmsginfo imap_mime_header_decode imap_msgno imap_num_msg imap_num_recent imap_open imap_ping imap_popen imap_qprint imap_rename imap_renamemailbox imap_reopen imap_rfc822_parse_adrlist imap_rfc822_parse_headers imap_rfc822_write_address imap_scan imap_scanmailbox imap_search imap_set_quota imap_setacl imap_setflag_full imap_sort imap_status imap_subscribe imap_thread imap_timeout imap_uid imap_undelete imap_unsubscribe imap_utf7_decode imap_utf7_encode imap_utf8 implode import_request_variables in_array include include_once ingres_autocommit ingres_close ingres_commit ingres_connect ingres_fetch_array ingres_fetch_object ingres_fetch_row ingres_field_length ingres_field_name ingres_field_nullable ingres_field_precision ingres_field_scale ingres_field_type ingres_num_fields ingres_num_rows ingres_pconnect ingres_query ingres_rollback ini_alter ini_get ini_get_all ini_restore ini_set interface_exists intval ip2long iptcembed iptcparse ircg_channel_mode ircg_disconnect ircg_fetch_error_msg ircg_get_username ircg_html_encode ircg_ignore_add ircg_ignore_del ircg_is_conn_alive ircg_join ircg_kick ircg_lookup_format_messages ircg_msg ircg_nick ircg_nickname_escape ircg_nickname_unescape ircg_notice ircg_part ircg_pconnect ircg_register_format_messages ircg_set_current ircg_set_file ircg_set_on_die ircg_topic ircg_whois is_a is_array is_bool is_callable is_dir is_double is_executable is_file is_finite is_float is_infinite is_int is_integer is_link is_long is_nan is_null is_numeric is_object is_readable is_real is_resource is_scalar is_string is_subclass_of is_uploaded_file is_writable is_writeable isset java_last_exception_clear java_last_exception_get jddayofweek jdmonthname jdtofrench jdtogregorian jdtojewish jdtojulian jdtounix jewishtojd join jpeg2wbmp juliantojd key key_exists krsort ksort lcg_value ldap_8859_to_t61 ldap_add ldap_bind ldap_close ldap_compare ldap_connect ldap_count_entries ldap_delete ldap_dn2ufn ldap_err2str ldap_errno ldap_error ldap_explode_dn ldap_first_attribute ldap_first_entry ldap_first_reference ldap_free_result ldap_get_attributes ldap_get_dn ldap_get_entries ldap_get_option ldap_get_values ldap_get_values_len ldap_list ldap_mod_add ldap_mod_del ldap_mod_replace ldap_modify ldap_next_attribute ldap_next_entry ldap_next_reference ldap_parse_reference ldap_parse_result ldap_read ldap_rename ldap_search ldap_set_option ldap_set_rebind_proc ldap_sort ldap_start_tls ldap_t61_to_8859 ldap_unbind leak levenshtein libxml_set_streams_context link linkinfo list localeconv localtime log log10 log1p long2ip lstat ltrim magic_quotes_runtime mail mailparse_determine_best_xfer_encoding mailparse_msg_create mailparse_msg_extract_part mailparse_msg_extract_part_file mailparse_msg_free mailparse_msg_get_part mailparse_msg_get_part_data mailparse_msg_get_structure mailparse_msg_parse mailparse_msg_parse_file mailparse_rfc822_parse_addresses mailparse_stream_encode mailparse_uudecode_all max mb_convert_case mb_convert_encoding mb_convert_kana mb_convert_variables mb_decode_mimeheader mb_decode_numericentity mb_detect_encoding mb_detect_order mb_encode_mimeheader mb_encode_numericentity mb_ereg mb_ereg_match mb_ereg_replace mb_ereg_search mb_ereg_search_getpos mb_ereg_search_getregs mb_ereg_search_init mb_ereg_search_pos mb_ereg_search_regs mb_ereg_search_setpos mb_eregi mb_eregi_replace mb_get_info mb_http_input mb_http_output mb_internal_encoding mb_language mb_output_handler mb_parse_str mb_preferred_mime_name mb_regex_encoding mb_regex_set_options mb_send_mail mb_split mb_strcut mb_strimwidth mb_strlen mb_strpos mb_strrpos mb_strtolower mb_strtoupper mb_strwidth mb_substitute_character mb_substr mcal_append_event mcal_close mcal_create_calendar mcal_date_compare mcal_date_valid mcal_day_of_week mcal_day_of_year mcal_days_in_month mcal_delete_calendar mcal_delete_event mcal_event_add_attribute mcal_event_init mcal_event_set_alarm mcal_event_set_category mcal_event_set_class mcal_event_set_description mcal_event_set_end mcal_event_set_recur_daily mcal_event_set_recur_monthly_mday mcal_event_set_recur_monthly_wday mcal_event_set_recur_none mcal_event_set_recur_weekly mcal_event_set_recur_yearly mcal_event_set_start mcal_event_set_title mcal_expunge mcal_fetch_current_stream_event mcal_fetch_event mcal_is_leap_year mcal_list_alarms mcal_list_events mcal_next_recurrence mcal_open mcal_popen mcal_rename_calendar mcal_reopen mcal_snooze mcal_store_event mcal_time_valid mcal_week_of_year mcrypt_cbc mcrypt_cfb mcrypt_create_iv mcrypt_decrypt mcrypt_ecb mcrypt_enc_get_algorithms_name mcrypt_enc_get_block_size mcrypt_enc_get_iv_size mcrypt_enc_get_key_size mcrypt_enc_get_modes_name mcrypt_enc_get_supported_key_sizes mcrypt_enc_is_block_algorithm mcrypt_enc_is_block_algorithm_mode mcrypt_enc_is_block_mode mcrypt_enc_self_test mcrypt_encrypt mcrypt_generic mcrypt_generic_deinit mcrypt_generic_end mcrypt_generic_init mcrypt_get_block_size mcrypt_get_cipher_name mcrypt_get_iv_size mcrypt_get_key_size mcrypt_list_algorithms mcrypt_list_modes mcrypt_module_close mcrypt_module_get_algo_block_size mcrypt_module_get_algo_key_size mcrypt_module_get_supported_key_sizes mcrypt_module_is_block_algorithm mcrypt_module_is_block_algorithm_mode mcrypt_module_is_block_mode mcrypt_module_open mcrypt_module_self_test mcrypt_ofb md5 md5_file mdecrypt_generic memory_get_usage metaphone method_exists mhash mhash_count mhash_get_block_size mhash_get_hash_name mhash_keygen_s2k microtime min ming_setcubicthreshold ming_setscale ming_useswfversion mkdir mktime money_format move_uploaded_file msg_get_queue msg_receive msg_remove_queue msg_send msg_set_queue msg_stat_queue msession_connect msession_count msession_create msession_destroy msession_disconnect msession_find msession_get msession_get_array msession_getdata msession_inc msession_list msession_listvar msession_lock msession_plugin msession_randstr msession_set msession_set_array msession_setdata msession_timeout msession_uniq msession_unlock msql msql_affected_rows msql_close msql_connect msql_create_db msql_createdb msql_data_seek msql_dbname msql_drop_db msql_dropdb msql_error msql_fetch_array msql_fetch_field msql_fetch_object msql_fetch_row msql_field_seek msql_fieldflags msql_fieldlen msql_fieldname msql_fieldtable msql_fieldtype msql_free_result msql_freeresult msql_list_dbs msql_list_fields msql_list_tables msql_listdbs msql_listfields msql_listtables msql_num_fields msql_num_rows msql_numfields msql_numrows msql_pconnect msql_query msql_regcase msql_result msql_select_db msql_selectdb msql_tablename mssql_bind mssql_close mssql_connect mssql_data_seek mssql_execute mssql_fetch_array mssql_fetch_assoc mssql_fetch_batch mssql_fetch_field mssql_fetch_object mssql_fetch_row mssql_field_length mssql_field_name mssql_field_seek mssql_field_type mssql_free_result mssql_get_last_message mssql_guid_string mssql_init mssql_min_error_severity mssql_min_message_severity mssql_next_result mssql_num_fields mssql_num_rows mssql_pconnect mssql_query mssql_result mssql_rows_affected mssql_select_db mt_getrandmax mt_rand mt_srand muscat_close muscat_get muscat_give muscat_setup muscat_setup_net mysql mysql_affected_rows mysql_client_encoding mysql_change_user mysql_character_set_name mysql_close mysql_connect mysql_create_db mysql_data_seek mysql_db_name mysql_db_query mysql_dbname mysql_drop_db mysql_errno mysql_error mysql_escape_string mysql_fetch_array mysql_fetch_assoc mysql_fetch_field mysql_fetch_lengths mysql_fetch_object mysql_fetch_row mysql_field_flags mysql_field_len mysql_field_name mysql_field_seek mysql_field_table mysql_field_type mysql_fieldflags mysql_fieldlen mysql_fieldname mysql_fieldtable mysql_fieldtype mysql_free_result mysql_freeresult mysql_get_client_info mysql_get_host_info mysql_get_proto_info mysql_get_server_info mysql_info mysql_insert_id mysql_list_dbs mysql_list_fields mysql_list_processes mysql_list_tables mysql_listdbs mysql_listfields mysql_listtables mysql_num_fields mysql_num_rows mysql_numfields mysql_numrows mysql_pconnect mysql_ping mysql_query mysql_real_escape_string mysql_result mysql_select_db mysql_selectdb mysql_stat mysql_table_name mysql_tablename mysql_thread_id mysql_unbuffered_query mysqli_affected_rows mysqli_autocommit mysqli_bind_param mysqli_bind_result mysqli_change_user mysqli_character_set_name mysqli_client_encoding mysqli_close mysqli_commit mysqli_connect mysqli_connect_errno mysqli_connect_error mysqli_data_seek mysqli_debug mysqli_disable_reads_from_master mysqli_disable_rpl_parse mysqli_dump_debug_info mysqli_enable_reads_from_master mysqli_enable_rpl_parse mysqli_errno mysqli_error mysqli_escape_string mysqli_execute mysqli_fetch mysqli_fetch_array mysqli_fetch_assoc mysqli_fetch_field mysqli_fetch_field_direct mysqli_fetch_fields mysqli_fetch_lengths mysqli_fetch_object mysqli_fetch_row mysqli_field_count mysqli_field_seek mysqli_field_tell mysqli_free_result mysqli_get_client_info mysqli_get_client_version mysqli_get_host_info mysqli_get_metadata mysqli_get_proto_info mysqli_get_server_info mysqli_get_server_version mysqli_info mysqli_init mysqli_insert_id mysqli_kill mysqli_master_query mysqli_more_results mysqli_multi_query mysqli_next_result mysqli_num_fields mysqli_num_rows mysqli_options mysqli_param_count mysqli_ping mysqli_prepare mysqli_query mysqli_real_connect mysqli_real_escape_string mysqli_real_query mysqli_report mysqli_rollback mysqli_rpl_parse_enabled mysqli_rpl_probe mysqli_rpl_query_type mysqli_select_db mysqli_send_long_data mysqli_send_query mysqli_set_local_infile_default mysqli_set_local_infile_handler mysqli_set_opt mysqli_slave_query mysqli_sqlstate mysqli_ssl_set mysqli_stat mysqli_stmt_affected_rows mysqli_stmt_attr_get mysqli_stmt_attr_set mysqli_stmt_bind_param mysqli_stmt_bind_result mysqli_stmt_close mysqli_stmt_data_seek mysqli_stmt_errno mysqli_stmt_error mysqli_stmt_execute mysqli_stmt_fetch mysqli_stmt_field_count mysqli_stmt_free_result mysqli_stmt_init mysqli_stmt_insert_id mysqli_stmt_num_rows mysqli_stmt_param_count mysqli_stmt_prepare mysqli_stmt_reset mysqli_stmt_result_metadata mysqli_stmt_send_long_data mysqli_stmt_sqlstate mysqli_stmt_store_result mysqli_store_result mysqli_thread_id mysqli_thread_safe mysqli_use_result mysqli_warning_count natcasesort natsort ncurses_addch ncurses_addchnstr ncurses_addchstr ncurses_addnstr ncurses_addstr ncurses_assume_default_colors ncurses_attroff ncurses_attron ncurses_attrset ncurses_baudrate ncurses_beep ncurses_bkgd ncurses_bkgdset ncurses_border ncurses_bottom_panel ncurses_can_change_color ncurses_cbreak ncurses_clear ncurses_clrtobot ncurses_clrtoeol ncurses_color_content ncurses_color_set ncurses_curs_set ncurses_def_prog_mode ncurses_def_shell_mode ncurses_define_key ncurses_del_panel ncurses_delay_output ncurses_delch ncurses_deleteln ncurses_delwin ncurses_doupdate ncurses_echo ncurses_echochar ncurses_end ncurses_erase ncurses_erasechar ncurses_filter ncurses_flash ncurses_flushinp ncurses_getch ncurses_getmaxyx ncurses_getmouse ncurses_getyx ncurses_halfdelay ncurses_has_colors ncurses_has_ic ncurses_has_il ncurses_has_key ncurses_hide_panel ncurses_hline ncurses_inch ncurses_init ncurses_init_color ncurses_init_pair ncurses_insch ncurses_insdelln ncurses_insertln ncurses_insstr ncurses_instr ncurses_isendwin ncurses_keyok ncurses_keypad ncurses_killchar ncurses_longname ncurses_meta ncurses_mouse_trafo ncurses_mouseinterval ncurses_mousemask ncurses_move ncurses_move_panel ncurses_mvaddch ncurses_mvaddchnstr ncurses_mvaddchstr ncurses_mvaddnstr ncurses_mvaddstr ncurses_mvcur ncurses_mvdelch ncurses_mvgetch ncurses_mvhline ncurses_mvinch ncurses_mvvline ncurses_mvwaddstr ncurses_napms ncurses_new_panel ncurses_newpad ncurses_newwin ncurses_nl ncurses_nocbreak ncurses_noecho ncurses_nonl ncurses_noqiflush ncurses_noraw ncurses_pair_content ncurses_panel_above ncurses_panel_below ncurses_panel_window ncurses_pnoutrefresh ncurses_prefresh ncurses_putp ncurses_qiflush ncurses_raw ncurses_refresh ncurses_replace_panel ncurses_reset_prog_mode ncurses_reset_shell_mode ncurses_resetty ncurses_savetty ncurses_scr_dump ncurses_scr_init ncurses_scr_restore ncurses_scr_set ncurses_scrl ncurses_show_panel ncurses_slk_attr ncurses_slk_attroff ncurses_slk_attron ncurses_slk_attrset ncurses_slk_clear ncurses_slk_color ncurses_slk_init ncurses_slk_noutrefresh ncurses_slk_refresh ncurses_slk_restore ncurses_slk_set ncurses_slk_touch ncurses_standend ncurses_standout ncurses_start_color ncurses_termattrs ncurses_termname ncurses_timeout ncurses_top_panel ncurses_typeahead ncurses_ungetch ncurses_ungetmouse ncurses_update_panels ncurses_use_default_colors ncurses_use_env ncurses_use_extended_names ncurses_vidattr ncurses_vline ncurses_waddch ncurses_waddstr ncurses_wattroff ncurses_wattron ncurses_wattrset ncurses_wborder ncurses_wclear ncurses_wcolor_set ncurses_werase ncurses_wgetch ncurses_whline ncurses_wmouse_trafo ncurses_wmove ncurses_wnoutrefresh ncurses_wrefresh ncurses_wstandend ncurses_wstandout ncurses_wvline next ngettext nl2br nl_langinfo notes_body notes_copy_db notes_create_db notes_create_note notes_drop_db notes_find_note notes_header_info notes_list_msgs notes_mark_read notes_mark_unread notes_nav_create notes_search notes_unread notes_version number_format ob_clean ob_end_clean ob_end_flush ob_flush ob_get_clean ob_get_contents ob_get_flush ob_get_length ob_get_level ob_get_status ob_gzhandler ob_iconv_handler ob_implicit_flush ob_list_handlers ob_start ocibindbyname ocicancel ocicollappend ocicollassign ocicollassignelem ocicollgetelem ocicollmax ocicollsize ocicolltrim ocicolumnisnull ocicolumnname ocicolumnprecision ocicolumnscale ocicolumnsize ocicolumntype ocicolumntyperaw ocicommit ocidefinebyname ocierror ociexecute ocifetch ocifetchinto ocifetchstatement ocifreecollection ocifreecursor ocifreedesc ocifreestatement ociinternaldebug ociloadlob ocilogoff ocilogon ocinewcollection ocinewcursor ocinewdescriptor ocinlogon ocinumcols ociparse ociplogon ociresult ocirollback ocirowcount ocisavelob ocisavelobfile ociserverversion ocisetprefetch ocistatementtype ociwritelobtofile octdec odbc_autocommit odbc_binmode odbc_close odbc_close_all odbc_columnprivileges odbc_columns odbc_commit odbc_connect odbc_cursor odbc_data_source odbc_do odbc_error odbc_errormsg odbc_exec odbc_execute odbc_fetch_array odbc_fetch_into odbc_fetch_object odbc_fetch_row odbc_field_len odbc_field_name odbc_field_num odbc_field_precision odbc_field_scale odbc_field_type odbc_foreignkeys odbc_free_result odbc_gettypeinfo odbc_longreadlen odbc_next_result odbc_num_fields odbc_num_rows odbc_pconnect odbc_prepare odbc_primarykeys odbc_procedurecolumns odbc_procedures odbc_result odbc_result_all odbc_rollback odbc_setoption odbc_specialcolumns odbc_statistics odbc_tableprivileges odbc_tables opendir openlog openssl_csr_export openssl_csr_export_to_file openssl_csr_new openssl_csr_sign openssl_error_string openssl_free_key openssl_get_privatekey openssl_get_publickey openssl_open openssl_pkcs7_decrypt openssl_pkcs7_encrypt openssl_pkcs7_sign openssl_pkcs7_verify openssl_pkey_export openssl_pkey_export_to_file openssl_pkey_free openssl_pkey_get_private openssl_pkey_get_public openssl_pkey_new openssl_private_decrypt openssl_private_encrypt openssl_public_decrypt openssl_public_encrypt openssl_seal openssl_sign openssl_verify openssl_x509_check_private_key openssl_x509_checkpurpose openssl_x509_export openssl_x509_export_to_file openssl_x509_free openssl_x509_parse openssl_x509_read ora_bind ora_close ora_columnname ora_columnsize ora_columntype ora_commit ora_commitoff ora_commiton ora_do ora_error ora_errorcode ora_exec ora_fetch ora_fetch_into ora_getcolumn ora_logoff ora_logon ora_numcols ora_numrows ora_open ora_parse ora_plogon ora_rollback ord output_add_rewrite_var output_reset_rewrite_vars overload ovrimos_close ovrimos_commit ovrimos_connect ovrimos_cursor ovrimos_exec ovrimos_execute ovrimos_fetch_into ovrimos_fetch_row ovrimos_field_len ovrimos_field_name ovrimos_field_num ovrimos_field_type ovrimos_free_result ovrimos_longreadlen ovrimos_num_fields ovrimos_num_rows ovrimos_prepare ovrimos_result ovrimos_result_all ovrimos_rollback pack parse_ini_file parse_str parse_url passthru pathinfo pclose pcntl_alarm pcntl_exec pcntl_fork pcntl_getpriority pcntl_setpriority pcntl_signal pcntl_wait pcntl_waitpid pcntl_wexitstatus pcntl_wifexited pcntl_wifsignaled pcntl_wifstopped pcntl_wstopsig pcntl_wtermsig pdf_add_annotation pdf_add_bookmark pdf_add_launchlink pdf_add_locallink pdf_add_note pdf_add_outline pdf_add_pdflink pdf_add_thumbnail pdf_add_weblink pdf_arc pdf_arcn pdf_attach_file pdf_begin_page pdf_begin_pattern pdf_begin_template pdf_circle pdf_clip pdf_close pdf_close_image pdf_close_pdi pdf_close_pdi_page pdf_closepath pdf_closepath_fill_stroke pdf_closepath_stroke pdf_concat pdf_continue_text pdf_curveto pdf_delete pdf_end_page pdf_end_pattern pdf_end_template pdf_endpath pdf_fill pdf_fill_stroke pdf_findfont pdf_get_buffer pdf_get_font pdf_get_fontname pdf_get_fontsize pdf_get_image_height pdf_get_image_width pdf_get_majorversion pdf_get_minorversion pdf_get_parameter pdf_get_pdi_parameter pdf_get_pdi_value pdf_get_value pdf_initgraphics pdf_lineto pdf_makespotcolor pdf_moveto pdf_new pdf_open pdf_open_ccitt pdf_open_file pdf_open_gif pdf_open_image pdf_open_image_file pdf_open_jpeg pdf_open_memory_image pdf_open_pdi pdf_open_pdi_page pdf_open_png pdf_open_tiff pdf_place_image pdf_place_pdi_page pdf_rect pdf_restore pdf_rotate pdf_save pdf_scale pdf_set_border_color pdf_set_border_dash pdf_set_border_style pdf_set_char_spacing pdf_set_duration pdf_set_font pdf_set_horiz_scaling pdf_set_info pdf_set_info_author pdf_set_info_creator pdf_set_info_keywords pdf_set_info_subject pdf_set_info_title pdf_set_leading pdf_set_parameter pdf_set_text_pos pdf_set_text_rendering pdf_set_text_rise pdf_set_transition pdf_set_value pdf_set_word_spacing pdf_setcolor pdf_setdash pdf_setflat pdf_setfont pdf_setgray pdf_setgray_fill pdf_setgray_stroke pdf_setlinecap pdf_setlinejoin pdf_setlinewidth pdf_setmatrix pdf_setmiterlimit pdf_setpolydash pdf_setrgbcolor pdf_setrgbcolor_fill pdf_setrgbcolor_stroke pdf_show pdf_show_boxed pdf_show_xy pdf_skew pdf_stringwidth pdf_stroke pdf_translate pfpro_cleanup pfpro_init pfpro_process pfpro_process_raw pfpro_version pfsockopen pg_affected_rows pg_cancel_query pg_client_encoding pg_clientencoding pg_close pg_cmdtuples pg_connect pg_connection_busy pg_connection_reset pg_connection_status pg_convert pg_copy_from pg_copy_to pg_dbname pg_delete pg_end_copy pg_errormessage pg_escape_bytea pg_escape_string pg_exec pg_fetch_all pg_fetch_array pg_fetch_assoc pg_fetch_object pg_fetch_result pg_fetch_row pg_field_is_null pg_field_name pg_field_num pg_field_prtlen pg_field_size pg_field_type pg_fieldisnull pg_fieldname pg_fieldnum pg_fieldprtlen pg_fieldsize pg_fieldtype pg_free_result pg_freeresult pg_get_notify pg_get_pid pg_get_result pg_getlastoid pg_host pg_insert pg_last_error pg_last_notice pg_last_oid pg_lo_close pg_lo_create pg_lo_export pg_lo_import pg_lo_open pg_lo_read pg_lo_read_all pg_lo_seek pg_lo_tell pg_lo_unlink pg_lo_write pg_loclose pg_locreate pg_loexport pg_loimport pg_loopen pg_loread pg_loreadall pg_lounlink pg_lowrite pg_meta_data pg_num_fields pg_num_rows pg_numfields pg_numrows pg_options pg_parameter_status pg_pconnect pg_ping pg_port pg_put_line pg_query pg_result pg_result_error pg_result_seek pg_result_status pg_select pg_send_query pg_set_client_encoding pg_setclientencoding pg_trace pg_tty pg_unescape_bytea pg_untrace pg_update pg_version php_check_syntax php_egg_logo_guid php_ini_scanned_files php_logo_guid php_real_logo_guid php_sapi_name php_strip_whitespace php_uname phpcredits phpinfo phpversion pi png2wbmp popen pos posix_ctermid posix_errno posix_get_last_error posix_getcwd posix_getegid posix_geteuid posix_getgid posix_getgrgid posix_getgrnam posix_getgroups posix_getlogin posix_getpgid posix_getpgrp posix_getpid posix_getppid posix_getpwnam posix_getpwuid posix_getrlimit posix_getsid posix_getuid posix_isatty posix_kill posix_mkfifo posix_setegid posix_seteuid posix_setgid posix_setpgid posix_setsid posix_setuid posix_strerror posix_times posix_ttyname posix_uname pow preg_grep preg_match preg_match_all preg_quote preg_replace preg_replace_callback preg_split prev print print_r printer_abort printer_close printer_create_brush printer_create_dc printer_create_font printer_create_pen printer_delete_brush printer_delete_dc printer_delete_font printer_delete_pen printer_draw_bmp printer_draw_chord printer_draw_elipse printer_draw_line printer_draw_pie printer_draw_rectangle printer_draw_roundrect printer_draw_text printer_end_doc printer_end_page printer_get_option printer_list printer_logical_fontheight printer_open printer_select_brush printer_select_font printer_select_pen printer_set_option printer_start_doc printer_start_page printer_write printf proc_close proc_get_status proc_nice proc_open proc_terminate pspell_add_to_personal pspell_add_to_session pspell_check pspell_clear_session pspell_config_create pspell_config_ignore pspell_config_mode pspell_config_personal pspell_config_repl pspell_config_runtogether pspell_config_save_repl pspell_new pspell_new_config pspell_new_personal pspell_save_wordlist pspell_store_replacement pspell_suggest putenv qdom_error qdom_tree quoted_printable_decode quotemeta rad2deg rand range rawurldecode rawurlencode read_exif_data readdir readfile readgzfile readline readline_add_history readline_clear_history readline_completion_function readline_info readline_list_history readline_read_history readline_write_history readlink realpath recode recode_file recode_string register_shutdown_function register_tick_function rename require require_once reset restore_error_handler restore_exception_handler restore_include_path rewind rewinddir rmdir round rsort rtrim scandir sem_acquire sem_get sem_release sem_remove serialize sesam_affected_rows sesam_commit sesam_connect sesam_diagnostic sesam_disconnect sesam_errormsg sesam_execimm sesam_fetch_array sesam_fetch_result sesam_fetch_row sesam_field_array sesam_field_name sesam_free_result sesam_num_fields sesam_query sesam_rollback sesam_seek_row sesam_settransaction session_cache_expire session_cache_limiter session_commit session_decode session_destroy session_encode session_get_cookie_params session_id session_is_registered session_module_name session_name session_regenerate_id session_register session_save_path session_set_cookie_params session_set_save_handler session_start session_unregister session_unset session_write_close set_error_handler set_exception_handler set_file_buffer set_include_path set_magic_quotes_runtime set_socket_blocking set_time_limit setcookie setlocale setrawcookie settype sha1 sha1_file shell_exec shm_attach shm_detach shm_get_var shm_put_var shm_remove shm_remove_var shmop_close shmop_delete shmop_open shmop_read shmop_size shmop_write show_source shuffle similar_text simplexml_load_file simplexml_load_string sin sinh sizeof sleep snmp3_get snmp3_getnext snmp3_real_walk snmp3_set snmp3_walk snmp_get_quick_print snmp_get_valueretrieval snmp_read_mib snmp_set_enum_print snmp_set_oid_numeric_print snmp_set_quick_print snmp_set_valueretrieval snmpget snmpgetnext snmprealwalk snmpset snmpwalk snmpwalkoid socket_accept socket_bind socket_clear_error socket_close socket_connect socket_create socket_create_listen socket_create_pair socket_get_option socket_get_status socket_getopt socket_getpeername socket_getsockname socket_iovec_add socket_iovec_alloc socket_iovec_delete socket_iovec_fetch socket_iovec_free socket_iovec_set socket_last_error socket_listen socket_read socket_readv socket_recv socket_recvfrom socket_recvmsg socket_select socket_send socket_sendmsg socket_sendto socket_set_block socket_set_blocking socket_set_nonblock socket_set_option socket_set_timeout socket_setopt socket_shutdown socket_strerror socket_write socket_writev sort soundex spl_classes split spliti sprintf sql_regcase sqlite_array_query sqlite_busy_timeout sqlite_changes sqlite_close sqlite_column sqlite_create_aggregate sqlite_create_function sqlite_current sqlite_error_string sqlite_escape_string sqlite_exec sqlite_factory sqlite_fetch_all sqlite_fetch_array sqlite_fetch_column_types sqlite_fetch_object sqlite_fetch_single sqlite_fetch_string sqlite_field_name sqlite_has_more sqlite_has_prev sqlite_last_error sqlite_last_insert_rowid sqlite_libencoding sqlite_libversion sqlite_next sqlite_num_fields sqlite_num_rows sqlite_open sqlite_popen sqlite_prev sqlite_query sqlite_rewind sqlite_seek sqlite_single_query sqlite_udf_decode_binary sqlite_udf_encode_binary sqlite_unbuffered_query sqlite_valid sqrt srand sscanf stat str_ireplace str_pad str_repeat str_replace str_rot13 str_shuffle str_split str_word_count strcasecmp strchr strcmp strcoll strcspn stream_bucket_append stream_bucket_make_writeable stream_bucket_new stream_bucket_prepend stream_context_create stream_context_get_options stream_context_set_option stream_context_set_params stream_copy_to_stream stream_filter_append stream_filter_prepend stream_filter_register stream_get_contents stream_get_filters stream_get_line stream_get_meta_data stream_get_transports stream_get_wrappers stream_register_wrapper stream_select stream_set_blocking stream_set_timeout stream_set_write_buffer stream_socket_accept stream_socket_client stream_socket_get_name stream_socket_recvfrom stream_socket_sendto stream_socket_server stream_wrapper_register strftime strip_tags stripcslashes stripos stripslashes stristr strlen strnatcasecmp strnatcmp strncasecmp strncmp strpbrk strpos strrchr strrev strripos strrpos strspn strstr strtok strtolower strtotime strtoupper strtr strval substr substr_compare substr_count substr_replace swf_actiongeturl swf_actiongotoframe swf_actiongotolabel swf_actionnextframe swf_actionplay swf_actionprevframe swf_actionsettarget swf_actionstop swf_actiontogglequality swf_actionwaitforframe swf_addbuttonrecord swf_addcolor swf_closefile swf_definebitmap swf_definefont swf_defineline swf_definepoly swf_definerect swf_definetext swf_endbutton swf_enddoaction swf_endshape swf_endsymbol swf_fontsize swf_fontslant swf_fonttracking swf_getbitmapinfo swf_getfontinfo swf_getframe swf_labelframe swf_lookat swf_modifyobject swf_mulcolor swf_nextid swf_oncondition swf_openfile swf_ortho swf_ortho2 swf_perspective swf_placeobject swf_polarview swf_popmatrix swf_posround swf_pushmatrix swf_removeobject swf_rotate swf_scale swf_setfont swf_setframe swf_shapearc swf_shapecurveto swf_shapecurveto3 swf_shapefillbitmapclip swf_shapefillbitmaptile swf_shapefilloff swf_shapefillsolid swf_shapelinesolid swf_shapelineto swf_shapemoveto swf_showframe swf_startbutton swf_startdoaction swf_startshape swf_startsymbol swf_textwidth swf_translate swf_viewport swfaction swfbitmap swfbitmap.getheight swfbitmap.getwidth swfbutton swfbutton.addaction swfbutton.addshape swfbutton.setaction swfbutton.setdown swfbutton.sethit swfbutton.setover swfbutton.setup swfbutton_keypress swfdisplayitem swfdisplayitem.addcolor swfdisplayitem.move swfdisplayitem.moveto swfdisplayitem.multcolor swfdisplayitem.remove swfdisplayitem.rotate swfdisplayitem.rotateto swfdisplayitem.scale swfdisplayitem.scaleto swfdisplayitem.setdepth swfdisplayitem.setname swfdisplayitem.setratio swfdisplayitem.skewx swfdisplayitem.skewxto swfdisplayitem.skewy swfdisplayitem.skewyto swffill swffill.moveto swffill.rotateto swffill.scaleto swffill.skewxto swffill.skewyto swffont swffont.getwidth swfgradient swfgradient.addentry swfmorph swfmorph.getshape1 swfmorph.getshape2 swfmovie swfmovie.add swfmovie.nextframe swfmovie.output swfmovie.remove swfmovie.save swfmovie.setbackground swfmovie.setdimension swfmovie.setframes swfmovie.setrate swfmovie.streammp3 swfshape swfshape.addfill swfshape.drawcurve swfshape.drawcurveto swfshape.drawline swfshape.drawlineto swfshape.movepen swfshape.movepento swfshape.setleftfill swfshape.setline swfshape.setrightfill swfsprite swfsprite.add swfsprite.nextframe swfsprite.remove swfsprite.setframes swftext swftext.addstring swftext.getwidth swftext.moveto swftext.setcolor swftext.setfont swftext.setheight swftext.setspacing swftextfield swftextfield.addstring swftextfield.align swftextfield.setbounds swftextfield.setcolor swftextfield.setfont swftextfield.setheight swftextfield.setindentation swftextfield.setleftmargin swftextfield.setlinespacing swftextfield.setmargins swftextfield.setname swftextfield.setrightmargin sybase_affected_rows sybase_close sybase_connect sybase_data_seek sybase_fetch_array sybase_fetch_field sybase_fetch_object sybase_fetch_row sybase_field_seek sybase_free_result sybase_get_last_message sybase_min_client_severity sybase_min_error_severity sybase_min_message_severity sybase_min_server_severity sybase_num_fields sybase_num_rows sybase_pconnect sybase_query sybase_result sybase_select_db symlink syslog system tan tanh tempnam textdomain time time_nanosleep tmpfile token_get_all token_name touch trigger_error trim uasort ucfirst ucwords udm_add_search_limit udm_alloc_agent udm_api_version udm_cat_list udm_cat_path udm_check_charset udm_check_stored udm_clear_search_limits udm_close_stored udm_crc32 udm_errno udm_error udm_find udm_free_agent udm_free_ispell_data udm_free_res udm_get_doc_count udm_get_res_field udm_get_res_param udm_load_ispell_data udm_open_stored udm_set_agent_param uksort umask uniqid unixtojd unlink unpack unregister_tick_function unserialize unset urldecode urlencode use_soap_error_handler user_error usleep usort utf8_decode utf8_encode var_dump var_export variant version_compare vfprintf virtual vpopmail_add_alias_domain vpopmail_add_alias_domain_ex vpopmail_add_domain vpopmail_add_domain_ex vpopmail_add_user vpopmail_alias_add vpopmail_alias_del vpopmail_alias_del_domain vpopmail_alias_get vpopmail_alias_get_all vpopmail_auth_user vpopmail_del_domain vpopmail_del_domain_ex vpopmail_del_user vpopmail_error vpopmail_passwd vpopmail_set_user_quota vprintf vsprintf w32api_deftype w32api_init_dtype w32api_invoke_function w32api_register_function w32api_set_call_method wddx_add_vars wddx_deserialize wddx_packet_end wddx_packet_start wddx_serialize_value wddx_serialize_vars wordwrap xml_error_string xml_get_current_byte_index xml_get_current_column_number xml_get_current_line_number xml_get_error_code xml_parse xml_parse_into_struct xml_parser_create xml_parser_create_ns xml_parser_free xml_parser_get_option xml_parser_set_option xml_set_character_data_handler xml_set_default_handler xml_set_element_handler xml_set_end_namespace_decl_handler xml_set_external_entity_ref_handler xml_set_notation_decl_handler xml_set_object xml_set_processing_instruction_handler xml_set_start_namespace_decl_handler xml_set_unparsed_entity_decl_handler xmldoc xmldocfile xmlrpc_decode xmlrpc_decode_request xmlrpc_encode xmlrpc_encode_request xmlrpc_get_type xmlrpc_is_fault xmlrpc_parse_method_descriptions xmlrpc_server_add_introspection_data xmlrpc_server_call_method xmlrpc_server_create xmlrpc_server_destroy xmlrpc_server_register_introspection_callback xmlrpc_server_register_method xmlrpc_set_type xmltree xpath_eval xpath_eval_expression xpath_new_context xptr_eval xptr_new_context xslt_create xslt_errno xslt_error xslt_free xslt_process xslt_set_base xslt_set_encoding xslt_set_error_handler xslt_set_log xslt_set_sax_handler xslt_set_sax_handlers xslt_set_scheme_handler xslt_set_scheme_handlers yaz_addinfo yaz_ccl_conf yaz_ccl_parse yaz_close yaz_connect yaz_database yaz_element yaz_errno yaz_error yaz_hits yaz_itemorder yaz_present yaz_range yaz_record yaz_scan yaz_scan_result yaz_search yaz_sort yaz_syntax yaz_wait yp_all yp_cat yp_err_string yp_errno yp_first yp_get_default_domain yp_master yp_match yp_next yp_order zend_logo_guid zend_version zip_close zip_entry_close zip_entry_compressedsize zip_entry_compressionmethod zip_entry_filesize zip_entry_name zip_entry_open zip_entry_read zip_open zip_read zlib_get_coding_type"

regex_'3c'5c'3f'28'3f'3a'3d'7cphp'29'3f = compileRegex "<\\?(?:=|php)?"
regex_'3c'3c'3c'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29 = compileRegex "<<<([A-Za-z_][A-Za-z0-9_]*)"
regex_'5c'24'2b'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a = compileRegex "\\$+[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*"
regex_'5b0123456789'5d'2a'5c'2e'5c'2e'5c'2e'5b0123456789'5d'2a = compileRegex "[0123456789]*\\.\\.\\.[0123456789]*"
regex_'5c'5c'5b0'2d7'5d'7b1'2c3'7d = compileRegex "\\\\[0-7]{1,3}"
regex_'5c'5cx'5b0'2d9A'2dFa'2df'5d'7b1'2c2'7d = compileRegex "\\\\x[0-9A-Fa-f]{1,2}"
regex_'5c'24'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5c'5d'29'2a = compileRegex "\\$[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[[a-zA-Z0-9_]*\\])*"
regex_'5c'24'5c'7b'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5c'5d'29'2a'5c'7d = compileRegex "\\$\\{[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[[a-zA-Z0-9_]*\\])*\\}"
regex_'5c'7b'5c'24'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'28'5b0'2d9'5d'2a'7c'22'5b'5e'22'5d'2a'22'29'7c'27'5b'5e'27'5d'2a'27'7c'5c'5d'29'2a'28'2d'3e'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5c'5d'29'2a'28'5c'5b'28'5b0'2d9'5d'2a'7c'22'5ba'2dzA'2dZ'5f'5d'2a'22'29'7c'27'5ba'2dzA'2dZ'5f'5d'2a'27'7c'5c'5d'29'2a'29'2a'5c'7d = compileRegex "\\{\\$[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[([0-9]*|\"[^\"]*\")|'[^']*'|\\])*(->[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[[a-zA-Z0-9_]*\\])*(\\[([0-9]*|\"[a-zA-Z_]*\")|'[a-zA-Z_]*'|\\])*)*\\}"
regex_'5c'7b'5c'24'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'28'5b0'2d9'5d'2a'7c'22'5ba'2dzA'2dZ'5f'5d'2a'22'29'7c'27'5ba'2dzA'2dZ'5f'5d'2a'27'7c'5c'5d'29'2a'28'2d'3e'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5c'5d'29'2a'28'5c'5b'28'5b0'2d9'5d'2a'7c'22'5ba'2dzA'2dZ'5f'5d'2a'22'29'7c'27'5ba'2dzA'2dZ'5f'5d'2a'27'7c'5c'5d'29'2a'29'2a'5c'7d = compileRegex "\\{\\$[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[([0-9]*|\"[a-zA-Z_]*\")|'[a-zA-Z_]*'|\\])*(->[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*(\\[[a-zA-Z0-9_]*\\])*(\\[([0-9]*|\"[a-zA-Z_]*\")|'[a-zA-Z_]*'|\\])*)*\\}"

defaultAttributes = [("start","Normal Text"),("braceregion","Normal Text"),("phpsource","PHP Text"),("onelinecomment","Comment"),("twolinecomment","Comment"),("doublebackquotestringcommon","String"),("backquotestring","String"),("doblequotestring","String"),("singlequotestring","String"),("heredoc","String")]

parseRules "start" = 
  do (attr, result) <- (((pRegExpr regex_'3c'5c'3f'28'3f'3a'3d'7cphp'29'3f >>= withAttribute "Keyword") >>~ pushContext "phpsource")
                        <|>
                        ((pString False "?>" >>= withAttribute "Keyword") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "braceregion" = 
  do (attr, result) <- (((parseRules "phpsource"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Normal Text") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "phpsource" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "PHP Text"))
                        <|>
                        ((lookAhead (pString False "?>") >> return ([],"") ) >>~ (popContext >> return ()))
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "onelinecomment")
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression >>= ((withAttribute "") . snd)))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "onelinecomment")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "twolinecomment")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_control_structures >>= withAttribute "Control Structures"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_functions >>= withAttribute "Function"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_special'5fmethods >>= withAttribute "Special method"))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "PHP Text"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "doblequotestring")
                        <|>
                        ((pDetectChar False '`' >>= withAttribute "String") >>~ pushContext "backquotestring")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ pushContext "singlequotestring")
                        <|>
                        ((pRegExpr regex_'3c'3c'3c'28'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'29 >>= withAttribute "Backslash Code") >>~ pushContext "heredoc")
                        <|>
                        ((pRegExpr regex_'5c'24'2b'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a >>= withAttribute "Variable"))
                        <|>
                        ((pRegExpr regex_'5b0123456789'5d'2a'5c'2e'5c'2e'5c'2e'5b0123456789'5d'2a >>= withAttribute "String"))
                        <|>
                        ((pHlCOct >>= withAttribute "Octal"))
                        <|>
                        ((pHlCHex >>= withAttribute "Hex"))
                        <|>
                        ((pFloat >>= withAttribute "Float"))
                        <|>
                        ((pInt >>= withAttribute "Decimal"))
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Normal Text") >>~ pushContext "braceregion")
                        <|>
                        ((pAnyChar ";():,[]" >>= withAttribute "Other")))
     return (attr, result)

parseRules "onelinecomment" = 
  do (attr, result) <- ((lookAhead (pString False "?>") >> return ([],"") ) >>~ (popContext >> return ()))
     return (attr, result)

parseRules "twolinecomment" = 
  do (attr, result) <- ((pDetect2Chars False '*' '/' >>= withAttribute "Comment") >>~ (popContext >> return ()))
     return (attr, result)

parseRules "doublebackquotestringcommon" = 
  do (attr, result) <- (((pDetect2Chars False '\\' '\\' >>= withAttribute "Backslash Code"))
                        <|>
                        ((pDetect2Chars False '\\' 'n' >>= withAttribute "Backslash Code"))
                        <|>
                        ((pDetect2Chars False '\\' 'r' >>= withAttribute "Backslash Code"))
                        <|>
                        ((pDetect2Chars False '\\' 't' >>= withAttribute "Backslash Code"))
                        <|>
                        ((pDetect2Chars False '\\' '$' >>= withAttribute "Backslash Code"))
                        <|>
                        ((pRegExpr regex_'5c'5c'5b0'2d7'5d'7b1'2c3'7d >>= withAttribute "Backslash Code"))
                        <|>
                        ((pRegExpr regex_'5c'5cx'5b0'2d9A'2dFa'2df'5d'7b1'2c2'7d >>= withAttribute "Backslash Code"))
                        <|>
                        ((pRegExpr regex_'5c'24'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5c'5d'29'2a >>= withAttribute "Variable"))
                        <|>
                        ((pRegExpr regex_'5c'24'5c'7b'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5c'5d'29'2a'5c'7d >>= withAttribute "Variable"))
                        <|>
                        ((pRegExpr regex_'5c'7b'5c'24'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'28'5b0'2d9'5d'2a'7c'22'5b'5e'22'5d'2a'22'29'7c'27'5b'5e'27'5d'2a'27'7c'5c'5d'29'2a'28'2d'3e'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5c'5d'29'2a'28'5c'5b'28'5b0'2d9'5d'2a'7c'22'5ba'2dzA'2dZ'5f'5d'2a'22'29'7c'27'5ba'2dzA'2dZ'5f'5d'2a'27'7c'5c'5d'29'2a'29'2a'5c'7d >>= withAttribute "Variable")))
     return (attr, result)

parseRules "backquotestring" = 
  do (attr, result) <- (((parseRules "doublebackquotestringcommon"))
                        <|>
                        ((pDetect2Chars False '\\' '`' >>= withAttribute "Backslash Code"))
                        <|>
                        ((pDetectChar False '`' >>= withAttribute "String") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "doblequotestring" = 
  do (attr, result) <- (((parseRules "doublebackquotestringcommon"))
                        <|>
                        ((pDetect2Chars False '\\' '"' >>= withAttribute "Backslash Code"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "singlequotestring" = 
  do (attr, result) <- (((pDetect2Chars False '\\' '\'' >>= withAttribute "Backslash Code"))
                        <|>
                        ((pDetect2Chars False '\\' '\\' >>= withAttribute "Backslash Code"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "heredoc" = 
  do (attr, result) <- (((pColumn 0 >> pRegExprDynamic "%1;?$" >>= withAttribute "Backslash Code") >>~ (popContext >> return ()))
                        <|>
                        ((pRegExpr regex_'5c'24'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5c'5d'29'2a >>= withAttribute "Variable"))
                        <|>
                        ((pRegExpr regex_'5c'24'5c'7b'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5c'5d'29'2a'5c'7d >>= withAttribute "Variable"))
                        <|>
                        ((pRegExpr regex_'5c'7b'5c'24'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'28'5b0'2d9'5d'2a'7c'22'5ba'2dzA'2dZ'5f'5d'2a'22'29'7c'27'5ba'2dzA'2dZ'5f'5d'2a'27'7c'5c'5d'29'2a'28'2d'3e'5ba'2dzA'2dZ'5f'5cx7f'2d'5cxff'5d'5ba'2dzA'2dZ0'2d9'5f'5cx7f'2d'5cxff'5d'2a'28'5c'5b'5ba'2dzA'2dZ0'2d9'5f'5d'2a'5c'5d'29'2a'28'5c'5b'28'5b0'2d9'5d'2a'7c'22'5ba'2dzA'2dZ'5f'5d'2a'22'29'7c'27'5ba'2dzA'2dZ'5f'5d'2a'27'7c'5c'5d'29'2a'29'2a'5c'7d >>= withAttribute "Variable")))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
