{- Copyright (c) 2007 John Goerzen <jgoerzen@complete.org>
   Please see the COPYRIGHT file -}

import System.Console.GetOpt
import System.Console.GetOpt.Utils
import Utils
import HSH
import Control.Monad
import Types

args = [Option ['v'] ["verbose"] (NoArg "v") "Enable verbose mode"]
helpinfo = "Usage:\n\
\hg-markdeb [-v]\n\
\\n\
\Will add a tag based on the version of the package in the repository.\n"

crashusage = die 5 $ usageInfo helpinfo args

main = 
  do (args, files) <- parseCmdLine RequireOrder args helpinfo
     let isverbose = ("v" `elem` args)
     when isverbose setverbose
     let verbargs = if isverbose then ["-v"] else []
     unless (files == []) crashusage

     package <- getwdpackage
     version <- getwdversion
     let tag = Tag "DEBIAN" package version
     
     assertvalidhg "."
     ht <- hastag tag
     if ht
        then die 1 $ "Tag " ++ show tag ++ " already exists in Debian \
                      \repo; not tagging again."
        else runIO $ ("hg", ["tag", show tag])
