/*
   Generic format conversion routines for the HERMES library
   Copyright (c) 1998 Christian Nentwich (c.nentwich@cs.ucl.ac.uk)
   This source code is licensed under the GNU LGPL
  
   Please refer to the file COPYING.LIB contained in the distribution for
   licensing conditions
*/

#include "HermConf.h"
#include "HeadC.h"
#include "Debug.h"

void ConvertC_Generic32_A_Generic32_O_Blit(HermesConverterInterface *iface)
{	unsigned long s_pixel, d_pixel, r, g, b, a;
	long sr, sg, sb, dr, dg, db, da;
	char8 *source = iface->s_pixels, *dest = iface->d_pixels;
	unsigned int count;
	float sa;
	DEBUG_PRINT("Func\n","");
	do {
		count = iface->s_width;		
		do {
			// Read source pixel
			s_pixel = READ32(source);
			sr = ((s_pixel >> iface->info.r_right) << iface->info.r_left) & iface->mask_r;
			sg = ((s_pixel >> iface->info.g_right) << iface->info.g_left) & iface->mask_g;
			sb = ((s_pixel >> iface->info.b_right) << iface->info.b_left) & iface->mask_b;
			
			// Compute alpha
			sa = (s_pixel & iface->s_mask_a)/(float)iface->s_mask_a;
			
			// Get destination values
			d_pixel = READ32(dest);
			dr = d_pixel & iface->mask_r;
			dg = d_pixel & iface->mask_g;
			db = d_pixel & iface->mask_b;
			
			
			/* We must downshift because we can't have a negative
			   for red, since the sign bit could already be set!
			   Question: Do I also need to downshift
			   sr?
			   I don't think this is portable, either, especially to big-edian.
			   Someone should really write some assembler to do this...
			   I wish I knew more myself, otherwise I would do it.
			*/ 
			dr >>= 24;
			sr >>= 24;
			dr &= (iface->mask_r >> 24);                        
			r = (int32)(dr + (sr - dr) * sa);
			r <<= 24;
			
			/* Or we could do this... */
			/*Which, unfortunately, does not work
			  if(sr < dr)
			  r = (int32)(dr - (dr-sr)*sa);
			  else
			  r = (int32)(dr + (sr-dr)*sa);
			*/
			// Blend pixels
			g = (int32)(dg + (sg - dg) * sa);
			
			// Blend pixels
			b = (int32)(db + (sb - db) * sa);
			
			// Constrain values
			// Would rounding be better here?
			r &= iface->mask_r;
			g &= iface->mask_g;
			b &= iface->mask_b;
			
			// Hack up alpha, since there is no alpha mask. I suppose this
			// would break anything that put data (perhaps a Zbuffer?) in
			// the alpha slot of a 32-bit RGB pixel. How would I fix this?
			a = ~(iface->mask_r|
			      iface->mask_g|
			      iface->mask_b); // Hack, hope it works.
			
			WRITE32(dest, (r|g|b|a)); // Write destination
			
			source+=4;
			dest+=4;
		} while(--count);
		
		source+=iface->s_add;
		dest+=iface->d_add;
	} while (--iface->s_height);
}


void ConvertC_Generic32_A_Generic24_O_Blit(HermesConverterInterface *iface)
{ unsigned long s_pixel, d_pixel, r, g, b, a;
  long sr, sg, sb, dr, dg, db, da;
  float sa;
  char8 *d_ptr=(char8 *)((int)&s_pixel);
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;    
  DEBUG_PRINT("ConvertC_Generic32_A_Generic24_O_Blit called\n","");
  do {
    count=iface->s_width;
    do
    {         
      /* What the hell? */
      /*
	r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
	iface->mask_r;
	g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
	iface->mask_g;
	b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
	iface->mask_b;
      */
      // Read source pixel            
      s_pixel=READ32(source);
      sr = ((s_pixel >> iface->info.r_right) << iface->info.r_left) & iface->mask_r;
      sg = ((s_pixel >> iface->info.g_right) << iface->info.g_left) & iface->mask_g;
      sb = ((s_pixel >> iface->info.b_right) << iface->info.b_left) & iface->mask_b;
      sa = (s_pixel & iface->s_mask_a)/(float)iface->s_mask_a;
      
      //d_pixel = READ32(dest);
      dr = *(dest+R_24);
      dg = *(dest+G_24);
      db = *(dest+B_24);
      
      DEBUG_PRINT("dr: %X ", dr);
      DEBUG_PRINT("dg: %X ", dg);
      DEBUG_PRINT("db: %X ", db);
      DEBUG_PRINT("sr: %X ", sr);
      DEBUG_PRINT("sg: %X ", sg);
      DEBUG_PRINT("sb: %X ", sb);
      DEBUG_PRINT("sa: %f\n", sa);
      
      r = (int32)(dr + (sr - dr) * sa);
      g = (int32)(dg + (sg - dg) * sa);
      b = (int32)(db + (sb - db) * sa);
      
      *(dest+R_24)=r;
      
      *(dest+G_24)=g;
      
      *(dest+B_24)=b;
      
      source+=4;
      dest+=3;
    } while (--count);
    
    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic32_A_Generic16_O_Blit(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b,a;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;

  do {
    count=iface->s_width>>1;

    if (count)
    do
    { 
      r=((READ32(source)>>iface->info.r_right)<<iface->info.r_left)&
        iface->mask_r;
      g=((READ32(source)>>iface->info.g_right)<<iface->info.g_left)&
        iface->mask_g;
      b=((READ32(source)>>iface->info.b_right)<<iface->info.b_left)&
        iface->mask_b;
      a=((READ32(source)>>iface->info.a_right)<<iface->info.a_left)&
        iface->mask_a;

      s_pixel=DWORD_BYTE0(r|g|b|a);
      
      r=((READ32(source+1)>>iface->info.r_right)<<iface->info.r_left)&
        iface->mask_r;           
      g=((READ32(source+1)>>iface->info.g_right)<<iface->info.g_left)&
        iface->mask_g;           
      b=((READ32(source+1)>>iface->info.b_right)<<iface->info.b_left)&
        iface->mask_b; 
      a=((READ32(source+1)>>iface->info.a_right)<<iface->info.a_left)&
        iface->mask_a; 
    
      s_pixel|=DWORD_BYTE2(r|g|b|a);
      
      WRITE32(dest,s_pixel);
      
      source+=8;
      dest+=4;
    } while (--count);


    /* Trailing pixel */
    
    if (iface->s_width&1) {
      r=((READ32(source)>>iface->info.r_right)<<iface->info.r_left)&
        iface->mask_r;
      g=((READ32(source)>>iface->info.g_right)<<iface->info.g_left)&
        iface->mask_g;
      b=((READ32(source)>>iface->info.b_right)<<iface->info.b_left)&
        iface->mask_b;
      a=((READ32(source)>>iface->info.a_right)<<iface->info.a_left)&
        iface->mask_a;

      WRITE16(dest,(short16)(r|g|b|a));
      dest+=2;
      source+=4;
    }

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic32_A_Generic8_O_Blit(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b,a;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;

  do {
    count=iface->s_width;

    do
    { s_pixel=READ32(source);

      r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
        iface->mask_r;
      g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
        iface->mask_g;
      b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
        iface->mask_b;
      a=((s_pixel>>iface->info.a_right)<<iface->info.a_left)&
        iface->mask_a;
    
      *(dest)=(char8)(r|g|b|a);
    
      source+=4;
      dest++;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}





void ConvertC_Generic24_A_Generic32_O_Blit(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b,a;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;

  do {
    count=iface->s_width;

    do
    { 
      s_pixel=(((int32)*(source+R_24))<<16)|
              (((int32)*(source+G_24))<<8)|
              ((int32)*(source+B_24));
    
      r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
        iface->mask_r;
      g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
        iface->mask_g;
      b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
        iface->mask_b;
    
      WRITE32(dest,(r|g|b));
    
      source+=3;
      dest+=4;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic24_A_Generic24_O_Blit(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b,a;
  char8 *d_ptr=(char8 *)&s_pixel;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;

  do {
    count=iface->s_width;

    do
    { 
      s_pixel=(((int32)*(source+R_24))<<16)|
              (((int32)*(source+G_24))<<8)|
               ((int32)*(source+B_24));
    
      r=((s_pixel<<iface->info.r_left)>>iface->info.r_right)&
        iface->mask_r;
      g=((s_pixel<<iface->info.g_left)>>iface->info.g_right)&
        iface->mask_g;
      b=((s_pixel<<iface->info.b_left)>>iface->info.b_right)&
        iface->mask_b;

      s_pixel=(r|g|b);
    
      *(dest+R_24)=*(d_ptr+R_32);
      *(dest+G_24)=*(d_ptr+G_32);
      *(dest+B_24)=*(d_ptr+B_32);
    
      source+=3;
      dest+=3;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (iface->s_height--);
}



void ConvertC_Generic24_A_Generic16_O_Blit(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b,a;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;

  do {
    count=iface->s_width;

    do
    { 
      s_pixel=(((int32)*(source+R_24))<<16)|
              (((int32)*(source+G_24))<<8)|
               ((int32)*(source+B_24));
    
      r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
        iface->mask_r;
      g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
        iface->mask_g;
      b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
        iface->mask_b;
    
      WRITE16(dest,(short16)(r|g|b));
    
      source+=3;
      dest+=2;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic24_A_Generic8_O_Blit(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b,a;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;

  do {
    count=iface->s_width;

    do
    { s_pixel=(((int32)*(source+R_24))<<16)|
              (((int32)*(source+G_24))<<8)|
               ((int32)*(source+B_24));

      r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
        iface->mask_r;
      g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
        iface->mask_g;
      b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
        iface->mask_b;
    
      *(dest)=(char8)(r|g|b);
    
      source+=3;
      dest++;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}




void ConvertC_Generic16_A_Generic32_O_Blit(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b,a;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;

  do {
    count=iface->s_width;

    do
    { s_pixel=(int32)READ16(source);

      r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
        iface->mask_r;
      g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
        iface->mask_g;
      b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
        iface->mask_b;
      a=((s_pixel>>iface->info.a_right)<<iface->info.a_left)&
        iface->mask_a;
    
      WRITE32(dest,(r|g|b|a));
    
      source+=2;
      dest+=4;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic16_A_Generic24_O_Blit(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b,a;
  char8 *d_ptr=(char8 *)((int)&s_pixel);
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;

  do {
    count=iface->s_width;

    do
    { s_pixel=(int32)READ16(source);

      r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
        iface->mask_r;
      g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
        iface->mask_g;
      b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
        iface->mask_b;
    
      s_pixel=(r|g|b);

      *(dest+R_24)=*(d_ptr+R_32);
      *(dest+G_24)=*(d_ptr+G_32);
      *(dest+B_24)=*(d_ptr+B_32);

      source+=2;
      dest+=3;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic16_A_Generic16_O_Blit(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b,a;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;

  do {
    count=iface->s_width;

    do
    { s_pixel=(int32)READ16(source);

      r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
        iface->mask_r;
      g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
        iface->mask_g;
      b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
        iface->mask_b;
      a=((s_pixel>>iface->info.a_right)<<iface->info.a_left)&
        iface->mask_a;
    
      WRITE16(dest,(short16)(r|g|b|a));
    
      source+=2;
      dest+=2;
    } while(--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


void ConvertC_Generic16_A_Generic8_O_Blit(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b,a;
  unsigned int count;
  char8 *source=iface->s_pixels,*dest=iface->d_pixels;

  do {
    count=iface->s_width;

    do
    { s_pixel=(int32)READ16(source);

      r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
        iface->mask_r;
      g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
        iface->mask_g;
      b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
        iface->mask_b;
      a=((s_pixel>>iface->info.a_right)<<iface->info.a_left)&
        iface->mask_a;
    
      *dest=(char8)(r|g|b|a);
    
      source+=2;
      dest++;
    } while (--count);

    source+=iface->s_add;
    dest+=iface->d_add;
  } while (--iface->s_height);
}


/* -------------------------------------------------------------------------

                              STRETCH CONVERTERS
   
   ------------------------------------------------------------------------- */


void ConvertC_Generic32_A_Generic32_O_S_Blit(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b,a;
  unsigned int count;
  char8 *source,*dest=iface->d_pixels;
  unsigned int dy=(iface->s_height<<16)/iface->d_height;
  unsigned int dx=(iface->s_width<<16)/iface->d_width;
  unsigned int y=0,x;

  do {
    count=iface->d_width;
    x=0;
    source=iface->s_pixels;

    do
    { s_pixel=READ32(source+(x>>16));

      r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
        iface->mask_r;
      g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
        iface->mask_g;
      b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
        iface->mask_b;
      a=((s_pixel>>iface->info.a_right)<<iface->info.a_left)&
        iface->mask_a;
    
      WRITE32(dest,(r|g|b|a));
    
      x+=dx;
      dest+=4;
    } while(--count);
    
    dest+=iface->d_add;
    
    y+=dy;
    source+=(y>>16)*iface->s_pitch;
    y &= (1<<16)-1;

  } while (--iface->d_height);
}


void ConvertC_Generic32_A_Generic16_O_S_Blit(HermesConverterInterface *iface)
{ int32 s_pixel,r,g,b,a;
  unsigned int count;
  int32 *source=(int32*)iface->s_pixels;
  char8 *dest=iface->d_pixels;
  unsigned int dy=(iface->s_height<<16)/iface->d_height;
  unsigned int dx=(iface->s_width<<16)/iface->d_width;
  unsigned int y=0,x;

  DEBUG_FNAME("ConvertC_Generic32_A_Generic16_A_S")

  do {

    count=iface->d_width;
    x=0;

    do
    { s_pixel=*(source+(x>>16));

      r=((s_pixel>>iface->info.r_right)<<iface->info.r_left)&
        iface->mask_r;
      g=((s_pixel>>iface->info.g_right)<<iface->info.g_left)&
        iface->mask_g;
      b=((s_pixel>>iface->info.b_right)<<iface->info.b_left)&
        iface->mask_b;
      a=((s_pixel>>iface->info.a_right)<<iface->info.a_left)&
        iface->mask_a;
    
      WRITE16(dest,(short16)(r|g|b|a));
    
      x+=dx;
      dest+=2;
    } while (--count);
    
    dest+=iface->d_add;

    y+=dy;
      
    source=(int32*)((char8*)source+(y>>16)*iface->s_pitch);
    y &= 0xffff;
  } while (--iface->d_height);
}













