module Hat.Data.PackedStringBuiltin
  (PackedString, aPackedString, toPackedString, fromPackedString)
  where

import qualified Data.PackedString
import qualified Prelude
import Hat.Hat as T
import Hat.Prelude

newtype PackedString = PS Data.PackedString.PackedString

aPackedString :: RefAtom
aPackedString = mkAbstract "PackedString"

toPackedString :: RefExp -> R PackedString -> Data.PackedString.PackedString
toPackedString _ (R (PS e) _) = e

fromPackedString :: RefExp -> Data.PackedString.PackedString -> R PackedString
fromPackedString p e = R (PS e) (T.mkValueUse p mkNoSrcPos (showPS e))
    where showPS e = mkAbstract (Prelude.show e)

