-- Verify.hs: OpenPGP (RFC4880) signature verification
-- Copyright © 2012  Clint Adams
-- This software is released under the terms of the ISC license.
-- (See the LICENSE file).

module Data.Conduit.OpenPGP.Verify (
   conduitVerify
) where

import Data.Conduit
import Data.Time.Clock (UTCTime)

import Codec.Encryption.OpenPGP.Internal (PktStreamContext(..), emptyPSC)
import Codec.Encryption.OpenPGP.Types
import Codec.Encryption.OpenPGP.Verify (verifySig)

conduitVerify :: MonadResource m => Keyring -> Maybe UTCTime -> Conduit Pkt m (Either String Verification)
conduitVerify kr mt = conduitState emptyPSC push close
    where
        push state ld@(LiteralDataPkt {}) = return $ StateProducing (state { lastLD = ld }) []
        push state uid@(UserIdPkt _) = return $ StateProducing (state { lastUIDorUAt = uid }) []
        push state uat@(UserAttributePkt _) = return $ StateProducing (state { lastUIDorUAt = uat }) []
        push state pk@(PublicKeyPkt _) = return $ StateProducing (state { lastPrimaryKey = pk }) []
        push state pk@(PublicSubkeyPkt _) = return $ StateProducing (state { lastSubkey = pk }) []
        push state sk@(SecretKeyPkt _ _) = return $ StateProducing (state { lastPrimaryKey = sk }) []
        push state sk@(SecretSubkeyPkt _ _) = return $ StateProducing (state { lastSubkey = sk }) []
        push state sig@(SignaturePkt (SigV4 {})) = return $ StateProducing state { lastSig = sig } [verifySig kr sig state mt]
        push state (OnePassSignaturePkt _ _ _ _ _ False) = return $ StateProducing state []
        push state _ = return $ StateProducing state []
        close _ = return []
        normLineEndings = id  -- FIXME
