-- Compression.hs: OpenPGP (RFC4880) compression conduits
-- Copyright © 2012  Clint Adams
-- This software is released under the terms of the ISC license.
-- (See the LICENSE file).

module Data.Conduit.OpenPGP.Compression (
   conduitCompress
 , conduitDecompress
) where

import Codec.Encryption.OpenPGP.Compression
import Codec.Encryption.OpenPGP.Types
import Data.Conduit
import qualified Data.Conduit.List as CL

conduitCompress :: MonadThrow m => CompressionAlgorithm -> Conduit Pkt m Pkt
conduitCompress algo = conduitState [] push (close algo)
    where
        push state input = return $ StateProducing (input : state) []
        close a state = return [compressPkts a state]

conduitDecompress :: MonadThrow m => Conduit Pkt m Pkt
conduitDecompress = CL.concatMap decompressPkt
