{-# LANGUAGE CPP #-}
{-| 

Print a histogram report.

-}

module Hledger.Cli.Histogram
where
import Hledger.Data
import Hledger.Cli.Options
import Prelude hiding (putStr)
import Hledger.Data.UTF8 (putStr)


barchar = '*'

-- | Print a histogram of some statistic per reporting interval, such as
-- number of postings per day.
histogram :: [Opt] -> [String] -> Journal -> IO ()
histogram opts args j = do
  t <- getCurrentLocalTime
  putStr $ showHistogram opts (optsToFilterSpec opts args t) j

showHistogram :: [Opt] -> FilterSpec -> Journal -> String
showHistogram opts filterspec j = concatMap (printDayWith countBar) spanps
    where
      i = intervalFromOpts opts
      interval | i == NoInterval = Days 1
               | otherwise = i
      span = datespan filterspec `orDatesFrom` journalDateSpan j
      spans = filter (DateSpan Nothing Nothing /=) $ splitSpan interval span
      spanps = [(s, filter (isPostingInDateSpan s) ps) | s <- spans]
      -- same as Register
      -- should count transactions, not postings ?
      ps = sortBy (comparing postingDate) $ filterempties $ filter matchapats $ filterdepth $ journalPostings j
      filterempties
          | Empty `elem` opts = id
          | otherwise = filter (not . isZeroMixedAmount . pamount)
      matchapats = matchpats apats . paccount
      apats = acctpats filterspec
      filterdepth | interval == NoInterval = filter (\p -> accountNameLevel (paccount p) <= depth)
                  | otherwise = id
      depth = fromMaybe 99999 $ depthFromOpts opts

printDayWith f (DateSpan b _, ts) = printf "%s %s\n" (show $ fromJust b) (f ts)

countBar ps = replicate (length ps) barchar
