/* 
 * File: gmladdfiles.c
 *
 * Medialib search and playlist editor
 * Copyright (c) 2005-2006 Johannes Heimansberg
 *
 * requires GTK+ 2.6 or better and XMMS2
 *
 * Released under the GNU General Public License v2
 */

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtk/gtksignal.h>
#include <gtk/gtkdialog.h>
#include "gmedialib.h"
#include "gtrackinfo/trackinfo.h"
#include "gtrackinfo/gtrackinfo.h"
#include "sdecode/sdecode.h"

extern xmmsc_connection_t *connection; /* available from gxmms2.c */

static int n_playlist_added(xmmsv_t *val, void *arg)
{
	GMedialib  *gml = (GMedialib *)arg;
	char const *xerr = "Playlist imported successfully.\n";

	xmmsv_get_error(val, &xerr);
	gml_set_statusbar_text(gml, (gchar *) xerr);
	return FALSE;
}

static int n_idlist_from_playlist_file(xmmsv_t *val, void *arg)
{
	xmmsc_result_t *res2;
	xmmsc_coll_t   *coll;
	xmmsv_t        *order_v;
	char           *order[] = { "id", NULL };
	char const     *xerr;

	if (xmmsv_get_error(val, &xerr))
		printf("%s\n", xerr);

	if (!xmmsv_get_coll(val, &coll))
		printf("Couldn't get collection from result!\n");

	order_v = xmmsv_make_stringlist(order, 1);
	res2 = xmmsc_playlist_add_collection(connection, NULL, coll, order_v);
	xmmsv_unref(order_v);
	xmmsc_result_notifier_set(res2, n_playlist_added, arg);

	xmmsc_result_unref(res2);
	return FALSE;
}

static void cb_add_files(GtkWidget *widget, gpointer pt)
{
	GMedialib      *gml = GMEDIALIB(pt);
	GSList         *filelist = NULL;
	GSList         *item = NULL;
	xmmsc_result_t *res;
	gchar          *fname, *url = NULL;

	gml_set_statusbar_text(gml, 
	                       "Adding files to the media library (this may take a while)...");

	filelist = 
	   gtk_file_chooser_get_uris(GTK_FILE_CHOOSER(gml->addfiles.file_selector));
	item = filelist;

	while (item != NULL) {
		fname = g_filename_from_uri((gchar *)item->data, NULL, NULL);
		if (fname != NULL) {
			url = g_malloc(strlen(fname) + 8);
			snprintf(url, strlen(fname) + 8, "file://%s", fname);

			if (g_file_test((fname), G_FILE_TEST_IS_DIR)) { /* directory */
				res = xmmsc_medialib_path_import(connection, url);
			} else { /* file */
				if (memcmp(url+(strlen(url)-4), ".pls", 4) == 0 ||
				    memcmp(url+(strlen(url)-4), ".m3u", 4) == 0) {
					res = xmmsc_coll_idlist_from_playlist_file(connection, url);
					xmmsc_result_notifier_set(res, n_idlist_from_playlist_file,
					                          gml);
				} else {
					res = xmmsc_medialib_add_entry(connection, url);
				}
			}
			xmmsc_result_unref(res);
			g_free(fname);
			g_free(url);
		}
		g_free(item->data);
		item = item->next;
	}
	g_slist_free(filelist);
}

void gml_create_mlib_add_files(GMedialib *gml)
{
	GtkWidget   *table;
	GtkTooltips *tooltips;

	gml->addfiles.frame = gtk_frame_new("MLib Add files");
	gtk_container_set_border_width(GTK_CONTAINER(gml->addfiles.frame), 2);

	/* table */
	table = gtk_table_new(2, 1, FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table), 3);
	gtk_table_set_row_spacings(GTK_TABLE(table), 4);
	gtk_table_set_col_spacings(GTK_TABLE(table), 4);
	gtk_container_add(GTK_CONTAINER(gml->addfiles.frame), table);

	gml->addfiles.file_selector = 
		gtk_file_chooser_widget_new(GTK_FILE_CHOOSER_ACTION_OPEN);
	gtk_file_chooser_set_select_multiple(
		GTK_FILE_CHOOSER(gml->addfiles.file_selector), TRUE);
	gtk_table_attach(GTK_TABLE(table),
		             gml->addfiles.file_selector,
		             0, 1, 0, 1, 
		             GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 0);

	/* add button */
	gml->addfiles.button_add = gtk_button_new_from_stock(GTK_STOCK_ADD);
	gtk_table_attach(GTK_TABLE(table),
		             gml->addfiles.button_add,
		             0, 1, 1, 2,
		             GTK_SHRINK, GTK_SHRINK, 0, 0);

	/* tooltips */
	tooltips = gtk_tooltips_new();
	gtk_tooltips_set_tip(tooltips, gml->addfiles.button_add, 
	                     "Add selected files/directories to the medialib", 
	                     NULL);

	g_signal_connect(G_OBJECT(gml->addfiles.button_add), "clicked",
	                 G_CALLBACK(cb_add_files),
	                 (gpointer)gml);
}
