// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Multithreaded AEWF (AEWF = Avanced EWF)
// ****************************************************************************

// Copyright 2008, 2009, 2010 Guy Voncken
//
// This file is part of guymager.
//
// guymager is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// guymager is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with guymager. If not, see <http://www.gnu.org/licenses/>.

#ifndef __AEWF_H__
#define __AEWF_H__

typedef struct _t_Aewf *t_pAewf;

typedef struct
{
   bool Dummy;
} t_AewfPreprocess, *t_pAewfPreprocess;

// ------------------------------------
//              Functions
// ------------------------------------

// Write access functions
APIRET AewfOpen          (t_pAewf *ppAewf, const char *pFilename, unsigned long long DeviceSize, unsigned int SectorSize, unsigned int ChunkSize);
APIRET AewfPreprocess    (t_pAewfPreprocess *ppPreprocess, unsigned char *pDataIn, unsigned int DataLenIn, unsigned char *pDataOut, unsigned int DataLenOut);
APIRET AewfWrite         (t_pAewf   pAewf, t_pAewfPreprocess pPreprocess, const unsigned char *pData, unsigned int DataLen);
APIRET AewfClose         (t_pAewf *ppAewf, unsigned long long BadSectors, const unsigned char *pMD5, const unsigned char *pSHA256, int Duration);

// Read access functions
APIRET AewfOpen          (t_pAewf *ppAewf, const char *pFilename);
APIRET AewfReadNextChunk (t_pAewf   pAewf, unsigned char *pData, unsigned int *pDataLen);
APIRET AewfClose         (t_pAewf *ppAewf);


APIRET AewfWriteSegmentStr (t_pAewf pAewf, const char *pName, unsigned int Argument, const char *pStr);

APIRET AewfCopyBadSectorMarker (unsigned char *pBuffer, unsigned int Len);

APIRET AewfInit   (void);
APIRET AewfDeInit (void);


// ------------------------------------
//             Error codes
// ------------------------------------

enum
{
   ERROR_AEWF_MEMALLOC_FAILED = ERROR_BASE_AEWF + 1,
   ERROR_AEWF_CANNOT_WRITE_FILE
};

#endif

