//
// C++ Implementation: serverindex
//
// Description: 
//
//
// Author: Lorn Potter <lorn.potter@gmail.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "serverindex.h"
#include "networkdialog.h"
#include "gutendb.h"


serverIndex::serverIndex()
 : QObject()
{
    qWarning("new serverindex");
    downloadMirrorsFile();
}


serverIndex::~serverIndex()
{
}

bool serverIndex::parseServerFile()
{
    qWarning() << __PRETTY_FUNCTION__;
    QFile mirrorsIndex("MIRRORS.ALL");
    QList<QStringList> itemList;
    QStringList items;

    //   if(mirrorsIndex.exists())
    //      return false;
    
    if ( mirrorsIndex.open( QIODevice::ReadOnly)) {
          // file opened successfully
        QTextStream indexStream( &mirrorsIndex );
        QString indexLine;
        
        while ( !indexStream.atEnd() ) {
            indexLine = indexStream.readLine();
            if( !indexLine.startsWith("  ")
                && !indexLine.startsWith("---")
                && !indexLine.startsWith("(")
                && !indexLine.isEmpty()) {
                    QStringList token = indexLine.split('|');
                    //      qWarning(token.at(2).toLocal8Bit());
                    items.clear();
                    items << token.at(1)
                        << token.at(3)
                        << token.at(4);
                    itemList << items;
                }
        }
    }
    mirrorsIndex.close();
    
    gutenDb *gutdb;
    gutdb = new gutenDb();
    gutdb->insertServers( itemList);
    return true;
}


void serverIndex::downloadMirrorsFile()
{
    // http://www.gutenberg.org/MIRRORS.ALL
    qWarning("downloadMirrorsFile");
    QString fileName = "MIRRORS.ALL";
    QFileInfo fi(fileName);
    if(!fi.exists()) {
        qWarning() << "Filesize is" << fi.size();
        NetworkDialog *net;
        net = new NetworkDialog();
        net->setWindowTitle("Downloading Server Mirrors List.");
        net->setUrl("http://www.gutenberg.org/MIRRORS.ALL");
        net->setFile(fileName);
        net->exec();
    }
}
