/* CConfigFile.h */

#ifndef CCONFIGFILE_H
#define CCONFIGFILE_H

#include "CConfigGroup.h"

#include <qstringlist.h>
#include <qfont.h>
#include <qapplication.h>

typedef QMap<QString, CConfigGroup*> ConfigMap;

class CConfigFile
{
 public:
  
  CConfigFile();
  CConfigFile(const QString& filename);
  ~CConfigFile();

  // clean up
  void clear();

  // file
  void setName(const QString& filename);
  const QString& name() const { return fname; }
  void write();
  void read();

  // current group
  void setGroup(const QString& group);
  const QString& group() const;

  // group info
  unsigned int numGroups() const { return map.count(); }
  QStringList groupList();

  // write entries
  void writeEntry(const QString& key, const QString& value);
  void writeEntry(const QString& key, int value);
  void writeEntry(const QString& key, double value);
  void writeNumEntry(const QString& key, int value);
  void writeBoolEntry(const QString& key, bool b_value);


  // read entries
  const QString& readEntry(const QString& key, const QString& default_value);
  int readEntry(const QString& key, int default_value);
  double readEntry(const QString& key, double default_value);
  int readNumEntry(const QString& key, int default_value =0);
  bool readBoolEntry(const QString& key, bool b_default_value);

  QFont readFontEntry( const QString& key,  const QFont* pDefault );
  void writeFontEntry( const QString& key, const QFont& rFont );
 private:

  QString fname;
  ConfigMap map;
  CConfigGroup* currentgroup;
};

#endif



