(if (not (defined? 'db-open))
    (begin
	(dynamic-call "scm_init_db3" (dynamic-link "libguiledb3.so"))))

(define-module (database berkeley))

(define (data->string data)
    (with-output-to-string
	(lambda ()
	    (write data))))

(define (string->data string)
    (with-input-from-string
	string
	(lambda ()
	    (read))))

(define-public (db-put handle key data)
    (let (
	    (k (data->string key))
	    (d (data->string data)))
	(db-put-text handle k d)))

(define-public (db-get handle key)
    (let (
	    (k (data->string key)))
	(string->data (db-get-text k))))

