
using System;
using Gtk;
using Gdk;
using Mono.Unix;

namespace gtwitter
{
	
	public class AboutDialog : Gtk.AboutDialog
	{
		
		// Strings
		private static readonly string string_translators = 
			Catalog.GetString ("translator-credits");

		private static readonly string string_gtwitter =
			Catalog.GetString ("gTwitter");

		private static readonly string string_copyright =
			Catalog.GetString ("Copyright © 2007 Nil Gradisnik");

		private static readonly string string_description =
			Catalog.GetString ("A Linux client for for reading and posting\nto twitter.com webservice");

		private static readonly string string_website =
			"http://code.google.com/p/gtwitter/";
		
		// Authors
		private static readonly string [] authors = {
			Catalog.GetString ("Nil Gradisnik <ghaefb@gmail.com>"),
			Catalog.GetString ("\nThanks to:"),
			Catalog.GetString ("Stojance Dimitrovski <sdimitrovski@gmail.com>"),
			Catalog.GetString ("Yoan Blanc <yoan.blanc@gmail.com>"),
			Catalog.GetString ("Miguel de Icaza <miguel@ximian.com>"),
			Catalog.GetString ("Luka Kac <skipper3k@gmail.com>"),
			Catalog.GetString ("Steve Neely <steve.neely@ucd.ie>"),
			null,
		};
		
		// Documenters
		/*private static readonly string [] documenters = {
			null,
		};*/
		
		// Artists
		private static readonly string [] artists = {
			Catalog.GetString ("Izo <izo.spip@gmail.com>"),
			Catalog.GetString ("Nil Gradisnik <ghaefb@gmail.com>"),
		};

		// Icon
		private static readonly Gdk.Pixbuf pixbuf =
		  new Gdk.Pixbuf (null, "gtwitter-64.png");
	
		// Variables
		private static string translators;
		
		// Static Constructor
		static AboutDialog ()
		{
			// Translators
			if (string_translators == "translator-credits")
				translators = null;
			else
				translators = string_translators;
		}

		// Constructor
		/// <summary>
		/// 	The About window for Muine
		/// </summary>
		/// <param name="parent">
		///	The parent window
		/// </param>
		public AboutDialog (Gtk.Window parent) : base ()
		{
			base.Authors           = authors;
			base.Copyright         = string_copyright;
			base.Comments          = string_description;
			//base.Documenters       = documenters;
			base.Artists 				= artists;
			base.Logo              = pixbuf;
			base.Name              = string_gtwitter;
			base.TranslatorCredits = translators;
			base.Version           = MainClass.version;
			base.Website           = string_website;
			
			string licence = string.Format("Licensed under the GNU General Public License Version 2\n\n{0}", "gTwitter is free software; you can redistribute it and/or\n");
			licence += string.Format("modify it under the terms of the GNU General Public License\n{0}", "as published by the Free Software Foundation; either version 2\n");
			licence += string.Format("of the License, or (at your option) any later version.\n\n{0}", "gTwitter is distributed in the hope that it will be useful,\n");
			licence += string.Format("but WITHOUT ANY WARRANTY; without even the implied warranty of\n{0}", "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n");
			licence += string.Format("GNU General Public License for more details.\n\n{0}", "You should have received a copy of the GNU General Public License\n");
			licence += string.Format("along with this program; if not, write to the Free Software\n{0}", "Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA\n");
			licence += string.Format("02110-1301, USA.\n{0}", "");
			base.License			= licence;

			base.TransientFor = parent;

			base.Response += OnResponse;

			//base.Show();
		}

		// Handlers :: OnResponse
		private void OnResponse (object obj, EventArgs args)
		{
			base.Hide ();
		}
	}
}

//ghaefb