#   File:       sorPPC.make
#   Target:     sorPPC
#   Sources:    cpp.c
#               err.c
#               gen.c
#               globals.c
#               hash.c
#               look.c
#               main.c
#               scan.c
#               sor.c
#               ::support:set:set.c
#   Created:    Monday, May 18, 1998 12:20:50 AM
#	Author:		Kenji Tanaka


MAKEFILE     = sorPPC.make
MondoBuild = {MAKEFILE}  # Make blank to avoid rebuilds when makefile is modified
Includes     = 
		-i "::h:" 
		-i "::support:set:"
SymPPC      = 
ObjDirPPC   = :Obj:

PPCCOptions  = {Includes} {SymPPC} -w off -d  __STDC__  -d MPW -d USER_ZZSYN 

ObjectsPPC  = 
		"{ObjDirPPC}cpp.c.x" 
		"{ObjDirPPC}err.c.x" 
		"{ObjDirPPC}gen.c.x" 
		"{ObjDirPPC}globals.c.x" 
		"{ObjDirPPC}hash.c.x" 
		"{ObjDirPPC}look.c.x" 
		"{ObjDirPPC}main.c.x" 
		"{ObjDirPPC}scan.c.x" 
		"{ObjDirPPC}sor.c.x" 
		"{ObjDirPPC}set.c.x"

sorPPC  {MondoBuild} {ObjectsPPC}
	PPCLink 
		-o {Targ} {SymPPC} 
		{ObjectsPPC} 
		-t 'MPST' 
		-c 'MPS ' 
		"{SharedLibraries}InterfaceLib" 
		"{SharedLibraries}StdCLib" 
		"{SharedLibraries}MathLib" 
		"{PPCLibraries}StdCRuntime.o" 
		"{PPCLibraries}PPCCRuntime.o" 
		"{PPCLibraries}PPCToolLibs.o"

"{ObjDirPPC}cpp.c.x"  {MondoBuild} cpp.c
	{PPCC} cpp.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}err.c.x"  {MondoBuild} err.c
	{PPCC} err.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}gen.c.x"  {MondoBuild} gen.c
	{PPCC} gen.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}globals.c.x"  {MondoBuild} globals.c
	{PPCC} globals.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}hash.c.x"  {MondoBuild} hash.c
	{PPCC} hash.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}look.c.x"  {MondoBuild} look.c
	{PPCC} look.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}main.c.x"  {MondoBuild} main.c
	{PPCC} main.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}scan.c.x"  {MondoBuild} scan.c
	{PPCC} scan.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}sor.c.x"  {MondoBuild} sor.c
	{PPCC} sor.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}set.c.x"  {MondoBuild} "::support:set:set.c"
	{PPCC} "::support:set:set.c" -o {Targ} {PPCCOptions}


sorPPC  sor.r
	Rez sor.r -o sorPPC -a

Install   sorPPC
	Duplicate -y sorPPC "{MPW}"Tools:sor
