/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4; coding: utf-8 -*- */
#ifndef __IMAGE_VIEW_DRAWER_H__
#define __IMAGE_VIEW_DRAWER_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include "utils.h"

/**
 * DrawFlags:
 *
 * Flags that decides what should be done for the next draw.
 **/
typedef enum
{
    /* Scale the pixbuf and put the result in the cache. */
    DRAW_METHOD_SCALE = 0,

    /* Whole draw is contained in the cache. Only blit is needed. */
    DRAW_METHOD_CONTAINS = 1,

    /* Scroll in the new draw area if possible. Much of the cache may
       be reused. */
    DRAW_METHOD_SCROLL = 2
} DrawMethod;

typedef struct
{
    gdouble        zoom;

    /* Rectangle in zoom-space coordinates of the area to draw. */
    GdkRectangle   zoom_rect;

    /* Position in widget-space coordinates where to draw. */
    int            widget_x;
    int            widget_y;
       
    GdkInterpType  interp;
    GdkPixbuf     *pixbuf;

    /* The two colors to use to draw the checker board. */
    int            check_color1;
    int            check_color2;
} DrawSettings;

typedef struct 
{
    GdkPixbuf     *last_pixbuf;
    DrawSettings   old;

    int            check_size;
} ImageViewDrawer;

DrawMethod       draw_settings_get_method (DrawSettings *last,
                                           DrawSettings *new_,
                                           GdkPixbuf    *last_pixbuf);
ImageViewDrawer *image_view_drawer_new  (void);
void             image_view_drawer_free (ImageViewDrawer *drawer);
void             image_view_drawer_force_scale (ImageViewDrawer *drawer);
void             image_view_drawer_draw (ImageViewDrawer *drawer,
                                         DrawSettings    *settings,
                                         GdkDrawable     *drawable);

#endif
