/* app.h
 * For GTKeyboard
 * written by David Allen s2mdalle@titan.vcu.edu http://opop.nols.com/
 * Released under the terms of the GNU General Public License.  See
 * COPYING for more information.
 */

#define APP_H

#define OUTPUT_CONSOLE         1
#define OUTPUT_DEVICE_CONSOLE  "/dev/console"
#define OUTPUT_PRINTER         2
#define OUTPUT_DEVICE_PRINTER  "/dev/printer"
#define OUTPUT_TEMPFILE        3
#define OUTPUT_DEVICE_TEMPFILE "/tmp/GTKeyboard"

/* Prototypes for app.c */
void program_info                            (GtkWidget *emitter, 
					      gint info_code);
void confirm_save_on_exit                    (char *filename);
void change_filename_save_and_exit           (GtkWidget *w, gpointer data);
void save_file_as_on_exit                    (GtkWidget *w, gpointer data);
void CLONE                                   (void);
int load_file                                (char *filename, 
					      GtkWidget *textbox);
void change_output                           (GtkWidget *w, int data);
void annoying_popup                          (const char *message);
void usage                                   (char *input);
void license                                 (void);
void clear_all_text_really                   (GtkWidget *widget, 
					      gpointer data);
void clear_all_text                          (GtkWidget *w, gpointer data);
int  init_keyboard_stuff                     (char *input);
void OpenFile                                (gpointer callback_data, 
					      guint callback_action,
					      GtkWidget *widget);
void NewFile                                 (gpointer callback_data, 
					      guint callback_action,
					      GtkWidget *widget);
void change_filename                         (GtkWidget *foo, gpointer data);
void CreateTable                             (GtkWidget *table, int columns, 
					      int rows, int buttons);
void find_dialog                             (GtkWidget *emitter, 
					      gpointer data);
int get_index_of                             (char input);
void save_handler                            (GtkWidget *w, gpointer data);
void gtkeyboard_error                        (const int count, ...);
void gtkeyboard_message                      (const int count, ...);
void clear_wrapper                           (GtkWidget *w, gint ID);
