/*
 * $Id: aging.h 16446 2009-04-08 20:24:09Z rmanfredi $
 *
 * Copyright (c) 2004, Raphael Manfredi
 *
 *----------------------------------------------------------------------
 * This file is part of gtk-gnutella.
 *
 *  gtk-gnutella is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  gtk-gnutella is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with gtk-gnutella; if not, write to the Free Software
 *  Foundation, Inc.:
 *      59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *----------------------------------------------------------------------
 */

/**
 * @ingroup lib
 * @file
 *
 * Hash table with aging key/value pairs, removed automatically after
 * some time has elapsed.
 *
 * @author Raphael Manfredi
 * @date 2004
 */

#ifndef _aging_h_
#define _aging_h_

#include "common.h"
#include "glib-missing.h"	/* For GEqualFunc in glib-1.x */

typedef struct aging aging_table_t;

typedef void (*aging_free_t)(gpointer value, gpointer udata);

/*
 * Public interface.
 */

aging_table_t *aging_make(int delay,
	GHashFunc hash, GEqualFunc eq, aging_free_t kfree);

void aging_destroy(aging_table_t **);

gpointer aging_lookup(const aging_table_t *ag, gconstpointer key);
gpointer aging_lookup_revitalise(const aging_table_t *ag, gconstpointer key);
void aging_insert(aging_table_t *ag, gpointer key, gpointer value);
gboolean aging_remove(aging_table_t *ag, gpointer key);

#endif	/* _aging_h_ */

/* vi: set ts=4: sw=4 cindent: */

