/*
 * Copyright (C) 1996 Eric M. Ludlam
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.ai.mit.edu.
 *
 * test_kbd.c
 *
 * Purpose:
 *  Sample application to run as child of etalk using the KEYBOARD
 * interface, and a proxy of NONE.  This test does _NOT_ use etalklib,
 * showing how to do it without etalk's structures.
 *
 * $Log: test_kbd.c,v $
 * Revision 1.2  1996/02/25  23:47:09  zappo
 * Added more diagnostics
 *
 * Revision 1.1  1996/01/07  04:19:26  zappo
 * Initial revision
 *
 */

/* These handle basic headers we need */
#include "config.h"
#include "headers.h"

/* check if this system has FD_SET defined (a macro for setting 
 * descriptors in a selection mask.  These values were taken from
 * "process.c" in the emacs-19.28 distribution.
 */
#ifndef FD_SET
#define fd_set unsigned long
#define FD_ZERO(p) (*(p) = 0)
#define FD_SET(n, p) (*(p) |= (1 << (n)))
#define FD_ISSET(n, p) (*(p) & (1 << (n)))
#endif /* not FD_SET */

int main(argc, argv)
     int argc;
     char *argv[];
{
  int   mysock;
  FILE *sockopen;
  char  readbuff[100];

  /* The first parameter says which FD is the one we want. */
  if(argc < 2)
    {
      fprintf(stderr, "Usage: test_kbd <sock fd>\n");
      exit(1);
    }

  mysock = atoi(argv[1]);

  if(mysock == 0)
    {
      fprintf(stderr, "Invalid socket number: %s\n", argv[1]);
      fprintf(stderr, "Usage: test_kbd <sock fd>\n");
      exit(1);
    }

  /* Verify that mysock really is an IO device */
  sockopen = fdopen(mysock, "wr");

  if(!sockopen)
    {
      fprintf(stderr, "File Descriptor %d is not valid.\n", mysock);
      exit(1);
    }

  /* Now report via stdout (which should be piped) what keys we like */
  /* Test pattern: Ctrl-a and Ctrl-b                                 */
  fprintf(stdout, "%c%c\n", 1, 2);

  /* Print a test startup message */
  fprintf(stdout, "This should appear in the minibuffer.\n");

  fflush(stdout);

  fprintf(stderr, "This should appear as output beyond the scope of parent\n");

  /* Now wait for input */
  do {
    fd_set mask;
    int rval, cnt;
    char *ret;

    FD_ZERO(&mask);
    FD_SET(mysock, &mask);	/* input socket */
    FD_SET(0, &mask);		/* stdin */

    rval = mysock+1;
    rval = select(rval, &mask, NULL, NULL, NULL);
    
    if(FD_ISSET(0, &mask))
      {
	ret = fgets(readbuff, sizeof(readbuff), stdin);

	if(!ret)
	  {
	    /* Parent probably died.  Lets exit nicely */
	    exit(0);
	  }
	/* Test case.. send char to remote */
	for(cnt = 0; cnt < strlen(readbuff);)
	  cnt = write(mysock, readbuff, strlen(readbuff));

	fprintf(stderr, "Read char and sent char\n");

      }
    if(FD_ISSET(mysock, &mask))
      {
	/* read the data from socket */
	cnt = read(mysock, readbuff, sizeof(readbuff));

	/* system closed */
	if(cnt == 0)
	  exit(0);

	readbuff[cnt-1] = 0;
	printf("TEST_KBD: Read [%s]\n", readbuff);

	fflush(stdout);
	
	fprintf(stderr, "Outputting data to etalk.\n");
      }
    /* Now do something interesting */
  } while(1);
}
