// Generated by gtkmmproc -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/structure.h>
#include <gstreamermm/private/structure_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstvalue.h> //Must be included before gststructure.h
#include <gst/gststructure.h>
#include <gstreamermm/value.h>
#include <gstreamermm/miniobject.h>

namespace
{

static Glib::ustring quark_to_ustring(GQuark quark)
{
 const gchar* pch = g_quark_to_string(quark);
 Glib::ustring str;
 if(pch)
   str = pch;
   
 return str;
}

extern "C"
{

static gboolean
Structure_Foreach_gstreamermm_callback(GQuark field_id, const GValue *value, void* data)
{
  Gst::Structure::SlotForeach* slot = static_cast<Gst::Structure::SlotForeach*>(data);

  try
  {
    return (*slot)(quark_to_ustring(field_id), *reinterpret_cast<const Glib::ValueBase*>(value));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return false;
}

static gboolean
Structure_Map_gstreamermm_callback(GQuark field_id, GValue *value, void* data)
{
  Gst::Structure::SlotMap* slot = static_cast<Gst::Structure::SlotMap*>(data);

  try
  {
    bool result = (*slot)(quark_to_ustring(field_id), *reinterpret_cast<Glib::ValueBase*>(value));
    return result;
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return false;
}

} // extern "C"

} // anonymous namespace

namespace Gst
{

Structure::Structure(const Glib::ustring& name)
{
  gobject_ = gst_structure_empty_new(name.c_str());
}

Structure::operator bool() const
{
  return gobject_ != 0;
}

void Structure::get_field(const Glib::ustring& name, Glib::ValueBase& value) const
{
  value.init(gst_structure_get_value(gobj(), name.c_str()));
}

void Structure::set_field(const Glib::ustring& fieldname,
  const Glib::ValueBase& value)
{
  gst_structure_set_value(gobj(), fieldname.c_str(), value.gobj());
}

void Structure::set_field(const Glib::ustring& fieldname, bool value)
{
  gst_structure_set(gobj(), fieldname.c_str(), G_TYPE_BOOLEAN, value, (void*)0);
}

void Structure::set_field(const Glib::ustring& fieldname, int value)
{
  gst_structure_set(gobj(), fieldname.c_str(), G_TYPE_INT, value, (void*)0);
}

void Structure::set_field(const Glib::ustring& fieldname, guint value)
{
  gst_structure_set(gobj(), fieldname.c_str(), G_TYPE_UINT, value, (void*)0);
}

void Structure::set_field(const Glib::ustring& fieldname, const Fourcc& value)
{
  gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_FOURCC,
    value.get_fourcc(), (void*)0);
}

void Structure::set_field(const Glib::ustring& fieldname, double value)
{
  gst_structure_set(gobj(), fieldname.c_str(), G_TYPE_DOUBLE, value, (void*)0);
};

//We use std::string, because the encoding is unknown. murrayc
void Structure::set_field(const Glib::ustring& fieldname, const std::string& value)
{
  gst_structure_set(gobj(), fieldname.c_str(), G_TYPE_STRING, value.c_str(), (void*)0);
}

//We use std::string, because the encoding is unknown. murrayc
void Structure::set_field(const Glib::ustring& fieldname, const char* value)
{
  gst_structure_set(gobj(), fieldname.c_str(), G_TYPE_STRING, value, (void*)0);
}
 
void Structure::set_field(const Glib::ustring& fieldname, const Glib::Date& value)
{
  gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_DATE, value.gobj(), (void*)0);
}

void Structure::set_field(const Glib::ustring& fieldname, const ClockTime& value)
{
  gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_CLOCK_TIME,
    (GstClockTime) value, (void*)0);
}

void Structure::set_field(const Glib::ustring& fieldname, GType enumtype, int value)
{
  gst_structure_set(gobj(), fieldname.c_str(), enumtype, value, (void*)0);
}

void Structure::set_field(const Glib::ustring& fieldname, const Gst::Fraction& value)
{
  gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_FRACTION, value.num,
    value.denom, (void*)0);
}

void Structure::set_field(const Glib::ustring& fieldname, const Gst::IntRange& value)
{
  gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_INT_RANGE, value.min,
    value.max, (void*)0);
}

void Structure::set_field(const Glib::ustring& fieldname, const Gst::DoubleRange& value)
{
  gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_DOUBLE_RANGE,
    value.min, value.max, (void*)0);
}

void Structure::set_field(const Glib::ustring& fieldname, const Gst::FractionRange& value)
{
  gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_FRACTION_RANGE,
    value.min.num, value.min.denom, value.max.num, value.max.denom, (void*)0);
}

void Structure::remove_field(const Glib::ustring& fieldname)
{
  gst_structure_remove_field(gobj(), fieldname.c_str());
}

bool Structure::get_field(const Glib::ustring& name, bool& value) const
{
  gboolean cvalue = FALSE;
  const bool result = gst_structure_get_boolean(gobj(), name.c_str(), &cvalue);
  value = cvalue;
  return result;
}

bool Structure::get_field(const Glib::ustring& name, int& value) const
{
  return gst_structure_get_int(gobj(), name.c_str(), &value);
}

bool Structure::get_field(const Glib::ustring& name, guint& value) const
{
  return gst_structure_get_uint(gobj(), name.c_str(), &value);
}

bool Structure::get_field(const Glib::ustring& name, Fourcc& value) const
{
  guint32 cvalue = 0;
  const bool result = gst_structure_get_fourcc(gobj(), name.c_str(), &cvalue);
  if(result)
    value = Fourcc(cvalue);

  return result;
}


bool Structure::get_field(const Glib::ustring& name, double& value) const
{
  return gst_structure_get_double(gobj(), name.c_str(), &value);
}

bool Structure::get_field(const Glib::ustring& name, Glib::ustring& value) const
{
  const gchar* cvalue = gst_structure_get_string(gobj(), name.c_str());
  if(cvalue)
  {
    value = Glib::convert_const_gchar_ptr_to_stdstring(cvalue);
    return true;
  }
  else
    return false;
}

bool Structure::get_field(const Glib::ustring& name, std::string& value) const
{
  const gchar* cvalue = gst_structure_get_string(gobj(), name.c_str());
  if(cvalue)
  {
    value = Glib::convert_const_gchar_ptr_to_stdstring(cvalue);
    return true;
  }
  else
    return false;
}

bool Structure::get_field(const Glib::ustring& name, Glib::Date& date) const
{
  GDate* gdate = 0;
  const bool has = gst_structure_get_date(gobj(), name.c_str(), &gdate);
  if(has)
    date.set_julian(Glib::Date(*gdate).get_julian());

  return has;
}

bool Structure::get_field(const Glib::ustring& name, ClockTime& value) const
{
  GstClockTime cvalue = 0;
  const bool result = gst_structure_get_clock_time(gobj(), name.c_str(), &cvalue);
  value = cvalue;
  return result;
}


bool Structure::get_field(const Glib::ustring& name, GType enum_type, int& value) const
{
  return gst_structure_get_enum(gobj(), name.c_str(), enum_type, &value);
}


bool Structure::get_field(const Glib::ustring& name, Gst::Fraction& f) const
{
  int value_numerator = 0;
  int value_denominator = 0;
  const bool result = gst_structure_get_fraction(gobj(), name.c_str(), &value_numerator, &value_denominator);
  if(result)
    f = Gst::Fraction(value_numerator, value_denominator);
  
  return result;
}

bool Structure::get_field(const Glib::ustring& name, Gst::IntRange& range) const
{
  const GValue* gst_range_val = gst_structure_get_value(gobj(), name.c_str());

  if(G_VALUE_TYPE(gst_range_val) == GST_TYPE_INT_RANGE)
  {
    const gint min = gst_value_get_int_range_min(gst_range_val);
    const gint max = gst_value_get_int_range_max(gst_range_val);
    range = Gst::IntRange(min, max);
    return true;
  }

  return false;
}

bool Structure::get_field(const Glib::ustring& name, Gst::DoubleRange& range) const
{
  const GValue* gst_range_val = gst_structure_get_value(gobj(), name.c_str());

  if(G_VALUE_TYPE(gst_range_val) == GST_TYPE_DOUBLE_RANGE)
  {
    const gdouble min = gst_value_get_double_range_min(gst_range_val);
    const gdouble max = gst_value_get_double_range_max(gst_range_val);
    range = Gst::DoubleRange(min, max);
    return true;
  }

  return false;
}

bool Structure::get_field(const Glib::ustring& name, Gst::FractionRange& range) const
{
  const GValue* gst_range_val = gst_structure_get_value(gobj(), name.c_str());

  if(G_VALUE_TYPE(gst_range_val) == GST_TYPE_FRACTION_RANGE)
  {
    const GValue* gst_min_val = gst_value_get_fraction_range_min(gst_range_val);
    const gint min_num = gst_value_get_fraction_numerator(gst_min_val);
    const gint min_denom = gst_value_get_fraction_denominator(gst_min_val);

    const GValue* gst_max_val = gst_value_get_fraction_range_max(gst_range_val);
    const gint max_num = gst_value_get_fraction_numerator(gst_max_val);
    const gint max_denom = gst_value_get_fraction_denominator(gst_max_val);

    range = Gst::FractionRange(Gst::Fraction(min_num, min_denom),
      Gst::Fraction(max_num, max_denom));

    return true;
  }

  return false;
}

bool Structure::foreach(const SlotForeach& slot)
{
  return gst_structure_foreach(gobj(), &Structure_Foreach_gstreamermm_callback, const_cast<SlotForeach*>(&slot));
}

bool Structure::map_in_place(const SlotMap& slot)
{
  return gst_structure_map_in_place(gobj(), &Structure_Map_gstreamermm_callback, const_cast<SlotMap*>(&slot));
}

Structure Structure::create_from_string(const Glib::ustring& the_string)
{
  return Structure(gst_structure_from_string(the_string.c_str(), 0)); 
}

bool Structure::fixate_nearest_fraction(const Glib::ustring& name, const Gst::Fraction& target)
{
  return gst_structure_fixate_field_nearest_fraction(gobj(), name.c_str(), target.num, target.denom);
}

} //namespace Gst

namespace
{
} // anonymous namespace


namespace Glib
{

Gst::Structure wrap(GstStructure* object, bool take_copy)
{
  return Gst::Structure(object, take_copy);
}

} // namespace Glib


namespace Gst
{


// static
GType Structure::get_type()
{
  return gst_structure_get_type();
}

Structure::Structure()
:
  gobject_ (0) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

Structure::Structure(const Structure& other)
:
  gobject_ ((other.gobject_) ? gst_structure_copy(other.gobject_) : 0)
{}

Structure::Structure(GstStructure* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? gst_structure_copy(gobject) : gobject)
{}

Structure& Structure::operator=(const Structure& other)
{
  Structure temp (other);
  swap(temp);
  return *this;
}

Structure::~Structure()
{
  if(gobject_)
    gst_structure_free(gobject_);
}

void Structure::swap(Structure& other)
{
  GstStructure *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

GstStructure* Structure::gobj_copy() const
{
  return gst_structure_copy(gobject_);
}


Glib::ustring Structure::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gst_structure_get_name(const_cast<GstStructure*>(gobj())));
}

bool Structure::has_name(const Glib::ustring& name) const
{
  return gst_structure_has_name(const_cast<GstStructure*>(gobj()), name.c_str());
}

void Structure::set_name(const Glib::ustring& name)
{
  gst_structure_set_name(gobj(), name.c_str());
}

Glib::QueryQuark Structure::get_name_id() const
{
  return Glib::QueryQuark(gst_structure_get_name_id(const_cast<GstStructure*>(gobj())));
}

void Structure::remove_all_fields()
{
  gst_structure_remove_all_fields(gobj());
}

GType Structure::get_field_type(const Glib::ustring& fieldname) const
{
  return gst_structure_get_field_type(const_cast<GstStructure*>(gobj()), fieldname.c_str());
}

int Structure::size() const
{
  return gst_structure_n_fields(const_cast<GstStructure*>(gobj()));
}

bool Structure::has_field(const Glib::ustring& fieldname) const
{
  return gst_structure_has_field(const_cast<GstStructure*>(gobj()), fieldname.c_str());
}

bool Structure::has_field(const Glib::ustring& fieldname, GType type) const
{
  return gst_structure_has_field_typed(const_cast<GstStructure*>(gobj()), fieldname.c_str(), type);
}

Glib::ustring Structure::get_nth_field_name(guint index) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gst_structure_nth_field_name(const_cast<GstStructure*>(gobj()), index));
}

Glib::ustring Structure::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gst_structure_to_string(const_cast<GstStructure*>(gobj())));
}

bool Structure::fixate_field_nearest_int(const Glib::ustring& name, int target)
{
  return gst_structure_fixate_field_nearest_int(gobj(), name.c_str(), target);
}

bool Structure::fixate_field_nearest_double(const Glib::ustring& name, double target)
{
  return gst_structure_fixate_field_nearest_double(gobj(), name.c_str(), target);
}

bool Structure::fixate_field_boolean(const Glib::ustring& name, bool target)
{
  return gst_structure_fixate_field_boolean(gobj(), name.c_str(), static_cast<int>(target));
}


} // namespace Gst


