/*
 * Copyright 2005 Fluendo S.L.
 */
 /*********************************************************************
 * Adapted from dist10 reference code and used under the license therein:
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Decoder - Lower Sampling Frequency Extension
 **********************************************************************/

#ifndef __TABLE_HUFFDEC_H__
#define __TABLE_HUFFDEC_H__

struct huffcodetab {
  guint treelen;       /* length of decoder tree */
  gint  xlen;          /* max. x-index+ */
  gint  ylen;          /* max. y-index+ */
  guint linbits;       /* number of linbits */
  gboolean quad_table; /* TRUE for quadruple tables (32 & 33) */
  const guchar (*val)[2];    /* decoder tree data */
};

/* Arrays of the table constants */
static const guchar huffbits_1[7][2] = {
  { 0x02, 0x01 }, { 0x00, 0x00 }, { 0x02, 0x01 }, { 0x00, 0x10 }, 
  { 0x02, 0x01 }, { 0x00, 0x01 }, { 0x00, 0x11 }
};

static const guchar huffbits_2[17][2] = {
  { 0x02, 0x01 }, { 0x00, 0x00 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x10 }, { 0x00, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x11 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x20 }, { 0x00, 0x21 }, 
  { 0x02, 0x01 }, { 0x00, 0x12 }, { 0x02, 0x01 }, { 0x00, 0x02 }, 
  { 0x00, 0x22 }
};

static const guchar huffbits_3[17][2] = {
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x00 }, { 0x00, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x11 }, { 0x02, 0x01 }, { 0x00, 0x10 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x20 }, { 0x00, 0x21 }, 
  { 0x02, 0x01 }, { 0x00, 0x12 }, { 0x02, 0x01 }, { 0x00, 0x02 }, 
  { 0x00, 0x22 }
};

static const guchar huffbits_5[31][2] = {
  { 0x02, 0x01 }, { 0x00, 0x00 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x10 }, { 0x00, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x11 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x20 }, 
  { 0x00, 0x02 }, { 0x02, 0x01 }, { 0x00, 0x21 }, { 0x00, 0x12 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x22 }, 
  { 0x00, 0x30 }, { 0x02, 0x01 }, { 0x00, 0x03 }, { 0x00, 0x13 }, 
  { 0x02, 0x01 }, { 0x00, 0x31 }, { 0x02, 0x01 }, { 0x00, 0x32 }, 
  { 0x02, 0x01 }, { 0x00, 0x23 }, { 0x00, 0x33 }
};

static const guchar huffbits_6[31][2] = {
  { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x00 }, 
  { 0x00, 0x10 }, { 0x00, 0x11 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x20 }, { 0x00, 0x21 }, 
  { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x12 }, { 0x02, 0x01 }, 
  { 0x00, 0x02 }, { 0x00, 0x22 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x31 }, { 0x00, 0x13 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x30 }, { 0x00, 0x32 }, { 0x02, 0x01 }, { 0x00, 0x23 }, 
  { 0x02, 0x01 }, { 0x00, 0x03 }, { 0x00, 0x33 }
};

static const guchar huffbits_7[71][2] = {
  { 0x02, 0x01 }, { 0x00, 0x00 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x10 }, { 0x00, 0x01 }, { 0x08, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x11 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x20 }, 
  { 0x00, 0x02 }, { 0x00, 0x21 }, { 0x12, 0x01 }, { 0x06, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x12 }, { 0x02, 0x01 }, { 0x00, 0x22 }, 
  { 0x00, 0x30 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x31 }, 
  { 0x00, 0x13 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x03 }, 
  { 0x00, 0x32 }, { 0x02, 0x01 }, { 0x00, 0x23 }, { 0x00, 0x04 }, 
  { 0x0a, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x40 }, 
  { 0x00, 0x41 }, { 0x02, 0x01 }, { 0x00, 0x14 }, { 0x02, 0x01 }, 
  { 0x00, 0x42 }, { 0x00, 0x24 }, { 0x0c, 0x01 }, { 0x06, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x33 }, { 0x00, 0x43 }, 
  { 0x00, 0x50 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x34 }, 
  { 0x00, 0x05 }, { 0x00, 0x51 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x15 }, { 0x02, 0x01 }, { 0x00, 0x52 }, { 0x00, 0x25 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x44 }, { 0x00, 0x35 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x53 }, { 0x00, 0x54 }, 
  { 0x02, 0x01 }, { 0x00, 0x45 }, { 0x00, 0x55 }
};

static const guchar huffbits_8[71][2] = {
  { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x00 }, { 0x02, 0x01 }, 
  { 0x00, 0x10 }, { 0x00, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x11 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x21 }, { 0x00, 0x12 }, 
  { 0x0e, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x20 }, 
  { 0x00, 0x02 }, { 0x02, 0x01 }, { 0x00, 0x22 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x30 }, { 0x00, 0x03 }, { 0x02, 0x01 }, 
  { 0x00, 0x31 }, { 0x00, 0x13 }, { 0x0e, 0x01 }, { 0x08, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x32 }, { 0x00, 0x23 }, 
  { 0x02, 0x01 }, { 0x00, 0x40 }, { 0x00, 0x04 }, { 0x02, 0x01 }, 
  { 0x00, 0x41 }, { 0x02, 0x01 }, { 0x00, 0x14 }, { 0x00, 0x42 }, 
  { 0x0c, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x24 }, 
  { 0x02, 0x01 }, { 0x00, 0x33 }, { 0x00, 0x50 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x43 }, { 0x00, 0x34 }, { 0x00, 0x51 }, 
  { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x15 }, { 0x02, 0x01 }, 
  { 0x00, 0x05 }, { 0x00, 0x52 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x25 }, { 0x02, 0x01 }, { 0x00, 0x44 }, { 0x00, 0x35 }, 
  { 0x02, 0x01 }, { 0x00, 0x53 }, { 0x02, 0x01 }, { 0x00, 0x45 }, 
  { 0x02, 0x01 }, { 0x00, 0x54 }, { 0x00, 0x55 }
};

static const guchar huffbits_9[71][2] = {
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x00 }, 
  { 0x00, 0x10 }, { 0x02, 0x01 }, { 0x00, 0x01 }, { 0x00, 0x11 }, 
  { 0x0a, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x20 }, 
  { 0x00, 0x21 }, { 0x02, 0x01 }, { 0x00, 0x12 }, { 0x02, 0x01 }, 
  { 0x00, 0x02 }, { 0x00, 0x22 }, { 0x0c, 0x01 }, { 0x06, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x30 }, { 0x00, 0x03 }, 
  { 0x00, 0x31 }, { 0x02, 0x01 }, { 0x00, 0x13 }, { 0x02, 0x01 }, 
  { 0x00, 0x32 }, { 0x00, 0x23 }, { 0x0c, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x41 }, { 0x00, 0x14 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x40 }, { 0x00, 0x33 }, { 0x02, 0x01 }, 
  { 0x00, 0x42 }, { 0x00, 0x24 }, { 0x0a, 0x01 }, { 0x06, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x04 }, { 0x00, 0x50 }, 
  { 0x00, 0x43 }, { 0x02, 0x01 }, { 0x00, 0x34 }, { 0x00, 0x51 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x15 }, 
  { 0x00, 0x52 }, { 0x02, 0x01 }, { 0x00, 0x25 }, { 0x00, 0x44 }, 
  { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x05 }, 
  { 0x00, 0x54 }, { 0x00, 0x53 }, { 0x02, 0x01 }, { 0x00, 0x35 }, 
  { 0x02, 0x01 }, { 0x00, 0x45 }, { 0x00, 0x55 }
};

static const guchar huffbits_10[127][2] = {
  { 0x02, 0x01 }, { 0x00, 0x00 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x10 }, { 0x00, 0x01 }, { 0x0a, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x11 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x20 }, 
  { 0x00, 0x02 }, { 0x02, 0x01 }, { 0x00, 0x21 }, { 0x00, 0x12 }, 
  { 0x1c, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x22 }, { 0x00, 0x30 }, { 0x02, 0x01 }, { 0x00, 0x31 }, 
  { 0x00, 0x13 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x03 }, { 0x00, 0x32 }, { 0x02, 0x01 }, { 0x00, 0x23 }, 
  { 0x00, 0x40 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x41 }, 
  { 0x00, 0x14 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x04 }, 
  { 0x00, 0x33 }, { 0x02, 0x01 }, { 0x00, 0x42 }, { 0x00, 0x24 }, 
  { 0x1c, 0x01 }, { 0x0a, 0x01 }, { 0x06, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x50 }, { 0x00, 0x05 }, { 0x00, 0x60 }, 
  { 0x02, 0x01 }, { 0x00, 0x61 }, { 0x00, 0x16 }, { 0x0c, 0x01 }, 
  { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x43 }, 
  { 0x00, 0x34 }, { 0x00, 0x51 }, { 0x02, 0x01 }, { 0x00, 0x15 }, 
  { 0x02, 0x01 }, { 0x00, 0x52 }, { 0x00, 0x25 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x26 }, { 0x00, 0x36 }, { 0x00, 0x71 }, 
  { 0x14, 0x01 }, { 0x08, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x17 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x44 }, { 0x00, 0x53 }, 
  { 0x00, 0x06 }, { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x35 }, { 0x00, 0x45 }, { 0x00, 0x62 }, { 0x02, 0x01 }, 
  { 0x00, 0x70 }, { 0x02, 0x01 }, { 0x00, 0x07 }, { 0x00, 0x64 }, 
  { 0x0e, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x72 }, 
  { 0x00, 0x27 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x63 }, 
  { 0x02, 0x01 }, { 0x00, 0x54 }, { 0x00, 0x55 }, { 0x02, 0x01 }, 
  { 0x00, 0x46 }, { 0x00, 0x73 }, { 0x08, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x37 }, { 0x00, 0x65 }, { 0x02, 0x01 }, 
  { 0x00, 0x56 }, { 0x00, 0x74 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x47 }, { 0x02, 0x01 }, { 0x00, 0x66 }, { 0x00, 0x75 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x57 }, { 0x00, 0x76 }, 
  { 0x02, 0x01 }, { 0x00, 0x67 }, { 0x00, 0x77 }
};

static const guchar huffbits_11[127][2] = {
  { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x00 }, { 0x02, 0x01 }, 
  { 0x00, 0x10 }, { 0x00, 0x01 }, { 0x08, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x11 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x20 }, 
  { 0x00, 0x02 }, { 0x00, 0x12 }, { 0x18, 0x01 }, { 0x08, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x21 }, { 0x02, 0x01 }, { 0x00, 0x22 }, 
  { 0x02, 0x01 }, { 0x00, 0x30 }, { 0x00, 0x03 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x31 }, { 0x00, 0x13 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x32 }, { 0x00, 0x23 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x40 }, { 0x00, 0x04 }, { 0x02, 0x01 }, 
  { 0x00, 0x41 }, { 0x00, 0x14 }, { 0x1e, 0x01 }, { 0x10, 0x01 }, 
  { 0x0a, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x42 }, 
  { 0x00, 0x24 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x33 }, 
  { 0x00, 0x43 }, { 0x00, 0x50 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x34 }, { 0x00, 0x51 }, { 0x00, 0x61 }, { 0x06, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x16 }, { 0x02, 0x01 }, { 0x00, 0x06 }, 
  { 0x00, 0x26 }, { 0x02, 0x01 }, { 0x00, 0x62 }, { 0x02, 0x01 }, 
  { 0x00, 0x15 }, { 0x02, 0x01 }, { 0x00, 0x05 }, { 0x00, 0x52 }, 
  { 0x10, 0x01 }, { 0x0a, 0x01 }, { 0x06, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x25 }, { 0x00, 0x44 }, { 0x00, 0x60 }, 
  { 0x02, 0x01 }, { 0x00, 0x63 }, { 0x00, 0x36 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x70 }, { 0x00, 0x17 }, { 0x00, 0x71 }, 
  { 0x10, 0x01 }, { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x07 }, { 0x00, 0x64 }, { 0x00, 0x72 }, { 0x02, 0x01 }, 
  { 0x00, 0x27 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x53 }, 
  { 0x00, 0x35 }, { 0x02, 0x01 }, { 0x00, 0x54 }, { 0x00, 0x45 }, 
  { 0x0a, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x46 }, 
  { 0x00, 0x73 }, { 0x02, 0x01 }, { 0x00, 0x37 }, { 0x02, 0x01 }, 
  { 0x00, 0x65 }, { 0x00, 0x56 }, { 0x0a, 0x01 }, { 0x06, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x55 }, { 0x00, 0x57 }, 
  { 0x00, 0x74 }, { 0x02, 0x01 }, { 0x00, 0x47 }, { 0x00, 0x66 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x75 }, { 0x00, 0x76 }, 
  { 0x02, 0x01 }, { 0x00, 0x67 }, { 0x00, 0x77 }
};

static const guchar huffbits_12[127][2] = {
  { 0x0c, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x10 }, 
  { 0x00, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x11 }, { 0x02, 0x01 }, 
  { 0x00, 0x00 }, { 0x02, 0x01 }, { 0x00, 0x20 }, { 0x00, 0x02 }, 
  { 0x10, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x21 }, 
  { 0x00, 0x12 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x22 }, 
  { 0x00, 0x31 }, { 0x02, 0x01 }, { 0x00, 0x13 }, { 0x02, 0x01 }, 
  { 0x00, 0x30 }, { 0x02, 0x01 }, { 0x00, 0x03 }, { 0x00, 0x40 }, 
  { 0x1a, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x32 }, { 0x00, 0x23 }, { 0x02, 0x01 }, { 0x00, 0x41 }, 
  { 0x00, 0x33 }, { 0x0a, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x14 }, { 0x00, 0x42 }, { 0x02, 0x01 }, { 0x00, 0x24 }, 
  { 0x02, 0x01 }, { 0x00, 0x04 }, { 0x00, 0x50 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x43 }, { 0x00, 0x34 }, { 0x02, 0x01 }, 
  { 0x00, 0x51 }, { 0x00, 0x15 }, { 0x1c, 0x01 }, { 0x0e, 0x01 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x52 }, 
  { 0x00, 0x25 }, { 0x02, 0x01 }, { 0x00, 0x53 }, { 0x00, 0x35 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x60 }, { 0x00, 0x16 }, 
  { 0x00, 0x61 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x62 }, 
  { 0x00, 0x26 }, { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x05 }, { 0x00, 0x06 }, { 0x00, 0x44 }, { 0x02, 0x01 }, 
  { 0x00, 0x54 }, { 0x00, 0x45 }, { 0x12, 0x01 }, { 0x0a, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x63 }, { 0x00, 0x36 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x70 }, { 0x00, 0x07 }, 
  { 0x00, 0x71 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x17 }, 
  { 0x00, 0x64 }, { 0x02, 0x01 }, { 0x00, 0x46 }, { 0x00, 0x72 }, 
  { 0x0a, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x27 }, 
  { 0x02, 0x01 }, { 0x00, 0x55 }, { 0x00, 0x73 }, { 0x02, 0x01 }, 
  { 0x00, 0x37 }, { 0x00, 0x56 }, { 0x08, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x65 }, { 0x00, 0x74 }, { 0x02, 0x01 }, 
  { 0x00, 0x47 }, { 0x00, 0x66 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x75 }, { 0x00, 0x57 }, { 0x02, 0x01 }, { 0x00, 0x76 }, 
  { 0x02, 0x01 }, { 0x00, 0x67 }, { 0x00, 0x77 }
};

static const guchar huffbits_13[511][2] = {
  { 0x02, 0x01 }, { 0x00, 0x00 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x10 }, { 0x02, 0x01 }, { 0x00, 0x01 }, { 0x00, 0x11 }, 
  { 0x1c, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x20 }, { 0x00, 0x02 }, { 0x02, 0x01 }, { 0x00, 0x21 }, 
  { 0x00, 0x12 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x22 }, { 0x00, 0x30 }, { 0x02, 0x01 }, { 0x00, 0x03 }, 
  { 0x00, 0x31 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x13 }, 
  { 0x02, 0x01 }, { 0x00, 0x32 }, { 0x00, 0x23 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x40 }, { 0x00, 0x04 }, { 0x00, 0x41 }, 
  { 0x46, 0x01 }, { 0x1c, 0x01 }, { 0x0e, 0x01 }, { 0x06, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x14 }, { 0x02, 0x01 }, { 0x00, 0x33 }, 
  { 0x00, 0x42 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x24 }, 
  { 0x00, 0x50 }, { 0x02, 0x01 }, { 0x00, 0x43 }, { 0x00, 0x34 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x51 }, { 0x00, 0x15 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x05 }, { 0x00, 0x52 }, 
  { 0x02, 0x01 }, { 0x00, 0x25 }, { 0x02, 0x01 }, { 0x00, 0x44 }, 
  { 0x00, 0x53 }, { 0x0e, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x60 }, { 0x00, 0x06 }, { 0x02, 0x01 }, 
  { 0x00, 0x61 }, { 0x00, 0x16 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x80 }, { 0x00, 0x08 }, { 0x00, 0x81 }, { 0x10, 0x01 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x35 }, 
  { 0x00, 0x62 }, { 0x02, 0x01 }, { 0x00, 0x26 }, { 0x00, 0x54 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x45 }, { 0x00, 0x63 }, 
  { 0x02, 0x01 }, { 0x00, 0x36 }, { 0x00, 0x70 }, { 0x06, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x07 }, { 0x00, 0x55 }, 
  { 0x00, 0x71 }, { 0x02, 0x01 }, { 0x00, 0x17 }, { 0x02, 0x01 }, 
  { 0x00, 0x27 }, { 0x00, 0x37 }, { 0x48, 0x01 }, { 0x18, 0x01 }, 
  { 0x0c, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x18 }, 
  { 0x00, 0x82 }, { 0x02, 0x01 }, { 0x00, 0x28 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x64 }, { 0x00, 0x46 }, { 0x00, 0x72 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x84 }, 
  { 0x00, 0x48 }, { 0x02, 0x01 }, { 0x00, 0x90 }, { 0x00, 0x09 }, 
  { 0x02, 0x01 }, { 0x00, 0x91 }, { 0x00, 0x19 }, { 0x18, 0x01 }, 
  { 0x0e, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x73 }, { 0x00, 0x65 }, { 0x02, 0x01 }, { 0x00, 0x56 }, 
  { 0x00, 0x74 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x47 }, 
  { 0x00, 0x66 }, { 0x00, 0x83 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x38 }, { 0x02, 0x01 }, { 0x00, 0x75 }, { 0x00, 0x57 }, 
  { 0x02, 0x01 }, { 0x00, 0x92 }, { 0x00, 0x29 }, { 0x0e, 0x01 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x67 }, 
  { 0x00, 0x85 }, { 0x02, 0x01 }, { 0x00, 0x58 }, { 0x00, 0x39 }, 
  { 0x02, 0x01 }, { 0x00, 0x93 }, { 0x02, 0x01 }, { 0x00, 0x49 }, 
  { 0x00, 0x86 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xa0 }, 
  { 0x02, 0x01 }, { 0x00, 0x68 }, { 0x00, 0x0a }, { 0x02, 0x01 }, 
  { 0x00, 0xa1 }, { 0x00, 0x1a }, { 0x44, 0x01 }, { 0x18, 0x01 }, 
  { 0x0c, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xa2 }, 
  { 0x00, 0x2a }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x95 }, 
  { 0x00, 0x59 }, { 0x02, 0x01 }, { 0x00, 0xa3 }, { 0x00, 0x3a }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x4a }, 
  { 0x00, 0x96 }, { 0x02, 0x01 }, { 0x00, 0xb0 }, { 0x00, 0x0b }, 
  { 0x02, 0x01 }, { 0x00, 0xb1 }, { 0x00, 0x1b }, { 0x14, 0x01 }, 
  { 0x08, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xb2 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x76 }, { 0x00, 0x77 }, { 0x00, 0x94 }, 
  { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x87 }, 
  { 0x00, 0x78 }, { 0x00, 0xa4 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x69 }, { 0x00, 0xa5 }, { 0x00, 0x2b }, { 0x0c, 0x01 }, 
  { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x5a }, 
  { 0x00, 0x88 }, { 0x00, 0xb3 }, { 0x02, 0x01 }, { 0x00, 0x3b }, 
  { 0x02, 0x01 }, { 0x00, 0x79 }, { 0x00, 0xa6 }, { 0x06, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x6a }, { 0x00, 0xb4 }, 
  { 0x00, 0xc0 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x0c }, 
  { 0x00, 0x98 }, { 0x00, 0xc1 }, { 0x3c, 0x01 }, { 0x16, 0x01 }, 
  { 0x0a, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x1c }, 
  { 0x02, 0x01 }, { 0x00, 0x89 }, { 0x00, 0xb5 }, { 0x02, 0x01 }, 
  { 0x00, 0x5b }, { 0x00, 0xc2 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x2c }, { 0x00, 0x3c }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xb6 }, { 0x00, 0x6b }, { 0x02, 0x01 }, { 0x00, 0xc4 }, 
  { 0x00, 0x4c }, { 0x10, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xa8 }, { 0x00, 0x8a }, { 0x02, 0x01 }, 
  { 0x00, 0xd0 }, { 0x00, 0x0d }, { 0x02, 0x01 }, { 0x00, 0xd1 }, 
  { 0x02, 0x01 }, { 0x00, 0x4b }, { 0x02, 0x01 }, { 0x00, 0x97 }, 
  { 0x00, 0xa7 }, { 0x0c, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xc3 }, { 0x02, 0x01 }, { 0x00, 0x7a }, { 0x00, 0x99 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xc5 }, { 0x00, 0x5c }, 
  { 0x00, 0xb7 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x1d }, 
  { 0x00, 0xd2 }, { 0x02, 0x01 }, { 0x00, 0x2d }, { 0x02, 0x01 }, 
  { 0x00, 0x7b }, { 0x00, 0xd3 }, { 0x34, 0x01 }, { 0x1c, 0x01 }, 
  { 0x0c, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x3d }, 
  { 0x00, 0xc6 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x6c }, 
  { 0x00, 0xa9 }, { 0x02, 0x01 }, { 0x00, 0x9a }, { 0x00, 0xd4 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xb8 }, 
  { 0x00, 0x8b }, { 0x02, 0x01 }, { 0x00, 0x4d }, { 0x00, 0xc7 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x7c }, { 0x00, 0xd5 }, 
  { 0x02, 0x01 }, { 0x00, 0x5d }, { 0x00, 0xe0 }, { 0x0a, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xe1 }, { 0x00, 0x1e }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x0e }, { 0x00, 0x2e }, 
  { 0x00, 0xe2 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xe3 }, { 0x00, 0x6d }, { 0x02, 0x01 }, { 0x00, 0x8c }, 
  { 0x00, 0xe4 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xe5 }, 
  { 0x00, 0xba }, { 0x00, 0xf0 }, { 0x26, 0x01 }, { 0x10, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xf1 }, { 0x00, 0x1f }, 
  { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xaa }, 
  { 0x00, 0x9b }, { 0x00, 0xb9 }, { 0x02, 0x01 }, { 0x00, 0x3e }, 
  { 0x02, 0x01 }, { 0x00, 0xd6 }, { 0x00, 0xc8 }, { 0x0c, 0x01 }, 
  { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x4e }, { 0x02, 0x01 }, 
  { 0x00, 0xd7 }, { 0x00, 0x7d }, { 0x02, 0x01 }, { 0x00, 0xab }, 
  { 0x02, 0x01 }, { 0x00, 0x5e }, { 0x00, 0xc9 }, { 0x06, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x0f }, { 0x02, 0x01 }, { 0x00, 0x9c }, 
  { 0x00, 0x6e }, { 0x02, 0x01 }, { 0x00, 0xf2 }, { 0x00, 0x2f }, 
  { 0x20, 0x01 }, { 0x10, 0x01 }, { 0x06, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xd8 }, { 0x00, 0x8d }, { 0x00, 0x3f }, 
  { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xf3 }, { 0x02, 0x01 }, 
  { 0x00, 0xe6 }, { 0x00, 0xca }, { 0x02, 0x01 }, { 0x00, 0xf4 }, 
  { 0x00, 0x4f }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xbb }, { 0x00, 0xac }, { 0x02, 0x01 }, { 0x00, 0xe7 }, 
  { 0x00, 0xf5 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xd9 }, 
  { 0x00, 0x9d }, { 0x02, 0x01 }, { 0x00, 0x5f }, { 0x00, 0xe8 }, 
  { 0x1e, 0x01 }, { 0x0c, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x6f }, { 0x02, 0x01 }, { 0x00, 0xf6 }, { 0x00, 0xcb }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xbc }, { 0x00, 0xad }, 
  { 0x00, 0xda }, { 0x08, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xf7 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x7e }, { 0x00, 0x7f }, 
  { 0x00, 0x8e }, { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x9e }, { 0x00, 0xae }, { 0x00, 0xcc }, { 0x02, 0x01 }, 
  { 0x00, 0xf8 }, { 0x00, 0x8f }, { 0x12, 0x01 }, { 0x08, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xdb }, { 0x00, 0xbd }, 
  { 0x02, 0x01 }, { 0x00, 0xea }, { 0x00, 0xf9 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x9f }, { 0x00, 0xeb }, { 0x02, 0x01 }, 
  { 0x00, 0xbe }, { 0x02, 0x01 }, { 0x00, 0xcd }, { 0x00, 0xfa }, 
  { 0x0e, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xdd }, 
  { 0x00, 0xec }, { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xe9 }, { 0x00, 0xaf }, { 0x00, 0xdc }, { 0x02, 0x01 }, 
  { 0x00, 0xce }, { 0x00, 0xfb }, { 0x08, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xbf }, { 0x00, 0xde }, { 0x02, 0x01 }, 
  { 0x00, 0xcf }, { 0x00, 0xee }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xdf }, { 0x00, 0xef }, { 0x02, 0x01 }, { 0x00, 0xff }, 
  { 0x02, 0x01 }, { 0x00, 0xed }, { 0x02, 0x01 }, { 0x00, 0xfd }, 
  { 0x02, 0x01 }, { 0x00, 0xfc }, { 0x00, 0xfe }
};

static const guchar huffbits_15[511][2] = {
  { 0x10, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x00 }, 
  { 0x02, 0x01 }, { 0x00, 0x10 }, { 0x00, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x11 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x20 }, 
  { 0x00, 0x02 }, { 0x02, 0x01 }, { 0x00, 0x21 }, { 0x00, 0x12 }, 
  { 0x32, 0x01 }, { 0x10, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x22 }, { 0x02, 0x01 }, { 0x00, 0x30 }, { 0x00, 0x31 }, 
  { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x13 }, { 0x02, 0x01 }, 
  { 0x00, 0x03 }, { 0x00, 0x40 }, { 0x02, 0x01 }, { 0x00, 0x32 }, 
  { 0x00, 0x23 }, { 0x0e, 0x01 }, { 0x06, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x04 }, { 0x00, 0x14 }, { 0x00, 0x41 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x33 }, { 0x00, 0x42 }, 
  { 0x02, 0x01 }, { 0x00, 0x24 }, { 0x00, 0x43 }, { 0x0a, 0x01 }, 
  { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x34 }, { 0x02, 0x01 }, 
  { 0x00, 0x50 }, { 0x00, 0x05 }, { 0x02, 0x01 }, { 0x00, 0x51 }, 
  { 0x00, 0x15 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x52 }, 
  { 0x00, 0x25 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x44 }, 
  { 0x00, 0x53 }, { 0x00, 0x61 }, { 0x5a, 0x01 }, { 0x24, 0x01 }, 
  { 0x12, 0x01 }, { 0x0a, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x35 }, { 0x02, 0x01 }, { 0x00, 0x60 }, { 0x00, 0x06 }, 
  { 0x02, 0x01 }, { 0x00, 0x16 }, { 0x00, 0x62 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x26 }, { 0x00, 0x54 }, { 0x02, 0x01 }, 
  { 0x00, 0x45 }, { 0x00, 0x63 }, { 0x0a, 0x01 }, { 0x06, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x36 }, { 0x02, 0x01 }, { 0x00, 0x70 }, 
  { 0x00, 0x07 }, { 0x02, 0x01 }, { 0x00, 0x71 }, { 0x00, 0x55 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x17 }, { 0x00, 0x64 }, 
  { 0x02, 0x01 }, { 0x00, 0x72 }, { 0x00, 0x27 }, { 0x18, 0x01 }, 
  { 0x10, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x46 }, { 0x00, 0x73 }, { 0x02, 0x01 }, { 0x00, 0x37 }, 
  { 0x00, 0x65 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x56 }, 
  { 0x00, 0x80 }, { 0x02, 0x01 }, { 0x00, 0x08 }, { 0x00, 0x74 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x81 }, { 0x00, 0x18 }, 
  { 0x02, 0x01 }, { 0x00, 0x82 }, { 0x00, 0x28 }, { 0x10, 0x01 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x47 }, 
  { 0x00, 0x66 }, { 0x02, 0x01 }, { 0x00, 0x83 }, { 0x00, 0x38 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x75 }, { 0x00, 0x57 }, 
  { 0x02, 0x01 }, { 0x00, 0x84 }, { 0x00, 0x48 }, { 0x06, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x90 }, { 0x00, 0x19 }, 
  { 0x00, 0x91 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x92 }, 
  { 0x00, 0x76 }, { 0x02, 0x01 }, { 0x00, 0x67 }, { 0x00, 0x29 }, 
  { 0x5c, 0x01 }, { 0x24, 0x01 }, { 0x12, 0x01 }, { 0x0a, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x85 }, { 0x00, 0x58 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x09 }, { 0x00, 0x77 }, 
  { 0x00, 0x93 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x39 }, 
  { 0x00, 0x94 }, { 0x02, 0x01 }, { 0x00, 0x49 }, { 0x00, 0x86 }, 
  { 0x0a, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x68 }, 
  { 0x02, 0x01 }, { 0x00, 0xa0 }, { 0x00, 0x0a }, { 0x02, 0x01 }, 
  { 0x00, 0xa1 }, { 0x00, 0x1a }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xa2 }, { 0x00, 0x2a }, { 0x02, 0x01 }, { 0x00, 0x95 }, 
  { 0x00, 0x59 }, { 0x1a, 0x01 }, { 0x0e, 0x01 }, { 0x06, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xa3 }, { 0x02, 0x01 }, { 0x00, 0x3a }, 
  { 0x00, 0x87 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x78 }, 
  { 0x00, 0xa4 }, { 0x02, 0x01 }, { 0x00, 0x4a }, { 0x00, 0x96 }, 
  { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x69 }, 
  { 0x00, 0xb0 }, { 0x00, 0xb1 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x1b }, { 0x00, 0xa5 }, { 0x00, 0xb2 }, { 0x0e, 0x01 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x5a }, 
  { 0x00, 0x2b }, { 0x02, 0x01 }, { 0x00, 0x88 }, { 0x00, 0x97 }, 
  { 0x02, 0x01 }, { 0x00, 0xb3 }, { 0x02, 0x01 }, { 0x00, 0x79 }, 
  { 0x00, 0x3b }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x6a }, { 0x00, 0xb4 }, { 0x02, 0x01 }, { 0x00, 0x4b }, 
  { 0x00, 0xc1 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x98 }, 
  { 0x00, 0x89 }, { 0x02, 0x01 }, { 0x00, 0x1c }, { 0x00, 0xb5 }, 
  { 0x50, 0x01 }, { 0x22, 0x01 }, { 0x10, 0x01 }, { 0x06, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x5b }, { 0x00, 0x2c }, 
  { 0x00, 0xc2 }, { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x0b }, { 0x00, 0xc0 }, { 0x00, 0xa6 }, { 0x02, 0x01 }, 
  { 0x00, 0xa7 }, { 0x00, 0x7a }, { 0x0a, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xc3 }, { 0x00, 0x3c }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x0c }, { 0x00, 0x99 }, { 0x00, 0xb6 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x6b }, { 0x00, 0xc4 }, 
  { 0x02, 0x01 }, { 0x00, 0x4c }, { 0x00, 0xa8 }, { 0x14, 0x01 }, 
  { 0x0a, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x8a }, 
  { 0x00, 0xc5 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xd0 }, 
  { 0x00, 0x5c }, { 0x00, 0xd1 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xb7 }, { 0x00, 0x7b }, { 0x02, 0x01 }, { 0x00, 0x1d }, 
  { 0x02, 0x01 }, { 0x00, 0x0d }, { 0x00, 0x2d }, { 0x0c, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xd2 }, { 0x00, 0xd3 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x3d }, { 0x00, 0xc6 }, 
  { 0x02, 0x01 }, { 0x00, 0x6c }, { 0x00, 0xa9 }, { 0x06, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x9a }, { 0x00, 0xb8 }, 
  { 0x00, 0xd4 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x8b }, 
  { 0x00, 0x4d }, { 0x02, 0x01 }, { 0x00, 0xc7 }, { 0x00, 0x7c }, 
  { 0x44, 0x01 }, { 0x22, 0x01 }, { 0x12, 0x01 }, { 0x0a, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xd5 }, { 0x00, 0x5d }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xe0 }, { 0x00, 0x0e }, 
  { 0x00, 0xe1 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x1e }, 
  { 0x00, 0xe2 }, { 0x02, 0x01 }, { 0x00, 0xaa }, { 0x00, 0x2e }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xb9 }, 
  { 0x00, 0x9b }, { 0x02, 0x01 }, { 0x00, 0xe3 }, { 0x00, 0xd6 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x6d }, { 0x00, 0x3e }, 
  { 0x02, 0x01 }, { 0x00, 0xc8 }, { 0x00, 0x8c }, { 0x10, 0x01 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xe4 }, 
  { 0x00, 0x4e }, { 0x02, 0x01 }, { 0x00, 0xd7 }, { 0x00, 0x7d }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xe5 }, { 0x00, 0xba }, 
  { 0x02, 0x01 }, { 0x00, 0xab }, { 0x00, 0x5e }, { 0x08, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xc9 }, { 0x00, 0x9c }, 
  { 0x02, 0x01 }, { 0x00, 0xf1 }, { 0x00, 0x1f }, { 0x06, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xf0 }, { 0x00, 0x6e }, 
  { 0x00, 0xf2 }, { 0x02, 0x01 }, { 0x00, 0x2f }, { 0x00, 0xe6 }, 
  { 0x26, 0x01 }, { 0x12, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xd8 }, { 0x00, 0xf3 }, { 0x02, 0x01 }, 
  { 0x00, 0x3f }, { 0x00, 0xf4 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x4f }, { 0x02, 0x01 }, { 0x00, 0x8d }, { 0x00, 0xd9 }, 
  { 0x02, 0x01 }, { 0x00, 0xbb }, { 0x00, 0xca }, { 0x08, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xac }, { 0x00, 0xe7 }, 
  { 0x02, 0x01 }, { 0x00, 0x7e }, { 0x00, 0xf5 }, { 0x08, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x9d }, { 0x00, 0x5f }, 
  { 0x02, 0x01 }, { 0x00, 0xe8 }, { 0x00, 0x8e }, { 0x02, 0x01 }, 
  { 0x00, 0xf6 }, { 0x00, 0xcb }, { 0x22, 0x01 }, { 0x12, 0x01 }, 
  { 0x0a, 0x01 }, { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x0f }, { 0x00, 0xae }, { 0x00, 0x6f }, { 0x02, 0x01 }, 
  { 0x00, 0xbc }, { 0x00, 0xda }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xad }, { 0x00, 0xf7 }, { 0x02, 0x01 }, { 0x00, 0x7f }, 
  { 0x00, 0xe9 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x9e }, { 0x00, 0xcc }, { 0x02, 0x01 }, { 0x00, 0xf8 }, 
  { 0x00, 0x8f }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xdb }, 
  { 0x00, 0xbd }, { 0x02, 0x01 }, { 0x00, 0xea }, { 0x00, 0xf9 }, 
  { 0x10, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x9f }, { 0x00, 0xdc }, { 0x02, 0x01 }, { 0x00, 0xcd }, 
  { 0x00, 0xeb }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xbe }, 
  { 0x00, 0xfa }, { 0x02, 0x01 }, { 0x00, 0xaf }, { 0x00, 0xdd }, 
  { 0x0e, 0x01 }, { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xec }, { 0x00, 0xce }, { 0x00, 0xfb }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xbf }, { 0x00, 0xed }, { 0x02, 0x01 }, 
  { 0x00, 0xde }, { 0x00, 0xfc }, { 0x06, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xcf }, { 0x00, 0xfd }, { 0x00, 0xee }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xdf }, { 0x00, 0xfe }, 
  { 0x02, 0x01 }, { 0x00, 0xef }, { 0x00, 0xff }
};

static const guchar huffbits_16[511][2] = {
  { 0x02, 0x01 }, { 0x00, 0x00 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x10 }, { 0x02, 0x01 }, { 0x00, 0x01 }, { 0x00, 0x11 }, 
  { 0x2a, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x20 }, { 0x00, 0x02 }, { 0x02, 0x01 }, { 0x00, 0x21 }, 
  { 0x00, 0x12 }, { 0x0a, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x22 }, { 0x02, 0x01 }, { 0x00, 0x30 }, { 0x00, 0x03 }, 
  { 0x02, 0x01 }, { 0x00, 0x31 }, { 0x00, 0x13 }, { 0x0a, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x32 }, { 0x00, 0x23 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x40 }, { 0x00, 0x04 }, 
  { 0x00, 0x41 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x14 }, 
  { 0x02, 0x01 }, { 0x00, 0x33 }, { 0x00, 0x42 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x24 }, { 0x00, 0x50 }, { 0x02, 0x01 }, 
  { 0x00, 0x43 }, { 0x00, 0x34 }, { 0x8a, 0x01 }, { 0x28, 0x01 }, 
  { 0x10, 0x01 }, { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x05 }, { 0x00, 0x15 }, { 0x00, 0x51 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x52 }, { 0x00, 0x25 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x44 }, { 0x00, 0x35 }, { 0x00, 0x53 }, 
  { 0x0a, 0x01 }, { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x60 }, { 0x00, 0x06 }, { 0x00, 0x61 }, { 0x02, 0x01 }, 
  { 0x00, 0x16 }, { 0x00, 0x62 }, { 0x08, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x26 }, { 0x00, 0x54 }, { 0x02, 0x01 }, 
  { 0x00, 0x45 }, { 0x00, 0x63 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x36 }, { 0x00, 0x70 }, { 0x00, 0x71 }, { 0x28, 0x01 }, 
  { 0x12, 0x01 }, { 0x08, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x17 }, 
  { 0x02, 0x01 }, { 0x00, 0x07 }, { 0x02, 0x01 }, { 0x00, 0x55 }, 
  { 0x00, 0x64 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x72 }, 
  { 0x00, 0x27 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x46 }, 
  { 0x00, 0x65 }, { 0x00, 0x73 }, { 0x0a, 0x01 }, { 0x06, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x37 }, { 0x02, 0x01 }, { 0x00, 0x56 }, 
  { 0x00, 0x08 }, { 0x02, 0x01 }, { 0x00, 0x80 }, { 0x00, 0x81 }, 
  { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x18 }, { 0x02, 0x01 }, 
  { 0x00, 0x74 }, { 0x00, 0x47 }, { 0x02, 0x01 }, { 0x00, 0x82 }, 
  { 0x02, 0x01 }, { 0x00, 0x28 }, { 0x00, 0x66 }, { 0x18, 0x01 }, 
  { 0x0e, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x83 }, { 0x00, 0x38 }, { 0x02, 0x01 }, { 0x00, 0x75 }, 
  { 0x00, 0x84 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x48 }, 
  { 0x00, 0x90 }, { 0x00, 0x91 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x19 }, { 0x02, 0x01 }, { 0x00, 0x09 }, { 0x00, 0x76 }, 
  { 0x02, 0x01 }, { 0x00, 0x92 }, { 0x00, 0x29 }, { 0x0e, 0x01 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x85 }, 
  { 0x00, 0x58 }, { 0x02, 0x01 }, { 0x00, 0x93 }, { 0x00, 0x39 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xa0 }, { 0x00, 0x0a }, 
  { 0x00, 0x1a }, { 0x08, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xa2 }, 
  { 0x02, 0x01 }, { 0x00, 0x67 }, { 0x02, 0x01 }, { 0x00, 0x57 }, 
  { 0x00, 0x49 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x94 }, 
  { 0x02, 0x01 }, { 0x00, 0x77 }, { 0x00, 0x86 }, { 0x02, 0x01 }, 
  { 0x00, 0xa1 }, { 0x02, 0x01 }, { 0x00, 0x68 }, { 0x00, 0x95 }, 
  { 0xdc, 0x01 }, { 0x7e, 0x01 }, { 0x32, 0x01 }, { 0x1a, 0x01 }, 
  { 0x0c, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x2a }, 
  { 0x02, 0x01 }, { 0x00, 0x59 }, { 0x00, 0x3a }, { 0x02, 0x01 }, 
  { 0x00, 0xa3 }, { 0x02, 0x01 }, { 0x00, 0x87 }, { 0x00, 0x78 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xa4 }, 
  { 0x00, 0x4a }, { 0x02, 0x01 }, { 0x00, 0x96 }, { 0x00, 0x69 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xb0 }, { 0x00, 0x0b }, 
  { 0x00, 0xb1 }, { 0x0a, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x1b }, { 0x00, 0xb2 }, { 0x02, 0x01 }, { 0x00, 0x2b }, 
  { 0x02, 0x01 }, { 0x00, 0xa5 }, { 0x00, 0x5a }, { 0x06, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xb3 }, { 0x02, 0x01 }, { 0x00, 0xa6 }, 
  { 0x00, 0x6a }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xb4 }, 
  { 0x00, 0x4b }, { 0x02, 0x01 }, { 0x00, 0x0c }, { 0x00, 0xc1 }, 
  { 0x1e, 0x01 }, { 0x0e, 0x01 }, { 0x06, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xb5 }, { 0x00, 0xc2 }, { 0x00, 0x2c }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xa7 }, { 0x00, 0xc3 }, 
  { 0x02, 0x01 }, { 0x00, 0x6b }, { 0x00, 0xc4 }, { 0x08, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x1d }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x88 }, { 0x00, 0x97 }, { 0x00, 0x3b }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xd1 }, { 0x00, 0xd2 }, { 0x02, 0x01 }, 
  { 0x00, 0x2d }, { 0x00, 0xd3 }, { 0x12, 0x01 }, { 0x06, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x1e }, { 0x00, 0x2e }, 
  { 0x00, 0xe2 }, { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x79 }, { 0x00, 0x98 }, { 0x00, 0xc0 }, { 0x02, 0x01 }, 
  { 0x00, 0x1c }, { 0x02, 0x01 }, { 0x00, 0x89 }, { 0x00, 0x5b }, 
  { 0x0e, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x3c }, 
  { 0x02, 0x01 }, { 0x00, 0x7a }, { 0x00, 0xb6 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x4c }, { 0x00, 0x99 }, { 0x02, 0x01 }, 
  { 0x00, 0xa8 }, { 0x00, 0x8a }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x0d }, { 0x02, 0x01 }, { 0x00, 0xc5 }, { 0x00, 0x5c }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x3d }, { 0x00, 0xc6 }, 
  { 0x02, 0x01 }, { 0x00, 0x6c }, { 0x00, 0x9a }, { 0x58, 0x01 }, 
  { 0x56, 0x01 }, { 0x24, 0x01 }, { 0x10, 0x01 }, { 0x08, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x8b }, { 0x00, 0x4d }, 
  { 0x02, 0x01 }, { 0x00, 0xc7 }, { 0x00, 0x7c }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xd5 }, { 0x00, 0x5d }, { 0x02, 0x01 }, 
  { 0x00, 0xe0 }, { 0x00, 0x0e }, { 0x08, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xe3 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xd0 }, 
  { 0x00, 0xb7 }, { 0x00, 0x7b }, { 0x06, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xa9 }, { 0x00, 0xb8 }, { 0x00, 0xd4 }, 
  { 0x02, 0x01 }, { 0x00, 0xe1 }, { 0x02, 0x01 }, { 0x00, 0xaa }, 
  { 0x00, 0xb9 }, { 0x18, 0x01 }, { 0x0a, 0x01 }, { 0x06, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x9b }, { 0x00, 0xd6 }, 
  { 0x00, 0x6d }, { 0x02, 0x01 }, { 0x00, 0x3e }, { 0x00, 0xc8 }, 
  { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x8c }, 
  { 0x00, 0xe4 }, { 0x00, 0x4e }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xd7 }, { 0x00, 0xe5 }, { 0x02, 0x01 }, { 0x00, 0xba }, 
  { 0x00, 0xab }, { 0x0c, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x9c }, { 0x00, 0xe6 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x6e }, { 0x00, 0xd8 }, { 0x02, 0x01 }, { 0x00, 0x8d }, 
  { 0x00, 0xbb }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xe7 }, { 0x00, 0x9d }, { 0x02, 0x01 }, { 0x00, 0xe8 }, 
  { 0x00, 0x8e }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xcb }, 
  { 0x00, 0xbc }, { 0x00, 0x9e }, { 0x00, 0xf1 }, { 0x02, 0x01 }, 
  { 0x00, 0x1f }, { 0x02, 0x01 }, { 0x00, 0x0f }, { 0x00, 0x2f }, 
  { 0x42, 0x01 }, { 0x38, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xf2 }, 
  { 0x34, 0x01 }, { 0x32, 0x01 }, { 0x14, 0x01 }, { 0x08, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xbd }, { 0x02, 0x01 }, { 0x00, 0x5e }, 
  { 0x02, 0x01 }, { 0x00, 0x7d }, { 0x00, 0xc9 }, { 0x06, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xca }, { 0x02, 0x01 }, { 0x00, 0xac }, 
  { 0x00, 0x7e }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xda }, 
  { 0x00, 0xad }, { 0x00, 0xcc }, { 0x0a, 0x01 }, { 0x06, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xae }, { 0x02, 0x01 }, { 0x00, 0xdb }, 
  { 0x00, 0xdc }, { 0x02, 0x01 }, { 0x00, 0xcd }, { 0x00, 0xbe }, 
  { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xeb }, 
  { 0x00, 0xed }, { 0x00, 0xee }, { 0x06, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xd9 }, { 0x00, 0xea }, { 0x00, 0xe9 }, 
  { 0x02, 0x01 }, { 0x00, 0xde }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xdd }, { 0x00, 0xec }, { 0x00, 0xce }, { 0x00, 0x3f }, 
  { 0x00, 0xf0 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xf3 }, 
  { 0x00, 0xf4 }, { 0x02, 0x01 }, { 0x00, 0x4f }, { 0x02, 0x01 }, 
  { 0x00, 0xf5 }, { 0x00, 0x5f }, { 0x0a, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xff }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xf6 }, 
  { 0x00, 0x6f }, { 0x02, 0x01 }, { 0x00, 0xf7 }, { 0x00, 0x7f }, 
  { 0x0c, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x8f }, 
  { 0x02, 0x01 }, { 0x00, 0xf8 }, { 0x00, 0xf9 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x9f }, { 0x00, 0xfa }, { 0x00, 0xaf }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xfb }, 
  { 0x00, 0xbf }, { 0x02, 0x01 }, { 0x00, 0xfc }, { 0x00, 0xcf }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xfd }, { 0x00, 0xdf }, 
  { 0x02, 0x01 }, { 0x00, 0xfe }, { 0x00, 0xef }
};

static const guchar huffbits_24[512][2] = {
  { 0x3c, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x00 }, { 0x00, 0x10 }, { 0x02, 0x01 }, { 0x00, 0x01 }, 
  { 0x00, 0x11 }, { 0x0e, 0x01 }, { 0x06, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x20 }, { 0x00, 0x02 }, { 0x00, 0x21 }, 
  { 0x02, 0x01 }, { 0x00, 0x12 }, { 0x02, 0x01 }, { 0x00, 0x22 }, 
  { 0x02, 0x01 }, { 0x00, 0x30 }, { 0x00, 0x03 }, { 0x0e, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x31 }, { 0x00, 0x13 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x32 }, { 0x00, 0x23 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x40 }, { 0x00, 0x04 }, 
  { 0x00, 0x41 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x14 }, { 0x00, 0x33 }, { 0x02, 0x01 }, { 0x00, 0x42 }, 
  { 0x00, 0x24 }, { 0x06, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x43 }, { 0x00, 0x34 }, { 0x00, 0x51 }, { 0x06, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x50 }, { 0x00, 0x05 }, 
  { 0x00, 0x15 }, { 0x02, 0x01 }, { 0x00, 0x52 }, { 0x00, 0x25 }, 
  { 0xfa, 0x01 }, { 0x62, 0x01 }, { 0x22, 0x01 }, { 0x12, 0x01 }, 
  { 0x0a, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x44 }, 
  { 0x00, 0x53 }, { 0x02, 0x01 }, { 0x00, 0x35 }, { 0x02, 0x01 }, 
  { 0x00, 0x60 }, { 0x00, 0x06 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x61 }, { 0x00, 0x16 }, { 0x02, 0x01 }, { 0x00, 0x62 }, 
  { 0x00, 0x26 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x54 }, { 0x00, 0x45 }, { 0x02, 0x01 }, { 0x00, 0x63 }, 
  { 0x00, 0x36 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x71 }, 
  { 0x00, 0x55 }, { 0x02, 0x01 }, { 0x00, 0x64 }, { 0x00, 0x46 }, 
  { 0x20, 0x01 }, { 0x0e, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x72 }, { 0x02, 0x01 }, { 0x00, 0x27 }, { 0x00, 0x37 }, 
  { 0x02, 0x01 }, { 0x00, 0x73 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x70 }, { 0x00, 0x07 }, { 0x00, 0x17 }, { 0x0a, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x65 }, { 0x00, 0x56 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x80 }, { 0x00, 0x08 }, 
  { 0x00, 0x81 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x74 }, 
  { 0x00, 0x47 }, { 0x02, 0x01 }, { 0x00, 0x18 }, { 0x00, 0x82 }, 
  { 0x10, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x28 }, { 0x00, 0x66 }, { 0x02, 0x01 }, { 0x00, 0x83 }, 
  { 0x00, 0x38 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x75 }, 
  { 0x00, 0x57 }, { 0x02, 0x01 }, { 0x00, 0x84 }, { 0x00, 0x48 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x91 }, 
  { 0x00, 0x19 }, { 0x02, 0x01 }, { 0x00, 0x92 }, { 0x00, 0x76 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x67 }, { 0x00, 0x29 }, 
  { 0x02, 0x01 }, { 0x00, 0x85 }, { 0x00, 0x58 }, { 0x5c, 0x01 }, 
  { 0x22, 0x01 }, { 0x10, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x93 }, { 0x00, 0x39 }, { 0x02, 0x01 }, 
  { 0x00, 0x94 }, { 0x00, 0x49 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x77 }, { 0x00, 0x86 }, { 0x02, 0x01 }, { 0x00, 0x68 }, 
  { 0x00, 0xa1 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xa2 }, { 0x00, 0x2a }, { 0x02, 0x01 }, { 0x00, 0x95 }, 
  { 0x00, 0x59 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xa3 }, 
  { 0x00, 0x3a }, { 0x02, 0x01 }, { 0x00, 0x87 }, { 0x02, 0x01 }, 
  { 0x00, 0x78 }, { 0x00, 0x4a }, { 0x16, 0x01 }, { 0x0c, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xa4 }, { 0x00, 0x96 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x69 }, { 0x00, 0xb1 }, 
  { 0x02, 0x01 }, { 0x00, 0x1b }, { 0x00, 0xa5 }, { 0x06, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xb2 }, { 0x02, 0x01 }, { 0x00, 0x5a }, 
  { 0x00, 0x2b }, { 0x02, 0x01 }, { 0x00, 0x88 }, { 0x00, 0xb3 }, 
  { 0x10, 0x01 }, { 0x0a, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x90 }, { 0x02, 0x01 }, { 0x00, 0x09 }, { 0x00, 0xa0 }, 
  { 0x02, 0x01 }, { 0x00, 0x97 }, { 0x00, 0x79 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xa6 }, { 0x00, 0x6a }, { 0x00, 0xb4 }, 
  { 0x0c, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x1a }, 
  { 0x02, 0x01 }, { 0x00, 0x0a }, { 0x00, 0xb0 }, { 0x02, 0x01 }, 
  { 0x00, 0x3b }, { 0x02, 0x01 }, { 0x00, 0x0b }, { 0x00, 0xc0 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x4b }, { 0x00, 0xc1 }, 
  { 0x02, 0x01 }, { 0x00, 0x98 }, { 0x00, 0x89 }, { 0x43, 0x01 }, 
  { 0x22, 0x01 }, { 0x10, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x1c }, { 0x00, 0xb5 }, { 0x02, 0x01 }, 
  { 0x00, 0x5b }, { 0x00, 0xc2 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x2c }, { 0x00, 0xa7 }, { 0x02, 0x01 }, { 0x00, 0x7a }, 
  { 0x00, 0xc3 }, { 0x0a, 0x01 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x3c }, { 0x02, 0x01 }, { 0x00, 0x0c }, { 0x00, 0xd0 }, 
  { 0x02, 0x01 }, { 0x00, 0xb6 }, { 0x00, 0x6b }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xc4 }, { 0x00, 0x4c }, { 0x02, 0x01 }, 
  { 0x00, 0x99 }, { 0x00, 0xa8 }, { 0x10, 0x01 }, { 0x08, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x8a }, { 0x00, 0xc5 }, 
  { 0x02, 0x01 }, { 0x00, 0x5c }, { 0x00, 0xd1 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xb7 }, { 0x00, 0x7b }, { 0x02, 0x01 }, 
  { 0x00, 0x1d }, { 0x00, 0xd2 }, { 0x09, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x2d }, { 0x00, 0xd3 }, { 0x02, 0x01 }, 
  { 0x00, 0x3d }, { 0x00, 0xc6 }, { 0x55, 0xfa }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x6c }, { 0x00, 0xa9 }, { 0x02, 0x01 }, 
  { 0x00, 0x9a }, { 0x00, 0xd4 }, { 0x20, 0x01 }, { 0x10, 0x01 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xb8 }, 
  { 0x00, 0x8b }, { 0x02, 0x01 }, { 0x00, 0x4d }, { 0x00, 0xc7 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x7c }, { 0x00, 0xd5 }, 
  { 0x02, 0x01 }, { 0x00, 0x5d }, { 0x00, 0xe1 }, { 0x08, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x1e }, { 0x00, 0xe2 }, 
  { 0x02, 0x01 }, { 0x00, 0xaa }, { 0x00, 0xb9 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x9b }, { 0x00, 0xe3 }, { 0x02, 0x01 }, 
  { 0x00, 0xd6 }, { 0x00, 0x6d }, { 0x14, 0x01 }, { 0x0a, 0x01 }, 
  { 0x06, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x3e }, { 0x02, 0x01 }, 
  { 0x00, 0x2e }, { 0x00, 0x4e }, { 0x02, 0x01 }, { 0x00, 0xc8 }, 
  { 0x00, 0x8c }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xe4 }, 
  { 0x00, 0xd7 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x7d }, 
  { 0x00, 0xab }, { 0x00, 0xe5 }, { 0x0a, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xba }, { 0x00, 0x5e }, { 0x02, 0x01 }, 
  { 0x00, 0xc9 }, { 0x02, 0x01 }, { 0x00, 0x9c }, { 0x00, 0x6e }, 
  { 0x08, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xe6 }, { 0x02, 0x01 }, 
  { 0x00, 0x0d }, { 0x02, 0x01 }, { 0x00, 0xe0 }, { 0x00, 0x0e }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xd8 }, { 0x00, 0x8d }, 
  { 0x02, 0x01 }, { 0x00, 0xbb }, { 0x00, 0xca }, { 0x4a, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xff }, { 0x40, 0x01 }, { 0x3a, 0x01 }, 
  { 0x20, 0x01 }, { 0x10, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xac }, { 0x00, 0xe7 }, { 0x02, 0x01 }, 
  { 0x00, 0x7e }, { 0x00, 0xd9 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x9d }, { 0x00, 0xe8 }, { 0x02, 0x01 }, { 0x00, 0x8e }, 
  { 0x00, 0xcb }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xbc }, { 0x00, 0xda }, { 0x02, 0x01 }, { 0x00, 0xad }, 
  { 0x00, 0xe9 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x9e }, 
  { 0x00, 0xcc }, { 0x02, 0x01 }, { 0x00, 0xdb }, { 0x00, 0xbd }, 
  { 0x10, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xea }, { 0x00, 0xae }, { 0x02, 0x01 }, { 0x00, 0xdc }, 
  { 0x00, 0xcd }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xeb }, 
  { 0x00, 0xbe }, { 0x02, 0x01 }, { 0x00, 0xdd }, { 0x00, 0xec }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xce }, 
  { 0x00, 0xed }, { 0x02, 0x01 }, { 0x00, 0xde }, { 0x00, 0xee }, 
  { 0x00, 0x0f }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xf0 }, 
  { 0x00, 0x1f }, { 0x00, 0xf1 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xf2 }, { 0x00, 0x2f }, { 0x02, 0x01 }, { 0x00, 0xf3 }, 
  { 0x00, 0x3f }, { 0x12, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0xf4 }, { 0x00, 0x4f }, { 0x02, 0x01 }, 
  { 0x00, 0xf5 }, { 0x00, 0x5f }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xf6 }, { 0x00, 0x6f }, { 0x02, 0x01 }, { 0x00, 0xf7 }, 
  { 0x02, 0x01 }, { 0x00, 0x7f }, { 0x00, 0x8f }, { 0x0a, 0x01 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xf8 }, { 0x00, 0xf9 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x9f }, { 0x00, 0xaf }, 
  { 0x00, 0xfa }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0xfb }, { 0x00, 0xbf }, { 0x02, 0x01 }, { 0x00, 0xfc }, 
  { 0x00, 0xcf }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0xfd }, 
  { 0x00, 0xdf }, { 0x02, 0x01 }, { 0x00, 0xfe }, { 0x00, 0xef }
  
};

static const guchar huffbits_32[31][2] = {
  { 0x02, 0x01 }, { 0x00, 0x00 }, { 0x08, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x08 }, { 0x00, 0x04 }, { 0x02, 0x01 }, 
  { 0x00, 0x01 }, { 0x00, 0x02 }, { 0x08, 0x01 }, { 0x04, 0x01 }, 
  { 0x02, 0x01 }, { 0x00, 0x0c }, { 0x00, 0x0a }, { 0x02, 0x01 }, 
  { 0x00, 0x03 }, { 0x00, 0x06 }, { 0x06, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x09 }, { 0x02, 0x01 }, { 0x00, 0x05 }, { 0x00, 0x07 }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x0e }, { 0x00, 0x0d }, 
  { 0x02, 0x01 }, { 0x00, 0x0f }, { 0x00, 0x0b }
};

static const guchar huffbits_33[31][2] = {
  { 0x10, 0x01 }, { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, 
  { 0x00, 0x00 }, { 0x00, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x02 }, 
  { 0x00, 0x03 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x04 }, 
  { 0x00, 0x05 }, { 0x02, 0x01 }, { 0x00, 0x06 }, { 0x00, 0x07 }, 
  { 0x08, 0x01 }, { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x08 }, 
  { 0x00, 0x09 }, { 0x02, 0x01 }, { 0x00, 0x0a }, { 0x00, 0x0b }, 
  { 0x04, 0x01 }, { 0x02, 0x01 }, { 0x00, 0x0c }, { 0x00, 0x0d }, 
  { 0x02, 0x01 }, { 0x00, 0x0e }, { 0x00, 0x0f }
};

/* Array of decoder table structures */
static const struct huffcodetab huff_tables[] = {
  /* 0 */ {0, 0, 0, 0, FALSE, NULL },
  /* 1 */ {7, 2, 2, 0, FALSE, huffbits_1 },
  /* 2 */ {17, 3, 3, 0, FALSE, huffbits_2 },
  /* 3 */ {17, 3, 3, 0, FALSE, huffbits_3 },
  /* 4 */ {0, 0, 0, 0, FALSE, NULL },
  /* 5 */ {31, 4, 4, 0, FALSE, huffbits_5 },
  /* 6 */ {31, 4, 4, 0, FALSE, huffbits_6 } ,
  /* 7 */ {71, 6, 6, 0, FALSE, huffbits_7 },
  /* 8 */ {71, 6, 6, 0, FALSE, huffbits_8 },
  /* 9 */ {71, 6, 6, 0, FALSE, huffbits_9 },
  /* 10 */ {127, 8, 8, 0, FALSE, huffbits_10 },
  /* 11 */ {127, 8, 8, 0, FALSE, huffbits_11 },
  /* 12 */ {127, 8, 8, 0, FALSE, huffbits_12 },
  /* 13 */ {511, 16, 16, 0, FALSE, huffbits_13 },
  /* 14 */ {0, 0, 0, 0, FALSE, NULL },
  /* 15 */ {511, 16, 16, 0, FALSE, huffbits_15 },
  /* 16 */ {511, 16, 16, 1, FALSE, huffbits_16 },
  /* 17 */ {511, 16, 16, 2, FALSE, huffbits_16 },
  /* 18 */ {511, 16, 16, 3, FALSE, huffbits_16 },
  /* 19 */ {511, 16, 16, 4, FALSE, huffbits_16 },
  /* 20 */ {511, 16, 16, 6, FALSE, huffbits_16 },
  /* 21 */ {511, 16, 16, 8, FALSE, huffbits_16 },
  /* 22 */ {511, 16, 16, 10, FALSE, huffbits_16 },
  /* 23 */ {511, 16, 16, 13, FALSE, huffbits_16 },
  /* 24 */ {512, 16, 16, 4, FALSE, huffbits_24 },
  /* 25 */ {512, 16, 16, 5, FALSE, huffbits_24 },
  /* 26 */ {512, 16, 16, 6, FALSE, huffbits_24 },
  /* 27 */ {512, 16, 16, 7, FALSE, huffbits_24 },
  /* 28 */ {512, 16, 16, 8, FALSE, huffbits_24 },
  /* 29 */ {512, 16, 16, 9, FALSE, huffbits_24 },
  /* 30 */ {512, 16, 16, 11, FALSE, huffbits_24 },
  /* 31 */ {512, 16, 16, 13, FALSE, huffbits_24 },
  /* 32 */ {31, 1, 16, 0, TRUE, huffbits_32 },
  /* 33 */ {31, 1, 16, 0, TRUE, huffbits_33 }
};

#endif
