/* GStreamer multi process transform
 * Copyright (C) <2007> Mark Nauwelaerts <mnauw@users.sourceforge.net>

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1307, USA.
 */


#ifndef __GST_MULTI_PROC_TRANS_H__
#define __GST_MULTI_PROC_TRANS_H__

#include <gst/gst.h>
#include <gst/base/gstadapter.h>
#include <gst/controller/gstcontroller.h>

#define GST_TYPE_MULTI_PROC_TRANS \
  gst_multi_proc_trans_get_type ()
#define GST_MULTI_PROC_TRANS(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GST_TYPE_MULTI_PROC_TRANS, GstMultiProcTrans))
#define GST_MULTI_PROC_TRANS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), GST_TYPE_MULTI_PROC_TRANS, GstMultiProcTransClass))
#define GST_MULTI_PROC_TRANS_GET_CLASS(obj)\
  (G_TYPE_INSTANCE_GET_CLASS((obj), GST_TYPE_MULTI_PROC_TRANS, GstMultiProcTransClass))
#define GST_IS_MULTI_PROC_TRANS(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GST_TYPE_MULTI_PROC_TRANS))
#define GST_IS_MULTI_PROC_TRANS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), GST_TYPE_MULTI_PROC_TRANS))
#define GST_MULTI_PROC_TRANS_CAST(obj)    ((GstMultiProcTrans *)(obj))


/**
 * GST_MULTI_PROC_TRANS_SINK_NAME:
 *
 * the name of the templates for the sink pad
 */
#define GST_MULTI_PROC_TRANS_SINK_NAME    "sink"
/**
 * GST_MULTI_PROC_TRANS_SRC_NAME:
 *
 * the name of the templates for the source pad
 */
#define GST_MULTI_PROC_TRANS_SRC_NAME     "src"

/**
 * GST_MULTI_PROC_TRANS_SRC_PAD:
 * @obj: process transform instance
 *
 * Gives the pointer to the source #GstPad object of the element.
 */
#define GST_MULTI_PROC_TRANS_SRC_PAD(obj)         (GST_MULTI_PROC_TRANS_CAST (obj)->srcpad)

/**
 * GST_MULTI_PROC_TRANS_SINK_PAD:
 * @obj: process transform instance
 *
 * Gives the pointer to the sink #GstPad object of the element.
 */
#define GST_MULTI_PROC_TRANS_SINK_PAD(obj)        (GST_MULTI_PROC_TRANS_CAST (obj)->sinkpad)


typedef struct _GstMultiProcTrans GstMultiProcTrans;
typedef struct _GstMultiProcTransClass GstMultiProcTransClass;

/**
 * GstMultiProcTrans:
 * @parent: the parent element.
 *
 * The opaque #GstMultiProcTrans data structure.
 */
struct _GstMultiProcTrans {
  GstElement parent;

  /*< protected >*/
  /* pads */
  GstPad *srcpad;
  GstPad *sinkpad;

  /* prop info */
  /* these are initialized by base element;
   * intermediate management is for the inheritor;
   * are cleaned up by base element */
  gchar *cmd;
  GArray* args;

  /*< private >*/
  /* props */
  guint blocksize;

  /* state */
  gboolean did_caps;

  /* communication */
  int readpipe[2];
  int writepipe[2];
  GPid pid;

  /* temp storage for buffers */
  GstAdapter *adapter;
};

/**
 * GstMultiProcTransClass:
 * @set_caps: Optional.  Notify the subclass of new incaps,
 *            we should try to set @outcaps on source pad upon return.
 *            Note that @incaps can be NULL,
 *            and *@outcaps can also be left NULL in which case no caps are set.
 */
struct _GstMultiProcTransClass {
  GstElementClass parent_class;

  /*< public >*/
  /* virtual methods for subclasses */

  gboolean      (*set_caps)     (GstMultiProcTrans *trans, GstCaps *incaps,
                                 GstCaps **outcaps);

};

GType           gst_multi_proc_trans_get_type         (void);

#endif /* __GST_MULTI_PROC_TRANS_H__ */
