/* GStreamer Plugin
 * Copyright (C) 2006 Mark Nauwelaerts <mnauw@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "plugin-tc.h"

struct _elements_entry
{
  gchar *name;
    GType (*type) (void);
};

static struct _elements_entry _elements[] = {
  {"dnr", gst_dnr_get_type},
  {"smooth", gst_smooth_get_type},
  {"cshift", gst_cshift_get_type},
  {"csub", gst_csub_get_type},
  {"whitebalance", gst_whitebalance_get_type},
  {"ivtc", gst_ivtc_get_type},
  {"decimate", gst_decimate_get_type},
  {"detectinter", gst_detect_inter_get_type},
  {"mask", gst_mask_get_type},
  {"rbswap", gst_rb_swap_get_type},
  {"divxkey", gst_divx_key_get_type},
  {"astat", gst_astat_get_type},
  {NULL, 0}
};

static gboolean
plugin_init (GstPlugin * plugin)
{
  gint i = 0;

  oil_init ();

  while (_elements[i].name) {
    if (!gst_element_register (plugin, _elements[i].name,
            GST_RANK_NONE, (_elements[i].type) ()))
      return FALSE;
    i++;
  }

  return TRUE;
}

GST_PLUGIN_DEFINE (GST_VERSION_MAJOR,
    GST_VERSION_MINOR,
    "transcode",
    "filters from transcode",
    plugin_init, VERSION, "GPL", GST_PACKAGE_NAME, GST_PACKAGE_ORIGIN);
