//*****************************************************************************
//                              SimnNgSpice.hpp                               *
//                             -----------------                              *
// Description : A class to contain the values required to define a NG-Spice  *
//               simulation.                                                  *
// Started     : 07/05/2008                                                   *
// Last Update : 15/09/2009                                                   *
// Copyright   : (C) 2008 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef SIMNNGSPICE_HPP
#define SIMNNGSPICE_HPP

// System Includes

#include <cfloat>

// wxWindows Includes

#include <wx/wx.h>

// Application Includes

#include "base/SimnBase.hpp"
#include "ngspice/commands/CmdNgSpiceOPT.hpp"
#include "ngspice/commands/CmdNgSpiceDC.hpp"
#include "ngspice/commands/CmdNgSpiceAC.hpp"
#include "ngspice/commands/CmdNgSpiceTR.hpp"
#include "ngspice/commands/CmdNgSpicePR.hpp"
#include "netlist/SimnGnuCap.hpp"

struct SimnGnuCap;

// Local Constant Declarations


//*****************************************************************************

struct SimnNgSpice : public SimnBase
{
  public :

    // NG-Spice simulation object attributes
    CmdNgSpiceOPT  m_oCmdOPT;
    CmdNgSpiceDC   m_oCmdDC;
    CmdNgSpiceAC   m_oCmdAC;
    CmdNgSpiceTR   m_oCmdTR;
    CmdNgSpicePR   m_oCmdPR;

    CpntNgsIndSrc  m_oCpntIndSrc;

  private :

    // Function to extract information from the circuit description
    virtual  bool  bExtractSimrEng( void );
    virtual  bool  bExtractSimCmds( void );
    virtual  bool  bExtractSigSrc ( void );

  public :

             SimnNgSpice( void );
            ~SimnNgSpice( );

    virtual  bool  bClear    ( void );
    virtual  bool  bClrCmds  ( void );
    virtual  bool  bClrTstPts( void );

    virtual  bool  bValidate( void );

    virtual  bool  bLoadFile( const wxString & rosFName=wxT("") );
    virtual  bool  bSaveFile( const wxString & rosFName=wxT("") );

    virtual  bool  bSetAnaType( eCmdType eAnaType )
                                { return( m_oCmdPR.bSetAnaType( eAnaType ) ); }

    virtual  bool  bAddTstNode( const wxString & rosName );
    virtual  bool  bAddTstCpnt( const wxString & rosName );

    virtual        eCmdType           eGetAnaType ( void ) const
                                             { return( m_oCmdPR.m_eAnaType ); }
    virtual  const wxArrayString & rosaGetTstNodes( void )
                                             { return( m_oCmdPR.m_osaNodes ); }
    virtual  const wxArrayString & rosaGetTstCpnts( void );
             const wxString      &  rosGetColLbls ( void );

    SimnNgSpice & operator = ( const SimnGnuCap & roSimn );

    virtual  void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // SIMNNGSPICE_HPP
