//*****************************************************************************
//                              PnlGnuCapAC.hpp                               *
//                             -----------------                              *
//  Description : This class derives from the Analysis Panel base class and   *
//                provides a GUI for a user to configure a AC Analysis for    *
//                GNU-Cap electronic circuit simulator.                       *
//  Started     : 18/08/2003                                                  *
//  Last Update : 30/06/2009                                                  *
//  Copyright   : (C) 2003 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLGNUCAPAC_HPP
#define PNLGNUCAPAC_HPP

// System Includes


// wxWindows Library Includes


// Application Includes

#include "base/PnlAnaBase.hpp"
#include "netlist/SimnGnuCap.hpp"

// Local Constant Declarations


//*****************************************************************************

class PnlGnuCapAC : public PnlAnaBase
{
  private :

    void  Create( void );

    virtual  void  InitScale( void );

  public :

    PnlGnuCapAC( wxWindow * poWin );
   ~PnlGnuCapAC( );

    bool  bClear( void );

    virtual  bool  bLoad( SimnGnuCap & roSimn );
    virtual  bool  bSave( SimnGnuCap & roSimn );

    // Event handlers
    void  OnScale  ( wxCommandEvent & roEvtCmd );
    void  OnSrcName( wxCommandEvent & roEvtCmd );

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // PNLGNUCAPAC_HPP
