//*****************************************************************************
//                                FileTasks.hpp                               *
//                               ---------------                              *
//  Description : This is a helper class for FrmMain, it handles most of the  *
//                required file operations.                                   *
//  Started     : 28/05/2005                                                  *
//  Last Update : 07/12/2006                                                  *
//  Copyright   : (C) 2005 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef FILETASKS_HPP
#define FILETASKS_HPP

// System includes

#include <iostream>

// wxWindows includes

#include <wx/wx.h>
#include <wx/config.h>

// Application includes

class FrmMain;

#include "Version.hpp"
#include "netlist/Simulation.hpp"
#include "process/PrcGNetList.hpp"

//*****************************************************************************

class FileTasks
{
  public:

    enum eTmpFMgtType
    {
      eTFM_DELETE=0,
      eTFM_PROMPT,
      eTFM_KEEP,
      eTFM_NONE,

      eTFM_FST = eTFM_DELETE,
      eTFM_LST = eTFM_KEEP
    };

  private:

    FrmMain     * m_poFrmMain;     // Pointer to application main frame
    wxConfig    * m_poConfig;      // Pointer to global configuration object
    eTmpFMgtType  m_eTmpFileMgt;   // Temporary file management strategy
    PrcGNetList   m_oPrcGNetList;  // gNetList file conversion utility

    // Object initialization functions
    void  InitTmpFileMgt( void );
    void  InitGuileProc ( void );
    void  InitSchemFiles( void );
    void  InitNetLstFile( void );

    void  DlgNetLstErr( void );
    void  DlgSchemsErr( void );

    bool  bDlgOpen    ( void );
    bool  bDlgImport  ( void );
    bool  bExecImport ( void );
    bool  bDelTmpFiles( void );

  public:

    FileTasks( FrmMain * poFrmMain );
   ~FileTasks( );

    bool  bClear( void );     // Clear the object attributes
    void  Initialize( void ); // This function calls the initialization funcs
    bool  bIsOkGNetList( void );

    bool  bSetTitle     ( void );
    bool  bSetGuileProc ( const wxString & rosProcName );
    bool  bSetSchemFiles( const wxArrayString & roasFileNames );
    bool  bSetNetLstFile( const wxString & rosFileName );
    bool  bSetTmpFileMgt( eTmpFMgtType eTFM );
    bool  bSetLogFile   ( const wxString & rosFileName )
                       { return( m_oPrcGNetList.bSetLogFile( rosFileName ) ); }

    const wxString      &  rosGetGuileProc ( void );
    const wxArrayString & roasGetSchemFiles( void );
    const wxString      &  rosGetNetLstFile( void );

    bool  bOpen  ( Simulation & roSim );
    bool  bImport( Simulation & roSim );
    bool  bReload( Simulation & roSim );
    bool  bClose ( void );
    bool  bExit  ( void );
};

//*****************************************************************************

#endif // FILETASKS_HPP
