//*****************************************************************************
//                                DlgPrefs.cpp                                *
//                               --------------                               *
//  Started     : 17/10/2006                                                  *
//  Last Update : 28/06/2007                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "main/DlgPrefs.hpp"

//*****************************************************************************
// Implement an event table.

BEGIN_EVENT_TABLE( DlgPrefs, wxDialog )

  EVT_BUTTON( ID_BTN_OK,     DlgPrefs::OnBtnOk     )
  EVT_BUTTON( ID_BTN_CANCEL, DlgPrefs::OnBtnCancel )

END_EVENT_TABLE( )

//*****************************************************************************
// Constructor.
//
// Argument List:
//   poWin - A pointer to the dialog parent window

DlgPrefs::DlgPrefs( wxWindow * poWin ) :
                wxDialog( poWin, -1, wxT(""), wxDefaultPosition, wxDefaultSize,
                          wxDEFAULT_DIALOG_STYLE, wxDialogNameStr )
{
  // Get the global configuration object
  m_poConfig = (wxConfig *) wxConfig::Get( );

  // Construct the display objects
  Initialize( );

  // Clear object attributes
  bClear( );
}

//*****************************************************************************
// Destructor.

DlgPrefs::~DlgPrefs( )
{
}

//*****************************************************************************
// Initialize object attributes.

void  DlgPrefs::Initialize( void )
{
  SetTitle( wxT(" Preferences") );

  // Call all the initialization functions
  Create( );
  ToolTips( );

  // Layout the of the display objects
  DoLayout( );
}

//*****************************************************************************
// Create the display objects.

void  DlgPrefs::Create( void )
{
  wxPanel * poPnl, * poPnl_TFM;

  // Create the preferences panel and controls
  poPnl = new wxPanel( this );

  // Create the temporary file management panel and controls
  poPnl_TFM = new wxPanel( poPnl );
  m_oLblTmpFileMgt.Create( poPnl_TFM, ID_UNUSED, wxT("Temporary Files"),
                           wxDefaultPosition, wxSize( 110, -1 ),
                           wxST_NO_AUTORESIZE );
  m_oChoTmpFileMgt.Create( poPnl_TFM, ID_CHO_TMPFILEMGT, wxDefaultPosition,
                           wxSize( 95, -1 ) );
  m_oChoTmpFileMgt.Append( wxT("Delete") );
  m_oChoTmpFileMgt.Append( wxT("Prompt") );
  m_oChoTmpFileMgt.Append( wxT("Keep") );
  m_oChoTmpFileMgt.SetStringSelection( wxT("Delete") );

  // Create the PnlValue controls
  m_oPnlMaxLines.bCreate( poPnl, ID_PNL_MAXLINES, 105, wxDefaultPosition, FALSE );
  m_oPnlMaxLines.bSetName( wxT("Maximum Lines") );
  m_oPnlMaxLines.bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlMaxLines.bShowUnits( FALSE );
  m_oPnlMaxLines.bSetParms( TXTCTL_LINESDEF, TXTCTL_LINESMIN, TXTCTL_LINESMAX );

  // Create the tool tips check box
  m_oCbxToolTips.Create( poPnl, ID_CBX_TOOLTIPS, wxT("Show Tool Tips\t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );

  // Create the buttons
  poPnl = new wxPanel( this );
  m_oBtnOk    .Create( poPnl, ID_BTN_OK,     wxT("OK") );
  m_oBtnCancel.Create( poPnl, ID_BTN_CANCEL, wxT("Cancel") );
}

//*****************************************************************************
// Initialize the tool tips.

void  DlgPrefs::ToolTips( void )
{
  m_oPnlMaxLines  .SetToolTip( wxT("The maximum number of lines which may be displayed in any text control") );
  m_oCbxToolTips  .SetToolTip( wxT("Enable or disable tool tips") );
  m_oChoTmpFileMgt.SetToolTip( wxT("The temporary file management strategy to be used") );
}

//*****************************************************************************
// Layout the display objects within the dialog.

void  DlgPrefs::DoLayout( void )
{
  wxPanel     * poPnlCtrls, * poPnl_TFM, * poPnlBtns;
  wxSizer     * poSzrCtrls, * poSzr_TFM, * poSzrBtns;
  wxSizerFlags  oFlags, oFlags2;  // ??? (06/06/2007) Need oFlags2 owing to a bug in wxWidgets

  // Create and set the underlying dialog's sizer
  SetSizer( new wxBoxSizer( wxVERTICAL ) );

  // Create and set preference control panel sizer
  poPnlCtrls = (wxPanel *) m_oPnlMaxLines.GetParent( );
  poSzrCtrls = new wxStaticBoxSizer( wxVERTICAL, poPnlCtrls );
  poPnlCtrls->SetSizer( poSzrCtrls );

  // Create and set the temporary file management strategy sizer
  poPnl_TFM = (wxPanel *) m_oChoTmpFileMgt.GetParent( );
  poSzr_TFM = new wxBoxSizer( wxHORIZONTAL );
  poPnl_TFM->SetSizer( poSzr_TFM );

  // Layout the temporary file management strategy panel
  oFlags.Align( wxALIGN_CENTER );
  oFlags.Border( wxTOP | wxBOTTOM, 1 );
  poSzr_TFM->Add( &m_oLblTmpFileMgt, oFlags );
  poSzr_TFM->Add( &m_oChoTmpFileMgt, oFlags );
  poSzr_TFM->SetSizeHints( poPnl_TFM );

  // Layout the preferences controls
  oFlags2.Align( wxALIGN_LEFT );
  oFlags2.Border( wxTOP | wxLEFT | wxRIGHT, 10 );
  poSzrCtrls->Add( poPnl_TFM,       oFlags2 );
  oFlags2.Border( wxLEFT | wxRIGHT,         10 );
  poSzrCtrls->Add( &m_oPnlMaxLines, oFlags2 );
  oFlags2.Border( wxTOP | wxBOTTOM | wxLEFT, 8 );
  poSzrCtrls->Add( &m_oCbxToolTips, oFlags2 );
  poSzrCtrls->SetSizeHints( poPnlCtrls );

  // Create and set the button panel sizer
  poPnlBtns = (wxPanel *) m_oBtnOk.GetParent( );
  poSzrBtns = new wxBoxSizer( wxHORIZONTAL );
  poPnlBtns->SetSizer( poSzrBtns );

  // Layout the buttons
  oFlags.Border( wxBOTTOM, 10 );
  oFlags.Align( wxALIGN_RIGHT );
  poSzrBtns->Add( &m_oBtnOk,     oFlags );
  poSzrBtns->AddSpacer( 10 );
  oFlags.Align( wxALIGN_LEFT );
  poSzrBtns->Add( &m_oBtnCancel, oFlags );
  poSzrBtns->SetSizeHints( poPnlBtns );

  // Layout the underlying dialog
  oFlags.Align( wxALIGN_CENTER );
  oFlags.Border( wxALL, 10 );
  GetSizer( )->Add( poPnlCtrls, oFlags );
  oFlags.Border( wxTOP | wxBOTTOM, 15 );
  GetSizer( )->Add( poPnlBtns,  oFlags );

  // Set dialogues minimum size and initial size as calculated by the sizer
  GetSizer( )->SetSizeHints( this );
}

//*****************************************************************************
// Set the values in the display controls from the configuration file.

void  DlgPrefs::SetValues( void )
{
  wxString  os1;
  long      li1;

  SetEvtHandlerEnabled( FALSE );

  m_poConfig->SetPath( wxT("/Main") );

  m_poConfig->Read( wxT("NbkMaxLines"), &li1, (long) TXTCTL_LINESDEF );
  m_oPnlMaxLines.bSetValue( li1 );

  m_poConfig->Read( wxT("TmpFileMgt"),  &os1, wxT("Delete") );
  m_oChoTmpFileMgt.SetStringSelection( os1 );

  m_poConfig->Read( wxT("ToolTips"),    &li1, (long) 0 );
  m_oCbxToolTips.SetValue( li1 != 0 ? TRUE : FALSE );

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Get the values from the display controls and put them into the configuration
// file.

void  DlgPrefs::GetValues( void )
{
  wxString  os1;
  long      li1;

  SetEvtHandlerEnabled( FALSE );

  m_poConfig->SetPath( wxT("/Main") );

  li1 = m_oPnlMaxLines.liGetValue( );
  m_poConfig->Write( wxT("NbkMaxLines"), li1 );

  os1 = m_oChoTmpFileMgt.GetStringSelection( );
  m_poConfig->Write( wxT("TmpFileMgt"),  os1 );

  li1 = ( m_oCbxToolTips.GetValue( ) ? 1 : 0 );
  m_poConfig->Write( wxT("ToolTips"),    li1 );
  wxToolTip::Enable( li1 != 0 ? TRUE : FALSE );

  m_poConfig->Flush( );

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Reset all dialog settings to defaults.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  DlgPrefs::bClear( void )
{
  SetValues( );

  return( TRUE );
}

//*****************************************************************************
//
//                             Event Handlers
//
//*****************************************************************************
// Ok button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgPrefs::OnBtnOk( wxCommandEvent & roEvtCmd )
{
  GetValues( );

  EndModal( wxID_OK );
}

//*****************************************************************************
// Cancel button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgPrefs::OnBtnCancel( wxCommandEvent & roEvtCmd )
{
  SetValues( );

  EndModal( wxID_CANCEL );
}

//*****************************************************************************
