//*****************************************************************************
//                              DlgGnuCapOPT.cpp                              *
//                             ------------------                             *
//  Started     : 14/09/2006                                                  *
//  Last Update : 09/10/2007                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "gnucap/dialogs/DlgGnuCapOPT.hpp"

//*****************************************************************************
// Implement an event table.

BEGIN_EVENT_TABLE( DlgGnuCapOPT, wxDialog )

  EVT_BUTTON( ID_BTN_OK,       DlgGnuCapOPT::OnBtnOk       )
  EVT_BUTTON( ID_BTN_DEFAULTS, DlgGnuCapOPT::OnBtnDefaults )
  EVT_BUTTON( ID_BTN_CANCEL,   DlgGnuCapOPT::OnBtnCancel   )

END_EVENT_TABLE( )

//*****************************************************************************
// Constructor.
//
// Argument List:
//   poWin - A pointer to the dialog parent window

DlgGnuCapOPT::DlgGnuCapOPT( wxWindow * poWin ) :
                wxDialog( poWin, -1, wxT(""), wxDefaultPosition, wxDefaultSize,
                          wxDEFAULT_DIALOG_STYLE, wxDialogNameStr ),
                CmdGnuCapOPT( )
{
  SetTitle( wxT(" GNU-Cap OPTIONS Command Setup") );
  Initialize( );
  bClear( );
}

//*****************************************************************************
// Destructor.

DlgGnuCapOPT::~DlgGnuCapOPT( )
{
}

//*****************************************************************************
// Initialize object attributes.

void  DlgGnuCapOPT::Initialize( void )
{
  // Call all the initialization functions
  Create( );
  ToolTips( );

  // Layout the of the display objects
  DoLayout( );
}

//*****************************************************************************
// Create the display objects.

void  DlgGnuCapOPT::Create( void )
{
  wxPanel * poPnl, * poPnlLHS, * poPnlMID, * poPnlRHS, * poPnl1;

  // Create the necessary panel objects
  poPnlLHS = new wxPanel( this );
  poPnlMID = new wxPanel( this );
  poPnlRHS = new wxPanel( this );
  poPnl1   = new wxPanel( poPnlRHS );

  // Create the PnlValue controls
  m_oPnlABSTOL  .bCreate( poPnlLHS, ID_PNL_ABSTOL,   75 );
  m_oPnlCHGTOL  .bCreate( poPnlLHS, ID_PNL_CHGTOL,   75 );
  m_oPnlDAMPMAX .bCreate( poPnlLHS, ID_PNL_DAMPMAX,  75 );
  m_oPnlDAMPMIN .bCreate( poPnlLHS, ID_PNL_DAMPMIN,  75 );
  m_oPnlDAMPST  .bCreate( poPnlLHS, ID_PNL_DAMPST,   75 );
  m_oPnlDEFAD   .bCreate( poPnlLHS, ID_PNL_DEFAD,    75 );
  m_oPnlDEFAS   .bCreate( poPnlLHS, ID_PNL_DEFAS,    75 );
  m_oPnlDEFL    .bCreate( poPnlLHS, ID_PNL_DEFL,     75 );
  m_oPnlDEFW    .bCreate( poPnlLHS, ID_PNL_DEFW,     75 );
  m_oPnlDTMIN   .bCreate( poPnlLHS, ID_PNL_DTMIN,    75 );
  m_oPnlDTRATIO .bCreate( poPnlLHS, ID_PNL_DTRATIO,  75 );
  m_oPnlFLOOR   .bCreate( poPnlLHS, ID_PNL_FLOOR,    75 );
  m_oPnlGMIN    .bCreate( poPnlLHS, ID_PNL_GMIN,     75 );
  m_oPnlHARMS   .bCreate( poPnlLHS, ID_PNL_HARMS,    75 );
  m_oPnlITL1    .bCreate( poPnlLHS, ID_PNL_ITL1,     75 );
  m_oPnlITL2    .bCreate( poPnlLHS, ID_PNL_ITL2,     75 );
  m_oPnlITL4    .bCreate( poPnlMID, ID_PNL_ITL4,     75 );
  m_oPnlITL7    .bCreate( poPnlMID, ID_PNL_ITL7,     75 );
  m_oPnlITL8    .bCreate( poPnlMID, ID_PNL_ITL8,     75 );
  m_oPnlLIMIT   .bCreate( poPnlMID, ID_PNL_LIMIT,    75 );
  m_oPnlNUMDGT  .bCreate( poPnlMID, ID_PNL_NUMDGT,   75 );
  m_oPnlRELTOL  .bCreate( poPnlMID, ID_PNL_RELTOL,   75 );
  m_oPnlSEED    .bCreate( poPnlMID, ID_PNL_SEED,     75 );
  m_oPnlSHORT   .bCreate( poPnlMID, ID_PNL_SHORT,    75 );
  m_oPnlTEMPAMB .bCreate( poPnlMID, ID_PNL_TEMPAMB,  75 );
  m_oPnlTNOM    .bCreate( poPnlMID, ID_PNL_TNOM,     75 );
  m_oPnlTRANSITS.bCreate( poPnlMID, ID_PNL_TRANSITS, 75 );
  m_oPnlTRREJECT.bCreate( poPnlMID, ID_PNL_TRREJECT, 75 );
  m_oPnlTRSTEPG .bCreate( poPnlMID, ID_PNL_TRSTEPG,  75 );
  m_oPnlTRSTEPS .bCreate( poPnlMID, ID_PNL_TRSTEPS,  75 );
  m_oPnlTRTOL   .bCreate( poPnlMID, ID_PNL_TRTOL,    75 );
  m_oPnlVFLOOR  .bCreate( poPnlMID, ID_PNL_VFLOOR,   75 );
  m_oPnlVMAX    .bCreate( poPnl1,   ID_PNL_VMAX,     75 );
  m_oPnlVMIN    .bCreate( poPnl1,   ID_PNL_VMIN,     75 );
  m_oPnlVNTOL   .bCreate( poPnl1,   ID_PNL_VNTOL,    75 );
  m_oPnlWCZERO  .bCreate( poPnl1,   ID_PNL_WCZERO,   75 );

  m_oPnlABSTOL  .bSetName( wxT("ABSTOL")   );
  m_oPnlCHGTOL  .bSetName( wxT("CHGTOL")   );
  m_oPnlDAMPMAX .bSetName( wxT("DAMPMAX")  );
  m_oPnlDAMPMIN .bSetName( wxT("DAMPMIN")  );
  m_oPnlDAMPST  .bSetName( wxT("DAMPST")   );
  m_oPnlDEFAD   .bSetName( wxT("DEFAD")    );
  m_oPnlDEFAS   .bSetName( wxT("DEFAS")    );
  m_oPnlDEFL    .bSetName( wxT("DEFL")     );
  m_oPnlDEFW    .bSetName( wxT("DEFW")     );
  m_oPnlDTMIN   .bSetName( wxT("DTMIN")    );
  m_oPnlDTRATIO .bSetName( wxT("DTRATIO")  );
  m_oPnlFLOOR   .bSetName( wxT("FLOOR")    );
  m_oPnlGMIN    .bSetName( wxT("GMIN")     );
  m_oPnlHARMS   .bSetName( wxT("HARMS")    );
  m_oPnlITL1    .bSetName( wxT("ITL1")     );
  m_oPnlITL2    .bSetName( wxT("ITL2")     );
  m_oPnlITL4    .bSetName( wxT("ITL4")     );
  m_oPnlITL7    .bSetName( wxT("ITL7")     );
  m_oPnlITL8    .bSetName( wxT("ITL8")     );
  m_oPnlLIMIT   .bSetName( wxT("LIMIT")    );
  m_oPnlNUMDGT  .bSetName( wxT("NUMDGT")   );
  m_oPnlRELTOL  .bSetName( wxT("RELTOL")   );
  m_oPnlSEED    .bSetName( wxT("SEED")     );
  m_oPnlSHORT   .bSetName( wxT("SHORT")    );
  m_oPnlTEMPAMB .bSetName( wxT("TEMPAMB")  );
  m_oPnlTNOM    .bSetName( wxT("TNOM")     );
  m_oPnlTRANSITS.bSetName( wxT("TRANSITS") );
  m_oPnlTRREJECT.bSetName( wxT("TRREJECT") );
  m_oPnlTRSTEPG .bSetName( wxT("TRSTEPG")  );
  m_oPnlTRSTEPS .bSetName( wxT("TRSTEPS")  );
  m_oPnlTRTOL   .bSetName( wxT("TRTOL")    );
  m_oPnlVFLOOR  .bSetName( wxT("VFLOOR")   );
  m_oPnlVMAX    .bSetName( wxT("VMAX")     );
  m_oPnlVMIN    .bSetName( wxT("VMIN")     );
  m_oPnlVNTOL   .bSetName( wxT("VNTOL")    );
  m_oPnlWCZERO  .bSetName( wxT("WCZERO")   );

  m_oPnlTEMPAMB .bSetUnitsType( ChoUnits::eUNITS_TEMP );
  m_oPnlTNOM    .bSetUnitsType( ChoUnits::eUNITS_TEMP );
  m_oPnlVMIN    .bSetUnitsType( ChoUnits::eUNITS_VOLT );
  m_oPnlVMAX    .bSetUnitsType( ChoUnits::eUNITS_VOLT );
  m_oPnlVNTOL   .bSetUnitsType( ChoUnits::eUNITS_VOLT );

  m_oPnlVNTOL   .bSetDefUnits( wxT("uV") );

  m_oPnlABSTOL  .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlCHGTOL  .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDAMPST  .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlDEFAD   .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDEFAS   .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDEFL    .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDEFW    .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDTMIN   .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDTRATIO .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlFLOOR   .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlGMIN    .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlHARMS   .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlITL1    .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlITL2    .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlITL4    .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlITL7    .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlITL8    .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlLIMIT   .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlNUMDGT  .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlSHORT   .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlTRANSITS.bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlVFLOOR  .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlWCZERO  .bSetVarType( SpinCtrl::eVAR_SCI );

  m_oPnlABSTOL  .bShowUnits( FALSE );
  m_oPnlCHGTOL  .bShowUnits( FALSE );
  m_oPnlDAMPMAX .bShowUnits( FALSE );
  m_oPnlDAMPMIN .bShowUnits( FALSE );
  m_oPnlDAMPST  .bShowUnits( FALSE );
  m_oPnlDEFAD   .bShowUnits( FALSE );
  m_oPnlDEFAS   .bShowUnits( FALSE );
  m_oPnlDEFL    .bShowUnits( FALSE );
  m_oPnlDEFW    .bShowUnits( FALSE );
  m_oPnlDTMIN   .bShowUnits( FALSE );
  m_oPnlDTRATIO .bShowUnits( FALSE );
  m_oPnlFLOOR   .bShowUnits( FALSE );
  m_oPnlGMIN    .bShowUnits( FALSE );
  m_oPnlHARMS   .bShowUnits( FALSE );
  m_oPnlITL1    .bShowUnits( FALSE );
  m_oPnlITL2    .bShowUnits( FALSE );
  m_oPnlITL4    .bShowUnits( FALSE );
  m_oPnlITL7    .bShowUnits( FALSE );
  m_oPnlITL8    .bShowUnits( FALSE );
  m_oPnlLIMIT   .bShowUnits( FALSE );
  m_oPnlNUMDGT  .bShowUnits( FALSE );
  m_oPnlRELTOL  .bShowUnits( FALSE );
  m_oPnlSEED    .bShowUnits( FALSE );
  m_oPnlSHORT   .bShowUnits( FALSE );
  m_oPnlTRANSITS.bShowUnits( FALSE );
  m_oPnlTRREJECT.bShowUnits( FALSE );
  m_oPnlTRSTEPG .bShowUnits( FALSE );
  m_oPnlTRSTEPS .bShowUnits( FALSE );
  m_oPnlTRTOL   .bShowUnits( FALSE );
  m_oPnlVFLOOR  .bShowUnits( FALSE );
  m_oPnlWCZERO  .bShowUnits( FALSE );

  m_oPnlABSTOL  .bSetParms( GC_ABSTOL,   1.00E-14, 9.99E-11 );
  m_oPnlCHGTOL  .bSetParms( GC_CHGTOL,   1.00E-16, 9.99E-13 );
  m_oPnlDAMPMAX .bSetParms( GC_DAMPMAX,  0.00,     1.0,     0.01, 0.1  );
  m_oPnlDAMPMIN .bSetParms( GC_DAMPMIN,  0.00,     1.0,     0.01, 0.1  );
  m_oPnlDAMPST  .bSetParms( GC_DAMPST,   0,        37,      1,    1    );
  m_oPnlDEFAD   .bSetParms( GC_DEFAD,    1.00E-14, 9.99E-10 );
  m_oPnlDEFAS   .bSetParms( GC_DEFAS,    1.00E-14, 9.99E-10 );
  m_oPnlDEFL    .bSetParms( GC_DEFL,     1.00E-08, 9.99E-02 );
  m_oPnlDEFW    .bSetParms( GC_DEFW,     1.00E-08, 9.99E-02 );
  m_oPnlDTMIN   .bSetParms( GC_DTMIN,    1.00E-14, 9.99E-12 );
  m_oPnlDTRATIO .bSetParms( GC_DTRATIO,  1.00E-10, 9.99E+10 );
  m_oPnlFLOOR   .bSetParms( GC_FLOOR,    1.00E-23, 9.99E-19 );
  m_oPnlGMIN    .bSetParms( GC_GMIN,     1.00E-14, 9.99E-11 );
  m_oPnlHARMS   .bSetParms( GC_HARMS,    1,        100,     1,    10   );
  m_oPnlITL1    .bSetParms( GC_ITL1,     0,        1000,    1,    100  );
  m_oPnlITL2    .bSetParms( GC_ITL2,     0,        1000,    1,    100  );
  m_oPnlITL4    .bSetParms( GC_ITL4,     0,        1000,    1,    100  );
  m_oPnlITL7    .bSetParms( GC_ITL7,     0,        1000,    1,    100  );
  m_oPnlITL8    .bSetParms( GC_ITL8,     0,        1000,    1,    100  );
  m_oPnlLIMIT   .bSetParms( GC_LIMIT,    1.00E-10, 9.99E+10 );
  m_oPnlNUMDGT  .bSetParms( GC_NUMDGT,   3,        20,      1,    1    );
  m_oPnlRELTOL  .bSetParms( GC_RELTOL*100.0, 0.01, 100.0,   0.01, 10.0 );
  m_oPnlSEED    .bSetParms( GC_SEED,     0.00,     10.0,    0.01, 1.0  );
  m_oPnlSHORT   .bSetParms( GC_SHORT,    1.00E-09, 9.99E-05 );
  m_oPnlTRANSITS.bSetParms( GC_TRANSITS, 1,        100,     1,    10   );
  m_oPnlTRREJECT.bSetParms( GC_TRREJECT, 0.01,     100.0,   0.01, 10.0 );
  m_oPnlTRSTEPG .bSetParms( GC_TRSTEPG,  0.01,     100.0,   0.01, 10.0 );
  m_oPnlTRSTEPS .bSetParms( GC_TRSTEPS,  0.01,     100.0,   0.01, 10.0 );
  m_oPnlTRTOL   .bSetParms( GC_TRTOL,    0.01,     100.0,   0.01, 10.0 );
  m_oPnlVFLOOR  .bSetParms( GC_VFLOOR,   1.00E-17, 9.99E-13 );
  m_oPnlWCZERO  .bSetParms( GC_WCZERO,   1.00E-09, 9.99E-08 );

  m_oPnlABSTOL  .bSetUnits( wxT("Amp")       );
  m_oPnlCHGTOL  .bSetUnits( wxT("Coulomb")   );
  m_oPnlDEFAD   .bSetUnits( wxT("Sq. Meter") );
  m_oPnlDEFAS   .bSetUnits( wxT("Sq. Meter") );
  m_oPnlDEFL    .bSetUnits( wxT("Meter")     );
  m_oPnlDEFW    .bSetUnits( wxT("Meter")     );
  m_oPnlDTMIN   .bSetUnits( wxT("Sec")       );
  m_oPnlGMIN    .bSetUnits( wxT("Ohm")       );
  m_oPnlLIMIT   .bSetUnits( wxT("Volt")      );
  m_oPnlRELTOL  .bSetUnits( wxT("%")         );
  m_oPnlVFLOOR  .bSetUnits( wxT("Volt")      );

  // Create the choice box controls
  poPnl = new wxPanel( poPnl1 );
  m_oLblMETHOD.Create( poPnl, ID_UNUSED, wxT("METHOD"), wxDefaultPosition,
                       wxSize( 80, PNLVALUE_HT ), wxST_NO_AUTORESIZE );
  m_oChoMETHOD.Create( poPnl, ID_CHO_METHOD, wxDefaultPosition,
                       wxSize( 95, -1 ) );
  m_oChoMETHOD.Append( wxT("Euler") );
  m_oChoMETHOD.Append( wxT("EulerOnly") );
  m_oChoMETHOD.Append( wxT("Trap") );
  m_oChoMETHOD.Append( wxT("TrapOnly") );

  poPnl = new wxPanel( poPnl1 );
  m_oLblMODE  .Create( poPnl, ID_UNUSED, wxT("MODE"),     wxDefaultPosition,
                       wxSize( 80, PNLVALUE_HT ), wxST_NO_AUTORESIZE );
  m_oChoMODE  .Create( poPnl, ID_CHO_MODE, wxDefaultPosition,
                       wxSize( 95, -1 ) );
  m_oChoMODE  .Append( wxT("Analog") );
  m_oChoMODE  .Append( wxT("Digital") );
  m_oChoMODE  .Append( wxT("Mixed") );

  poPnl = new wxPanel( poPnl1 );
  m_oLblORDER .Create( poPnl, ID_UNUSED, wxT("ORDER"),   wxDefaultPosition,
                       wxSize( 80, PNLVALUE_HT ), wxST_NO_AUTORESIZE );
  m_oChoORDER .Create( poPnl, ID_CHO_ORDER, wxDefaultPosition,
                       wxSize( 95, -1 ) );
  m_oChoORDER .Append( wxT("Forward") );
  m_oChoORDER .Append( wxT("Reverse") );
  m_oChoORDER .Append( wxT("Auto") );

  // Create the check box controls
  m_oCbxBYPASS  .Create( poPnl1, ID_CBX_BYPASS,   wxT("  BYPASS    \t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );
  m_oCbxCSTRAY  .Create( poPnl1, ID_CBX_CSTRAY,   wxT("  CSTRAY    \t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );
  m_oCbxINCMODE .Create( poPnl1, ID_CBX_INCMODE,  wxT("  INCMODE   \t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );
  m_oCbxLUBYPASS.Create( poPnl1, ID_CBX_LUBYPASS, wxT("  LUBYPASS  \t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );
  m_oCbxRSTRAY  .Create( poPnl1, ID_CBX_RSTRAY,   wxT("  RSTRAY    \t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );
  m_oCbxTRACEL  .Create( poPnl1, ID_CBX_TRACEL,   wxT("  TRACEL    \t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );
  m_oCbxVBYPASS .Create( poPnl1, ID_CBX_VBYPASS,  wxT("  VBYPASS   \t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );

  // Create the buttons
  poPnl = new wxPanel( poPnlRHS );
  m_oBtnOk      .Create( poPnl, ID_BTN_OK,       wxT("OK") );
  m_oBtnDefaults.Create( poPnl, ID_BTN_DEFAULTS, wxT("Defaults") );
  m_oBtnCancel  .Create( poPnl, ID_BTN_CANCEL,   wxT("Cancel") );
}

//*****************************************************************************
// Initialize the tool tips.

void  DlgGnuCapOPT::ToolTips( void )
{
  // Define tool tips for each control
  m_oPnlABSTOL  .SetToolTip( wxT("Absolute current error tolerance") );
  m_oPnlCHGTOL  .SetToolTip( wxT("Charge tolerance") );
  m_oPnlDAMPMAX .SetToolTip( wxT("Normal Newton damping factor (when all is well)") );
  m_oPnlDAMPMIN .SetToolTip( wxT("Newton damping factor when there's a problem") );
  m_oPnlDAMPST  .SetToolTip( wxT("Damping strategy") );
  m_oPnlDEFAD   .SetToolTip( wxT("MOS drain diffusion area") );
  m_oPnlDEFAS   .SetToolTip( wxT("MOS source diffusion area") );
  m_oPnlDEFL    .SetToolTip( wxT("MOS channel length") );
  m_oPnlDEFW    .SetToolTip( wxT("MOS channel width") );
  m_oPnlDTMIN   .SetToolTip( wxT("Minimum time step") );
  m_oPnlDTRATIO .SetToolTip( wxT("Ratio between the minimum and maximum time step") );
  m_oPnlFLOOR   .SetToolTip( wxT("Effective zero value") );
  m_oPnlGMIN    .SetToolTip( wxT("Minimum allowable conductance") );
  m_oPnlHARMS   .SetToolTip( wxT("Harmonics in Fourier analysis") );
  m_oPnlITL1    .SetToolTip( wxT("DC iteration limit") );
  m_oPnlITL2    .SetToolTip( wxT("DC transfer curve iteration limit") );
  m_oPnlITL4    .SetToolTip( wxT("Transient analysis timepoint iteration limit") );
  m_oPnlITL7    .SetToolTip( wxT("Worst case analysis iteration limit") );
  m_oPnlITL8    .SetToolTip( wxT("Convergence diagnostic iteration threshold") );
  m_oPnlLIMIT   .SetToolTip( wxT("Internal differential branch voltage limit") );
  m_oPnlNUMDGT  .SetToolTip( wxT("Number of digits to print for analysis results") );
  m_oPnlRELTOL  .SetToolTip( wxT("Relative error tolerance") );
  m_oPnlSEED    .SetToolTip( wxT("Seed used by the random number generator") );
  m_oPnlSHORT   .SetToolTip( wxT("Resistance of voltage source or short") );
  m_oPnlTEMPAMB .SetToolTip( wxT("Ambient temp. of circuit") );
  m_oPnlTNOM    .SetToolTip( wxT("Nominal temp. at which device parameters measured") );
  m_oPnlTRANSITS.SetToolTip( wxT("Mixed mode transition count") );
  m_oPnlTRREJECT.SetToolTip( wxT("Transient error rejection threshold") );
  m_oPnlTRSTEPG .SetToolTip( wxT("Maximum internal step size growth in transient analysis") );
  m_oPnlTRSTEPS .SetToolTip( wxT("Amount to decrease the transient step size by when convergence fails") );
  m_oPnlTRTOL   .SetToolTip( wxT("Transient analysis error tolerance") );
  m_oPnlVFLOOR  .SetToolTip( wxT("Effective zero value for voltage probes") );
  m_oPnlVMAX    .SetToolTip( wxT("Positive node voltage limit") );
  m_oPnlVMIN    .SetToolTip( wxT("Negative node voltage limit") );
  m_oPnlVNTOL   .SetToolTip( wxT("Absolute voltage error tolerance") );
  m_oPnlWCZERO  .SetToolTip( wxT("Worst case zero window") );

  m_oCbxBYPASS  .SetToolTip( wxT("Bypass model evaluation if appropriate") );
  m_oCbxCSTRAY  .SetToolTip( wxT("Include capacitance in device models") );
  m_oCbxINCMODE .SetToolTip( wxT("Incrementally update the matrix") );
  m_oCbxLUBYPASS.SetToolTip( wxT("Bypass parts of LU decomposition if appropriate") );
  m_oCbxRSTRAY  .SetToolTip( wxT("Include series resistance in device models") );
  m_oCbxTRACEL  .SetToolTip( wxT("Use a queue to only load changed elements to the matrix") );
  m_oCbxVBYPASS .SetToolTip( wxT("Check only voltage to bypass model evaluation") );

  m_oChoMETHOD.GetParent( )->SetToolTip( wxT("Numerical integration method") );
  m_oChoMODE  .GetParent( )->SetToolTip( wxT("Simulation mode selection") );
  m_oChoORDER .GetParent( )->SetToolTip( wxT("Equation ordering") );
}

//*****************************************************************************
// Layout the dialog display objects.

void  DlgGnuCapOPT::DoLayout( void )
{
  wxBoxSizer  * poSzrDlg, * poSzrLHS, * poSzrMID, * poSzrRHS, * poSzr1;
  wxBoxSizer  * poSzrMETHOD, * poSzrMODE, * poSzrORDER, * poSzrBtns;
  wxPanel     * poPnlLHS, * poPnlMID, * poPnlRHS, * poPnl1;
  wxPanel     * poPnlMETHOD, * poPnlMODE, * poPnlORDER, * poPnlBtns;
  wxSizerFlags  oFlags;

  // Create the necessary panels and associated sizers
  poPnlBtns   = (wxPanel *) m_oBtnOk    .GetParent( );
  poPnlMETHOD = (wxPanel *) m_oChoMETHOD.GetParent( );
  poPnlMODE   = (wxPanel *) m_oChoMODE  .GetParent( );
  poPnlORDER  = (wxPanel *) m_oChoORDER .GetParent( );
  poPnl1      = (wxPanel *) poPnlMETHOD->GetParent( );
  poPnlRHS    = (wxPanel *) poPnlBtns  ->GetParent( );
  poPnlMID    = (wxPanel *) m_oPnlNUMDGT.GetParent( );
  poPnlLHS    = (wxPanel *) m_oPnlABSTOL.GetParent( );
  poSzrDlg    = new wxBoxSizer      ( wxHORIZONTAL );
#if wxCHECK_VERSION( 2,8,0 )
  poSzrLHS    = new wxStaticBoxSizer( wxVERTICAL, poPnlLHS );
  poSzrMID    = new wxStaticBoxSizer( wxVERTICAL, poPnlMID );
  poSzr1      = new wxStaticBoxSizer( wxVERTICAL, poPnl1 );
#else
  poSzrLHS    = new wxStaticBoxSizer( wxVERTICAL, poPnlLHS, wxT(" ") );
  poSzrMID    = new wxStaticBoxSizer( wxVERTICAL, poPnlMID, wxT(" ") );
  poSzr1      = new wxStaticBoxSizer( wxVERTICAL, poPnl1,   wxT(" ") );
#endif
  poSzrRHS    = new wxBoxSizer      ( wxVERTICAL );
  poSzrMETHOD = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrMODE   = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrORDER  = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrBtns   = new wxBoxSizer      ( wxHORIZONTAL );
               SetSizer( poSzrDlg );
  poPnlLHS   ->SetSizer( poSzrLHS );
  poPnlMID   ->SetSizer( poSzrMID );
  poPnlRHS   ->SetSizer( poSzrRHS );
  poPnl1     ->SetSizer( poSzr1 );
  poPnlMETHOD->SetSizer( poSzrMETHOD );
  poPnlMODE  ->SetSizer( poSzrMODE );
  poPnlORDER ->SetSizer( poSzrORDER );
  poPnlBtns  ->SetSizer( poSzrBtns );

  // Add the controls to the choice panels
  oFlags.Align( wxALIGN_CENTER ); // ??? 04/06/2007 This seems be ignored
  oFlags.Border( wxTOP, 7 );      // ??? 26/05/2007
  poSzrMETHOD->Add( &m_oLblMETHOD, oFlags );
  poSzrMODE  ->Add( &m_oLblMODE,   oFlags );
  poSzrORDER ->Add( &m_oLblORDER,  oFlags );
  oFlags.Border( wxTOP | wxBOTTOM, 1 );
  poSzrMETHOD->Add( &m_oChoMETHOD, oFlags );
  poSzrMODE  ->Add( &m_oChoMODE,   oFlags );
  poSzrORDER ->Add( &m_oChoORDER,  oFlags );
  poSzrMETHOD->SetSizeHints( poPnlMETHOD );
  poSzrMODE  ->SetSizeHints( poPnlMODE );
  poSzrORDER ->SetSizeHints( poPnlORDER );

  // Add the controls to the left hand panel
  oFlags.Border( wxTOP, 5 );
  poSzrLHS->Add( &m_oPnlABSTOL,  oFlags );
  oFlags.Border( wxLEFT | wxRIGHT, 10 );
  poSzrLHS->Add( &m_oPnlCHGTOL,  oFlags );
  poSzrLHS->Add( &m_oPnlDAMPMAX, oFlags );
  poSzrLHS->Add( &m_oPnlDAMPMIN, oFlags );
  poSzrLHS->Add( &m_oPnlDAMPST,  oFlags );
  poSzrLHS->Add( &m_oPnlDEFAD,   oFlags );
  poSzrLHS->Add( &m_oPnlDEFAS,   oFlags );
  poSzrLHS->Add( &m_oPnlDEFL,    oFlags );
  poSzrLHS->Add( &m_oPnlDEFW,    oFlags );
  poSzrLHS->Add( &m_oPnlDTMIN,   oFlags );
  poSzrLHS->Add( &m_oPnlDTRATIO, oFlags );
  poSzrLHS->Add( &m_oPnlFLOOR,   oFlags );
  poSzrLHS->Add( &m_oPnlGMIN,    oFlags );
  poSzrLHS->Add( &m_oPnlHARMS,   oFlags );
  poSzrLHS->Add( &m_oPnlITL1,    oFlags );
  oFlags.Border( wxBOTTOM, 5 );
  poSzrLHS->Add( &m_oPnlITL2,    oFlags );
  poSzrLHS->SetSizeHints( poPnlLHS );

  // Add the controls to the middle panel
  oFlags.Border( wxTOP, 5 );
  poSzrMID->Add( &m_oPnlITL4,     oFlags );
  oFlags.Border( wxLEFT | wxRIGHT, 10 );
  poSzrMID->Add( &m_oPnlITL7,     oFlags );
  poSzrMID->Add( &m_oPnlITL8,     oFlags );
  poSzrMID->Add( &m_oPnlLIMIT,    oFlags );
  poSzrMID->Add( &m_oPnlNUMDGT,   oFlags );
  poSzrMID->Add( &m_oPnlRELTOL,   oFlags );
  poSzrMID->Add( &m_oPnlSEED,     oFlags );
  poSzrMID->Add( &m_oPnlSHORT,    oFlags );
  poSzrMID->Add( &m_oPnlTEMPAMB,  oFlags );
  poSzrMID->Add( &m_oPnlTNOM,     oFlags );
  poSzrMID->Add( &m_oPnlTRANSITS, oFlags );
  poSzrMID->Add( &m_oPnlTRREJECT, oFlags );
  poSzrMID->Add( &m_oPnlTRSTEPG,  oFlags );
  poSzrMID->Add( &m_oPnlTRSTEPS,  oFlags );
  poSzrMID->Add( &m_oPnlTRTOL,    oFlags );
  oFlags.Border( wxBOTTOM, 5 );
  poSzrMID->Add( &m_oPnlVFLOOR,   oFlags );
  poSzrMID->SetSizeHints( poPnlMID );

  // Add the controls to the right hand panel
  oFlags.Border( wxTOP, 5 );
  poSzr1->Add( &m_oPnlVMAX,     oFlags );
  oFlags.Border( wxLEFT | wxRIGHT, 10 );
  poSzr1->Add( &m_oPnlVMIN,     oFlags );
  poSzr1->Add( &m_oPnlVNTOL,    oFlags );
  poSzr1->Add( &m_oPnlWCZERO,   oFlags );
  oFlags.Align( wxALIGN_LEFT );
  poSzr1->Add( poPnlMETHOD,     oFlags );
  poSzr1->Add( poPnlMODE,       oFlags );
  poSzr1->Add( poPnlORDER,      oFlags );
  oFlags.Border( wxTOP, 5 );
  poSzr1->Add( &m_oCbxBYPASS,   oFlags );
  poSzr1->Add( &m_oCbxCSTRAY,   oFlags );
  poSzr1->Add( &m_oCbxINCMODE,  oFlags );
  poSzr1->Add( &m_oCbxLUBYPASS, oFlags );
  poSzr1->Add( &m_oCbxRSTRAY,   oFlags );
  poSzr1->Add( &m_oCbxTRACEL,   oFlags );
  oFlags.Border( wxTOP | wxBOTTOM, 6 );
  poSzr1->Add( &m_oCbxVBYPASS,  oFlags );
  poSzr1->SetSizeHints( poPnl1 );

  // Add the controls to the buttons panel
  oFlags.Border( wxTOP | wxBOTTOM, 5 );
  oFlags.Align( wxALIGN_RIGHT );
  poSzrBtns->Add( &m_oBtnOk,       oFlags );
  poSzrBtns->AddSpacer( 10 );
  oFlags.Align( wxALIGN_CENTER );
  poSzrBtns->Add( &m_oBtnDefaults, oFlags );
  poSzrBtns->AddSpacer( 10 );
  oFlags.Align( wxALIGN_LEFT );
  poSzrBtns->Add( &m_oBtnCancel,   oFlags );
  poSzrBtns->SetSizeHints( poPnlBtns );

  // Put it all together
  oFlags.Align( wxALIGN_TOP );
  oFlags.Border( wxALL, 0 );
  poSzrRHS->Add( poPnl1, oFlags );
  oFlags.Align( wxALIGN_CENTER_HORIZONTAL | wxALIGN_BOTTOM );
  oFlags.Border( wxTOP, 30 );
  poSzrRHS->Add( poPnlBtns, oFlags );
  poSzrRHS->SetSizeHints( poPnlRHS );
  oFlags.Border( wxALL, 15 );
  poSzrDlg->Add( poPnlLHS, oFlags );
  oFlags.Border( wxTOP | wxBOTTOM, 15 );
  poSzrDlg->Add( poPnlMID, oFlags );
  oFlags.Align( wxALIGN_TOP );
  oFlags.Border( wxALL, 15 );
  poSzrDlg->Add( poPnlRHS, oFlags );
  poSzrDlg->SetSizeHints( this );
}

//*****************************************************************************
// Get a pointer to a value panel associated with a control ID number.
//
// Argument List:
//   iPnlID - The control ID number
//
// Return Values:
//   Success - A pointer to the value panel
//   Failure - NULL

PnlValue * DlgGnuCapOPT::poGetPanel( int iPnlID )
{
  switch( iPnlID )
  {
    case ID_PNL_ABSTOL   : return( &m_oPnlABSTOL   );
    case ID_PNL_CHGTOL   : return( &m_oPnlCHGTOL   );
    case ID_PNL_DAMPMAX  : return( &m_oPnlDAMPMAX  );
    case ID_PNL_DAMPMIN  : return( &m_oPnlDAMPMIN  );
    case ID_PNL_DAMPST   : return( &m_oPnlDAMPST   );
    case ID_PNL_DEFAD    : return( &m_oPnlDEFAD    );
    case ID_PNL_DEFAS    : return( &m_oPnlDEFAS    );
    case ID_PNL_DEFL     : return( &m_oPnlDEFL     );
    case ID_PNL_DEFW     : return( &m_oPnlDEFW     );
    case ID_PNL_DTMIN    : return( &m_oPnlDTMIN    );
    case ID_PNL_DTRATIO  : return( &m_oPnlDTRATIO  );
    case ID_PNL_FLOOR    : return( &m_oPnlFLOOR    );
    case ID_PNL_GMIN     : return( &m_oPnlGMIN     );
    case ID_PNL_HARMS    : return( &m_oPnlHARMS    );
    case ID_PNL_ITL1     : return( &m_oPnlITL1     );
    case ID_PNL_ITL2     : return( &m_oPnlITL2     );
    case ID_PNL_ITL4     : return( &m_oPnlITL4     );
    case ID_PNL_ITL7     : return( &m_oPnlITL7     );
    case ID_PNL_ITL8     : return( &m_oPnlITL8     );
    case ID_PNL_LIMIT    : return( &m_oPnlLIMIT    );
    case ID_PNL_NUMDGT   : return( &m_oPnlNUMDGT   );
    case ID_PNL_RELTOL   : return( &m_oPnlRELTOL   );
    case ID_PNL_SEED     : return( &m_oPnlSEED     );
    case ID_PNL_SHORT    : return( &m_oPnlSHORT    );
    case ID_PNL_TEMPAMB  : return( &m_oPnlTEMPAMB  );
    case ID_PNL_TNOM     : return( &m_oPnlTNOM     );
    case ID_PNL_TRANSITS : return( &m_oPnlTRANSITS );
    case ID_PNL_TRREJECT : return( &m_oPnlTRREJECT );
    case ID_PNL_TRSTEPG  : return( &m_oPnlTRSTEPG  );
    case ID_PNL_TRSTEPS  : return( &m_oPnlTRSTEPS  );
    case ID_PNL_TRTOL    : return( &m_oPnlTRTOL    );
    case ID_PNL_VFLOOR   : return( &m_oPnlVFLOOR   );
    case ID_PNL_VMAX     : return( &m_oPnlVMAX     );
    case ID_PNL_VMIN     : return( &m_oPnlVMIN     );
    case ID_PNL_VNTOL    : return( &m_oPnlVNTOL    );
    case ID_PNL_WCZERO   : return( &m_oPnlWCZERO   );
    default              : return( NULL );
  }
}

//*****************************************************************************
// Set the values in the spin controls from temporary storage.

void  DlgGnuCapOPT::SetValues( void )
{
  int  i1;

  SetEvtHandlerEnabled( FALSE );

  m_oPnlABSTOL  .bSetValue( (double) m_fABSTOL   );
  m_oPnlCHGTOL  .bSetValue( (double) m_fCHGTOL   );
  m_oPnlDAMPMAX .bSetValue( (double) m_fDAMPMAX  );
  m_oPnlDAMPMIN .bSetValue( (double) m_fDAMPMIN  );
  m_oPnlDAMPST  .bSetValue( (long)   m_iDAMPST   );
  m_oPnlDEFAD   .bSetValue( (double) m_fDEFAD    );
  m_oPnlDEFAS   .bSetValue( (double) m_fDEFAS    );
  m_oPnlDEFL    .bSetValue( (double) m_fDEFL     );
  m_oPnlDEFW    .bSetValue( (double) m_fDEFW     );
  m_oPnlDTMIN   .bSetValue( (double) m_fDTMIN    );
  m_oPnlDTRATIO .bSetValue( (double) m_fDTRATIO  );
  m_oPnlFLOOR   .bSetValue( (double) m_fFLOOR    );
  m_oPnlGMIN    .bSetValue( (double) m_fGMIN     );
  m_oPnlHARMS   .bSetValue( (long)   m_iHARMS    );
  m_oPnlITL1    .bSetValue( (long)   m_iITL1     );
  m_oPnlITL2    .bSetValue( (long)   m_iITL2     );
  m_oPnlITL4    .bSetValue( (long)   m_iITL4     );
  m_oPnlITL7    .bSetValue( (long)   m_iITL7     );
  m_oPnlITL8    .bSetValue( (long)   m_iITL8     );
  m_oPnlLIMIT   .bSetValue( (double) m_fLIMIT    );
  m_oPnlNUMDGT  .bSetValue( (long)   m_iNUMDGT   );
  m_oPnlRELTOL  .bSetValue( (double) m_fRELTOL * 100.0 );
  m_oPnlSEED    .bSetValue( (double) m_fSEED     );
  m_oPnlSHORT   .bSetValue( (double) m_fSHORT    );
  m_oPnlTEMPAMB .bSetValue( (double) m_fTEMPAMB  );
  m_oPnlTNOM    .bSetValue( (double) m_fTNOM     );
  m_oPnlTRANSITS.bSetValue( (long)   m_iTRANSITS );
  m_oPnlTRREJECT.bSetValue( (double) m_fTRREJECT );
  m_oPnlTRSTEPG .bSetValue( (double) m_fTRSTEPG  );
  m_oPnlTRSTEPS .bSetValue( (double) m_fTRSTEPS  );
  m_oPnlTRTOL   .bSetValue( (double) m_fTRTOL    );
  m_oPnlVFLOOR  .bSetValue( (double) m_fVFLOOR   );
  m_oPnlVMAX    .bSetValue( (double) m_fVMAX     );
  m_oPnlVMIN    .bSetValue( (double) m_fVMIN     );
  m_oPnlVNTOL   .bSetValue( (double) m_fVNTOL    );
  m_oPnlWCZERO  .bSetValue( (double) m_fWCZERO   );

  m_oCbxBYPASS  .SetValue( m_bBYPASS   );
  m_oCbxCSTRAY  .SetValue( m_bCSTRAY   );
  m_oCbxINCMODE .SetValue( m_bINCMODE  );
  m_oCbxLUBYPASS.SetValue( m_bLUBYPASS );
  m_oCbxRSTRAY  .SetValue( m_bRSTRAY   );
  m_oCbxTRACEL  .SetValue( m_bTRACEL   );
  m_oCbxVBYPASS .SetValue( m_bVBYPASS  );

  for( i1=0; i1<(int)m_oChoMETHOD.GetCount( ); i1++ )
    if( m_oChoMETHOD.GetString( i1 ).IsSameAs( m_osMETHOD, FALSE ) )
      { m_oChoMETHOD.SetSelection( i1 ); break; }

  for( i1=0; i1<(int)m_oChoMODE.GetCount( ); i1++ )
    if( m_oChoMODE.GetString( i1 ).IsSameAs( m_osMODE, FALSE ) )
      { m_oChoMODE.SetSelection( i1 ); break; }

  for( i1=0; i1<(int)m_oChoORDER.GetCount( ); i1++ )
    if( m_oChoORDER.GetString( i1 ).IsSameAs( m_osORDER, FALSE ) )
      { m_oChoORDER.SetSelection( i1 ); break; }

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Get the values from the spin controls and put them in temporary storage.

void  DlgGnuCapOPT::GetValues( void )
{
  SetEvtHandlerEnabled( FALSE );

  m_fABSTOL   = (float) m_oPnlABSTOL  .dfGetValue( );
  m_fCHGTOL   = (float) m_oPnlCHGTOL  .dfGetValue( );
  m_fDAMPMAX  = (float) m_oPnlDAMPMAX .dfGetValue( );
  m_fDAMPMIN  = (float) m_oPnlDAMPMIN .dfGetValue( );
  m_iDAMPST   = (int)   m_oPnlDAMPST  .liGetValue( );
  m_fDEFAD    = (float) m_oPnlDEFAD   .dfGetValue( );
  m_fDEFAS    = (float) m_oPnlDEFAS   .dfGetValue( );
  m_fDEFL     = (float) m_oPnlDEFL    .dfGetValue( );
  m_fDEFW     = (float) m_oPnlDEFW    .dfGetValue( );
  m_fDTMIN    = (float) m_oPnlDTMIN   .dfGetValue( );
  m_fDTRATIO  = (float) m_oPnlDTRATIO .dfGetValue( );
  m_fFLOOR    = (float) m_oPnlFLOOR   .dfGetValue( );
  m_fGMIN     = (float) m_oPnlGMIN    .dfGetValue( );
  m_iHARMS    = (int)   m_oPnlHARMS   .liGetValue( );
  m_iITL1     = (int)   m_oPnlITL1    .liGetValue( );
  m_iITL2     = (int)   m_oPnlITL2    .liGetValue( );
  m_iITL4     = (int)   m_oPnlITL4    .liGetValue( );
  m_iITL7     = (int)   m_oPnlITL7    .liGetValue( );
  m_iITL8     = (int)   m_oPnlITL8    .liGetValue( );
  m_fLIMIT    = (float) m_oPnlLIMIT   .dfGetValue( );
  m_iNUMDGT   = (int)   m_oPnlNUMDGT  .liGetValue( );
  m_fRELTOL   = (float) m_oPnlRELTOL  .dfGetValue( ) / 100.0;
  m_fSEED     = (float) m_oPnlSEED    .dfGetValue( );
  m_fSHORT    = (float) m_oPnlSHORT   .dfGetValue( );
  m_fTEMPAMB  = (float) m_oPnlTEMPAMB .dfGetValue( );
  m_fTNOM     = (float) m_oPnlTNOM    .dfGetValue( );
  m_iTRANSITS = (int)   m_oPnlTRANSITS.liGetValue( );
  m_fTRREJECT = (float) m_oPnlTRREJECT.dfGetValue( );
  m_fTRSTEPG  = (float) m_oPnlTRSTEPG .dfGetValue( );
  m_fTRSTEPS  = (float) m_oPnlTRSTEPS .dfGetValue( );
  m_fTRTOL    = (float) m_oPnlTRTOL   .dfGetValue( );
  m_fVFLOOR   = (float) m_oPnlVFLOOR  .dfGetValue( );
  m_fVMAX     = (float) m_oPnlVMAX    .dfGetValue( );
  m_fVMIN     = (float) m_oPnlVMIN    .dfGetValue( );
  m_fVNTOL    = (float) m_oPnlVNTOL   .dfGetValue( );
  m_fWCZERO   = (float) m_oPnlWCZERO  .dfGetValue( );

  m_bBYPASS   = m_oCbxBYPASS  .GetValue( );
  m_bCSTRAY   = m_oCbxCSTRAY  .GetValue( );
  m_bINCMODE  = m_oCbxINCMODE .GetValue( );
  m_bLUBYPASS = m_oCbxLUBYPASS.GetValue( );
  m_bRSTRAY   = m_oCbxRSTRAY  .GetValue( );
  m_bTRACEL   = m_oCbxTRACEL  .GetValue( );
  m_bVBYPASS  = m_oCbxVBYPASS .GetValue( );

  m_osMETHOD = m_oChoMETHOD.GetStringSelection( ).Upper( );
  m_osMODE   = m_oChoMODE  .GetStringSelection( ).Upper( );
  m_osORDER  = m_oChoORDER .GetStringSelection( ).Upper( );

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Reset all dialog settings to defaults.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  DlgGnuCapOPT::bClear( void )
{
  CmdGnuCapOPT::bClear( );

  SetValues( );

  return( TRUE );
}

//*****************************************************************************
// Set the OPTIONS command string.
//
// Argument List:
//   rosCmd - A string reference containing the command
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  DlgGnuCapOPT::bSetCmd( const wxString & rosCmd )
{
  if( CmdBase::bSetCmd( rosCmd ) ) return( FALSE );

  SetValues( );

  return( TRUE );
}

//*****************************************************************************
// Get a value panel control's value.
//
// Argument List:
//   iPnlID   - Value panel control identifier
//
// Return Values:
//   Success - The panel value
//   Failure - 0.0

double  DlgGnuCapOPT::dfGetValue( int iPnlID )
{
  PnlValue * poPnlValue;

  poPnlValue = poGetPanel( iPnlID );
  if( poPnlValue == NULL ) return( 0.0 );

  return( poPnlValue->dfGetValue( ) );
}

//*****************************************************************************
// Set a value panel control's value.
//
// Argument List:
//   iPnlID   - Value panel control identifier
//   dfValue  - The value to set the spin control
//   rosUnits - The units to display
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  DlgGnuCapOPT::bSetValue( int iPnlID, double dfValue,
                               const wxString & rosUnits )
{
  PnlValue * poPnlValue;

  // Get a pointer to the appropriate value panel
  poPnlValue = poGetPanel( iPnlID );
  if( poPnlValue == NULL )                  return( FALSE );

  // Set the panel value
  if( ! poPnlValue->bSetValue( dfValue ) )  return( FALSE );

  // Set the units
  if( ! poPnlValue->bSetUnits( rosUnits ) ) return( FALSE );

  return( TRUE );
}

//*****************************************************************************
//
//                             Event Handlers
//
//*****************************************************************************
// Ok button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgGnuCapOPT::OnBtnOk( wxCommandEvent & roEvtCmd )
{
  GetValues( );
  EndModal( wxID_OK );
}

//*****************************************************************************
// Cancel button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgGnuCapOPT::OnBtnCancel( wxCommandEvent & roEvtCmd )
{
  SetValues( );
  EndModal( wxID_CANCEL );
}

//*****************************************************************************
// Defaults button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgGnuCapOPT::OnBtnDefaults( wxCommandEvent & roEvtCmd )
{
  m_oPnlABSTOL  .bSetValue( GC_ABSTOL   );
  m_oPnlCHGTOL  .bSetValue( GC_CHGTOL   );
  m_oPnlDAMPMAX .bSetValue( GC_DAMPMAX  );
  m_oPnlDAMPMIN .bSetValue( GC_DAMPMIN  );
  m_oPnlDAMPST  .bSetValue( GC_DAMPST   );
  m_oPnlDEFAD   .bSetValue( GC_DEFAD    );
  m_oPnlDEFAS   .bSetValue( GC_DEFAS    );
  m_oPnlDEFL    .bSetValue( GC_DEFL     );
  m_oPnlDEFW    .bSetValue( GC_DEFW     );
  m_oPnlDTMIN   .bSetValue( GC_DTMIN    );
  m_oPnlDTRATIO .bSetValue( GC_DTRATIO  );
  m_oPnlFLOOR   .bSetValue( GC_FLOOR    );
  m_oPnlGMIN    .bSetValue( GC_GMIN     );
  m_oPnlHARMS   .bSetValue( GC_HARMS    );
  m_oPnlITL1    .bSetValue( GC_ITL1     );
  m_oPnlITL2    .bSetValue( GC_ITL2     );
  m_oPnlITL4    .bSetValue( GC_ITL4     );
  m_oPnlITL7    .bSetValue( GC_ITL7     );
  m_oPnlITL8    .bSetValue( GC_ITL8     );
  m_oPnlLIMIT   .bSetValue( GC_LIMIT    );
  m_oPnlNUMDGT  .bSetValue( GC_NUMDGT   );
  m_oPnlRELTOL  .bSetValue( GC_RELTOL * 100.0 );
  m_oPnlSEED    .bSetValue( GC_SEED     );
  m_oPnlSHORT   .bSetValue( GC_SHORT    );
  m_oPnlTEMPAMB .bSetValue( GC_TEMPAMB  );
  m_oPnlTNOM    .bSetValue( GC_TNOM     );
  m_oPnlTRANSITS.bSetValue( GC_TRANSITS );
  m_oPnlTRREJECT.bSetValue( GC_TRREJECT );
  m_oPnlTRSTEPG .bSetValue( GC_TRSTEPG  );
  m_oPnlTRSTEPS .bSetValue( GC_TRSTEPS  );
  m_oPnlTRTOL   .bSetValue( GC_TRTOL    );
  m_oPnlVFLOOR  .bSetValue( GC_VFLOOR   );
  m_oPnlVMAX    .bSetValue( GC_VMAX     );
  m_oPnlVMIN    .bSetValue( GC_VMIN     );
  m_oPnlVNTOL   .bSetValue( GC_VNTOL    );
  m_oPnlWCZERO  .bSetValue( GC_WCZERO   );

  m_oCbxBYPASS  .SetValue( GC_BYPASS    );
  m_oCbxCSTRAY  .SetValue( GC_CSTRAY    );
  m_oCbxINCMODE .SetValue( GC_INCMODE   );
  m_oCbxLUBYPASS.SetValue( GC_LUBYPASS  );
  m_oCbxRSTRAY  .SetValue( GC_RSTRAY    );
  m_oCbxTRACEL  .SetValue( GC_TRACEL    );
  m_oCbxVBYPASS .SetValue( GC_VBYPASS   );

  m_oChoMETHOD.SetStringSelection( GC_METHOD );
  m_oChoMODE  .SetStringSelection( GC_MODE   );
  m_oChoORDER .SetStringSelection( GC_ORDER  );
}

//*****************************************************************************
