/*
 * gsnmp-stub-ping.c --
 *
 * A simple program to retrieve sysUpTime.0 and sysDescr.0 using the
 * gnet-snmp API and scli stub procedures generated by smidump. The
 * stubs also validates the received values against type, range or
 * indexing errors.
 */

#include "snmpv2-mib.h"

static void
ping(GNetSnmp *s, int sflag)
{
    GError *error = NULL;
    snmpv2_mib_system_t *system;

    snmpv2_mib_get_system(s, &system,
			  SNMPV2_MIB_SYSUPTIME | SNMPV2_MIB_SYSDESCR, &error);
    if (error) {
	g_printerr("%s: %s\n", g_get_prgname(), error->message);
	g_clear_error(&error);
	goto cleanup;
    }
    if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
	g_printerr("%s: snmp error: %s @ %d\n", g_get_prgname(),
		   gnet_snmp_enum_get_label(gnet_snmp_enum_error_table,
					    s->error_status),
		   s->error_index);
	goto cleanup;
    }

    if (system && system->sysUpTime) {
	if (!sflag) {
	    g_print("%u: %.*s\n", *system->sysUpTime,
		    system->_sysDescrLength, system->sysDescr);
	}
    }

  cleanup:
    if (system) snmpv2_mib_free_system(system);
}

int
main(int argc, char **argv)
{
    gint i, r;
    static gint repeats = 1;
    static gboolean sflag = 0;
    GNetSnmp *s;
    GError *error = NULL;
    GOptionContext *context;

    static GOptionEntry entries[] = {
	{ "repeats", 'r', 0, G_OPTION_ARG_INT, &repeats,
	  "Executes N times", "N" },
	{ "silent", 's', 0, G_OPTION_ARG_NONE, &sflag,
	  "Keep silent and produce no output", NULL },
	{ NULL }
    };

    context = g_option_context_new("uri - ping snmp agents");
    g_option_context_add_main_entries(context, entries, NULL);
    g_option_context_add_group (context, gnet_snmp_get_option_group());    
    if (! g_option_context_parse(context, &argc, &argv, &error)) {
	g_printerr("%s: %s\n", g_get_prgname(),
		   (error && error->message) ? error->message
		   : "option parsing failed");
	return 1;
    }

    for (i = 1; i < argc; i++) {
	g_clear_error(&error);
	s = gnet_snmp_new_string(argv[i], &error);
	if (error) {
	    g_printerr("%s: %s\n", g_get_prgname(), error->message);
	    continue;
	}
	
	for (r = 0; r < repeats; r++) {
	    ping(s, sflag);
	}
	
	gnet_snmp_delete(s);
    }
    
    return 0;
}
